/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import oracle.ideimpl.macros.MacroDefinition;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class MacroDefinitions
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.ideimpl.macros.MacroDefinitionList";
    private static final String LEGACY_DATA_KEY = "oracle.jdevimpl.runner.macros.MacroDefinitionList";
    private PropertyStorage ps;
    public static final String MACRO_DEFINITIONS = "macro-definitions-list";

    private MacroDefinitions(HashStructure hash) {
        super(hash);
    }

    public static MacroDefinitions getInstance(PropertyStorage ps) {
        MacroDefinitions macros = new MacroDefinitions(MacroDefinitions.findOrCreate((PropertyStorage)ps, (String)DATA_KEY));
        macros.ps = ps;
        return macros;
    }

    public void addMacroDefinition(MacroDefinition md) {
        String name = md.getName();
        HashStructure macroDefinitionHashStructure = md.getHash();
        HashStructure activeProperties = this.ps.getProperties();
        HashStructure macroDefinitionsProperties = activeProperties.getOrCreateHashStructure(DATA_KEY);
        Object[] oldContent = this.checkForDeprecatedListContent(macroDefinitionsProperties);
        HashStructure macroDefinitionsList = macroDefinitionsProperties.getOrCreateHashStructure(MACRO_DEFINITIONS);
        macroDefinitionsList.putHashStructure(name, macroDefinitionHashStructure);
        if (oldContent != null && oldContent.length > 0) {
            this.migrateDeprecatedListContent(oldContent, macroDefinitionsList);
        }
    }

    public HashStructure getMacroDefinitions() {
        HashStructure hs;
        HashStructure macros = this.getHashStructure().getHashStructure(MACRO_DEFINITIONS);
        if (macros == null && (hs = this.ps.getProperties()) != null) {
            ListStructure legacyMacros;
            HashStructure legacyData = (HashStructure)hs.getObject(LEGACY_DATA_KEY);
            if (legacyData != null && (legacyMacros = legacyData.getListStructure(MACRO_DEFINITIONS)) != null) {
                while (legacyMacros.size() > 0) {
                    HashStructure mdHash = (HashStructure)legacyMacros.get(0);
                    MacroDefinition md = new MacroDefinition(mdHash);
                    this.addMacroDefinition(md);
                }
                hs.remove(LEGACY_DATA_KEY);
            }
            macros = this.getHashStructure().getHashStructure(MACRO_DEFINITIONS);
        }
        return macros;
    }

    private Object[] checkForDeprecatedListContent(HashStructure macroDefinitionsProperties) {
        Object o = macroDefinitionsProperties.getObject(MACRO_DEFINITIONS);
        Object[] oldContent = null;
        if (o != null && o instanceof ListStructure) {
            oldContent = ((ListStructure)o).toArray();
            macroDefinitionsProperties.remove(MACRO_DEFINITIONS);
        }
        return oldContent;
    }

    private void migrateDeprecatedListContent(Object[] oldContent, HashStructure macroDefinitionsList) {
        for (Object old : oldContent) {
            MacroDefinition oldMD = new MacroDefinition((HashStructure)old);
            macroDefinitionsList.putHashStructure(oldMD.getName(), oldMD.getHash());
        }
    }
}

