/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.metadata.KeyDescriptor;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AffiliationDescriptor
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"AffiliateMember", "Extension", "KeyDescriptor", "Signature"};
    private static final String[] nsURIsPrecedeDSig = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08"};
    private static final String[] localNamesPrecedeDSig = new String[]{"AffiliateMember", "Extension", "KeyDescriptor"};

    public AffiliationDescriptor(Element element) throws DOMException {
        super(element);
    }

    public AffiliationDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AffiliationDescriptor(Document owner) throws DOMException {
        super(owner, "urn:liberty:metadata:2003-08", "AffiliationDescriptor");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:metadata:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:metadata:2003-08");
    }

    public AffiliationDescriptor(Document owner, String affiliationOwnerID) throws DOMException {
        this(owner);
        this.setAffiliationOwnerID(affiliationOwnerID);
    }

    public void setAffiliationOwnerID(String affiliationOwnerID) throws DOMException {
        this.setAttribute("affiliationOwnerID", affiliationOwnerID);
    }

    public String getAffiliationOwnerID() {
        if (this.hasAttribute("affiliationOwnerID")) {
            return this.getAttribute("affiliationOwnerID");
        }
        return null;
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public void setValidUntil(Date validUntil) throws DOMException {
        this.setAttribute("validUntil", XMLUtils.formatDateTime((Date)validUntil));
    }

    public Date getValidUntil() {
        if (this.hasAttribute("validUntil")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("validUntil"));
        }
        return null;
    }

    public void setCacheDuration(String duration) throws DOMException {
        this.setAttribute("cacheDuration", duration);
    }

    public String getCacheDuration() {
        if (this.hasAttribute("cacheDuration")) {
            return this.getAttribute("cacheDuration");
        }
        return null;
    }

    public void addAffiliateMember(String providerID) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "AffiliateMember", nsURIs, localNames, providerID, false);
    }

    public List getAffiliateMembers() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "AffiliateMember");
    }

    public void addKeyDescriptor(KeyDescriptor keyDesc) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)keyDesc, (String[])nsURIs, (String[])localNames);
    }

    public List getKeyDescriptors() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "KeyDescriptor");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) throws DOMException, SigningException {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            throw new SigningException("Cannot add ds:Signature, missing 'id' attribute");
        }
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        return LibDSigUtils.addSignature(this, id, signatureMethod, c14nMethod, digestMethod, nsURIsPrecedeDSig, localNamesPrecedeDSig);
    }

    public XSSignature getSignature() {
        return (XSSignature)LibertyUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

