/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibRequestMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.NameIdentifier;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FederationTerminationNotification
extends LibRequestMessage {
    public FederationTerminationNotification(Element element) throws DOMException {
        super(element);
    }

    public FederationTerminationNotification(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public FederationTerminationNotification(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "FederationTerminationNotification");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public FederationTerminationNotification(Document owner, String requestId, Date issueInstant, String providerId) throws DOMException {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void setNameIdentifier(NameIdentifier nameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)nameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public NameIdentifier getNameIdentifier() {
        return (NameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
    }

    public void setConsent(String consent) throws DOMException {
        this.setAttribute("consent", consent);
    }

    public String getConsent() {
        if (this.hasAttribute("consent")) {
            return this.getAttribute("consent");
        }
        return null;
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        NameIdentifier nameIdentifier;
        String providerID;
        String consent;
        StringBuffer queryBuffer = new StringBuffer();
        String requestID = this.getRequestID();
        if (requestID != null) {
            queryBuffer.append("RequestID=");
            queryBuffer.append(URLEncoder.encode(requestID));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion=1&MinorVersion=2&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((consent = this.getConsent()) != null) {
            queryBuffer.append("consent=");
            queryBuffer.append(URLEncoder.encode(consent));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((nameIdentifier = this.getNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = nameIdentifier.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("NameQualifier=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = nameIdentifier.getFormat()) != null) {
                queryBuffer.append("NameFormat=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = nameIdentifier.getValue()) != null) {
                queryBuffer.append("NameIdentifier=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&Signature=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:oasis:names:tc:SAML:1.0:assertion"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "Extension", "ProviderID", "NameIdentifier"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

