/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.liberty.v12.LibAssertion;
import oracle.security.xmlsec.liberty.v12.LibResponseMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthnResponse
extends LibResponseMessage {
    public AuthnResponse(Element element) throws DOMException {
        super(element);
    }

    public AuthnResponse(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnResponse(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "AuthnResponse");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:ac:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public AuthnResponse(Document owner, String responseId, Date issueInstant, String providerId) throws DOMException {
        this(owner);
        this.setResponseID(responseId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void addAssertion(Assertion assertion) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)assertion, (String[])this.getChildElementsNSURIs(), (String[])this.getChildElementsLocalNames());
    }

    public List getAssertions() {
        Vector<LibAssertion> vec = new Vector<LibAssertion>();
        NodeList list = this.getChildElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            vec.addElement(new LibAssertion((Element)list.item(i), this.systemId));
        }
        return vec;
    }

    public void setConsent(String consent) throws DOMException {
        this.setAttribute("consent", consent);
    }

    public String getConsent() {
        if (this.hasAttribute("consent")) {
            return this.getAttribute("consent");
        }
        return null;
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"Signature", "Status", "Assertion", "Extension", "ProviderID", "RelayState"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

