/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gridView.ASFormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewFormatUtils;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.NewColorChoice;
import oracle.dss.gridView.gui.StoplightThresholdDialog;
import oracle.dss.util.DataAccess;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.QDR;

public class StoplightToolBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    private UIGridView m_gridView;
    private String m_measureDim;
    private Vector m_measureVector;
    private ResourceBundle m_bundle;
    private JLabel m_formatLabel;
    private JComboBox m_format;
    private DefaultComboBoxModel m_model;
    private NumberTextField m_unacceptable;
    private NumberTextField m_desirable;
    private JLabel m_unacceptLabel;
    private JLabel m_acceptLabel;
    private JLabel m_desireLabel;
    private NewColorChoice m_unacceptColor;
    private NewColorChoice m_acceptColor;
    private NewColorChoice m_desireColor;
    private JButton m_go;
    private String m_formatStr;
    private String m_selectedCellsStr;
    private String m_allDataCellsStr;
    private Color m_currentUnacceptColor;
    private Color m_currentAcceptColor;
    private Color m_currentDesireColor;
    private String m_currentUnacceptValue;
    private String m_currentDesireValue;
    private int m_currentIndex = -1;
    private KeyAdapter m_keyAdapter;
    private ImageIcon m_stopIcon;
    private HelpProvider m_helpProvider;

    public StoplightToolBar(UIGridView gridView) {
        this.m_gridView = gridView;
        if (this.m_gridView.getFormatModel() == null) {
            this.m_gridView.setFormatModel(new ASFormatModel(this.m_gridView));
        }
        if (gridView.getLocale() != null) {
            this.setLocale(gridView.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.installComponents();
        this.installStrings();
        this.installIcons();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public UIGridView getGridView() {
        return this.m_gridView;
    }

    public void setGridView(UIGridView gridView) {
        this.m_gridView = gridView;
        if (this.m_gridView != null) {
            if (this.m_gridView.getFormatModel() == null) {
                this.m_gridView.setFormatModel(new ASFormatModel(this.m_gridView));
            }
            this.refreshMeasureList();
            Color unacceptColor = new Color(DataviewUtils.hexStringToInt((String)this.m_gridView.getBadColor()));
            if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_unacceptColor.getColorPalette(), (Color)unacceptColor)) {
                this.m_unacceptColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_unacceptColor.getColorPalette(), (Color)unacceptColor, (boolean)false));
            }
            this.m_unacceptColor.setSelectedColor(unacceptColor);
            this.m_unacceptColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
            Color acceptColor = new Color(DataviewUtils.hexStringToInt((String)this.m_gridView.getWarningColor()));
            if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_acceptColor.getColorPalette(), (Color)acceptColor)) {
                this.m_acceptColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_acceptColor.getColorPalette(), (Color)acceptColor, (boolean)false));
            }
            this.m_acceptColor.setSelectedColor(acceptColor);
            this.m_acceptColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
            Color desireColor = new Color(DataviewUtils.hexStringToInt((String)this.m_gridView.getGoodColor()));
            if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_desireColor.getColorPalette(), (Color)desireColor)) {
                this.m_desireColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_desireColor.getColorPalette(), (Color)desireColor, (boolean)false));
            }
            this.m_desireColor.setSelectedColor(desireColor);
            this.m_desireColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
        }
    }

    public void cleanup() {
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object _src = evt.getSource();
        if (!(_src.equals((Object)this.m_acceptColor) || _src.equals((Object)this.m_unacceptColor) || _src.equals((Object)this.m_desireColor))) {
            return;
        }
        if (!evt.getPropertyName().equals("selectedColor")) {
            return;
        }
        String tooltiptext = this.m_bundle.getString("STOPLIGHT.COLORPALETTETOOLTIP");
        MessageFormat messageformat = new MessageFormat(tooltiptext);
        if (_src.equals((Object)this.m_unacceptColor)) {
            Object[] aobj = new Object[]{IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getBlue())};
            String s1 = messageformat.format(aobj);
            this.m_unacceptColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE")) + " " + s1);
            this.m_unacceptColor.updateIconColor();
        } else if (_src.equals((Object)this.m_acceptColor)) {
            Object[] aobj1 = new Object[]{IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getBlue())};
            String s1 = messageformat.format(aobj1);
            this.m_acceptColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.ACCEPTABLE")) + " " + s1);
            this.m_acceptColor.updateIconColor();
        } else {
            Object[] aobj2 = new Object[]{IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getBlue())};
            String s1 = messageformat.format(aobj2);
            this.m_desireColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.DESIRABLE")) + " " + s1);
            this.m_desireColor.updateIconColor();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object _src = e.getSource();
        if (_src instanceof JComboBox) {
            if (this.m_desirable != null) {
                this.m_unacceptable.setText("");
                this.m_desirable.setText("");
            }
        } else if (_src instanceof JButton) {
            this.apply();
        }
    }

    private void installComponents() {
        this.m_formatLabel = new JLabel();
        this.m_formatLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.m_format = new JComboBox();
        this.m_format.addActionListener(this);
        this.m_format.setRenderer(new MeasureListRenderer());
        this.m_formatLabel.setLabelFor(this.m_format);
        this.m_unacceptLabel = new JLabel();
        this.m_unacceptLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.m_unacceptable = new NumberTextField();
        this.m_unacceptable.setDataType(BigDecimal.class);
        this.m_unacceptable.setHorizontalAlignment(4);
        this.m_unacceptable.setDecimal(true);
        this.m_unacceptable.addActionListener((ActionListener)this);
        this.m_unacceptable.setMargin(new Insets(5, 5, 5, 5));
        this.m_unacceptable.setMaximumSize(new Dimension(90, 25));
        this.m_unacceptable.setPreferredSize(new Dimension(90, 25));
        this.m_unacceptColor = new NewColorChoice();
        this.m_unacceptColor.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        Color color = new Color(DataviewUtils.hexStringToInt((String)GridViewDefaultValues.getBadColor()));
        if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_unacceptColor.getColorPalette(), (Color)color)) {
            this.m_unacceptColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_unacceptColor.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_unacceptColor.setSelectedColor(color);
        this.m_unacceptColor.updateIconColor();
        this.m_unacceptColor.addPropertyChangeListener(this);
        String tooltiptext = this.m_bundle.getString("STOPLIGHT.COLORPALETTETOOLTIP");
        MessageFormat messageformat = new MessageFormat(tooltiptext);
        Object[] aobj = new Object[]{IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_unacceptColor.getSelectedColor().getBlue())};
        String s1 = messageformat.format(aobj);
        this.m_unacceptColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE")) + " " + s1);
        this.m_acceptLabel = new JLabel();
        this.m_acceptColor = new NewColorChoice();
        this.m_acceptColor.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        color = new Color(DataviewUtils.hexStringToInt((String)GridViewDefaultValues.getWarningColor()));
        if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_acceptColor.getColorPalette(), (Color)color)) {
            this.m_acceptColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_acceptColor.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_acceptColor.setSelectedColor(color);
        this.m_acceptColor.updateIconColor();
        Object[] aobj1 = new Object[]{IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_acceptColor.getSelectedColor().getBlue())};
        s1 = messageformat.format(aobj1);
        this.m_acceptColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.ACCEPTABLE")) + " " + s1);
        this.m_acceptColor.addPropertyChangeListener(this);
        this.m_desireLabel = new JLabel();
        this.m_desireLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.m_desirable = new NumberTextField();
        this.m_desirable.setDataType(BigDecimal.class);
        this.m_desirable.setHorizontalAlignment(4);
        this.m_desirable.setDecimal(true);
        this.m_desirable.addActionListener((ActionListener)this);
        this.m_desirable.setMargin(new Insets(5, 5, 5, 5));
        this.m_desirable.setMaximumSize(new Dimension(90, 25));
        this.m_desirable.setPreferredSize(new Dimension(90, 25));
        this.m_desireColor = new NewColorChoice();
        this.m_desireColor.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        color = new Color(DataviewUtils.hexStringToInt((String)GridViewDefaultValues.getGoodColor()));
        if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_desireColor.getColorPalette(), (Color)color)) {
            this.m_desireColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_desireColor.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_desireColor.setSelectedColor(color);
        this.m_desireColor.updateIconColor();
        Object[] aobj2 = new Object[]{IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getRed()), IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getGreen()), IntegerUtils.getInteger((int)this.m_desireColor.getSelectedColor().getBlue())};
        s1 = messageformat.format(aobj2);
        this.m_desireColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.DESIRABLE")) + " " + s1);
        this.m_desireColor.addPropertyChangeListener(this);
        this.m_go = new JButton();
        this.m_go.setBorderPainted(true);
        this.m_go.addActionListener(this);
        this.add(this.m_formatLabel);
        this.add(this.m_format);
        this.addSeparator();
        this.add(this.m_unacceptLabel);
        this.add((Component)this.m_unacceptable);
        this.add((Component)((Object)this.m_unacceptColor));
        this.addSeparator();
        this.add(this.m_acceptLabel);
        this.add((Component)((Object)this.m_acceptColor));
        this.addSeparator();
        this.add(this.m_desireLabel);
        this.add((Component)this.m_desirable);
        this.add((Component)((Object)this.m_desireColor));
        this.addSeparator();
        this.add(this.m_go);
        this.m_keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StoplightToolBar.this.apply();
                }
            }
        };
        this.m_desirable.addKeyListener((KeyListener)this.m_keyAdapter);
        this.m_unacceptable.addKeyListener((KeyListener)this.m_keyAdapter);
    }

    private void installStrings() {
        this.m_unacceptLabel.setText(this.m_bundle.getString("STOPLIGHTBAR.UNACCEPTABLE"));
        this.m_acceptLabel.setText(this.m_bundle.getString("STOPLIGHTBAR.ACCEPTABLE"));
        this.m_desireLabel.setText(this.m_bundle.getString("STOPLIGHTBAR.DESIRABLE"));
        this.m_formatStr = this.m_bundle.getString("STOPLIGHTBAR.FORMAT");
        this.m_selectedCellsStr = this.m_bundle.getString("STOPLIGHTBAR.SELECTEDCELLS");
        this.m_allDataCellsStr = this.m_bundle.getString("STOPLIGHTBAR.ALLDATACELLS");
        this.m_go.setText(this.m_bundle.getString("STOPLIGHTBAR.GO"));
        this.m_formatLabel.setText(this.m_formatStr);
        this.refreshMeasureList();
    }

    private void installIcons() {
        this.m_stopIcon = new ImageIcon(ImageUtils.getImageResource(StoplightToolBar.class, (String)"images/stop.gif"));
    }

    private void updateResourceBundle(Locale loc) {
        this.m_bundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void refreshMeasureList() {
        this.m_model = this.createModel();
        this.m_format.setModel(this.m_model);
        if (this.m_format.getItemCount() > 2) {
            this.m_format.setSelectedIndex(2);
        }
        int _largest = -1;
        for (int i = 0; i < this.m_model.getSize(); ++i) {
            Object _obj = this.m_model.getElementAt(i);
            String _str = _obj.toString();
            int _width = this.m_format.getFontMetrics(this.m_format.getFont()).stringWidth(_str);
            if (_width <= _largest) continue;
            _largest = _width;
        }
        if (_largest > 550) {
            _largest = 550;
        }
        this.m_format.setMaximumSize(new Dimension(_largest + 30, 25));
        this.m_format.setMinimumSize(new Dimension(100, 25));
        this.m_format.repaint();
    }

    private DefaultComboBoxModel createModel() {
        DefaultComboBoxModel<String> _model;
        block10: {
            block9: {
                _model = new DefaultComboBoxModel<String>();
                _model.addElement(this.m_selectedCellsStr);
                _model.addElement(this.m_allDataCellsStr);
                try {
                    QDR qdr = this.m_gridView.getModel().getDataAccess().getValueQDR(0, 0, 0);
                    if (qdr != null) {
                        this.m_measureDim = qdr.getMeasureDim();
                    }
                    if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                        this.m_measureDim = null;
                    }
                }
                catch (Exception qdr) {
                    // empty catch block
                }
                if (this.m_gridView.getViewType() != 0) break block9;
                this.m_measureVector = this.getDimMembers(this.m_measureDim, "value");
                Vector measures = this.getDimMembers(this.m_measureDim, "shortName");
                if (measures == null) break block10;
                for (int i = 0; i < measures.size(); ++i) {
                    String _measure = measures.elementAt(i).toString();
                    if (_measure == null) continue;
                    _model.addElement(_measure);
                }
                break block10;
            }
            if (this.m_gridView.getDataSource() instanceof LayoutContext) {
                LayoutAccess access = ((LayoutContext)this.m_gridView.getDataSource()).createLayoutAccess();
                String[] measures = access.getMeasures("value");
                String[] measureLabels = access.getMeasures("shortName");
                this.m_measureVector = new Vector();
                for (int i = 0; i < measures.length; ++i) {
                    _model.addElement(measureLabels[i]);
                    this.m_measureVector.add(measures[i]);
                }
            } else {
                List list = GridViewFormatUtils.getMeasures(this.m_gridView.getModel().getDataAccess(), "value");
                List list1 = GridViewFormatUtils.getMeasures(this.m_gridView.getModel().getDataAccess(), "shortName");
                this.m_measureVector = new Vector();
                for (int i = 0; i < list.size(); ++i) {
                    _model.addElement((String)list.get(i));
                    this.m_measureVector.add(list1.get(i));
                }
            }
        }
        return _model;
    }

    protected boolean apply() {
        String _unaccept = this.m_unacceptable.getText();
        String _desire = this.m_desirable.getText();
        if ((_unaccept == null || _unaccept.equals("")) && (_desire == null || _desire.equals(""))) {
            JOptionPane.showMessageDialog(this, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUEU") + "\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUED"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.m_stopIcon);
            return false;
        }
        if (_unaccept == null || _unaccept.equals("")) {
            JOptionPane.showMessageDialog(this, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUEU"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.m_stopIcon);
            return false;
        }
        if (_desire == null || _desire.equals("")) {
            JOptionPane.showMessageDialog(this, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUED"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.m_stopIcon);
            return false;
        }
        boolean _desireGreater = true;
        if (_unaccept.equals(_desire)) {
            Frame _parent = JOptionPane.getFrameForComponent(this);
            StoplightThresholdDialog _dialog = new StoplightThresholdDialog(_parent, this.m_gridView.getLocale(), _unaccept);
            _dialog.setHelpProvider(this.getHelpProvider());
            if (!_dialog.runDialog()) {
                return false;
            }
            if (_dialog.getDesirableValue() == 1) {
                _desireGreater = false;
            }
        }
        int _index = this.m_format.getSelectedIndex();
        Color _unacceptColor = this.m_unacceptColor.getSelectedColor();
        Color _acceptColor = this.m_acceptColor.getSelectedColor();
        Color _desireColor = this.m_desireColor.getSelectedColor();
        if (_unaccept.equals(this.m_currentUnacceptValue) && _desire.equals(this.m_currentDesireValue) && this.m_currentIndex == _index && _unacceptColor.equals(this.m_currentAcceptColor) && _acceptColor.equals(this.m_currentAcceptColor) && _desireColor.equals(this.m_currentDesireColor)) {
            return false;
        }
        this.m_gridView.setBadColor(GridViewFormatUtils.getColorValue(this.m_unacceptColor.getSelectedColor()));
        this.m_gridView.setWarningColor(GridViewFormatUtils.getColorValue(this.m_acceptColor.getSelectedColor()));
        this.m_gridView.setGoodColor(GridViewFormatUtils.getColorValue(this.m_desireColor.getSelectedColor()));
        if (_index == 0) {
            if (this.m_gridView.getSelectedObject() != null) {
                GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, _unaccept, _desire, _desireGreater);
            }
        } else if (_index == 1) {
            GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, _unaccept, _desire, (String)null, _desireGreater);
        } else {
            GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, _unaccept, _desire, this.m_measureVector.elementAt(_index - 2).toString(), _desireGreater);
        }
        this.m_currentUnacceptColor = _unacceptColor;
        this.m_currentAcceptColor = _acceptColor;
        this.m_currentDesireColor = _desireColor;
        this.m_currentUnacceptValue = _unaccept;
        this.m_currentDesireValue = _desire;
        this.m_currentIndex = _index;
        return true;
    }

    protected Vector getDimMembers(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            List list = dataAccess.getUniqueMemberMetadata(dimension, new String[]{type}, 0, -1);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || ((Object[])list.get(i)).length <= 0) continue;
                    members.addElement(((Object[])list.get(i))[0]);
                }
                return members;
            }
            for (int i = 0; i < dataAccess.getEdgeCount(); ++i) {
                int layerCount = dataAccess.getLayerCount(i);
                int endslice = dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = dataAccess.getLayerMetadata(i, j, "layerName");
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (dim == null || !dimension.equals(dim)) continue;
                    for (int startslice = 0; startslice != endslice; startslice += dataAccess.getMemberExtent(i, j, startslice)) {
                        if (dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = dataAccess.getMemberMetadata(i, j, startslice, type);
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || members.indexOf(value) != -1) continue;
                        members.addElement(value);
                    }
                }
            }
            if (members.size() > 0) {
                return members;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    class MeasureListRenderer
    extends DefaultListCellRenderer {
        MeasureListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }
}

