/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;

public class StoplightThresholdDialog
extends JEWTDialog
implements HelpContext {
    public static final int GREATER_THAN_THRESHOLD = 0;
    public static final int LESS_THAN_THRESHOLD = 1;
    private ResourceBundle m_bundle;
    private JRadioButton m_greater;
    private JRadioButton m_less;
    private HelpProvider m_helpProvider;
    private boolean m_bHelpEnabled;
    private String m_strHelpContextID;
    private String m_threshold;
    private boolean m_desirableValue;

    public StoplightThresholdDialog(Frame parent, Locale locale, String threshold) {
        super(parent, null, 7);
        this.setLocale(locale);
        this.m_threshold = threshold;
        this._initialize();
        this.setResizable(true);
    }

    public StoplightThresholdDialog(Dialog parent, Locale locale, String threshold) {
        super(parent, null, 7);
        this.setLocale(locale);
        this.m_threshold = threshold;
        this._initialize();
        this.setResizable(true);
    }

    private void updateResourceBundle(Locale loc) {
        this.m_bundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public void setDesirableValue(boolean value) {
        if (value) {
            this.m_greater.setSelected(true);
        } else {
            this.m_less.setSelected(true);
        }
    }

    public int getDesirableValue() {
        if (this.m_greater.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)this.m_helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public String getHelpContextID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    private void _initialize() {
        this.setTitle(this.m_bundle.getString("STOPLIGHTTHRESHOLD.TITLE"));
        MultiLineLabel _instruction = new MultiLineLabel();
        _instruction.setPreferredRows(2);
        _instruction.setTextWrapper(WordWrapper.getTextWrapper());
        _instruction.setText(this.m_bundle.getString("STOPLIGHTTHRESHOLD.INSTRUCTION"));
        MultiLineLabel _instruction2 = new MultiLineLabel();
        _instruction2.setPreferredRows(2);
        _instruction2.setTextWrapper(WordWrapper.getTextWrapper());
        _instruction2.setText(MessageFormat.format(this.m_bundle.getString("STOPLIGHTTHRESHOLD.INSTRUCTION2"), this.m_threshold));
        JLabel _desirableValues = new JLabel();
        _desirableValues.setAlignmentX(0.0f);
        _desirableValues.setAlignmentY(0.0f);
        _desirableValues.setText(this.m_bundle.getString("STOPLIGHTTHRESHOLD.DESIRABLE"));
        this.m_greater = new JRadioButton();
        this.m_greater.setName("GreaterThan");
        this.m_greater.setSelected(true);
        this.m_greater.setAlignmentX(0.0f);
        this.m_greater.setAlignmentY(0.0f);
        String translatedText = MessageFormat.format(this.m_bundle.getString("STOPLIGHTTHRESHOLD.GREATER"), this.m_threshold);
        this.m_greater.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_greater.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_less = new JRadioButton();
        this.m_less.setName("LessThan");
        this.m_less.setAlignmentX(0.0f);
        this.m_less.setAlignmentY(0.0f);
        translatedText = MessageFormat.format(this.m_bundle.getString("STOPLIGHTTHRESHOLD.LESS"), this.m_threshold);
        this.m_less.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_less.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        ButtonGroup _group = new ButtonGroup();
        _group.add(this.m_greater);
        _group.add(this.m_less);
        JLabel _imageLabel = new JLabel();
        ImageIcon _icon = new ImageIcon(ImageUtils.getImageResource(StoplightThresholdDialog.class, (String)"images/Warn.gif"));
        _imageLabel.setIcon(_icon);
        JPanel _mainPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        _mainPanel.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        _mainPanel.add(Box.createHorizontalStrut(10));
        c.gridx = 10;
        gridBag.setConstraints(_imageLabel, c);
        _mainPanel.add(_imageLabel);
        _mainPanel.add(Box.createHorizontalStrut(15));
        c.weightx = 1.0;
        c.gridx += 15;
        c.gridwidth = 0;
        gridBag.setConstraints((Component)_instruction, c);
        c.weighty = 1.0;
        gridBag.setConstraints((Component)_instruction2, c);
        _mainPanel.add((Component)_instruction);
        _mainPanel.add((Component)_instruction2);
        _mainPanel.add(Box.createVerticalStrut(10));
        c.gridy += 10;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridBag.setConstraints(_desirableValues, c);
        c.gridy = -1;
        gridBag.setConstraints(this.m_greater, c);
        gridBag.setConstraints(this.m_less, c);
        _mainPanel.add(_desirableValues);
        _mainPanel.add(this.m_greater);
        _mainPanel.add(this.m_less);
        _mainPanel.add(Box.createVerticalGlue());
        _mainPanel.add(Box.createVerticalStrut(10));
        this.setContent(_mainPanel);
        this.getContent().setSize(_mainPanel.getPreferredSize());
    }
}

