/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.dss.gridView.GridViewDefaultValues;

public class GridlinePainter
extends AbstractPainter {
    protected boolean _horizontal;
    protected Color m_color = new Color(GridViewDefaultValues.getGridColor());
    protected boolean m_3D = GridViewDefaultValues.isGrid3D();

    public GridlinePainter(boolean horizontal, boolean is3D) {
        this._horizontal = horizontal;
        this.m_3D = is3D;
    }

    public Dimension getMinimumSize(PaintContext context) {
        if (this.m_3D) {
            return new Dimension(2, 2);
        }
        return new Dimension(1, 1);
    }

    public int getRepaintFlags(PaintContext context) {
        if (this.m_3D) {
            return 4;
        }
        return 1;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        if (this._horizontal) {
            if (this.m_3D) {
                this.paintHorizontal3D(context, g, x, y, width, height);
            } else {
                this.paintHorizontal(context, g, x, y, width, height);
            }
        } else if (this.m_3D) {
            this.paintVertical3D(context, g, x, y, width, height);
        } else {
            this.paintVertical(context, g, x, y, width, height);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color c) {
        this.m_color = c;
    }

    public boolean is3D() {
        return this.m_3D;
    }

    protected void paintHorizontal(PaintContext context, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.m_color);
        int state = context.getPaintState();
        boolean enabled = (state & 1) == 0;
        int right = x + width - 1;
        if (enabled) {
            g.drawLine(x, y, right, y);
        } else {
            Color c = g.getColor();
            Color bg = context.getPaintUIDefaults().getColor("Grid.disabledBackground");
            for (int i = x; i <= right; i += 2) {
                g.setColor(c);
                g.drawLine(i, y, i, y);
                g.setColor(bg);
                g.drawLine(i + 1, y, i + 1, y);
            }
        }
    }

    protected void paintVertical(PaintContext context, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.m_color);
        int state = context.getPaintState();
        boolean enabled = (state & 1) == 0;
        int bottom = y + height - 1;
        if (enabled) {
            g.drawLine(x, y, x, bottom);
        } else {
            Color c = g.getColor();
            Color bg = context.getPaintUIDefaults().getColor("Grid.disabledBackground");
            for (int i = y; i <= bottom; i += 2) {
                g.setColor(c);
                g.drawLine(x, i, x, i);
                g.setColor(bg);
                g.drawLine(x, i + 1, x, i + 1);
            }
        }
    }

    protected void paintHorizontal3D(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color lightColor;
        Color darkColor;
        UIDefaults defaults = context.getPaintUIDefaults();
        if ((context.getPaintState() & 4) != 0) {
            lightColor = darkColor = this.darker(this.m_color);
        } else {
            darkColor = this.darker(this.m_color);
            lightColor = this.brighter(this.m_color);
        }
        Color firstColor = lightColor;
        Color secondColor = darkColor;
        int right = x + width - 1;
        g.setColor(firstColor);
        g.drawLine(x, y, right - 1, y);
        g.setColor(secondColor);
        g.drawLine(x, ++y, right, y);
    }

    protected void paintVertical3D(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color lightColor;
        Color darkColor;
        UIDefaults defaults = context.getPaintUIDefaults();
        if ((context.getPaintState() & 4) != 0) {
            lightColor = darkColor = this.darker(this.m_color);
        } else {
            darkColor = this.darker(this.m_color);
            lightColor = this.brighter(this.m_color);
        }
        Color firstColor = lightColor;
        Color secondColor = darkColor;
        int bottom = y + height - 1;
        g.setColor(firstColor);
        g.drawLine(x, y, x, bottom - 1);
        g.setColor(secondColor);
        g.drawLine(++x, y, x, bottom);
    }

    protected Color brighter(Color c) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
        hsb[1] = (float)((double)hsb[1] * 0.1);
        hsb[2] = (float)((double)hsb[2] + (double)(1.0f - hsb[2]) * 0.9);
        Color result = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return result;
    }

    protected Color darker(Color c) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
        hsb[1] = (float)((double)hsb[1] + (double)(1.0f - hsb[1]) * 0.5);
        hsb[2] = (float)((double)hsb[2] * 0.5);
        Color result = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return result;
    }
}

