/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.Hashtable;
import java.util.Locale;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewModel;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.WaitData;

public class GridViewAppearanceMgr
implements AppearanceManager {
    protected GridView gridView = null;
    protected GridViewDatabody grid = null;
    private ViewStyle _appearance;
    private transient Hashtable styleCache = null;
    private transient DataComponentInfo info = new DataComponentInfo(0, 0);
    private static final String m_method_getcellpaintingappearance = "getCellPaintingAppearance(int column, int row)";
    private static final String m_method_getCellPaintingAppearance = "getCellPaintingAppearance(int column, int row)";
    private static final String m_method_getcellappearance = "getCellAppearance(int column, int row)";

    public GridViewAppearanceMgr(GridView ct, GridViewDatabody cpg) {
        this.gridView = ct;
        this.grid = cpg;
        this.styleCache = new Hashtable();
    }

    public Appearance getCellPaintingAppearance(int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), "getCellPaintingAppearance(int column, int row)");
            return null;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), "getCellPaintingAppearance(int column, int row)");
            return null;
        }
        GridViewModel model = this.gridView.getGridViewModel();
        int _col = model.getDataFromTableCol(column);
        int _row = model.getDataFromTableRow(row);
        this.info.setRowCol(_row, _col);
        ViewStyle style = (ViewStyle)this.styleCache.get(this.info);
        if (style == null) {
            if (this.gridView.getWaitDataForRow(row) != null) {
                return this.gridView.getDatabody().getViewStyle();
            }
            Object object = this.grid.getGridViewData().getRawData(column, row);
            if (object instanceof WaitData) {
                this.gridView.setWaitDataForRow(row, (WaitData)object);
                return this.gridView.getDatabody().getViewStyle();
            }
            try {
                style = model.getGridViewDatabodyStyleManager().getDataStyle(this.gridView, object, this.gridView.getDatabody().getViewStyle(), row, column, this.gridView.getGridViewModel().getDataAccess().getEdgeCurrentHPos(2));
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                // empty catch block
            }
            if (style != null) {
                this.styleCache.put(this.info.clone(), style);
            }
        }
        if (style == null) {
            style = this._getAppearance();
        }
        if (this.gridView.isCellEditingAllowed() && this.gridView.getGridViewController().getGridViewSelectionManager().canEditCell(_row, _col)) {
            boolean editBackgroundUsed = style.isEditBackgroundUsed();
            boolean editForegroundUsed = style.isEditForegroundUsed();
            if (editBackgroundUsed || editForegroundUsed) {
                style = (ViewStyle)style.copy();
                if (editBackgroundUsed) {
                    style.setBackground(style.getEditBackground());
                }
                if (editForegroundUsed) {
                    style.setBackground(style.getEditBackground());
                }
            }
        }
        style.setView((DataviewCommon)this.gridView);
        if (this.gridView.getZoomFactor() != 100) {
            style = style.scaleStyle(style.getFont());
            style.setView((DataviewCommon)this.gridView);
        }
        style.setReadingDirection(this.getReadingDirectionForLocale(this.gridView.getLocale()));
        return style;
    }

    public ViewStyle getAppearance() {
        return (ViewStyle)this._getAppearance().copy();
    }

    public void setAppearance(ViewStyle object) {
        this._appearance = (ViewStyle)object.copy();
    }

    public ViewStyle getCellAppearance(int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getcellappearance);
            return null;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getcellappearance);
            return null;
        }
        return (ViewStyle)this.getCellPaintingAppearance(column, row);
    }

    public void updateUI() {
    }

    private ViewStyle _getAppearance() {
        if (this._appearance == null) {
            this._appearance = this._createAppearance();
        }
        return this._appearance;
    }

    private ViewStyle _createAppearance() {
        ViewStyle vs = new ViewStyle((DataviewCommon)this.gridView, this.grid.getDefaultAppearance());
        return vs;
    }

    public void clearCache() {
        if (this.styleCache != null) {
            this.styleCache.clear();
        }
    }

    public void setGrid(Grid grid) {
    }

    public TwoDModelListener getTwoDModelListener() {
        return null;
    }

    private int getReadingDirectionForLocale(Locale loc) {
        String language;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            return 2;
        }
        return 1;
    }
}

