/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JViewport;
import javax.swing.Timer;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.pivot.PivotScrollPaneView;

class HeaderAutoScroller
implements ActionListener {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static HeaderAutoScroller _sAutoScroller;
    private Timer _timer = new Timer(200, this);
    private Grid _scrollee;
    private boolean _hDecrease;
    private boolean _vDecrease;
    private boolean _horizontal;
    private boolean _vertical;
    private boolean _cancel;
    private boolean _scheduled;

    public static HeaderAutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new HeaderAutoScroller();
        }
        return _sAutoScroller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    public void schedule(Grid scrollee, boolean needHorizontal, boolean horizontalDecrease, boolean needVertical, boolean verticalDecrease) {
        this._scrollee = scrollee;
        this._horizontal = needHorizontal;
        this._vertical = needVertical;
        this._hDecrease = horizontalDecrease;
        this._vDecrease = verticalDecrease;
        this._cancel = false;
        if (this._scheduled) {
            return;
        }
        this._scheduled = true;
        this._timer.setDelay(200);
        this._timer.start();
    }

    public void cancel() {
        this._timer.stop();
        this._scheduled = false;
        this._cancel = true;
    }

    public void cancel(Grid possibleTarget) {
        if (this._scrollee == possibleTarget) {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this._cancel) {
            return;
        }
        int x = ((PivotScrollPaneView)this._scrollee.getParent().getParent()).getX();
        int y = ((PivotScrollPaneView)this._scrollee.getParent().getParent()).getY();
        Point origin = new Point(x, y);
        boolean scrolledHorizontal = false;
        boolean scrolledVertical = false;
        this._scrollee.freezeRepaints();
        try {
            int pos;
            if (this._horizontal) {
                int columnIndex = -1;
                if (this._hDecrease) {
                    columnIndex = this._scrollee.getColumnAt(-origin.x);
                    if (columnIndex != -1) {
                        columnIndex = this._scrollee.getPreviousVisibleColumn(columnIndex);
                    }
                } else {
                    pos = -origin.x + ((JViewport)this._scrollee.getParent().getParent().getParent()).getExtentSize().width;
                    columnIndex = this._scrollee.getColumnAt(pos);
                    if (columnIndex != -1 && columnIndex != this._scrollee.getColumnCount() - 1) {
                        columnIndex = this._scrollee.getNextVisibleColumn(columnIndex);
                    }
                }
                if (columnIndex != -1) {
                    this._scrollee.scrollColumnIntoView(columnIndex);
                    scrolledHorizontal = true;
                }
            }
            if (this._vertical) {
                int rowIndex = -1;
                if (this._vDecrease) {
                    rowIndex = this._scrollee.getRowAt(-origin.y);
                    if (rowIndex != -1) {
                        rowIndex = this._scrollee.getPreviousVisibleRow(rowIndex);
                    }
                } else {
                    pos = -origin.y + ((JViewport)this._scrollee.getParent().getParent().getParent()).getExtentSize().height;
                    rowIndex = this._scrollee.getRowAt(pos);
                    if (rowIndex != -1 && rowIndex != this._scrollee.getRowCount() - 1) {
                        rowIndex = this._scrollee.getNextVisibleRow(rowIndex);
                    }
                }
                if (rowIndex != -1) {
                    this._scrollee.scrollRowIntoView(rowIndex);
                    scrolledVertical = true;
                }
            }
        }
        finally {
            this._scrollee.unfreezeRepaints();
        }
        if (scrolledHorizontal || scrolledVertical) {
            this._timer.setDelay(100);
            this._timer.restart();
        } else {
            this._scheduled = false;
        }
    }

    private HeaderAutoScroller() {
    }
}

