/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.io.Serializable;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.PivotHandleCell;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;

public class ColumnHeaderPivotHandleData
extends ArrayOneDModel
implements Serializable {
    protected CrosstabModel model = null;
    protected Crosstab crosstab = null;
    private PivotHandleCell[] m_cells;
    private static final String m_method_getdata = "getData(int index)";

    public ColumnHeaderPivotHandleData(CrosstabModel model, Crosstab t) throws EdgeOutOfRangeException {
        super(model.getDataAccess().getLayerCount(0));
        this.crosstab = t;
        this.model = model;
        this.m_cells = new PivotHandleCell[this.getItemCount()];
    }

    public void setData(int index, Object data) {
    }

    public Object getData(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        if (this.m_cells[index] == null) {
            PivotHandleCell cell;
            Object data = null;
            int drillstate = 0;
            DataAccess da = this.model.getDataAccess();
            try {
                Object drillstateObj;
                String layerLabelType;
                boolean bShowLabel = true;
                if (!this.crosstab.isMeasurePivotLabelTextDisplayed()) {
                    Object objMeasure;
                    boolean bMeasure = false;
                    if (this.crosstab.isLayerMetaMeasureSupported() && (objMeasure = da.getLayerMetadata(0, index, "dimIsMeasure")) instanceof Boolean) {
                        bMeasure = (Boolean)objMeasure;
                    }
                    if (bMeasure) {
                        bShowLabel = false;
                    }
                }
                if (bShowLabel && this.crosstab.isLayerMetadataLabelTypeSupported(layerLabelType = this.crosstab.getLayerMetadataLabelType(0))) {
                    data = da.getLayerMetadata(0, index, layerLabelType);
                }
                if (this.crosstab.isLayerMetaDrillStateSupported() && (drillstateObj = da.getLayerMetadata(0, index, "dimDrillState")) instanceof Integer) {
                    drillstate = (Integer)drillstateObj;
                }
            }
            catch (EdgeOutOfRangeException ee) {
                this.crosstab.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getdata);
                data = null;
            }
            catch (LayerOutOfRangeException le) {
                this.crosstab.getErrorHandler().log("invalid layer", this.getClass().getName(), m_method_getdata);
                data = null;
            }
            switch (drillstate) {
                case 1: {
                    drillstate = 1;
                    break;
                }
                case 2: {
                    drillstate = 2;
                    break;
                }
                default: {
                    drillstate = 0;
                }
            }
            this.m_cells[index] = cell = new PivotHandleCell(0, index, data, drillstate);
            return cell;
        }
        return this.m_cells[index];
    }

    void clearCache() {
        if (this.m_cells != null) {
            for (int i = 0; i < this.m_cells.length; ++i) {
                this.m_cells[i] = null;
            }
        }
    }
}

