/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Crosstab;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Layout;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PagingComponent;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.dss.util.PagingControlAttributes;

public class CrosstabLayout
extends Layout {
    protected Crosstab m_crosstab;
    private boolean m_bMeasuresPivotable = true;
    private Layout.PopupManager m_measuresPopupManager;
    private PagingControlAttributes m_pca = null;

    public CrosstabLayout() {
        this.init();
        this.updateTextUsingCorrectLocale();
    }

    public void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        String rMeasures = this.m_rBundle.getString("Measures");
        this.m_popupManager.setRowName(this.m_rBundle.getString("Row"));
        this.m_popupManager.setColumnName(this.m_rBundle.getString("Column"));
        this.m_popupManager.setMeasureName(rMeasures);
        this.m_measuresPopupManager.setMeasureName(rMeasures);
        this.m_measuresPopupManager.updateTextUsingCorrectLocale();
    }

    private void init() {
        Layout.LayoutPivotListener pivotListener = new Layout.LayoutPivotListener((Layout)this);
        this.m_popupManager.setPivotListener((PivotListener)pivotListener);
        this.m_popupManager.setPageLayoutComponent((LayoutComponent)this.m_pageEdgeLayers);
        this.m_crosstab = new Crosstab();
        this.m_crosstab.addPivotListener((PivotListener)new Layout.LayoutPivotListener((Layout)this));
        this.m_crosstab.setPopupManager(this.m_popupManager);
        this.m_measuresPopupManager = new Layout.PopupManager((Layout)this);
        this.m_measuresPopupManager.setPivotListener((PivotListener)pivotListener);
        this.m_measuresPopupManager.setShowHideMenuItem(false);
        this.setMeasuresPivotable(true);
        this.m_crosstab.setAlignmentX(0.0f);
        this.add((Component)this.m_crosstab);
        this.m_componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CrosstabLayout.this.resizeDescriptionLabel();
            }
        };
        this.addComponentListener(this.m_componentListener);
    }

    public void setPagingControlAttributes(PagingControlAttributes pca) {
        this.m_pca = pca;
        if (this.m_pca != null) {
            this.m_showPageItemsChkBox.setSelected(this.m_pca.isPagingControlVisible());
        }
    }

    public boolean apply() {
        if (this.m_pca != null) {
            this.m_pca.setPagingControlVisible(this.m_bPagingControlVisible);
        }
        return super.apply();
    }

    public String getDescriptionText() {
        if (super.getDescriptionText() != null && super.getDescriptionText().length() > 0) {
            return super.getDescriptionText();
        }
        return this.m_rBundle.getString("crosstabLayoutDesc");
    }

    public void setMeasuresPivotable(boolean pivotable) {
        this.m_bMeasuresPivotable = pivotable;
        if (pivotable) {
            this.m_crosstab.setGridPopupManager(this.m_popupManager);
        } else {
            this.m_crosstab.setGridPopupManager(this.m_measuresPopupManager);
            this.m_popupManager.setMeasureLayoutComponent(null);
        }
    }

    public boolean isMeasuresPivotable() {
        return this.m_bMeasuresPivotable;
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            return ((Object)((Object)this)).getClass().getName() + "_PageCtrl";
        }
        return ((Object)((Object)this)).getClass().getName() + "_NoPageCtrl";
    }

    protected void updateLayerDisplay() {
        super.updateLayerDisplay();
        this.addLayersToPagingComponent((PagingComponent)this.m_pageEdgeLayers, 2, true, true);
        Vector rowLayers = this.getEdgeLayers(1);
        Object[] arrRowLayers = new String[rowLayers.size()];
        rowLayers.copyInto(arrRowLayers);
        Vector colLayers = this.getEdgeLayers(0);
        Object[] arrColLayers = new String[colLayers.size()];
        colLayers.copyInto(arrColLayers);
        this.m_crosstab.getColumnHeader().setItems((String[])arrColLayers);
        this.m_crosstab.getRowHeader().setItems((String[])arrRowLayers);
        int measureEdge = this.m_layoutAccess.getMeasureEdge();
        if (measureEdge == 1) {
            this.m_crosstab.setDataPointOrientation(1);
        } else {
            this.m_crosstab.setDataPointOrientation(0);
        }
        this.m_crosstab.getDataPointGrid().setItems(this.m_layoutAccess.getMeasures(this.getMemberMetadataLabelType()));
    }

    protected boolean performPivot(int fromEdge, int toEdge, int fromLayer, int toLayer, boolean isPivot) {
        block9: {
            int flags = -1;
            if (fromEdge == toEdge && fromEdge == -1) {
                try {
                    if (super.performPivot(fromEdge, toEdge, fromLayer, toLayer, isPivot)) break block9;
                    String[] measures = null;
                    if (this.m_layoutAccess != null && (measures = this.m_layoutAccess.getMeasures("value")) != null) {
                        int measureCount = measures.length;
                        if (fromLayer > -1 && fromLayer < measureCount && toLayer > -1 && toLayer < measureCount) {
                            Object[] reorderedMeasures = new String[measureCount];
                            Vector<String> vMeasures = new Vector<String>();
                            for (int i = 0; i < measureCount; ++i) {
                                vMeasures.addElement(measures[i]);
                            }
                            String sourceMeasure = measures[fromLayer];
                            String destinationMeasure = measures[toLayer];
                            if (isPivot) {
                                vMeasures.removeElementAt(fromLayer);
                                vMeasures.insertElementAt(sourceMeasure, toLayer);
                            } else {
                                vMeasures.setElementAt(destinationMeasure, fromLayer);
                                vMeasures.setElementAt(sourceMeasure, toLayer);
                            }
                            vMeasures.copyInto(reorderedMeasures);
                            this.m_layoutAccess.setMeasures((String[])reorderedMeasures);
                            return true;
                        }
                    }
                    break block9;
                }
                catch (Exception e) {
                    if (this.m_eh != null) {
                        this.m_eh.error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "performPivot");
                    }
                    break block9;
                }
            }
            return super.performPivot(fromEdge, toEdge, fromLayer, toLayer, isPivot);
        }
        return false;
    }
}

