/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class SchemaObjectValidator<T extends SchemaObject>
extends DBObjectValidator<T> {
    public SchemaObjectValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    private void validateSchema(SchemaObject schemaObject) throws ValidationException {
        Schema schema = schemaObject.getSchema();
        if (schema == null) {
            throw new ValidationException((DBObject)schemaObject, APIBundle.get("DBOV_NO_SCHEMA"));
        }
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = schema.getName();
        if (!ModelUtil.hasLength((String)string)) {
            throw new InvalidNameException((DBObject)schema, APIBundle.get("DBOV_SCHEMA_NO_NAME"));
        }
        if (!dBObjectProvider.isValidName("SCHEMA", dBObjectProvider.getExternalName(string))) {
            throw new InvalidNameException((DBObject)schema, APIBundle.format("DBOV_SCHEMA_INVALID_NAME", string));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"schema"})
    public void validateSchema(T t, T t2) throws ValidationException {
        Schema schema = t == null ? null : t.getSchema();
        Schema schema2 = t2.getSchema();
        if (schema == null) {
            this.validateSchema((SchemaObject)t2);
        } else {
            DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
            if (!databaseDescriptor.areNamesEqual(schema, schema2)) {
                if (this.canChangeSchema()) {
                    this.validateSchema((SchemaObject)t2);
                    if (databaseDescriptor.areNamesEqual((DBObject)t, (DBObject)t2)) {
                        this.validateNameInUse(t2);
                    }
                } else {
                    throw new ValidationException((DBObject)t2, APIBundle.get("DBOV_NO_SCHEMA_CHANGE"));
                }
            }
        }
    }

    protected boolean canChangeSchema() {
        return true;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject dBObject, T t) throws DBException {
        if (this.checkSchemaDelete(dBObject, t)) {
            return CascadeAction.DELETE;
        }
        return super.cascadeDelete(dBObject, t);
    }

    protected boolean checkSchemaDelete(DBObject dBObject, T t) {
        return dBObject instanceof Schema && DBUtil.areNamesAndTypesEqual(dBObject, t.getSchema());
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        CascadeAction cascadeAction = super.cascadePropertyChange(difference, string, object, object2, t);
        if (this.checkSchemaRename(difference, string, t)) {
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    protected boolean checkSchemaRename(Difference difference, String string, T t) {
        DBObject dBObject;
        boolean bl = false;
        if ("name".equals(string) && DBUtil.areNamesAndTypesEqual(dBObject = (DBObject)difference.getOriginalObject(), t.getSchema())) {
            t.setSchema((Schema)difference.getUpdatedObject());
            bl = true;
        }
        return bl;
    }
}

