/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeWorker;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationCancelledException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectValidator<T extends DBObject>
extends CascadeWorker<T>
implements oracle.javatools.db.DBObjectValidator<T> {
    private SortedMap<String, Method> m_propMap;

    protected DBObjectValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void checkInterrupt() throws ValidationCancelledException {
        if (Thread.currentThread().isInterrupted()) {
            throw new ValidationCancelledException();
        }
    }

    protected void logException(DBException dBException, Level level) throws ValidationCancelledException {
        if (dBException instanceof CancelledException) {
            throw new ValidationCancelledException();
        }
        this.getLogger().log(level, dBException.getMessage());
    }

    @Override
    @Deprecated
    public final void validateObject(T t) throws ValidationException {
        this.validateObject(null, t);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(T t, String string) throws ValidationException {
        this.validateObjectProperty(null, t, string);
    }

    private boolean isTemporaryCopy(T t, T t2) {
        return t != null && TemporaryObjectID.findOriginalObject(t2) == t;
    }

    protected boolean shouldValidateProperty(ValidationContext<? extends T> validationContext, String string) {
        T t;
        T t2 = validationContext.getOriginalObject();
        return !this.isTemporaryCopy(t2, t = validationContext.getUpdatedObject()) || !DBUtil.needsBuilding(t, string);
    }

    @Override
    public void validateObject(T t, T t2) throws ValidationException {
        this.validateObjectProperty(t, t2, null);
    }

    @Override
    @Deprecated
    public void validateObjectProperty(T t, T t2, String string) throws ValidationException {
        this.validateImpl(new ValidationContext<T>(t, t2, ValidationLevel.FULL, string));
    }

    public final void validate(ValidationContext<? extends T> validationContext) throws ValidationException {
        T t = validationContext.getOriginalObject();
        T t2 = validationContext.getUpdatedObject();
        String[] stringArray = validationContext.getProperties();
        if (stringArray == null) {
            Method method = this.getLegacyMethod("validateObject", DBObject.class, DBObject.class);
            if (method == null) {
                this.validateImpl(validationContext);
            } else {
                this.invokeValidationMethod(method, t, t2);
            }
        } else {
            Method method = this.getLegacyMethod("validateObjectProperty", DBObject.class, DBObject.class, String.class);
            if (method == null) {
                this.validateImpl(validationContext);
            } else {
                for (String string : stringArray) {
                    this.invokeValidationMethod(method, t, t2, string);
                }
            }
        }
    }

    private Method getLegacyMethod(String string, Class ... classArray) {
        Method method = null;
        try {
            Method method2 = this.getClass().getMethod(string, classArray);
            if (!DBObjectValidator.class.equals(method2.getDeclaringClass())) {
                method = method2;
            }
        }
        catch (Exception exception) {
            this.getLogger().log(DBLog.getExceptionLogLevel(), "Reflection error", exception);
        }
        return method;
    }

    private void validateImpl(ValidationContext<? extends T> validationContext) throws ValidationException {
        Object object;
        Collection<String> collection;
        Collection<String> collection2;
        ValidationException validationException = null;
        T t = validationContext.getOriginalObject();
        T t2 = validationContext.getUpdatedObject();
        ValidationLevel validationLevel = validationContext.getLevel();
        String[] stringArray = validationContext.getProperties();
        if (stringArray == null) {
            collection2 = this.getPropertyMethodMap().keySet();
        } else {
            collection2 = new ArrayList();
            collection = this.listAlwaysValidProperties();
            for (String object2 : stringArray) {
                if (object2 == null || collection.contains(object2)) continue;
                collection2.add(object2);
            }
        }
        collection = new HashSet<String>();
        HashSet hashSet = new HashSet();
        for (String string : collection2) {
            this.checkInterrupt();
            if (this.shouldValidateProperty(validationContext, string)) {
                Method method = this.findValidationPropertyMethod(string);
                Object object2 = object = method == null ? null : method.getAnnotation(PropertyValidator.class);
                if (object == null || object.level() == null || object.level().ordinal() > validationContext.getLevel().ordinal()) {
                    boolean bl = this.validateMissingMethod(validationContext, string);
                    if (bl) {
                        collection.add(string);
                        continue;
                    }
                    if (method != null) continue;
                    validationException = ValidationException.append(validationException, new MissingValidatorException((DBObject)t2, string));
                    continue;
                }
                if (hashSet.contains(method)) continue;
                hashSet.add(method);
                collection.add(string);
                if (object.path()) {
                    collection.add(Property.stripProperties(Property.createPath(object.value())));
                } else {
                    for (String string2 : object.value()) {
                        collection.add(string2);
                    }
                }
                try {
                    if (method.getParameterTypes().length == 1) {
                        this.invokeValidationMethod(method, validationContext);
                        continue;
                    }
                    this.invokeValidationMethod(method, t, t2);
                }
                catch (ValidationException validationException2) {
                    if (validationException2.getPropertyName() == null) {
                        validationException2.setPropertyName(string);
                    }
                    validationException = ValidationException.append(validationException, validationException2);
                }
                continue;
            }
            this.getLogger().log(Level.FINE, "Skipping validation for {0} on {1}", new String[]{string, t2.getName()});
        }
        if (stringArray == null) {
            Map<String, Object> map = this.isTemporaryCopy(t, t2) ? DBUtil.getFrozenProperties(t2) : t2.getProperties();
            for (Map.Entry entry : map.entrySet()) {
                this.checkInterrupt();
                object = (String)entry.getKey();
                if (collection.contains(object)) continue;
                Object v = entry.getValue();
                try {
                    if (v instanceof DBObject[]) {
                        this.validateOwnedObjects(validationLevel, (DBObject[])v);
                        continue;
                    }
                    if (!(v instanceof DBObject)) continue;
                    this.validateOwnedObjects(validationLevel, (DBObject)v);
                }
                catch (MissingValidatorException missingValidatorException) {
                    this.getLogger().fine(missingValidatorException.getMessage());
                }
                catch (ValidationException validationException3) {
                    if (validationException3.getPropertyName() == null) {
                        validationException3.setPropertyName((String)object);
                    }
                    validationException = ValidationException.append(validationException, validationException3);
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
    }

    private boolean validateMissingMethod(ValidationContext<? extends T> validationContext, String string) throws ValidationException {
        String string2;
        String[] stringArray;
        boolean bl = false;
        T t = validationContext.getOriginalObject();
        T t2 = validationContext.getUpdatedObject();
        PropertyHelper propertyHelper = new PropertyHelper();
        String[] stringArray2 = Property.getProperties(string);
        String string3 = stringArray2[0];
        if (stringArray2.length > 1) {
            stringArray = new String[stringArray2.length - 1];
            System.arraycopy(stringArray2, 1, stringArray, 0, stringArray.length);
            string2 = Property.createPath(stringArray);
        } else {
            string2 = null;
        }
        stringArray = t == null ? null : propertyHelper.getPropertyValue(t2, string3);
        Object object = propertyHelper.getPropertyValue(t2, string3);
        if (object == null && (string2 != null || this.isChildObjectProperty((DBObject)t2, string3))) {
            bl = true;
            this.validateMissingPath(t, t2, string);
        } else if (object instanceof DBObject) {
            DBObject dBObject = (DBObject)object;
            if (dBObject.getParent() == t2) {
                try {
                    bl = true;
                    this.validateChild((DBObject)stringArray, (DBObject)object, validationContext.getLevel(), string2);
                }
                catch (MissingValidatorException missingValidatorException) {
                    bl = false;
                }
            }
        } else if (string2 == null && object instanceof DBObject[]) {
            bl = true;
            this.validateOwnedObjects(validationContext.getLevel(), (DBObject[])object);
        }
        return bl;
    }

    private boolean isChildObjectProperty(DBObject dBObject, String string) {
        PropertyInfo propertyInfo;
        boolean bl = false;
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null && (propertyInfo = this.getProvider().getPropertyManager().findPropertyInfo(dBObject.getClass(), string)) != null) {
            bl = DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(propertyInfo.getPropertyClass()));
        }
        return bl;
    }

    protected void validateMissingPath(T t, T t2, String string) throws ValidationException {
    }

    protected Collection<String> listAlwaysValidProperties() {
        return new TreeSet<String>();
    }

    private void invokeValidationMethod(Method method, Object ... objectArray) throws ValidationException {
        try {
            method.invoke((Object)this, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.processPropException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ValidationException) {
                throw (ValidationException)throwable;
            }
            this.processPropException(throwable == null ? invocationTargetException : throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.processPropException(illegalAccessException);
        }
    }

    private void processPropException(Throwable throwable) {
        this.getLogger().log(DBLog.getExceptionLogLevel(), "Error calling property validation", throwable);
    }

    private Method findValidationPropertyMethod(String string) {
        Method method = null;
        if (ModelUtil.hasLength((String)string)) {
            method = this.getPropertyMethodMap().get(string);
        }
        return method;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                this.populateMethodMap(clazz);
                if (clazz == DBObjectValidator.class) break;
            }
        }
        return this.m_propMap;
    }

    private void populateMethodMap(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            PropertyValidator propertyValidator = method.getAnnotation(PropertyValidator.class);
            if (propertyValidator == null) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.logMethodError(method, "@PropertyValidator methods must be public");
                continue;
            }
            String[] stringArray = propertyValidator.path() ? new String[]{Property.createPath(propertyValidator.value())} : propertyValidator.value();
            for (String string : stringArray) {
                if (!ModelUtil.hasLength((String)string)) {
                    this.logMethodError(method, "@PropertyValidator for method " + clazz.getName() + "." + method.getName() + " is missing a property name");
                    continue;
                }
                if (this.m_propMap.containsKey(string)) continue;
                this.m_propMap.put(string, method);
            }
        }
    }

    private void logMethodError(Method method, String string) {
        this.getLogger().log(DBLog.getExceptionLogLevel(), method.getName(), new IllegalStateException(string));
    }

    @PropertyValidator(value={"type"})
    public final void validateType(T t, T t2) throws ValidationException {
        if (t != null && ModelUtil.areDifferent((Object)t.getType(), (Object)t2.getType())) {
            throw new ValidationException((DBObject)t2, APIBundle.get("DBOV_NO_TYPE_CHANGE"));
        }
    }

    @PropertyValidator(value={"name"})
    @PropertyDependency(value={"schema"})
    public final void validateName(T t, T t2) throws ValidationException {
        this.validateName(t2);
        if (t == null) {
            this.validateNameInUse(t2);
        } else if (!this.getProvider().getDescriptor().areNamesEqual((DBObject)t, (DBObject)t2)) {
            if (this.canRename()) {
                this.validateNameInUse(t2);
            } else {
                throw new ValidationException((DBObject)t2, APIBundle.get("DBOV_NO_RENAME"));
            }
        }
    }

    protected final boolean isChildOfPendingObject(DBObject dBObject) {
        boolean bl = false;
        DBObject dBObject2 = dBObject;
        while (dBObject2.getParent() != null) {
            dBObject2 = dBObject2.getParent();
            bl = true;
        }
        if (dBObject2 instanceof SchemaObject && !this.isPendingObject((SchemaObject)dBObject2)) {
            bl = false;
        }
        return bl;
    }

    protected final boolean isPendingObject(SchemaObject schemaObject) {
        return TemplateExpander.isPendingObject(schemaObject);
    }

    protected void validateName(T t) throws InvalidNameException {
        String string = t.getName();
        if (!ModelUtil.hasLength((String)string) && !this.canHaveEmptyName()) {
            throw new InvalidNameException((DBObject)t, APIBundle.get("DBOV_NO_NAME"));
        }
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null && ModelUtil.hasLength((String)string)) {
            try {
                String string2 = dBObjectProvider.getExternalName(string);
                this.validateName(t.getType(), string2);
            }
            catch (InvalidNameException invalidNameException) {
                String string3 = invalidNameException.getMessage();
                throw new InvalidNameException((DBObject)t, APIBundle.format("DBOV_INVALID_NAME", string, string3));
            }
        }
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null) {
            dBObjectProvider.getDescriptor().validateName(string, string2);
        }
    }

    protected final void validateNonNullableProperty(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        if (dBObject != null && this.getProvider() instanceof Database) {
            Object object = dBObject.getProperty(string);
            Object object2 = dBObject2.getProperty(string);
            if (object != null && object2 == null) {
                throw new ValidationException(dBObject2, APIBundle.format("INVALID_NULL_VALUE", DisplayNames.getPropertyDisplayName(string)));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected void validateNameInUse(T t) throws NameInUseException {
        this.validateNameInUse(t, this.getNamespaceType());
    }

    protected final void validateNameInUse(T t, NamespaceType namespaceType) throws NameInUseException {
        String string;
        Object object;
        Schema schema = DBUtil.getSchema(t);
        String string2 = t.getName();
        DBObjectProvider dBObjectProvider = this.getProvider();
        DBObject dBObject = t.getParent();
        if (dBObject != null && namespaceType.compareTo(NamespaceType.TYPE_PARENT) >= 0 && (object = dBObject.getProperty(string = DBUtil.getParentProperty(t))) instanceof DBObject[]) {
            for (DBObject dBObject2 : (DBObject[])object) {
                if (dBObject2 == t || !dBObjectProvider.getDescriptor().areNamesEqual(string2, dBObject2.getName(), t.getType(), false)) continue;
                throw new NameInUseException((DBObject)t, dBObject2);
            }
        }
        if (!(namespaceType.compareTo(NamespaceType.TYPE) < 0 || dBObject != null && this.isChildOfPendingObject((DBObject)t))) {
            dBObjectProvider.validateUniqueName((DBObject)t, schema);
        }
    }

    @Deprecated
    protected T findExistingObject(T t) throws ValidationException {
        DBObjectID dBObjectID = t.getID();
        DBObject dBObject = null;
        if (dBObjectID != null) {
            try {
                dBObject = dBObjectID instanceof TemporaryObjectID ? TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID) : dBObjectID.resolveID();
            }
            catch (CancelledException cancelledException) {
                throw new ValidationCancelledException();
            }
            catch (DBException dBException) {
                throw new ValidationException((DBObject)t, dBException.getMessage());
            }
            if (dBObject != null && ModelUtil.areDifferent((Object)dBObject.getType(), (Object)t.getType())) {
                throw new ValidationException((DBObject)t, APIBundle.format("DBOV_OBJ_ID_ERR", t.getName()));
            }
        }
        if (dBObject == null && t instanceof SystemObject && (dBObjectID == null || dBObjectID instanceof TemporaryObjectID)) {
            try {
                dBObject = DBUtil.getProviderDefinition((SystemObject)t, this.getProvider());
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.WARNING);
            }
        }
        return (T)dBObject;
    }

    public NamespaceType getNamespaceType() {
        return this.canHaveEmptyName() ? NamespaceType.NONE : NamespaceType.TYPE;
    }

    public boolean initializeWithDefaultName() {
        return !this.canHaveEmptyName();
    }

    @Deprecated
    protected boolean enforceChildNameUniqueInSchema(DBObject dBObject) {
        return false;
    }

    @PropertyValidator(value={"Comment"}, level=ValidationLevel.FULL)
    public void validateComment(T t, T t2) throws ValidationException {
        String string = (String)t2.getProperty("Comment");
        if (string != null) {
            DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
            try {
                databaseDescriptor.validateEncoding(string, "Comment");
            }
            catch (ValidationException validationException) {
                throw new ValidationException((DBObject)t2, validationException.getMessage());
            }
        }
    }

    public Collection<String[]> getDependencies(String string) {
        PropertyDependency propertyDependency;
        ArrayList<String[]> arrayList = null;
        Method method = this.findValidationPropertyMethod(string);
        if (method != null && (propertyDependency = method.getAnnotation(PropertyDependency.class)) != null) {
            for (String string2 : propertyDependency.value()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String[]>();
                }
                arrayList.add(new String[]{string2});
            }
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    @Deprecated
    protected final void validateOwnedObjects(DBObject ... dBObjectArray) throws ValidationException {
        this.validateOwnedObjects(ValidationLevel.FULL, dBObjectArray);
    }

    protected final void validateOwnedObjects(ValidationLevel validationLevel, DBObject ... dBObjectArray) throws ValidationException {
        if (dBObjectArray != null) {
            ValidationException validationException = null;
            for (DBObject dBObject : dBObjectArray) {
                if (dBObject == null) continue;
                DBObject dBObject2 = null;
                DBObjectID dBObjectID = dBObject.getID();
                if (dBObjectID instanceof TemporaryObjectID) {
                    dBObject2 = TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID);
                }
                try {
                    this.validateChild(dBObject2, dBObject, validationLevel, new String[0]);
                }
                catch (ValidationException validationException2) {
                    validationException = DBException.append(validationException, validationException2);
                }
            }
            if (validationException != null) {
                throw validationException;
            }
        }
    }

    private void validateChild(DBObject dBObject, DBObject dBObject2, ValidationLevel validationLevel, String ... stringArray) throws ValidationException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (!(dBObjectProvider instanceof AbstractDBObjectProvider)) {
            throw new MissingValidatorException(dBObject2);
        }
        ValidationContext<DBObject> validationContext = new ValidationContext<DBObject>(dBObject, dBObject2, validationLevel, stringArray);
        ((AbstractDBObjectProvider)dBObjectProvider).validate(validationContext);
    }

    @Deprecated
    public static void validateUniqueNames(DBObject[] dBObjectArray) throws ValidationException {
    }

    public static enum NamespaceType {
        NONE,
        TYPE_PARENT,
        TYPE,
        SCHEMA;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyDependency {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyValidator {
        public String[] value();

        public boolean path() default false;

        public ValidationLevel level() default ValidationLevel.SIMPLE;
    }
}

