/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.util;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;

public abstract class BeanHashStructureConverter {
    private static final String CLASS_NAME = ".className.";
    private final ClassLoader m_classLoader;

    protected BeanHashStructureConverter() {
        this(null);
    }

    protected BeanHashStructureConverter(ClassLoader classLoader) {
        this.m_classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public final HashStructure getHashStructureForBean(Object object) {
        HashStructure hashStructure = HashStructure.newInstance();
        this.beanToHash(object, hashStructure);
        return hashStructure;
    }

    protected final void beanToHash(Object object, HashStructure hashStructure) {
        hashStructure.putString(CLASS_NAME, object.getClass().getCanonicalName());
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            PropertyInfo propertyInfo = propertyIterator.next();
            String string = propertyInfo.getXMLName();
            Object object2 = propertyInfo.getPropertyValue(object);
            Class<?> clazz = propertyInfo.getPropertyClass();
            if (clazz == Object.class && object2 != null) {
                clazz = object2.getClass();
            }
            this.setHashValue(hashStructure, clazz, string, object2, object);
        }
    }

    protected void setHashValue(HashStructure hashStructure, Class clazz, String string, Object object, Object object2) {
        if (object != null) {
            if (this.isSupportedNatively(clazz)) {
                this.setNativeHashValue(hashStructure, clazz, string, object);
            } else if (clazz.isArray() || List.class == clazz) {
                Object[] objectArray = clazz.isArray() ? (Object[])object : ((List)object).toArray();
                ListStructure listStructure = ListStructure.newInstance();
                for (Object object3 : objectArray) {
                    if (this.isSupportedNatively(object3.getClass())) {
                        listStructure.add(object3);
                        continue;
                    }
                    HashStructure hashStructure2 = HashStructure.newInstance();
                    this.beanToHash(object3, hashStructure2);
                    listStructure.add((Object)hashStructure2);
                }
                hashStructure.putListStructure(string, listStructure);
            } else if (Map.class.isAssignableFrom(clazz)) {
                HashStructure hashStructure3 = HashStructure.newInstance();
                hashStructure.putHashStructure(string, hashStructure3);
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    String string2 = (String)entry.getKey();
                    Object v = entry.getValue();
                    Class<?> clazz2 = v.getClass();
                    if (this.isSupportedNatively(clazz2)) {
                        this.setNativeHashValue(hashStructure3, clazz2, string2, v);
                        continue;
                    }
                    HashStructure hashStructure4 = HashStructure.newInstance();
                    this.setHashValue(hashStructure4, v.getClass(), string2, v, map);
                }
            } else if (clazz == Class.class) {
                hashStructure.putString(string, ((Class)object).getCanonicalName());
            } else if (Enum.class.isAssignableFrom(clazz)) {
                Enum enum_ = (Enum)object;
                if (object != null) {
                    hashStructure.putString(string, enum_.name());
                }
            } else {
                HashStructure hashStructure5 = HashStructure.newInstance();
                this.beanToHash(object, hashStructure5);
                hashStructure.putHashStructure(string, hashStructure5);
            }
        }
    }

    private void setNativeHashValue(HashStructure hashStructure, Class clazz, String string, Object object) {
        if (String.class == clazz) {
            hashStructure.putString(string, (String)object);
        } else if (Integer.class == clazz || Integer.TYPE == clazz) {
            hashStructure.putInt(string, ((Integer)object).intValue());
        } else if (Long.class == clazz || Long.TYPE == clazz) {
            hashStructure.putLong(string, ((Long)object).longValue());
        } else if (Float.class == clazz || Float.TYPE == clazz) {
            hashStructure.putFloat(string, ((Float)object).floatValue());
        } else if (Double.class == clazz || Double.TYPE == clazz) {
            hashStructure.putDouble(string, ((Double)object).doubleValue());
        } else if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            hashStructure.putBoolean(string, ((Boolean)object).booleanValue());
        } else if (URL.class.isAssignableFrom(clazz)) {
            hashStructure.putURL(string, (URL)object);
        } else if (HashStructure.class.isAssignableFrom(clazz)) {
            hashStructure.putHashStructure(string, (HashStructure)object);
        } else if (ListStructure.class.isAssignableFrom(clazz)) {
            hashStructure.putListStructure(string, (ListStructure)object);
        }
    }

    public final boolean isGetBeanSupported(HashStructure hashStructure) {
        return hashStructure.containsKey(CLASS_NAME);
    }

    public final Object getBeanFromHashStructure(HashStructure hashStructure) throws HashToBeanException {
        return this.createObjectForHash(null, null, hashStructure);
    }

    protected final Object createObjectForHash(Object object, String string, HashStructure hashStructure) throws HashToBeanException {
        Object object2 = null;
        try {
            Class<?> clazz;
            String string2 = hashStructure.getString(CLASS_NAME);
            if (string2 != null && (object2 = this.createObject(object, string, clazz = Class.forName(string2, true, this.m_classLoader))) != null) {
                this.hashToBean(hashStructure, object2);
            }
        }
        catch (Exception exception) {
            throw new HashToBeanException(exception, object2);
        }
        return object2;
    }

    protected Object createObject(Object object, String string, Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    protected final void hashToBean(HashStructure hashStructure, Object object) throws Exception {
        Object object2;
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            object2 = propertyIterator.next();
            hashMap.put(object2.getXMLName(), (PropertyInfo)object2);
        }
        object2 = null;
        for (String string : hashStructure.keySet()) {
            if (CLASS_NAME.equals(string)) continue;
            PropertyInfo propertyInfo = (PropertyInfo)hashMap.get(string);
            try {
                if (propertyInfo != null) {
                    this.setBeanValue(propertyInfo, object, hashStructure);
                    continue;
                }
                this.setUnrecognisedBeanValue(object, string, hashStructure.getObject(string));
            }
            catch (Exception exception) {
                if (object2 == null) {
                    object2 = exception;
                    continue;
                }
                object2.addSuppressed(exception);
            }
        }
        if (object2 != null) {
            throw object2;
        }
    }

    protected void setBeanValue(PropertyInfo propertyInfo, Object object, HashStructure hashStructure) throws Exception {
        Class clazz = propertyInfo.getPropertyClass();
        String string = propertyInfo.getXMLName();
        if (hashStructure.containsKey(string)) {
            if (String.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getString(string));
            } else if (Integer.TYPE == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getInt(string, 0));
            } else if (Integer.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getInt(string));
            } else if (Long.TYPE == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getLong(string, 0L));
            } else if (Long.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getLong(string));
            } else if (Float.TYPE == clazz) {
                propertyInfo.setPropertyValue(object, (Object)Float.valueOf(hashStructure.getFloat(string, 0.0f)));
            } else if (Float.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)Float.valueOf(hashStructure.getFloat(string)));
            } else if (Double.TYPE == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getDouble(string, 0.0));
            } else if (Double.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getDouble(string));
            } else if (Boolean.TYPE == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getBoolean(string, false));
            } else if (Boolean.class == clazz) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getBoolean(string));
            } else if (URL.class.isAssignableFrom(clazz)) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getURL(string));
            } else if (HashStructure.class.isAssignableFrom(clazz)) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getHashStructure(string));
            } else if (ListStructure.class.isAssignableFrom(clazz)) {
                propertyInfo.setPropertyValue(object, (Object)hashStructure.getListStructure(string));
            } else if (clazz.isArray() || List.class == clazz) {
                ListStructure listStructure = hashStructure.getListStructure(string);
                if (listStructure != null && !listStructure.isEmpty()) {
                    int n = listStructure.size();
                    Object[] objectArray = clazz.isArray() ? Arrays.copyOf(new Object[0], n, clazz) : new Object[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = listStructure.get(i);
                        if (object2 instanceof HashStructure) {
                            HashStructure hashStructure2 = (HashStructure)object2;
                            if (this.isGetBeanSupported(hashStructure2)) {
                                objectArray[i] = this.getBeanFromHashStructure(hashStructure2);
                                continue;
                            }
                            objectArray[i] = this.getListValue(object, string, i, object2);
                            continue;
                        }
                        objectArray[i] = this.getListValue(object, string, i, object2);
                    }
                    Object object3 = clazz.isArray() ? objectArray : Arrays.asList(objectArray);
                    propertyInfo.setPropertyValue(object, object3);
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                HashStructure hashStructure3 = hashStructure.getHashStructure(string);
                if (hashStructure3 != null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    for (String string2 : hashStructure3.keySet()) {
                        Object object4 = hashStructure3.getObject(string2);
                        if (object4 instanceof HashStructure) {
                            HashStructure hashStructure4 = (HashStructure)object4;
                            if (this.isGetBeanSupported(hashStructure4)) {
                                hashMap.put(string2, this.getBeanFromHashStructure(hashStructure4));
                                continue;
                            }
                            hashMap.put(string2, this.getMapValue(object, string, string2, object4));
                            continue;
                        }
                        hashMap.put(string2, this.getMapValue(object, string, string2, object4));
                    }
                    propertyInfo.setPropertyValue(object, hashMap);
                }
            } else if (clazz == Class.class) {
                String string3 = hashStructure.getString(string);
                if (string3 != null) {
                    Class<?> clazz2 = Class.forName(string3, true, this.m_classLoader);
                    propertyInfo.setPropertyValue(object, clazz2);
                }
            } else if (Enum.class.isAssignableFrom(clazz)) {
                String string4 = hashStructure.getString(string);
                if (string4 != null) {
                    Object t = Enum.valueOf(clazz, string4);
                    propertyInfo.setPropertyValue(object, t);
                }
            } else {
                HashStructure hashStructure5 = hashStructure.getHashStructure(string);
                if (hashStructure5 != null) {
                    HashToBeanException hashToBeanException = null;
                    Object object5 = null;
                    try {
                        object5 = this.createObjectForHash(object, string, hashStructure5);
                    }
                    catch (HashToBeanException hashToBeanException2) {
                        hashToBeanException = hashToBeanException2;
                        object5 = hashToBeanException2.getObject();
                    }
                    if (object5 != null) {
                        propertyInfo.setPropertyValue(object, object5);
                    }
                    if (hashToBeanException != null) {
                        throw hashToBeanException;
                    }
                }
            }
        }
    }

    protected void setUnrecognisedBeanValue(Object object, String string, Object object2) throws Exception {
        throw new IllegalStateException("No PropertyInfo for property " + string);
    }

    protected Object getMapValue(Object object, String string, String string2, Object object2) {
        return object2;
    }

    protected Object getListValue(Object object, String string, int n, Object object2) {
        return object2;
    }

    private final boolean isSupportedNatively(Class clazz) {
        return String.class == clazz || Integer.TYPE == clazz || Integer.class == clazz || Long.TYPE == clazz || Long.class == clazz || Float.TYPE == clazz || Float.class == clazz || Double.TYPE == clazz || Double.class == clazz || Boolean.TYPE == clazz || Boolean.class == clazz || URL.class.isAssignableFrom(clazz) || HashStructure.class.isAssignableFrom(clazz) || ListStructure.class.isAssignableFrom(clazz);
    }

    public static class HashToBeanException
    extends Exception {
        private final Object m_obj;

        private HashToBeanException(Exception exception, Object object) {
            super(exception);
            this.m_obj = object;
        }

        public final Object getObject() {
            return this.m_obj;
        }

        @Override
        public synchronized Throwable getCause() {
            return super.getCause();
        }
    }
}

