/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperation
extends Operation {
    public SetOperation() {
        this(Operator.IN, null);
    }

    public SetOperation(Operator operator, SQLFragment[] sQLFragmentArray) {
        this.setFunctionFormat(false);
        this.setArguments(sQLFragmentArray);
        this.setOperator(operator);
    }

    public void setOperator(Operator operator) {
        if (operator == Operator.BETWEEN || operator == Operator.NOT_BETWEEN) {
            this.setSeparator(" AND ");
        } else {
            this.setSeparator(", ");
        }
        this.setProperty("operator", (Object)operator);
    }

    public Operator getOperator() {
        return (Operator)((Object)this.getProperty("operator"));
    }

    @Override
    protected String getOperatorText() {
        Operator operator = this.getOperator();
        return operator == null ? null : operator.getSQLText();
    }

    @Override
    public String getSQLText() {
        String string = null;
        Operator operator = this.getOperator();
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            List<SQLFragment> list = Arrays.asList(this.getArguments());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(list.iterator().next());
            stringBuffer.append(" ").append(this.getOperatorText()).append(" ");
            String string2 = this.argsToString(list, false, this.getSeparator(), 1);
            if (list.size() > 2 || list.size() == 2 && !string2.startsWith("(")) {
                string2 = this.surroundWithBrackets(string2, true);
            }
            stringBuffer.append(string2);
            string = stringBuffer.toString();
        } else {
            string = super.getSQLText();
        }
        return string;
    }

    public static enum Operator {
        BETWEEN(704),
        NOT_BETWEEN(706),
        IN(705),
        EQUALS_ANY(729),
        NOT_IN(707);

        private final int m_oldValue;

        private Operator(int n2) {
            this.m_oldValue = n2;
        }

        public String getSQLText() {
            String string = this == EQUALS_ANY ? "=ANY" : this.toString().replace("_", " ");
            return string;
        }

        public static Operator migrate(String string) {
            Operator operator = null;
            if (string != null) {
                for (Operator operator2 : Operator.values()) {
                    if (!string.equals(String.valueOf(operator2.m_oldValue))) continue;
                    operator = operator2;
                    break;
                }
            }
            return operator;
        }
    }
}

