/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.sql.AbstractDBObjectUsage;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;

public final class SQLFragmentUtils {
    private SQLFragmentUtils() {
    }

    public static SelectObject[] getSelectObjects(SQLQuery sQLQuery) {
        SetOperator setOperator = sQLQuery.getSetOperator();
        if (setOperator != null) {
            SQLQuery sQLQuery2 = (SQLQuery)setOperator.getArguments()[0];
            return SQLFragmentUtils.getSelectObjects(sQLQuery2);
        }
        return sQLQuery.getSelectObjects();
    }

    public static void replaceStarColumns(SQLQuery sQLQuery) {
        if (sQLQuery.isDeclarative()) {
            List<SelectObject> list = SQLFragmentUtils.expandStarColumns(sQLQuery);
            sQLQuery.setSelectObjects(list.toArray(new SelectObject[list.size()]));
        }
    }

    public static List<SelectObject> expandStarColumns(SQLQuery sQLQuery) {
        ArrayList<SelectObject> arrayList = new ArrayList<SelectObject>();
        for (SelectObject selectObject : SQLFragmentUtils.getSelectObjects(sQLQuery)) {
            String string;
            int n = arrayList.size();
            SQLFragment sQLFragment = selectObject.getExpression();
            if (sQLFragment instanceof ColumnKeywordUsage && "*".equals(string = ((ColumnKeywordUsage)sQLFragment).getColumnName())) {
                FromObject fromObject = ((ColumnKeywordUsage)sQLFragment).resolveFromObject();
                if (fromObject == null) {
                    for (FromObject fromObject2 : sQLQuery.getFromObjects()) {
                        SQLFragmentUtils.addAllColumns(fromObject2, arrayList);
                    }
                } else {
                    SQLFragmentUtils.addAllColumns(fromObject, arrayList);
                }
            }
            if (n != arrayList.size()) continue;
            arrayList.add(selectObject);
        }
        return arrayList;
    }

    private static void addAllColumns(FromObject fromObject, Collection<SelectObject> collection) {
        if (fromObject != null) {
            ArrayList arrayList = new ArrayList();
            SQLFragmentUtils.queryColumns(fromObject, null, arrayList, SelectObject.class);
            for (SelectObject selectObject : arrayList) {
                collection.add(selectObject);
            }
        }
    }

    public static Relation getTable(FromObject fromObject) {
        DBObjectID dBObjectID;
        Relation relation = null;
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof DBObjectUsage && (dBObjectID = ((DBObjectUsage)sQLFragment).getObjectID()) != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof Relation) {
                    relation = (Relation)dBObject;
                }
            }
            catch (DBException dBException) {
                SQLFragmentUtils.getLogger().log(Level.WARNING, "Couldn't find table for FROM {0}: {1}", new Object[]{fromObject.getName(), dBException.getMessage()});
            }
        }
        return relation;
    }

    public static String getTableName(FromObjectUsage fromObjectUsage) {
        FromObject fromObject = fromObjectUsage.resolveFromObject();
        return fromObject == null ? null : fromObject.getName();
    }

    public static Set<String> listFromObjectNames(SQLQuery sQLQuery) {
        HashSet<String> hashSet = new HashSet<String>();
        SQLFragmentUtils.addFromNames(sQLQuery, hashSet);
        return hashSet;
    }

    private static void addFromNames(SQLFragment sQLFragment, Set<String> set) {
        if (sQLFragment != null) {
            if (sQLFragment instanceof FromObject) {
                set.add(sQLFragment.getName());
            }
            for (DBObject dBObject : sQLFragment.getOwnedObjects()) {
                if (!(dBObject instanceof SQLFragment)) continue;
                SQLFragmentUtils.addFromNames((SQLFragment)dBObject, set);
            }
        }
    }

    public static Collection<String> listCommonColumns(JoinObject joinObject) {
        return SQLFragmentUtils.listCommonColumns(joinObject.getLeftExpression(), joinObject.getRightExpression());
    }

    public static Collection<String> listCommonColumns(FromObject fromObject, FromObject fromObject2) {
        Collection<String> collection = SQLFragmentUtils.listColumnNames(fromObject.getExpression());
        Collection<String> collection2 = SQLFragmentUtils.listColumnNames(fromObject2.getExpression());
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (collection2.contains(iterator.next())) continue;
            iterator.remove();
        }
        return collection;
    }

    @Deprecated
    public static Collection<Column> listColumns(SQLFragment sQLFragment) {
        return Collections.emptyList();
    }

    @Deprecated
    public static Collection<ColumnUsage> listColumnUsages(SQLFragment sQLFragment) {
        return Collections.emptyList();
    }

    public static Collection<String> listColumnNames(SQLFragment sQLFragment) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SQLFragmentUtils.queryColumns(sQLFragment, null, arrayList, String.class);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void queryColumns(SQLFragment sQLFragment, FromObject fromObject, Collection<T> collection, Class<T> clazz) {
        if (sQLFragment instanceof FromObject) {
            SQLFragmentUtils.queryColumns(((FromObject)sQLFragment).getExpression(), (FromObject)sQLFragment, collection, clazz);
            return;
        } else if (sQLFragment instanceof RelationUsage) {
            DBObjectID dBObjectID = ((RelationUsage)sQLFragment).getObjectID();
            if (dBObjectID == null) return;
            try {
                Relation relation = (Relation)dBObjectID.resolveID();
                if (relation == null) return;
                for (Column column : relation.getColumns()) {
                    collection.add(SQLFragmentUtils.createColumnObject(column, fromObject, clazz));
                }
                return;
            }
            catch (DBException dBException) {
                SQLFragmentUtils.getLogger().warning("Couldn't resolve ID: " + dBException.getMessage());
                return;
            }
        } else if (sQLFragment instanceof SynonymUsage) {
            DBObjectID dBObjectID = ((SynonymUsage)sQLFragment).getObjectID();
            if (dBObjectID == null) return;
            try {
                Synonym synonym = (Synonym)dBObjectID.resolveID();
                SchemaObject schemaObject = DBUtil.getSynonymReference(synonym);
                if (!(schemaObject instanceof Relation)) return;
                for (Column column : ((Relation)schemaObject).getColumns()) {
                    collection.add(SQLFragmentUtils.createColumnObject(column, fromObject, clazz));
                }
                return;
            }
            catch (DBException dBException) {
                SQLFragmentUtils.getLogger().warning("Couldn't resolve ID: " + dBException.getMessage());
                return;
            }
        } else if (sQLFragment instanceof JoinObject) {
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            SQLFragmentUtils.queryColumns(fromObject2, fromObject, collection, clazz);
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            SQLFragmentUtils.queryColumns(fromObject3, fromObject, collection, clazz);
            return;
        } else if (sQLFragment instanceof SQLQuery) {
            List<SelectObject> list = SQLFragmentUtils.expandStarColumns((SQLQuery)sQLFragment);
            for (SelectObject selectObject : list) {
                ColumnUsage columnUsage;
                DBObjectID dBObjectID;
                if (!(selectObject.getExpression() instanceof ColumnUsage) || (dBObjectID = (columnUsage = (ColumnUsage)selectObject.getExpression()).getObjectID()) == null) continue;
                try {
                    Column column = (Column)dBObjectID.resolveID();
                    if (column == null) continue;
                    collection.add(SQLFragmentUtils.createColumnObject(column, fromObject, clazz));
                }
                catch (DBException dBException) {}
            }
            return;
        } else {
            DBObjectID dBObjectID;
            if (!(sQLFragment instanceof Function) || !"TABLE".equals(((Function)sQLFragment).getFunction()) || (dBObjectID = ((Function)sQLFragment).getDataTypeID()) == null) return;
            try {
                DBObject dBObject;
                DBObjectID dBObjectID2;
                DBObject dBObject2 = dBObjectID.resolveID();
                if (!(dBObject2 instanceof Type) || !"COLLECTION".equals(((Type)dBObject2).getTypeCode()) || (dBObjectID2 = ((Type)dBObject2).getOfTypeUsage().getDataTypeID()) == null || !((dBObject = dBObjectID2.resolveID()) instanceof Type)) return;
                Type type = (Type)dBObject;
                for (PlSqlAttribute plSqlAttribute : type.getAttributes()) {
                    collection.add(SQLFragmentUtils.createColumnObject(plSqlAttribute, fromObject, clazz));
                }
                return;
            }
            catch (DBException dBException) {
                SQLFragmentUtils.getLogger().warning("Couldn't resolve ID: " + dBException.getMessage());
            }
        }
    }

    private static <T> T createColumnObject(DBObject dBObject, FromObject fromObject, Class<T> clazz) {
        if (!(dBObject instanceof Column) && !(dBObject instanceof PlSqlAttribute)) {
            throw new IllegalArgumentException("Only Column and PlSqlAttribute supported.");
        }
        if (clazz == String.class) {
            Object object = "";
            if (fromObject != null) {
                object = fromObject.getAlias();
                object = ModelUtil.hasLength((String)object) ? (String)object + "." : "";
            }
            return clazz.cast((String)object + dBObject.getName());
        }
        if (clazz == SelectObject.class) {
            SelectObject selectObject = new SelectObject();
            AbstractDBObjectUsage abstractDBObjectUsage = null;
            if (dBObject instanceof Column) {
                abstractDBObjectUsage = new ColumnUsage(dBObject.getID(), fromObject);
            } else {
                abstractDBObjectUsage = new PlSqlUsage();
                abstractDBObjectUsage.setObjectID(dBObject.getID());
                abstractDBObjectUsage.setFromObjectID(fromObject.getID());
            }
            selectObject.setExpression(abstractDBObjectUsage);
            return clazz.cast(selectObject);
        }
        throw new IllegalArgumentException("Unknown column query type.");
    }

    public static boolean hasPKCols(Collection<String> collection, FromObject fromObject) {
        PKConstraint pKConstraint;
        Relation relation;
        if (collection != null && !collection.isEmpty() && (relation = SQLFragmentUtils.getTable(fromObject)) != null && (pKConstraint = PKConstraint.getPrimaryKey(relation)) != null) {
            for (DBObjectID dBObjectID : pKConstraint.getColumnIDs()) {
                if (!collection.contains(DBUtil.getDBObjectName(dBObjectID))) continue;
                return true;
            }
        }
        return false;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(SQLFragmentUtils.class);
    }

    public static Collection<DBObjectID> getReferenceIDs(String string, DBObjectProvider dBObjectProvider) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        if (ModelUtil.hasLength((String)string)) {
            HashSet<Object> hashSet = new HashSet<Object>();
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                String string2 = plSqlToken.getSource();
                String string3 = dBObjectProvider == null ? string2 : dBObjectProvider.getInternalName(string2);
                hashSet.add(string3);
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            }
            for (String string2 : hashSet) {
                arrayList.add(new ReferenceID("UNSPECIFIED_TYPE", (String)null, string2));
            }
        }
        return arrayList;
    }

    public static Collection<String> listBindVariables(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        while (plSqlToken.getType() != Token.Type.END_MARKER) {
            PlSqlToken plSqlToken2;
            if (plSqlToken.matches(":") && (plSqlToken2 = (PlSqlToken)plSqlToken.getNextCodeToken()) != null) {
                String string2 = plSqlToken2.getSource();
                hashSet.add(plSqlToken2.getSource());
            }
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
        }
        return hashSet;
    }
}

