/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.SQLFragment;

public class IndexObject
extends AbstractProviderUsageSQLFragment {
    public static final String TYPE = "IndexObject";
    @Deprecated
    public static final String ASC = "ASC";
    @Deprecated
    public static final String DESC = "DESC";

    public IndexObject() {
    }

    public IndexObject(SQLFragment sQLFragment) {
        this(sQLFragment, (OrderType)null);
    }

    @Deprecated
    public IndexObject(SQLFragment sQLFragment, String string) {
        this(sQLFragment);
        this.setOrder(string);
    }

    public IndexObject(SQLFragment sQLFragment, OrderType orderType) {
        if (sQLFragment != null) {
            this.setExpressionSource(sQLFragment.getSQLText());
            this.setExpression(sQLFragment);
        }
        this.setOrderType(orderType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Deprecated
    public String getOrder() {
        OrderType orderType = this.getOrderType();
        return orderType == null ? null : orderType.toString();
    }

    @Deprecated
    @Transient
    public void setOrder(String string) {
        OrderType orderType;
        if (string == null) {
            orderType = null;
        } else if (string.equals(ASC) || string.equals(DESC)) {
            orderType = OrderType.valueOf(string);
        } else {
            Object var2_3 = null;
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_ORDERING", string));
        }
        this.setOrderType(orderType);
    }

    public OrderType getOrderType() {
        return (OrderType)((Object)this.getProperty("orderType"));
    }

    public void setOrderType(OrderType orderType) {
        this.setProperty("orderType", (Object)orderType);
    }

    public String getExpressionSource() {
        SQLFragment sQLFragment;
        String string = (String)this.getProperty("expressionSource");
        if (string == null && (sQLFragment = (SQLFragment)DBUtil.getFrozenProperties(this).get("expression")) != null) {
            string = sQLFragment.getSQLText();
        }
        return string;
    }

    public void setExpressionSource(String string) {
        this.setProperty("expressionSource", string);
    }

    @Derived(value="expressionSource")
    @Internal
    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment sQLFragment) {
        this.setProperty("expression", sQLFragment);
    }

    @Override
    public String getSQLText() {
        String string = this.getExpressionSource();
        OrderType orderType = this.getOrderType();
        return string + (String)(orderType == null ? "" : " " + orderType.toString());
    }

    @Override
    @Internal
    public String getName() {
        String string = super.getName();
        if (string == null) {
            string = this.getInternalName(this.getExpressionSource(), "COLUMN");
        }
        return string;
    }

    public static enum OrderType {
        ASC,
        DESC;

    }
}

