/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractDBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.util.ModelUtil;

public class ColumnUsage
extends AbstractDBObjectUsage
implements SQLFragmentWithDatatype {
    private boolean m_alwaysQuote;

    public ColumnUsage() {
        this((DBObjectID)null, (FromObject)null);
    }

    public ColumnUsage(DBObjectID dBObjectID) {
        this(dBObjectID, (FromObject)null);
    }

    public ColumnUsage(DBObjectID dBObjectID, FromObject fromObject) {
        super(dBObjectID, fromObject != null ? fromObject.getID() : null);
        this.setOuterJoin(false);
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        ((ColumnUsage)abstractDBObject).m_alwaysQuote = this.m_alwaysQuote;
    }

    @Deprecated
    public void setColumnID(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.setObjectID(dBObjectID);
        }
    }

    public String[] getAttributes() {
        return this.getChildSupport("attributes").getChildArray(String.class);
    }

    public void setAttributes(String[] stringArray) {
        this.getChildSupport("attributes").setChildArray(stringArray);
    }

    public void setOuterJoin(boolean bl) {
        this.setProperty("outerJoin", bl);
    }

    public boolean isOuterJoin() {
        return (Boolean)this.getProperty("outerJoin", false);
    }

    @Override
    public String getSQLText() {
        StringBuilder stringBuilder = this.getSQLTextImpl();
        if (this.m_alwaysQuote && !stringBuilder.toString().startsWith("\"")) {
            stringBuilder = stringBuilder.insert(0, "\"");
            stringBuilder = stringBuilder.append("\"");
        }
        for (String string : this.getAttributes()) {
            stringBuilder.append(".").append(string);
        }
        if (this.isOuterJoin()) {
            stringBuilder.append("(+)");
        }
        return stringBuilder.toString();
    }

    @Transient
    public void setAlwaysQuote(boolean bl) {
        this.m_alwaysQuote = bl;
    }

    @Override
    public String getColumnName() {
        DBObjectID dBObjectID = this.getObjectID();
        String string = null;
        if (dBObjectID instanceof BaseObjectID) {
            DBObject dBObject;
            Relation relation;
            String string2 = ((BaseObjectID)dBObjectID).getName();
            if (ModelUtil.hasLength((String)string2)) {
                string = this.getExternalName(string2, "COLUMN");
            }
            if (!ModelUtil.hasLength((String)string) && (relation = this.findParent(Relation.class)) != null && DBUtil.getUppermostParent(dBObjectID).equals(relation.getID(), true) && (dBObject = relation.findOwnedObject(dBObjectID)) != null) {
                string = this.getExternalName(dBObject.getName(), "COLUMN");
            }
        }
        if (string == null) {
            string = super.getColumnName();
        }
        return string;
    }

    @Override
    public DBObjectID getDataTypeID() {
        DBObjectID dBObjectID = null;
        DBObjectID dBObjectID2 = this.getObjectID();
        if (dBObjectID2 != null) {
            DataTypeUsage dataTypeUsage;
            DBObject dBObject;
            try {
                dBObject = dBObjectID2.resolveID();
            }
            catch (DBException dBException) {
                dBObject = null;
            }
            if (dBObject instanceof Column && (dataTypeUsage = ((Column)dBObject).getDataTypeUsage()) != null) {
                dBObjectID = dataTypeUsage.getDataTypeID();
            }
        }
        return dBObjectID;
    }
}

