/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractFromObjectUsage
extends AbstractProviderUsageSQLFragment
implements FromObjectUsage {
    protected AbstractFromObjectUsage() {
        this.setQualified(true);
    }

    @Deprecated
    protected AbstractFromObjectUsage(FromObject fromObject) {
        this(fromObject != null ? fromObject.getID() : null);
    }

    protected AbstractFromObjectUsage(DBObjectID dBObjectID) {
        this();
        this.setFromObjectID(dBObjectID);
    }

    @Override
    @Transient
    @Deprecated
    public void setFromObject(FromObject fromObject) {
        this.setFromObjectID(fromObject != null ? fromObject.getID() : null);
    }

    @Override
    @Transient
    @Deprecated
    public FromObject getFromObject() {
        return this.resolveFromObject();
    }

    @Override
    public FromObject resolveFromObject() {
        return this.resolveFromObject(this.getFromObjectID());
    }

    protected FromObject resolveFromObject(DBObjectID dBObjectID) {
        return (FromObject)this.findFragmentInQuery(dBObjectID);
    }

    protected DBObject findFragmentInQuery(DBObjectID dBObjectID) {
        DBObject dBObject = null;
        if (dBObjectID instanceof TemporaryObjectID) {
            dBObject = ((TemporaryObjectID)dBObjectID).getDBObject();
        } else if (dBObjectID != null) {
            SQLQuery sQLQuery = this.findParent(SQLQuery.class);
            while (sQLQuery != null && dBObject == null) {
                dBObject = DBUtil.findOwnedObjectInHierarchy(sQLQuery, dBObjectID);
                if (dBObject != null) continue;
                sQLQuery = sQLQuery.findParent(SQLQuery.class);
            }
        }
        return dBObject;
    }

    @Override
    public void setFromObjectID(DBObjectID dBObjectID) {
        this.setProperty("fromObjectID", dBObjectID);
    }

    @Override
    public DBObjectID getFromObjectID() {
        return (DBObjectID)this.getProperty("fromObjectID");
    }

    @Override
    public void setQualified(boolean bl) {
        this.setProperty("qualified", bl);
    }

    @Override
    public boolean isQualified() {
        return (Boolean)this.getProperty("qualified", true);
    }

    protected StringBuilder getSQLTextImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isQualified()) {
            String string = null;
            FromObject fromObject = this.resolveFromObject();
            if (fromObject == null) {
                DBObjectID dBObjectID = this.getFromObjectID();
                if (dBObjectID instanceof BaseObjectID) {
                    string = ((BaseObjectID)dBObjectID).getName();
                }
            } else {
                string = fromObject.getUsableAlias();
            }
            if (ModelUtil.hasLength((String)string) && string.indexOf(" ") < 0) {
                stringBuilder.append(string);
                stringBuilder.append('.');
            }
        }
        stringBuilder.append(this.getColumnName());
        return stringBuilder;
    }
}

