/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public final class PropertyDefinition
extends PropertyInfo {
    private final String m_name;
    private final Class m_returnType;
    private final Class<? extends DBObjectProvider> m_providerType;
    private final Collection<Class<? extends DBObject>> m_objTypes;
    private boolean m_staticReference;
    private Class<? extends DBObject> m_referencedClass;
    private String[] m_referencedTypes;
    private boolean m_multiLine;
    private boolean m_password;
    private boolean m_internalName;
    private boolean m_physicalSize;
    private Integer m_unlimited;
    private Nullable.NullBehaviour m_nullBehaviour;

    public PropertyDefinition(String string, Class clazz, Class<? extends DBObjectProvider> clazz2, Class<? extends DBObject> ... classArray) {
        this.m_name = string;
        if (!ModelUtil.hasLength((String)this.m_name)) {
            throw new IllegalArgumentException("Every property must have a name.");
        }
        this.m_returnType = clazz;
        if (this.m_returnType == null) {
            throw new IllegalArgumentException("Every property must have a return type.");
        }
        this.m_providerType = clazz2;
        this.m_objTypes = new HashSet<Class<? extends DBObject>>();
        if (classArray != null) {
            for (Class<? extends DBObject> clazz3 : classArray) {
                if (clazz3 == null) continue;
                this.m_objTypes.add(clazz3);
            }
        }
        if (this.m_objTypes.size() == 0) {
            this.m_objTypes.add(DBObject.class);
        }
    }

    @Override
    public String getPropertyName() {
        return this.m_name;
    }

    public Class getPropertyClass() {
        return this.m_returnType;
    }

    @Override
    protected Collection<Class<? extends DBObject>> getObjectClasses() {
        return this.m_objTypes;
    }

    @Override
    protected Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_providerType;
    }

    @Override
    protected boolean equalsImpl(PropertyInfo propertyInfo) {
        return propertyInfo instanceof PropertyDefinition ? this.equalsImpl((PropertyDefinition)propertyInfo) : false;
    }

    protected boolean equalsImpl(PropertyDefinition propertyDefinition) {
        return ModelUtil.areEqual((Object)propertyDefinition.m_name, (Object)this.m_name) && ModelUtil.areEqual((Object)propertyDefinition.m_returnType, (Object)this.m_returnType) && ModelUtil.areEqual(propertyDefinition.m_providerType, this.m_providerType) && ModelUtil.areEqual(propertyDefinition.m_objTypes, this.m_objTypes);
    }

    public PropertyDefinition clone() {
        PropertyDefinition propertyDefinition = new PropertyDefinition(this.m_name, this.m_returnType, this.m_providerType, this.m_objTypes.toArray(new Class[this.m_objTypes.size()]));
        propertyDefinition.m_staticReference = this.m_staticReference;
        propertyDefinition.m_referencedClass = this.m_referencedClass;
        propertyDefinition.m_referencedTypes = this.m_referencedTypes;
        propertyDefinition.m_multiLine = this.m_multiLine;
        propertyDefinition.m_password = this.m_password;
        propertyDefinition.m_internalName = this.m_internalName;
        propertyDefinition.m_physicalSize = this.m_physicalSize;
        propertyDefinition.m_unlimited = this.m_unlimited;
        propertyDefinition.m_nullBehaviour = this.m_nullBehaviour;
        return propertyDefinition;
    }

    public String toString() {
        return this.m_name + "(" + this.m_returnType.getName() + ")";
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void setReferencesInfo(boolean bl, Class<? extends DBObject> clazz, String ... stringArray) {
        this.m_staticReference = bl;
        this.m_referencedClass = clazz;
        this.m_referencedTypes = stringArray;
    }

    @Override
    public boolean isStaticReference() {
        return this.m_staticReference;
    }

    @Override
    public Class<? extends DBObject> getReferencedClass() {
        return this.m_referencedClass;
    }

    @Override
    public String[] getReferencedTypes() {
        return this.m_referencedTypes;
    }

    public void setTextPropertyInfo(boolean bl, boolean bl2, boolean bl3) {
        this.m_multiLine = bl;
        this.m_password = bl2;
        this.m_internalName = bl3;
    }

    @Override
    public boolean isTextMultiLine() {
        return this.m_multiLine;
    }

    @Override
    public boolean isTextPassword() {
        return this.m_password;
    }

    @Override
    public boolean isTextInternalName() {
        return this.m_internalName;
    }

    public void setNumberPropertyInfo(Integer n, boolean bl) {
        this.m_unlimited = n;
        this.m_physicalSize = bl;
    }

    @Override
    public Integer getNumberUnlimitedValue() {
        return this.m_unlimited;
    }

    @Override
    public boolean isNumberPhysicalSize() {
        return this.m_physicalSize;
    }

    public void setNullBehaviour(Nullable.NullBehaviour nullBehaviour) {
        this.m_nullBehaviour = nullBehaviour;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour() {
        return this.m_nullBehaviour == null ? super.getNullBehaviour() : this.m_nullBehaviour;
    }
}

