/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.MultiMap;

class MetadataGenerator {
    private List<Class<? extends Copyable>> m_beans;
    private MultiMap<String, PropertyInfo> m_extraProps;

    public Collection<Class<? extends Copyable>> getBeans() {
        this.init();
        return this.m_beans;
    }

    public MultiMap<String, PropertyInfo> getExtraProperties() {
        this.init();
        return this.m_extraProps;
    }

    private synchronized void init() {
        if (this.m_beans == null) {
            this.loadMetadata();
        }
    }

    private static void logException(Exception exception) {
        exception.printStackTrace();
    }

    private void loadMetadata() {
        this.m_beans = new ArrayList<Class<? extends Copyable>>();
        this.m_extraProps = new MultiMap();
        try {
            Collection<Class> collection = this.getClasses();
            for (Class clazz : collection) {
                int n = clazz.getModifiers();
                if (Copyable.class.isAssignableFrom(clazz) && Modifier.isPublic(n) && clazz.getAnnotation(Deprecated.class) == null && !Difference.class.isAssignableFrom(clazz)) {
                    this.m_beans.add(clazz);
                }
                MetadataGenerator.findExtendedProperties(clazz, this.m_extraProps);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MetadataGenerator.logException(classNotFoundException);
        }
        Collections.sort(this.m_beans, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> clazz, Class<?> clazz2) {
                String string = clazz == null ? "" : clazz.getName();
                String string2 = clazz2 == null ? "" : clazz2.getName();
                return string.compareTo(string2);
            }
        });
    }

    static void findExtendedProperties(Class<?> clazz, MultiMap<String, PropertyInfo> multiMap) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    int n = field.getModifiers();
                    if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !field.isAnnotationPresent(PropertyKey.class)) continue;
                    if (field.getType() != String.class) {
                        throw new IllegalArgumentException("PropertyKey fields must be Strings");
                    }
                    String string = (String)field.get(null);
                    if (string == null) continue;
                    if (multiMap.containsKey((Object)string)) {
                        throw new IllegalArgumentException(string + " has already been used by " + multiMap.get((Object)string));
                    }
                    multiMap.add((Object)string, (Object)PropertyInfo.createPropertyInfo(string, field));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MetadataGenerator.logException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    MetadataGenerator.logException(illegalAccessException);
                }
            }
        }
        catch (SecurityException securityException) {
            MetadataGenerator.logException(securityException);
        }
    }

    private Collection<Class> getClasses() throws ClassNotFoundException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ClassLoader classLoader = DBObject.class.getClassLoader();
        if (classLoader == null) {
            throw new ClassNotFoundException("Can't get class loader.");
        }
        URL uRL = classLoader.getResource("oracle/javatools/db/DBObject.class");
        if (uRL == null) {
            throw new ClassNotFoundException("Can't find oracle.javatools.db.DBObject on classpath.");
        }
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        this.addClasses(arrayList, uRL2);
        return arrayList;
    }

    private void addClasses(Collection<Class> collection, URL uRL) {
        String string = URLFileSystem.getPath((URL)uRL);
        string = string.substring(string.lastIndexOf("oracle")).replace('/', '.');
        for (URL uRL2 : URLFileSystem.list((URL)uRL)) {
            if (URLFileSystem.isDirectory((URL)uRL2)) {
                this.addClasses(collection, uRL2);
                continue;
            }
            if (!URLFileSystem.hasSuffix((URL)uRL2, (String)".class")) continue;
            try {
                collection.add(Class.forName(string + URLFileSystem.getName((URL)uRL2)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }
}

