/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.util.ModelUtil;

public class Type
extends PlSqlSchemaObjectSpec
implements DataType {
    public static final String TYPE = "TYPE";
    public static final String OBJECT_TYPECODE = "OBJECT";
    public static final String COLLECTION_TYPECODE = "COLLECTION";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VARRAY_TYPE = "VARYING ARRAY";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Integer getSQLType() {
        return null;
    }

    @Override
    public boolean canHaveBody() {
        return !COLLECTION_TYPECODE.equals(this.getTypeCode());
    }

    @Derived(value="source")
    public boolean isFinal() {
        return (Boolean)this.getProperty("final", false);
    }

    public void setFinal(boolean bl) {
        this.setProperty("final", bl);
    }

    @Derived(value="source")
    public boolean isInstantiable() {
        return (Boolean)this.getProperty("instantiable", false);
    }

    public void setInstantiable(boolean bl) {
        this.setProperty("instantiable", bl);
    }

    @Derived(value="source")
    public String getTypeCode() {
        return (String)this.getProperty("typeCode");
    }

    public void setTypeCode(String string) {
        this.setProperty("typeCode", string);
    }

    @Derived(value="source")
    public String getCollectionType() {
        return (String)this.getProperty("collectionType");
    }

    public void setCollectionType(String string) {
        this.setProperty("collectionType", string);
    }

    public void setAuthidCurrentUser(boolean bl) {
        this.setProperty("authidCurrentUser", bl);
    }

    @Derived(value="source")
    public boolean isAuthidCurrentUser() {
        return (Boolean)this.getProperty("authidCurrentUser", false);
    }

    public void setLimit(Integer n) {
        this.setProperty("limit", n);
    }

    @Derived(value="source")
    public Integer getLimit() {
        return (Integer)this.getProperty("limit");
    }

    public DataTypeUsage getOfTypeUsage() {
        PlSqlReference plSqlReference = this.getOfTypeUsageReference();
        return plSqlReference == null ? null : plSqlReference.getDataTypeUsage();
    }

    public void setOfTypeUsageReference(PlSqlReference plSqlReference) {
        this.setProperty("ofTypeUsageReference", plSqlReference);
    }

    @Derived(value="source")
    public PlSqlReference getOfTypeUsageReference() {
        return (PlSqlReference)this.getProperty("ofTypeUsageReference");
    }

    @Derived(value="source")
    public PlSqlReference getUnderTypeReference() {
        return (PlSqlReference)this.getProperty("underTypeReference");
    }

    public void setUnderTypeReference(PlSqlReference plSqlReference) {
        this.setProperty("underTypeReference", plSqlReference);
    }

    public DBObjectID getUnderTypeID() {
        PlSqlReference plSqlReference = this.getUnderTypeReference();
        return plSqlReference == null ? null : plSqlReference.getReferenceID();
    }

    public void setOID(String string) {
        this.setProperty("OID", string);
    }

    @Derived(value="source")
    public String getOID() {
        return (String)this.getProperty("OID");
    }

    public void setSqljExternalName(String string) {
        this.setProperty("sqljExternalName", string);
    }

    @Derived(value="source")
    public String getSqljExternalName() {
        return (String)this.getProperty("sqljExternalName");
    }

    public void setSqljUsing(SQLJUsingType sQLJUsingType) {
        this.setProperty("sqljUsing", (Object)sQLJUsingType);
    }

    @Derived(value="source")
    public SQLJUsingType getSqljUsing() {
        return (SQLJUsingType)((Object)this.getProperty("sqljUsing"));
    }

    public void setMethods(PlSqlMethod[] plSqlMethodArray) {
        this.getChildSupport("methods").setChildArray(plSqlMethodArray);
    }

    @Derived(value="source")
    public PlSqlMethod[] getMethods() {
        return this.getChildSupport("methods").getChildArray(PlSqlMethod.class);
    }

    public PlSqlMethod getMethod(String string) {
        return (PlSqlMethod)this.getChildSupport("methods").findChild(string);
    }

    public void addMethod(PlSqlMethod plSqlMethod) {
        this.getChildSupport("methods").addChild(plSqlMethod);
    }

    public void removeMethod(PlSqlMethod plSqlMethod) {
        this.getChildSupport("methods").removeChild(plSqlMethod);
    }

    @Override
    @Internal
    public PlSqlSubProgram[] getSubPrograms() {
        PlSqlMethod[] plSqlMethodArray = this.getMethods();
        PlSqlSubProgram[] plSqlSubProgramArray = new PlSqlSubProgram[plSqlMethodArray.length];
        for (int i = 0; i < plSqlMethodArray.length; ++i) {
            plSqlSubProgramArray[i] = plSqlMethodArray[i];
        }
        return plSqlSubProgramArray;
    }

    @Override
    public void setSubPrograms(PlSqlSubProgram[] plSqlSubProgramArray) {
        PlSqlMethod[] plSqlMethodArray = new PlSqlMethod[plSqlSubProgramArray == null ? 0 : plSqlSubProgramArray.length];
        for (int i = 0; i < plSqlMethodArray.length; ++i) {
            if (!(plSqlSubProgramArray[i] instanceof PlSqlMethod)) {
                throw new IllegalArgumentException("Array element " + i + " is not a PlSqlMethod");
            }
            plSqlMethodArray[i] = (PlSqlMethod)plSqlSubProgramArray[i];
        }
        this.setMethods(plSqlMethodArray);
    }

    @Override
    public void addSubProgram(PlSqlSubProgram plSqlSubProgram) {
        if (!(plSqlSubProgram instanceof PlSqlMethod)) {
            throw new IllegalArgumentException("subProgram is not a PlSqlMethod");
        }
        this.addMethod((PlSqlMethod)plSqlSubProgram);
    }

    public void setAttributes(PlSqlAttribute[] plSqlAttributeArray) {
        this.getChildSupport("attributes").setChildArray(plSqlAttributeArray);
    }

    @Derived(value="source")
    public PlSqlAttribute[] getAttributes() {
        return this.getChildSupport("attributes").getChildArray(PlSqlAttribute.class);
    }

    public PlSqlAttribute getAttribute(String string) {
        return (PlSqlAttribute)this.getChildSupport("attributes").findChild(string);
    }

    public void addAttribute(PlSqlAttribute plSqlAttribute) {
        this.getChildSupport("attributes").addChild(plSqlAttribute);
    }

    public void removeAttribute(PlSqlAttribute plSqlAttribute) {
        this.getChildSupport("attributes").removeChild(plSqlAttribute);
    }

    @Override
    @Internal
    public PlSqlVariable[] getVariables() {
        PlSqlAttribute[] plSqlAttributeArray = this.getAttributes();
        PlSqlVariable[] plSqlVariableArray = new PlSqlVariable[plSqlAttributeArray.length];
        for (int i = 0; i < plSqlAttributeArray.length; ++i) {
            plSqlVariableArray[i] = plSqlAttributeArray[i];
        }
        return plSqlVariableArray;
    }

    @Override
    public void setVariables(PlSqlVariable[] plSqlVariableArray) {
        PlSqlAttribute[] plSqlAttributeArray = new PlSqlAttribute[plSqlVariableArray == null ? 0 : plSqlVariableArray.length];
        for (int i = 0; i < plSqlAttributeArray.length; ++i) {
            if (!(plSqlVariableArray[i] instanceof PlSqlAttribute)) {
                throw new IllegalArgumentException("Array element " + i + " is not a PlSqlAttribute");
            }
            plSqlAttributeArray[i] = (PlSqlAttribute)plSqlVariableArray[i];
        }
        this.setAttributes(plSqlAttributeArray);
    }

    @Override
    public void addVariable(PlSqlVariable plSqlVariable) {
        if (!(plSqlVariable instanceof PlSqlAttribute)) {
            throw new IllegalArgumentException("subProgram is not a PlSqlAttribute");
        }
        this.addAttribute((PlSqlAttribute)plSqlVariable);
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        DBObjectProvider dBObjectProvider = this.getID() instanceof BaseObjectID ? ((BaseObjectID)this.getID()).getProvider() : null;
        Schema schema = this.getSchema();
        if (schema != null && ModelUtil.hasLength((String)(string = schema.getName()))) {
            if (dBObjectProvider != null) {
                string = dBObjectProvider.getExternalName(string);
            }
            stringBuffer.append(string).append(".");
        }
        if ((string = this.getName()) != null && dBObjectProvider != null) {
            string = dBObjectProvider.getExternalName(string);
        }
        stringBuffer.append(string);
        return DataTypeHelper.getTypeDDL(dataTypeUsage, stringBuffer.toString());
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return new DataTypeAttribute[0];
    }

    @Override
    public boolean hasDataTypeAttribute(String string) {
        return false;
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String string) {
        return null;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        return new DataTypeUsage(this);
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> map) {
        return this.createDefaultUsage();
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
    }

    @Override
    public boolean matches(String string) {
        StringBuffer stringBuffer = new StringBuffer("[? .] {");
        stringBuffer.append("\"").append(this.getName()).append("\" |");
        stringBuffer.append(this.getName().toUpperCase()).append("}");
        PlSqlSearch plSqlSearch = null;
        try {
            plSqlSearch = new PlSqlSearch(stringBuffer.toString());
            return plSqlSearch.matches(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public DataTypeUsage createUsage(String string) {
        return this.createDefaultUsage();
    }

    public static enum SQLJUsingType {
        SQLData,
        CustomDatum,
        OraData;

    }
}

