/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Map;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Transient;

public class PlSqlDatatype
extends PlSqlCodeFragment
implements DataType {
    public static final String TYPE = "PlSqlDatatype";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Integer getSQLType() {
        return null;
    }

    public void setVariables(PlSqlVariable[] plSqlVariableArray) {
        this.getChildSupport("variables").setChildArray(plSqlVariableArray);
    }

    @Derived(value="source")
    public PlSqlVariable[] getVariables() {
        return this.getChildSupport("variables").getChildArray(PlSqlVariable.class);
    }

    public void addVariable(PlSqlVariable plSqlVariable) {
        this.getChildSupport("variables").addChild(plSqlVariable);
    }

    @Derived(value="source")
    public boolean isSubType() {
        return (Boolean)this.getProperty("subType", false);
    }

    public void setSubType(boolean bl) {
        this.setProperty("subType", bl);
    }

    @Derived(value="source")
    public Structure getStructure() {
        return (Structure)((Object)this.getProperty("structure"));
    }

    public void setStructure(Structure structure) {
        this.setProperty("structure", (Object)structure);
    }

    public DBObjectID getBaseTypeID() throws CancelledException {
        DBObjectID dBObjectID = null;
        PlSqlReference plSqlReference = this.findBaseTypeReference();
        if (plSqlReference != null) {
            dBObjectID = plSqlReference.getReferenceID();
        }
        return dBObjectID;
    }

    @Deprecated
    @Transient
    public void setBaseTypeID(DBObjectID dBObjectID) {
    }

    @Derived(value="source")
    public Integer getBaseTypeOffset() {
        return (Integer)this.getProperty("baseTypeOffset");
    }

    public void setBaseTypeOffset(Integer n) {
        this.setProperty("baseTypeOffset", n);
    }

    public PlSqlReference findBaseTypeReference() throws CancelledException {
        DBObjectPlSqlFragment dBObjectPlSqlFragment;
        DBObject dBObject;
        PlSqlReference plSqlReference = null;
        Integer n = this.getBaseTypeOffset();
        if (n != null && (dBObject = this.getParent()) instanceof PlSqlBlock && (dBObjectPlSqlFragment = ((PlSqlBlock)dBObject).getReferenceAtOffset(n)) instanceof PlSqlReference) {
            plSqlReference = (PlSqlReference)dBObjectPlSqlFragment;
        }
        return plSqlReference;
    }

    @Derived(value="source")
    public Integer getLimit() {
        return (Integer)this.getProperty("limit");
    }

    public void setLimit(Integer n) {
        this.setProperty("limit", n);
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return new DataTypeAttribute[0];
    }

    @Override
    public boolean hasDataTypeAttribute(String string) {
        return false;
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String string) {
        return null;
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        return null;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        return null;
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> map) {
        return null;
    }

    @Override
    public DataTypeUsage createUsage(String string) {
        return null;
    }

    @Override
    public boolean matches(String string) {
        return false;
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) {
    }

    public static enum Structure {
        SCALAR,
        RECORD,
        VARRAY,
        TABLE;

    }
}

