/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.DBLog;

public abstract class ConnectionMatcher {
    public abstract boolean matches(Connection var1);

    public static ConnectionMatcher matchDatabaseProductName(String string) {
        return new DatabaseProductNameMatcher(string);
    }

    public static ConnectionMatcher matchDatabaseProductVersion(String string) {
        return new DatabaseProductVersionMatcher(string);
    }

    public static ConnectionMatcher matchDriverName(String string) {
        return new DriverNameMatcher(string);
    }

    public static ConnectionMatcher matchAll(boolean bl, ConnectionMatcher ... connectionMatcherArray) {
        return new AndOrMatcher(bl, connectionMatcherArray);
    }

    private static class DatabaseProductNameMatcher
    extends RegexMatcher {
        DatabaseProductNameMatcher(String string) {
            super(string);
        }

        @Override
        protected String getStringToMatch(Connection connection) throws SQLException {
            return connection.getMetaData().getDatabaseProductName();
        }
    }

    private static class DatabaseProductVersionMatcher
    extends RegexMatcher {
        DatabaseProductVersionMatcher(String string) {
            super(string);
        }

        @Override
        protected String getStringToMatch(Connection connection) throws SQLException {
            return connection.getMetaData().getDatabaseProductVersion();
        }
    }

    private static class DriverNameMatcher
    extends RegexMatcher {
        DriverNameMatcher(String string) {
            super(string);
        }

        @Override
        protected String getStringToMatch(Connection connection) throws SQLException {
            return connection.getMetaData().getDriverName();
        }
    }

    private static abstract class RegexMatcher
    extends ConnectionMatcher {
        private final String m_regex;

        RegexMatcher(String string) {
            this.m_regex = string;
        }

        @Override
        public boolean matches(Connection connection) {
            boolean bl = false;
            try {
                bl = this.getStringToMatch(connection).matches(this.m_regex);
            }
            catch (Exception exception) {
                DBLog.getLogger(this).fine(exception.getMessage());
            }
            return bl;
        }

        protected abstract String getStringToMatch(Connection var1) throws SQLException;
    }

    private static class AndOrMatcher
    extends ConnectionMatcher {
        private final boolean m_and;
        private final ConnectionMatcher[] m_children;

        AndOrMatcher(boolean bl, ConnectionMatcher ... connectionMatcherArray) {
            this.m_and = bl;
            this.m_children = connectionMatcherArray;
            if (connectionMatcherArray == null) {
                throw new IllegalArgumentException("Must supply children");
            }
        }

        @Override
        public boolean matches(Connection connection) {
            ConnectionMatcher connectionMatcher;
            boolean bl = false;
            ConnectionMatcher[] connectionMatcherArray = this.m_children;
            int n = connectionMatcherArray.length;
            for (int i = 0; i < n && (bl = (connectionMatcher = connectionMatcherArray[i]).matches(connection)) == this.m_and; ++i) {
            }
            return bl;
        }
    }
}

