/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DifferenceApplier {
    private List<DBObjectChange> m_events;
    private boolean m_applyToB;
    private DBObjectProvider m_pro;

    public DifferenceApplier(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider, false);
    }

    public DifferenceApplier(DBObjectProvider dBObjectProvider, boolean bl) {
        this.m_pro = dBObjectProvider;
        this.m_applyToB = bl;
    }

    private Object getOriginalObject(Difference difference) {
        return this.m_applyToB ? difference.getUpdatedObject() : difference.getOriginalObject();
    }

    private Object getUpdatedObject(Difference difference) {
        return this.m_applyToB ? difference.getOriginalObject() : difference.getUpdatedObject();
    }

    private Integer getIndexOfUpdatedObject(Difference difference) {
        return this.m_applyToB ? difference.getIndexOfOriginalObject() : difference.getIndexOfUpdatedObject();
    }

    public final void apply(SystemObject systemObject, SystemObject systemObject2) {
        this.apply(this.m_pro.getDiffEngine().difference(systemObject, systemObject2));
    }

    public final void apply(Difference difference) {
        this.apply(difference, null);
    }

    public final void apply(Difference difference, SystemObject systemObject) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!difference.isSame()) {
            if (difference.isList()) {
                Collection<? extends Difference> collection = difference.getChildren();
                for (Difference difference2 : collection) {
                    if (!difference2.isModified() || !difference2.isMap() || difference2.isSame()) continue;
                    this.applyObjectDiff(difference2, systemObject);
                }
            } else if (difference.isMap()) {
                this.applyObjectDiff(difference, systemObject);
            }
        }
    }

    private void applyObjectDiff(Difference difference, DBObject dBObject) {
        this.applyProperties(difference, null);
        this.m_events.add(new ResultSetChange(difference, dBObject, this.m_pro));
    }

    private void applyProperties(Difference difference, Difference difference2) {
        Object object = this.getOriginalObject(difference);
        if (object instanceof DBObject) {
            Runnable runnable = () -> this.applyPropertiesImpl(difference, difference2);
            DBUtil.invokeCompoundChange((DBObject)object, runnable, true);
        } else {
            this.applyPropertiesImpl(difference, difference2);
        }
    }

    private final void applyPropertiesImpl(Difference difference, Difference difference2) {
        block13: {
            Object object = this.getOriginalObject(difference);
            if (object == null) break block13;
            Class<?> clazz = difference.getDifferenceClass();
            if (Map.class.isAssignableFrom(clazz)) {
                for (Difference difference3 : difference.getChildren()) {
                    Holder<?> holder;
                    if (!this.shouldApplyChildDiff(difference3) || (holder = this.getAppliedPropertyValue(difference3, difference, difference2)) == null) continue;
                    ((Map)object).put(difference3.getPropertyName(), holder.get());
                }
            } else {
                Object object2;
                Object object3;
                TreeMap<Object[], Difference> treeMap = new TreeMap<Object[], Difference>();
                Map<String, PropertyInfo> map = PropertyHelper.getPropertyInfos(object.getClass(), null, null);
                Collection<? extends Difference> collection = difference.getChildren();
                for (Difference object4 : collection) {
                    object3 = object4.getPropertyName();
                    if (!this.shouldApplyChildDiff(object4)) continue;
                    object2 = map.get(object3);
                    if (object2 == null) {
                        throw new IllegalStateException("don't have a property info for property " + (String)object3 + " on object " + clazz);
                    }
                    treeMap.put((Object[])object2, object4);
                }
                for (PropertyInfo propertyInfo : treeMap.keySet()) {
                    object3 = (Difference)treeMap.get(propertyInfo);
                    object2 = null;
                    boolean bl = false;
                    if (((Difference)object3).isList()) {
                        boolean exception = DBObject.class.isAssignableFrom(difference.getDifferenceClass());
                        object2 = this.applyList((Difference)object3, exception ? difference : difference2);
                        bl = true;
                    } else if ("schema".equals(propertyInfo.getPropertyName()) && SchemaObject.class.isAssignableFrom(difference.getDifferenceClass())) {
                        object2 = this.getUpdatedObject((Difference)object3);
                        bl = true;
                    } else {
                        Holder<?> holder = this.getAppliedPropertyValue((Difference)object3, difference, difference2);
                        if (holder != null) {
                            object2 = holder.get();
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    try {
                        propertyInfo.setPropertyValue(object, object2);
                    }
                    catch (Exception exception) {
                        DBLog.logStackTrace("Error applying property value", exception);
                    }
                }
            }
        }
    }

    private boolean shouldApplyChildDiff(Difference difference) {
        boolean bl = BuildableDBObjectDiffer.isLazyDifference(difference) ? false : !difference.isSame();
        return bl;
    }

    private Holder<?> getAppliedPropertyValue(Difference difference, Difference difference2, Difference difference3) {
        boolean bl = true;
        Object object = this.getUpdatedObject(difference);
        if (difference.isSame()) {
            bl = false;
        } else if (object != null) {
            if (difference.isList()) {
                object = this.applyList(difference, difference3);
            } else {
                Object object2 = this.getOriginalObject(difference);
                if (object2 == null || object2.getClass() != object.getClass()) {
                    Object object3;
                    Object object4 = object3 = difference3 == null ? null : this.getOriginalObject(difference3);
                    if (object instanceof ChildDBObject && this.m_pro != null && object3 instanceof DBObject) {
                        ChildDBObject childDBObject = (ChildDBObject)object;
                        object = this.m_pro.getObjectFactory().newObject(childDBObject.getClass(), (DBObject)object3, false, false);
                        ((ChildDBObject)object).setID(null);
                        childDBObject.copyTo((DBObject)((ChildDBObject)object), new TemporaryObjectID.CopyBackPolicy());
                    } else if (object instanceof Copyable) {
                        object = ((Copyable)object).copyTo(null);
                    }
                } else if (difference.isMap() && (object instanceof DBObject || "properties".equals(difference.getPropertyName()) && this.getUpdatedObject(difference2) instanceof DBObject)) {
                    bl = false;
                    this.applyProperties(difference, difference2);
                }
            }
        }
        return bl ? new Holder(object) : null;
    }

    private final Object[] applyList(Difference difference, Difference difference2) {
        ArrayList<Object> arrayList = null;
        ArrayList<? extends Difference> arrayList2 = new ArrayList<Difference>(difference.getChildren());
        if (arrayList2 != null) {
            Collections.sort(arrayList2, new Comparator<Difference>(){

                @Override
                public int compare(Difference difference, Difference difference2) {
                    if (difference == difference2) {
                        return 0;
                    }
                    if (difference == null) {
                        return -100;
                    }
                    if (difference2 == null) {
                        return 100;
                    }
                    return DifferenceApplier.this.getIndexOfUpdatedObject(difference).compareTo(DifferenceApplier.this.getIndexOfUpdatedObject(difference2));
                }
            });
            arrayList = new ArrayList<Object>(arrayList2.size());
            for (Difference difference3 : arrayList2) {
                Holder<?> holder = this.getAppliedPropertyValue(difference3, difference, difference2);
                if (holder == null) {
                    arrayList.add(this.getOriginalObject(difference3));
                    continue;
                }
                Object object = holder.get();
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        Object[] objectArray = arrayList != null && arrayList.size() > 0 ? arrayList.toArray((Object[])Array.newInstance(difference.getDifferenceClass().getComponentType(), arrayList.size())) : null;
        return objectArray;
    }

    public SystemObject getCopyOfOrigWithDiffApplied(Difference difference) {
        SystemObject systemObject = null;
        SystemObject systemObject2 = (SystemObject)difference.getOriginalObject();
        SystemObject systemObject3 = (SystemObject)difference.getUpdatedObject();
        if (systemObject2 != null) {
            if (this.m_pro != null) {
                this.m_pro.getObjectFactory().ensureID(systemObject2, true, true);
            }
            Map<DBObjectID, DBObjectID> map = DBUtil.getTemporaryIDMap(systemObject3);
            SameTempIDPolicy sameTempIDPolicy = new SameTempIDPolicy(map);
            systemObject2.copyTo(null, sameTempIDPolicy);
            Difference difference2 = (Difference)difference.copyTo(null);
            this.switchOriginalWithCopy(difference2, sameTempIDPolicy.m_ourTemps);
            this.apply(difference2);
            systemObject = (SystemObject)difference2.getOriginalObject();
            DBUtil.replaceAllIDs(systemObject, sameTempIDPolicy.m_ourTemps);
        }
        if (systemObject == null) {
            systemObject = systemObject3;
        }
        return systemObject;
    }

    private void switchOriginalWithCopy(Difference difference, Map<DBObjectID, TemporaryObjectID> map) {
        Object object;
        Difference difference2;
        Object object2;
        Object object3;
        Object object4 = difference.getOriginalObject();
        if (object4 instanceof DBObject) {
            TemporaryObjectID copyable2;
            object3 = ((DBObject)object4).getID();
            if (object3 != null && (copyable2 = map.get(object3)) != null && (object2 = copyable2.getDBObject()) != null) {
                difference.setObject(difference.getOriginalContributor(), object2);
            }
        } else if (object4 instanceof Map && ModelUtil.hasLength(object3 = difference.getPropertyName()) && (difference2 = difference.getParent()) != null && (object2 = difference2.getOriginalObject()) instanceof DBObject && (object = ((DBObject)object2).getProperty((String)object3)) instanceof Map) {
            difference.setObject(difference.getOriginalContributor(), object);
        }
        for (Difference difference3 : difference.getChildren()) {
            this.switchOriginalWithCopy(difference3, map);
        }
    }

    @Deprecated
    public DBObjectChange[] fireEvents() {
        return this.m_events == null ? new DBObjectChange[]{} : this.m_events.toArray(new DBObjectChange[this.m_events.size()]);
    }

    public Iterable<DBObjectChange> getEvents() {
        return this.m_events;
    }

    private DBObjectChange fireLazyChangeEventImpl(SystemObject systemObject, SystemObject systemObject2) {
        ResultSetChange resultSetChange = new ResultSetChange(systemObject, (DBObject)systemObject2, this.m_pro);
        systemObject.fireObjectUpdated(resultSetChange);
        return resultSetChange;
    }

    public static DBObjectChange fireLazyChangeEvent(SystemObject systemObject, SystemObject systemObject2, DBObjectProvider dBObjectProvider) {
        DifferenceApplier differenceApplier = new DifferenceApplier(dBObjectProvider);
        return differenceApplier.fireLazyChangeEventImpl(systemObject, systemObject2);
    }

    private static class SameTempIDPolicy
    extends IDPolicy.SameIDPolicy {
        private final Map<DBObjectID, TemporaryObjectID> m_ourTemps = new DBObjectIDMap<TemporaryObjectID>(true);
        private final Map<DBObjectID, DBObjectID> m_origToUpdIDMap;

        public SameTempIDPolicy(Map<DBObjectID, DBObjectID> map) {
            this.m_origToUpdIDMap = map;
        }

        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            TemporaryObjectID temporaryObjectID = (TemporaryObjectID)TemporaryObjectID.createID(dBObject2, dBObject);
            DBObjectID dBObjectID = super.getNewID(dBObject, dBObject2);
            if (dBObjectID != null) {
                this.m_ourTemps.put(dBObjectID, temporaryObjectID);
                DBObjectID dBObjectID2 = this.m_origToUpdIDMap.get(dBObjectID);
                if (dBObjectID2 != null) {
                    this.m_ourTemps.put(dBObjectID2, temporaryObjectID);
                }
            }
            return dBObjectID;
        }
    }

    private final class ResultSetChange
    extends DBObjectChange {
        private DiffEngine m_diffEngine;
        private Difference m_diff;
        private DBObject m_lazyDiffObj;
        private final Collection<String> m_loaded;
        private final List<DBObject> m_objectsAdded;
        private final List<DBObject> m_objectsRemoved;
        private final Map<DBObject, DBObjectChange> m_objectsChanged;
        private Collection<String> m_allChangedProps;
        private boolean m_fullyLoaded;
        private final PropertyChangeMap m_propsChanged;

        private ResultSetChange(Difference difference, DBObject dBObject, DBObjectProvider dBObjectProvider) {
            super((DBObject)DifferenceApplier.this.getOriginalObject(difference), dBObjectProvider);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_diff = difference;
            this.m_lazyDiffObj = dBObject;
        }

        private ResultSetChange(DBObject dBObject, DBObject dBObject2, DBObjectProvider dBObjectProvider) {
            super(dBObject, dBObjectProvider);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_lazyDiffObj = dBObject2;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsAdded);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableMap(this.m_objectsChanged);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsRemoved);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.m_propsChanged;
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            if (this.m_allChangedProps == null) {
                this.m_allChangedProps = new ArrayList<String>();
                for (Difference difference : this.getDifference().getChildren()) {
                    if (difference.isSame()) continue;
                    this.m_allChangedProps.add(difference.getPropertyName());
                }
            }
            return this.m_allChangedProps;
        }

        private Difference getDifference() {
            if (this.m_diff == null) {
                this.m_diff = this.getDiffEngine().difference(this.m_lazyDiffObj, this.getDBObject());
            }
            return this.m_diff;
        }

        private DiffEngine getDiffEngine() {
            if (this.m_diffEngine == null) {
                this.m_diffEngine = GenericDiffEngine.getDiffEngine(true);
            }
            return this.m_diffEngine;
        }

        private void ensureChildrenLoaded() {
            if (!this.m_fullyLoaded) {
                for (Difference difference : this.getDifference().getChildren()) {
                    this.loadDifferenceImpl(difference);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void loadDifferenceImpl(Difference difference) {
            String string = difference.getPropertyName();
            if (!this.m_loaded.contains(string) && !difference.isSame()) {
                Object object;
                boolean bl = true;
                Class<?> clazz = difference.getDifferenceClass();
                if (difference.isList()) {
                    if (clazz.isArray() && DBObject.class.isAssignableFrom(clazz.getComponentType())) {
                        for (Difference object2 : difference.getChildren()) {
                            if (!object2.isSame()) {
                                object = (DBObject)DifferenceApplier.this.getUpdatedObject(object2);
                                DBObject dBObject = (DBObject)DifferenceApplier.this.getOriginalObject(object2);
                                if (object == null && dBObject != null) {
                                    this.m_objectsRemoved.add(dBObject);
                                    continue;
                                }
                                if (object != null && dBObject == null) {
                                    DBObject dBObject2;
                                    Object object3 = object;
                                    DBObject dBObject3 = this.getDBObject();
                                    if (object.getParent() != dBObject3 && (dBObject2 = this.findMatchingChild((DBObject)object, dBObject3, arg_0 -> ResultSetChange.lambda$loadDifferenceImpl$0((DBObject)object, arg_0))) != null) {
                                        object3 = dBObject2;
                                    }
                                    this.m_objectsAdded.add((DBObject)object3);
                                    continue;
                                }
                                this.addChildObjectChange(object2);
                                continue;
                            }
                            int n = object2.getIndexOfOriginalObject();
                            int n2 = object2.getIndexOfUpdatedObject();
                            if (n < 0 || n2 < 0 || n == n2) continue;
                            this.addChildObjectChange(object2);
                        }
                    }
                } else if (difference.isMap()) {
                    if ("properties".equals(string)) {
                        bl = false;
                        for (Difference difference2 : difference.getChildren()) {
                            this.loadDifferenceImpl(difference2);
                        }
                    } else if (DBObject.class.isAssignableFrom(clazz) && difference.isModified()) {
                        this.addChildObjectChange(difference);
                    }
                }
                if (bl) {
                    void var6_11;
                    Iterator<? extends Difference> iterator = this.getDBObject();
                    object = difference.getPropertyInfo();
                    if (object != null && !"schema".equals(string) && DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(clazz)) && this.m_lazyDiffObj != null) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(iterator, string, null, null, (PropertyInfo)object, (DBObject)((Object)iterator)){
                            final /* synthetic */ PropertyInfo val$info;
                            final /* synthetic */ DBObject val$obj;
                            {
                                this.val$info = propertyInfo;
                                this.val$obj = dBObject;
                                super(object, string, object2, object3);
                            }

                            @Override
                            public Object getNewValue() {
                                return this.val$info.getPropertyValue(this.val$obj);
                            }

                            @Override
                            public Object getOldValue() {
                                return this.val$info.getPropertyValue(ResultSetChange.this.m_lazyDiffObj);
                            }
                        };
                    } else {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getDBObject(), string, DifferenceApplier.this.getOriginalObject(difference), DifferenceApplier.this.getUpdatedObject(difference));
                    }
                    this.m_propsChanged.m_delegate.put(string, (PropertyChangeEvent)var6_11);
                }
            }
            this.m_loaded.add(string);
        }

        private DBObject findMatchingChild(DBObject dBObject, DBObject dBObject2, Predicate<DBObject> predicate) {
            String string;
            DBObject dBObject3 = null;
            if (dBObject2 != null && (string = DBUtil.getParentProperty(dBObject)) != null && !DBUtil.needsBuilding(dBObject2, string)) {
                Object object = dBObject2.getProperty(string);
                if (object instanceof DBObject) {
                    dBObject3 = (DBObject)object;
                } else if (object instanceof DBObject[]) {
                    for (DBObject dBObject4 : (DBObject[])object) {
                        if (!predicate.test(dBObject4)) continue;
                        dBObject3 = dBObject4;
                        break;
                    }
                }
            }
            return dBObject3;
        }

        private void addChildObjectChange(Difference difference) {
            DBObject dBObject2 = (DBObject)DifferenceApplier.this.getOriginalObject(difference);
            DBObject dBObject3 = null;
            DBObjectID dBObjectID = dBObject2.getID();
            if (dBObjectID instanceof BaseObjectID) {
                dBObject3 = this.findMatchingChild(dBObject2, this.m_lazyDiffObj, dBObject -> dBObjectID.equals(dBObject.getID(), true));
            }
            this.m_objectsChanged.put(dBObject2, new ResultSetChange(difference, dBObject3, this.getProvider()));
        }

        @Override
        public boolean hasNameChanged() {
            if (this.m_diff == null) {
                DBObject dBObject = this.getDBObject();
                return !DBUtil.areNamesAndTypesEqual(this.m_lazyDiffObj, dBObject);
            }
            return super.hasNameChanged();
        }

        private static /* synthetic */ boolean lambda$loadDifferenceImpl$0(DBObject dBObject, DBObject dBObject2) {
            return DBUtil.areNamesAndTypesEqual(dBObject, dBObject2);
        }

        private class PropertyChangeMap
        extends AbstractMap<String, PropertyChangeEvent> {
            private Map<String, PropertyChangeEvent> m_delegate = new ConcurrentHashMap<String, PropertyChangeEvent>();

            private PropertyChangeMap() {
            }

            @Override
            public Set<Map.Entry<String, PropertyChangeEvent>> entrySet() {
                ResultSetChange.this.ensureChildrenLoaded();
                return this.m_delegate.entrySet();
            }

            @Override
            public PropertyChangeEvent get(Object object) {
                PropertyChangeEvent propertyChangeEvent = this.m_delegate.get(object);
                if (object instanceof String && propertyChangeEvent == null && !ResultSetChange.this.m_loaded.contains(object) && !ResultSetChange.this.m_fullyLoaded) {
                    Difference difference;
                    String string = (String)object;
                    if (ResultSetChange.this.m_diff == null && ResultSetChange.this.m_lazyDiffObj != null && !"properties".equals(string)) {
                        Object object2 = ResultSetChange.this.m_lazyDiffObj.getProperty(string);
                        Object object3 = ResultSetChange.this.getDBObject().getProperty(string);
                        if (object2 == null && object3 == null) {
                            ResultSet resultSet = new ResultSet(null, null, null, string, "MAP");
                            resultSet.setSame(true);
                            difference = resultSet;
                        } else {
                            ResultSet resultSet = ResultSetChange.this.getDiffEngine().diff(object2, object3).getResult();
                            resultSet.setName(string);
                            difference = resultSet;
                        }
                    } else {
                        difference = ResultSetChange.this.m_diff.getChildDifference(string);
                    }
                    if (difference != null) {
                        ResultSetChange.this.loadDifferenceImpl(difference);
                        propertyChangeEvent = this.m_delegate.get(object);
                    }
                }
                return propertyChangeEvent;
            }

            @Override
            public Set<String> keySet() {
                Set<String> set;
                if (ResultSetChange.this.m_fullyLoaded) {
                    set = super.keySet();
                } else {
                    set = new HashSet();
                    this.addChangedProperties(ResultSetChange.this.getDifference(), set);
                }
                return set;
            }

            private void addChangedProperties(Difference difference, Collection<String> collection) {
                for (Difference difference2 : difference.getChildren()) {
                    if (difference2.isSame()) continue;
                    String string = difference2.getPropertyName();
                    if ("properties".equals(string)) {
                        this.addChangedProperties(difference2, collection);
                        continue;
                    }
                    collection.add(string);
                }
            }

            @Override
            public boolean containsKey(Object object) {
                return this.keySet().contains(object);
            }
        }
    }
}

