/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public abstract class Difference
implements Copyable {
    private boolean m_same;
    private boolean m_filtered;
    private final Map<String, Object> m_props = new HashMap<String, Object>();
    private Difference m_parent;

    public boolean isLoaded() {
        return true;
    }

    public Difference getParent() {
        return this.m_parent;
    }

    protected void setParent(Difference difference) {
        this.m_parent = difference;
    }

    public abstract String getPropertyName();

    public boolean isDerived() {
        PropertyInfo propertyInfo = this.getPropertyInfo();
        return propertyInfo != null && propertyInfo.isDerived();
    }

    protected Difference getSourceDifference() {
        String string;
        PropertyInfo propertyInfo;
        Difference difference = null;
        Difference difference2 = this.getParent();
        if (difference2 != null && (propertyInfo = this.getPropertyInfo()) != null && propertyInfo.isDerived() && (string = propertyInfo.getDerivedSourceProperty()) != null) {
            difference = difference2.getChildDifference(string);
        }
        return difference;
    }

    protected PropertyInfo getPropertyInfo() {
        PropertyInfo propertyInfo = null;
        String string = this.getPropertyName();
        if (string != null) {
            Class<?> clazz;
            Difference difference = this.getParent();
            if (difference != null && "properties".equals(difference.getPropertyName())) {
                difference = difference.getParent();
            }
            if (difference != null && (clazz = difference.getDifferenceClass()) != null && DBObject.class.isAssignableFrom(clazz)) {
                propertyInfo = PropertyHelper.findPropertyInfo(clazz, string, (DBObjectProvider)null);
            }
        }
        return propertyInfo;
    }

    public String getPropertyPath() {
        String string;
        String string2 = this.getPropertyName();
        String string3 = string = this.m_parent == null ? null : this.m_parent.getPropertyPath();
        Object object = ModelUtil.hasLength((String)string) ? (ModelUtil.hasLength((String)string2) ? string + "/" + string2 : string) : string2;
        return object;
    }

    public abstract boolean isModified();

    public boolean isSame() {
        return this.m_same;
    }

    public final boolean isFiltered() {
        return this.m_filtered;
    }

    public void setSame(boolean bl) {
        this.m_same = bl;
    }

    public abstract boolean isLeaf();

    public abstract boolean isMap();

    public abstract boolean isList();

    public abstract Object getObject(String var1);

    public abstract void setObject(String var1, Object var2);

    public abstract int getIndexOf(String var1);

    public abstract void setUpdateContributor(String var1);

    public abstract String getOriginalContributor();

    public abstract String getUpdateContributor();

    public abstract Collection<? extends Difference> getChildren();

    public Difference getChildDifference(String string) {
        return this.getChildDifference(string, false);
    }

    public Difference getChildDifference(String string, boolean bl) {
        Difference difference = null;
        if (ModelUtil.hasLength((String)string)) {
            for (Difference difference2 : this.getChildren()) {
                if (difference2 == null || !string.equals(difference2.getPropertyName())) continue;
                if (bl && difference2.isSame()) break;
                difference = difference2;
                break;
            }
        }
        return difference;
    }

    public abstract Class<?> getDifferenceClass();

    public final Object getOriginalObject() {
        return this.getObject(this.getOriginalContributor());
    }

    public final Object getUpdatedObject() {
        return this.getObject(this.getUpdateContributor());
    }

    public final int getIndexOfOriginalObject() {
        return this.getIndexOf(this.getOriginalContributor());
    }

    public final int getIndexOfUpdatedObject() {
        return this.getIndexOf(this.getUpdateContributor());
    }

    public Difference getFilteredDifference(DifferenceFilter ... differenceFilterArray) {
        Difference difference = (Difference)this.copyTo(null);
        if (differenceFilterArray != null && differenceFilterArray.length > 0) {
            difference.applyFilters(false, differenceFilterArray);
        }
        return difference;
    }

    private void applyFilters(boolean bl, DifferenceFilter ... differenceFilterArray) {
        if (!this.isLoaded() || !this.isSame()) {
            Collection<? extends Difference> collection;
            int n;
            String string;
            boolean bl2 = bl;
            if (!bl2 && ModelUtil.hasLength((String)(string = this.getPropertyPath()))) {
                for (n = 0; n < differenceFilterArray.length; ++n) {
                    if (!differenceFilterArray[n].isFilteredProperty(this, string)) continue;
                    bl2 = true;
                    break;
                }
            }
            boolean bl3 = this.m_filtered;
            n = 0;
            if (!(!this.isLoaded() && bl2 || (collection = this.getChildrenInFilterOrder()).isEmpty())) {
                n = 1;
                for (Difference difference : collection) {
                    Difference difference2 = difference.getSourceDifference();
                    if (difference2 != null && difference2.isFiltered()) {
                        difference.applyFilters(true, differenceFilterArray);
                        continue;
                    }
                    difference.applyFilters(bl2, differenceFilterArray);
                    if (bl2) continue;
                    n &= difference.isSame();
                    bl3 |= difference.isFiltered();
                }
            }
            if (bl2) {
                bl3 = true;
                n = 1;
            }
            this.m_filtered = bl3;
            if (n != 0) {
                this.setSame(true);
            }
        }
    }

    private Collection<? extends Difference> getChildrenInFilterOrder() {
        Collection<? extends Difference> collection;
        if (this.isList()) {
            collection = this.getChildren();
        } else if (this.isMap()) {
            ArrayList<? extends Difference> arrayList = new ArrayList<Difference>();
            ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
            for (Difference difference : this.getChildren()) {
                if (difference.isDerived()) {
                    arrayList2.add(difference);
                    continue;
                }
                arrayList.add(difference);
            }
            arrayList.addAll(arrayList2);
            collection = arrayList;
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public final Object getProperty(String string) {
        return this.m_props.get(string);
    }

    public final void setProperty(String string, Object object) {
        this.m_props.put(string, object);
    }

    protected void copyToImpl(Difference difference) {
        difference.m_same = this.m_same;
        difference.m_props.clear();
        ModelUtil.deepCopy(this.m_props, difference.m_props);
    }

    public final void print() {
        this.print(DBLog.getLogger(this), Level.FINEST);
    }

    public final void print(Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            StringBuilder stringBuilder = new StringBuilder("\n");
            this.print(stringBuilder, "");
            logger.log(level, stringBuilder.toString());
        }
    }

    public final void print(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder, "");
        printStream.println(stringBuilder);
        printStream.flush();
    }

    private void print(StringBuilder stringBuilder, String object) {
        stringBuilder.append((String)object);
        this.toString(stringBuilder);
        stringBuilder.append("\n");
        object = (String)object + "  ";
        for (Difference difference : this.getChildrenForLog()) {
            difference.print(stringBuilder, (String)object);
        }
    }

    protected String getOriginalObjectForLog() {
        return String.valueOf(this.getOriginalObject());
    }

    protected String getUpdatedObjectForLog() {
        return String.valueOf(this.getUpdatedObject());
    }

    protected String getSameTextForLog() {
        return this.isSame() ? "SAME" : "XXXX";
    }

    protected Collection<? extends Difference> getChildrenForLog() {
        return this.getChildren();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    protected void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.getSameTextForLog()).append("  ");
        stringBuilder.append(this.getPropertyName());
        if (this.isLeaf()) {
            stringBuilder.append("  ").append("(").append(this.getOriginalObjectForLog()).append(" : ").append(this.getUpdatedObjectForLog()).append(")");
        }
        int n = this.getIndexOfOriginalObject();
        int n2 = this.getIndexOfUpdatedObject();
        if (n >= 0 || n2 >= 0) {
            stringBuilder.append("  ").append(n + " " + n2);
        }
    }
}

