/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLGeneratorImpl;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.extension.DelegateDDLGenerator;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;

public class TokenDDLGenerator<T extends DDLType>
extends DDLGeneratorImpl<T> {
    private final TokenProcessor m_processor = new TokenProcessor(this.getPropertyHelper());

    @Deprecated
    public TokenDDLGenerator(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider.getClass(), dBObjectProvider);
    }

    public TokenDDLGenerator(Class<? extends Database> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider);
    }

    public void registerTokenGenerator(String string, TokenGenerator tokenGenerator) {
        this.m_processor.registerGenerator(string, tokenGenerator);
    }

    public final void registerCreateDDL(final String string, final String string2, final DDLType dDLType) {
        this.registerCreateGenerator(string, new CreateDDLGenerator(){
            private Collection<String> m_allProps;

            @Override
            public DDL getCreateDDL(DDLOptions dDLOptions, DBObject dBObject) {
                return TokenDDLGenerator.this.createDDL(dDLOptions, string2, dBObject, dDLType);
            }

            @Override
            public boolean canCreate(String string3) {
                if (this.m_allProps == null) {
                    this.m_allProps = TokenDDLGenerator.this.m_processor.getCreatePropertyPaths(string2, string, TokenDDLGenerator.this.getProvider());
                }
                return this.m_allProps.contains(string3);
            }

            @Override
            public boolean canReplace() {
                boolean bl = string2.contains("{replace}");
                return bl;
            }
        });
    }

    public final void registerDropDDL(String string, final String string2, final DDLType dDLType) {
        this.registerDropGenerator(string, new DropDDLGenerator(){

            @Override
            public DDL getDropDDL(DDLOptions dDLOptions, DBObject dBObject) {
                return TokenDDLGenerator.this.createDDL(dDLOptions, string2, dBObject, dDLType);
            }
        });
    }

    public final void registerUndeleteDDL(String string, final String string2, final DDLType dDLType) {
        this.registerUndeleteGenerator(string, new UndeleteDDLGenerator(){

            @Override
            public DDL getUndeleteDDL(DDLOptions dDLOptions, DBObject dBObject) {
                return TokenDDLGenerator.this.createDDL(dDLOptions, string2, dBObject, dDLType);
            }
        });
    }

    public final void registerAlterDDL(final String string, final String string2, final DDLType dDLType) {
        this.registerAlterGenerator(string, new AlterDDLGenerator(){
            private Map<PropertyAction.ChildAction, Collection<String>> m_allProps;

            @Override
            public DDL getAlterDDL(DDLOptions dDLOptions, Difference difference) {
                return TokenDDLGenerator.this.createUpdateDDL(dDLOptions, string2, difference, dDLType);
            }

            @Override
            public Collection<PropertyAction.ChildAction> canAlter(String string3) {
                if (this.m_allProps == null) {
                    this.m_allProps = TokenDDLGenerator.this.m_processor.getAlterPropertyPaths(string2, string, TokenDDLGenerator.this.getProvider());
                }
                EnumSet<PropertyAction.ChildAction> enumSet = EnumSet.noneOf(PropertyAction.ChildAction.class);
                for (PropertyAction.ChildAction childAction : PropertyAction.ChildAction.values()) {
                    Collection<String> collection = this.m_allProps.get((Object)childAction);
                    if (collection == null || !collection.contains(string3)) continue;
                    enumSet.add(childAction);
                }
                return enumSet;
            }
        });
    }

    protected DDL createDDL(DDLOptions dDLOptions, String string, DBObject dBObject, DDLType dDLType) {
        TokenContext tokenContext = new TokenContext(this.getProvider(), dDLOptions, dBObject);
        return this.constructDDL(dDLOptions, string, tokenContext, dDLType);
    }

    protected DDL createUpdateDDL(DDLOptions dDLOptions, String string, Difference difference, DDLType dDLType) {
        TokenContext tokenContext = new TokenContext(this.getProvider(), dDLOptions, difference);
        return this.constructDDL(dDLOptions, string, tokenContext, dDLType);
    }

    private DDL constructDDL(DDLOptions dDLOptions, String string, TokenContext tokenContext, DDLType dDLType) {
        this.m_processor.process(string, tokenContext);
        DDL<DDLType> dDL = null;
        for (String string2 : tokenContext.getStatements()) {
            if (!ModelUtil.hasLength((String)string2)) continue;
            if (dDL == null) {
                dDL = new DDL<DDLType>((DBObject)tokenContext.getObject());
            }
            dDL.append(dDLType, string2);
        }
        return dDL;
    }

    public String getDDLFragment(DBObject dBObject) {
        String string = null;
        if (this.m_processor.canProcess(dBObject)) {
            TokenContext tokenContext = new TokenContext(this.getProvider(), new DDLOptions(), dBObject);
            tokenContext.setProcessor(this.m_processor);
            tokenContext.append(dBObject);
            string = tokenContext.toString();
        }
        return string;
    }

    public void includeSyntax(DatabaseDescriptor databaseDescriptor, String string, boolean bl) {
        DBObjectProvider dBObjectProvider = this.getProvider();
        DDLGenerator dDLGenerator = databaseDescriptor.getDDLGenerator(dBObjectProvider);
        if (dDLGenerator instanceof DelegateDDLGenerator) {
            dDLGenerator = ((DelegateDDLGenerator)dDLGenerator).getBaseGenerator();
        }
        if (dDLGenerator instanceof DDLGeneratorImpl) {
            ((DDLGeneratorImpl)dDLGenerator).copyGenerators(this, string, bl);
        }
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        Collection<String> collection;
        if (Property.getLastProperty(string).equals("constraintType")) {
            collection = new ArrayList();
            for (String string2 : Constraint.getConstraintTypes()) {
                if (!this.m_processor.hasRegisteredToken("CONSTRAINT." + string2)) continue;
                collection.add(string2);
            }
        } else {
            collection = super.getAllowedPropertyValues(dBObject, dBObject2, string);
        }
        return collection;
    }
}

