/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class TokenContext {
    private static final char NEWLINE = '\n';
    private StringBuilder m_buff = new StringBuilder();
    private List<String> m_stmts = new ArrayList<String>();
    private DBObjectProvider m_provider;
    private DDLOptions m_options;
    private TokenProcessor m_processor;
    private Object m_obj;
    private String m_block;
    private Difference m_difference;
    private Object m_loop;
    private boolean m_statementLoop;
    private int m_increment;

    TokenContext(DBObjectProvider dBObjectProvider, DDLOptions dDLOptions, Object object) {
        this.m_provider = dBObjectProvider;
        DDLOptions dDLOptions2 = this.m_options = dDLOptions == null ? new DDLOptions() : dDLOptions;
        if (object instanceof Difference) {
            this.m_difference = (Difference)object;
            this.m_obj = this.m_difference.getUpdatedObject();
        } else {
            this.m_obj = object;
        }
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public Schema getDefaultSchema() {
        Schema schema = null;
        if (this.m_provider != null) {
            try {
                schema = this.m_provider.getDefaultSchema();
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
        }
        return schema;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public Difference getDifference() {
        return this.m_difference;
    }

    public boolean isUpdate() {
        return this.m_difference != null;
    }

    public Difference findUpdateDifference(DBObject dBObject) {
        Difference difference = null;
        Difference difference2 = this.m_options.getContextDifference();
        if (difference2 != null) {
            difference = this.findDifference(dBObject, difference2);
        }
        return difference;
    }

    private Difference findDifference(DBObject dBObject, Difference difference) {
        Difference difference2;
        block3: {
            difference2 = null;
            if ((difference.isSame() || !DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(difference.getDifferenceClass()))) && !"properties".equals(difference.getPropertyName())) break block3;
            if (dBObject == difference.getUpdatedObject() || dBObject == difference.getOriginalObject()) {
                difference2 = difference;
            } else {
                Difference difference3;
                Iterator<? extends Difference> iterator = difference.getChildren().iterator();
                while (iterator.hasNext() && (difference2 = this.findDifference(dBObject, difference3 = iterator.next())) == null) {
                }
            }
        }
        return difference2;
    }

    public DDLOptions getOptions() {
        return this.m_options;
    }

    TokenProcessor getProcessor() {
        return this.m_processor;
    }

    void setProcessor(TokenProcessor tokenProcessor) {
        this.m_processor = tokenProcessor;
    }

    void setBlock(String string) {
        this.m_block = string;
    }

    String getBlock() {
        return this.m_block;
    }

    void setLoopObject(Object object) {
        this.m_loop = object;
        if (this.m_buff.length() == 0) {
            this.m_statementLoop = true;
        } else if (this.m_statementLoop) {
            this.endCurrentStatement();
        }
    }

    public Object getLoopObject() {
        return this.m_loop;
    }

    public void endCurrentStatement() {
        if (this.m_buff.length() > 0) {
            String string = this.m_buff.toString().trim();
            if (string.length() > 0) {
                this.m_stmts.add(string);
            }
            this.m_buff.delete(0, this.m_buff.length());
        }
    }

    public void incrementIndent() {
        ++this.m_increment;
    }

    public void decrementIndent() {
        if (this.m_increment > 0) {
            --this.m_increment;
        }
    }

    private void appendIncrement() {
        int n;
        boolean bl = false;
        if (this.m_increment > 0 && !(bl = this.endsWith('\n')) && this.endsWithWhitespace()) {
            n = this.m_buff.length();
            char[] cArray = new char[1];
            for (int i = n; i > 0; --i) {
                this.m_buff.getChars(i - 1, i, cArray, 0);
                if (!Character.isWhitespace(cArray[0])) break;
                if (cArray[0] != '\n') continue;
                this.m_buff.delete(i, n);
                bl = true;
                break;
            }
        }
        if (bl) {
            for (n = 1; n <= this.m_increment; ++n) {
                this.m_buff.append("  ");
            }
        }
    }

    public String toString() {
        return this.m_buff.toString().trim();
    }

    public List<String> getStatements() {
        this.endCurrentStatement();
        return this.m_stmts;
    }

    public int length() {
        return this.m_buff.length();
    }

    public void removeIfEndsWith(String string) {
        int n = this.m_buff.length() - string.length();
        if (n >= 0 && this.m_buff.lastIndexOf(string) == n) {
            this.m_buff.delete(n, this.m_buff.length());
        }
    }

    boolean endsWithWhitespace() {
        char[] cArray = new char[1];
        int n = this.m_buff.length();
        if (n > 0) {
            this.m_buff.getChars(n - 1, n, cArray, 0);
            return Character.isWhitespace(cArray[0]);
        }
        return false;
    }

    boolean endsWith(char c) {
        char[] cArray = new char[1];
        int n = this.m_buff.length();
        if (n > 0) {
            this.m_buff.getChars(n - 1, n, cArray, 0);
            return c == cArray[0];
        }
        return false;
    }

    void appendName(String string) {
        this.appendString(this.getExternalName(string), false);
    }

    public String getExternalName(String string) {
        String string2 = string;
        if (this.m_provider != null) {
            string2 = this.m_provider.getExternalName(string);
        }
        return string2;
    }

    public void appendString(String string, boolean bl) {
        if (ModelUtil.hasLength((String)string)) {
            if (bl) {
                int n = string.indexOf(10);
                if (this.m_increment > 0) {
                    while (n >= 0) {
                        this.appendIncrement();
                        this.m_buff.append(string.substring(0, n));
                        this.m_buff.append('\n');
                        string = string.substring(n + 1);
                        n = string.indexOf(10);
                    }
                }
            }
            this.appendIncrement();
            this.m_buff.append(string);
        } else if (string == null) {
            this.m_buff.append(string);
        }
    }

    void appendSchemaName(String string) {
        if (ModelUtil.hasLength((String)string)) {
            Object object = this.getObject();
            Schema schema = null;
            boolean bl = this.m_options.isPrefixSchemaName();
            if (!bl && this.m_provider != null) {
                schema = this.getDefaultSchema();
                boolean bl2 = bl = schema == null || !string.equals(schema.getName());
            }
            if (!bl) {
                Schema schema2 = schema = object instanceof DBObject ? DBUtil.getSchema((DBObject)object) : null;
                if (schema != null) {
                    boolean bl3 = bl = !string.equals(schema.getName());
                }
            }
            if (bl) {
                this.appendName(string);
                this.appendString(".", false);
            }
        }
    }

    public void append(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Difference) {
            this.append(((Difference)object).getUpdatedObject());
        } else if (object instanceof DBObject) {
            if (this.m_processor.canProcess(object)) {
                TokenContext tokenContext = this.newChildContext((DBObject)object);
                this.m_processor.process(object, tokenContext);
            } else if (object instanceof SQLFragment) {
                this.appendString(((SQLFragment)object).getSQLText(), true);
            } else if (object instanceof DataTypeUsage) {
                String string = DataTypeHelper.getDDL((DataTypeUsage)object, this.getProvider());
                if (string != null) {
                    this.appendString(string, true);
                }
            } else if (object instanceof PredefinedDataType) {
                this.appendString(((PredefinedDataType)object).getName(), true);
            } else {
                Schema schema;
                if (object instanceof SchemaObject && (schema = ((SchemaObject)object).getSchema()) != null) {
                    this.appendSchemaName(schema.getName());
                }
                this.appendName(((DBObject)object).getName());
            }
        } else if (object instanceof DBObjectID) {
            DBObject dBObject;
            boolean bl = false;
            try {
                dBObject = ((DBObjectID)object).resolveID();
                if (dBObject != null) {
                    bl = true;
                    this.append(dBObject);
                }
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
            if (!bl) {
                if (DataTypeHelper.canGetTypeStringFromID((DBObjectID)object)) {
                    dBObject = null;
                    try {
                        dBObject = this.m_provider == null ? null : this.m_provider.getDefaultSchema();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    this.appendString(DataTypeHelper.getTypeStringFromID((BaseObjectID)object, (Schema)dBObject, this.m_provider), true);
                } else if (object instanceof BaseObjectID) {
                    this.appendSchemaName(((BaseObjectID)object).getSchemaName());
                    this.appendName(((BaseObjectID)object).getName());
                }
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    this.appendString(", ", false);
                }
                this.append(objectArray[i]);
            }
        } else {
            this.appendString(object.toString(), true);
        }
    }

    public TokenContext newChildContext(Object object) {
        Object object2 = object != null ? object : (this.m_difference != null ? this.m_difference : this.m_obj);
        TokenContext tokenContext = new TokenContext(this.m_provider, this.m_options, object2);
        tokenContext.m_buff = this.m_buff;
        tokenContext.m_processor = this.m_processor;
        tokenContext.m_loop = this.m_loop;
        tokenContext.m_increment = this.m_increment;
        tokenContext.m_stmts = this.m_stmts;
        return tokenContext;
    }

    public Object getPropertyValue(String string) {
        PropertyHelper propertyHelper = this.m_processor.getPropertyHelper();
        Difference difference = this.getDifference();
        if (difference != null) {
            try {
                Difference difference2 = propertyHelper.getChildDifference(difference, string);
                if (difference2 != null) {
                    if (difference2.isSame()) {
                        return difference2.getOriginalObject();
                    }
                    return difference2.getUpdatedObject();
                }
            }
            catch (MissingPropertyException missingPropertyException) {
                // empty catch block
            }
        }
        try {
            return propertyHelper.getPropertyValueOrFail(this.getObject(), string);
        }
        catch (MissingPropertyException missingPropertyException) {
            this.getLogger().fine(missingPropertyException.getMessage());
            return null;
        }
    }
}

