/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public class DataTypeSynonym
extends AbstractDBObject
implements DataType {
    private DataType m_delegate;
    private String m_definition;
    private TokenPattern m_search;

    public DataTypeSynonym() {
    }

    public DataTypeSynonym(String string, DataType dataType) {
        assert (string != null);
        assert (dataType != null);
        this.m_delegate = dataType;
        this.setName(string);
    }

    public DataType getBaseType() {
        return this.m_delegate;
    }

    @Override
    public Integer getSQLType() {
        return this.m_delegate.getSQLType();
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_delegate.getDataTypeAttributes();
    }

    @Override
    public boolean hasDataTypeAttribute(String string) {
        return this.m_delegate.hasDataTypeAttribute(string);
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String string) {
        return this.m_delegate.getDataTypeAttribute(string);
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        String string;
        if (this.m_delegate instanceof PredefinedDataType && ((PredefinedDataType)this.m_delegate).getDefinitionForSearch().contains(this.m_delegate.getName())) {
            string = this.m_delegate.getDDL(dataTypeUsage).replaceFirst(Pattern.quote(this.m_delegate.getName()), this.getName());
        } else {
            PredefinedDataType.DDLGenImpl dDLGenImpl = new PredefinedDataType.DDLGenImpl(this.getDefinition());
            string = dDLGenImpl.getDDL(dataTypeUsage.getAttributeValues());
        }
        return string;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        DataTypeUsage dataTypeUsage = this.m_delegate.createDefaultUsage();
        dataTypeUsage.setDataTypeID(this.getID());
        return dataTypeUsage;
    }

    public DataTypeUsage createUsage(Map map) {
        Object object;
        if (map != null && (object = (String)map.get("name")) != null) {
            object = ((String)object).replaceAll(this.getName(), this.m_delegate.getName());
            map.put("name", object);
        }
        object = this.m_delegate.createUsage(map);
        ((DataTypeUsage)object).setDataTypeID(this.getID());
        return object;
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        DataTypeSynonym dataTypeSynonym = (DataTypeSynonym)abstractDBObject;
        super.copyToImpl(dataTypeSynonym, dBObject, iDPolicy);
        dataTypeSynonym.m_delegate = this.m_delegate;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        DataTypeSynonym dataTypeSynonym = (DataTypeSynonym)abstractDBObject;
        return super.equalsImpl(abstractDBObject) && ModelUtil.areEqual((Object)dataTypeSynonym.m_delegate, (Object)this.m_delegate);
    }

    @Override
    public String getType() {
        return this.m_delegate == null ? null : this.m_delegate.getType();
    }

    @Override
    public boolean matches(String string) {
        return DataTypeHelper.matches(this.getSearch(), string) != null;
    }

    @Override
    public DataTypeUsage createUsage(String string) {
        return DataTypeHelper.getUsageFromString(this, this.getSearch(), string);
    }

    private String getDefinition() {
        String string = this.m_definition;
        if (string == null) {
            String string2 = this.getName();
            if (this.m_delegate instanceof PredefinedDataType) {
                String string3;
                PredefinedDataType predefinedDataType = (PredefinedDataType)this.m_delegate;
                String string4 = predefinedDataType.getDefinitionForSearch();
                if (string4.contains(string3 = predefinedDataType.getName())) {
                    string4 = string4.replace(string3, string2);
                } else {
                    String[] stringArray = string3.split("\\s", 2);
                    if (stringArray.length == 2 && string4.contains(stringArray[0]) && string2.endsWith(stringArray[1])) {
                        String string5 = string2.substring(0, string2.length() - stringArray[1].length()).trim();
                        string4 = string4.replaceFirst(Pattern.quote(stringArray[0]), string5);
                    } else {
                        string4 = null;
                    }
                }
                this.m_definition = string = string4;
            }
            if (string == null) {
                string = "";
                DBLog.getLogger(this).severe("Cannot create search definition for " + string2);
            }
        }
        return string;
    }

    private TokenPattern getSearch() {
        TokenPattern tokenPattern = this.m_search;
        if (tokenPattern == null) {
            String string = this.getDefinition();
            this.m_search = tokenPattern = DataTypeHelper.buildSearch(string, this.getDataTypeAttributes());
        }
        return tokenPattern;
    }
}

