/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public final class DataTypeRegistry {
    private final Object m_lock = new Object();
    private final Map<Class, Object> m_dataTypes = new HashMap<Class, Object>();
    private final Map<DataType, DataType> m_synonyms = new HashMap<DataType, DataType>();
    private final Map<Class, Object> m_registered = new HashMap<Class, Object>();
    private final Collection<String> m_attributeNames = new HashSet<String>();
    private final Collection<String> m_genericJdbcClasses = new HashSet<String>();

    private DataTypeRegistry() {
        this.m_genericJdbcClasses.add(JdbcDatabase.class.getName());
    }

    public boolean isRegistered(Class<? extends Database> clazz) {
        boolean bl = false;
        for (Class<? extends Database> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            if (!this.m_dataTypes.containsKey(clazz2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataTypesImpl(Class<? extends Database> clazz, boolean bl, Collection<DataType> collection, String string) {
        DatabaseDescriptor databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(clazz);
        boolean bl2 = bl ? false : this.isRegistered(clazz);
        for (Class<? extends Database> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Object object = this.m_lock;
            synchronized (object) {
                Object object2 = this.m_dataTypes.get(clazz2);
                bl2 |= object2 != null;
                if (object2 instanceof Thunk) {
                    object2 = ((Thunk)object2).get();
                }
                if (object2 instanceof Registerer) {
                    this.m_dataTypes.remove(clazz2);
                    this.m_registered.put(clazz2, object2);
                    ((Registerer)object2).registerDataTypes(this);
                    object2 = this.m_dataTypes.get(clazz2);
                }
                if (object2 instanceof Map) {
                    Map map = (Map)object2;
                    if (string == null) {
                        collection.addAll(map.values());
                    } else {
                        DataType dataType = (DataType)map.get(string);
                        if (dataType != null) {
                            collection.add(dataType);
                            bl = false;
                        }
                    }
                }
            }
            if (bl) {
                continue;
            }
            clazz2 = null;
            break;
        }
        if (!bl2) {
            if (string == null) {
                collection.addAll(databaseDescriptor.listSupportedDataTypes());
            } else {
                collection.add(databaseDescriptor.getDataType(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProvider(Registerer registerer, Class<? extends Database> clazz) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_registered.containsKey(clazz)) {
                this.m_dataTypes.put(clazz, registerer);
            }
        }
    }

    public void registerDataType(DataType dataType, Class<? extends Database> clazz) {
        this.registerDataType(dataType, clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataType(DataType dataType, Class<? extends Database> clazz, DataType dataType2) {
        Object object = this.m_lock;
        synchronized (object) {
            String string;
            Object object2 = this.m_dataTypes.get(clazz);
            if (object2 instanceof Registerer) {
                throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
            }
            HashMap<String, DataType> hashMap = (HashMap<String, DataType>)object2;
            if (hashMap == null) {
                hashMap = new HashMap<String, DataType>();
                this.m_dataTypes.put(clazz, hashMap);
            }
            if (hashMap.containsKey(string = dataType.getName().toUpperCase())) {
                DBLog.getLogger(this).log(Level.WARNING, "Duplicate datatype for " + clazz.getName() + " registered: " + string);
            }
            hashMap.put(string, dataType);
            this.registerAttributes(dataType);
            dataType.setID(new DataTypeID(string, DatabaseFactory.getDatabaseDescriptor(clazz)));
            if (dataType2 != null) {
                this.mapToAnsiType(dataType, dataType2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAttributes(DataType dataType) {
        Object object = this.m_lock;
        synchronized (object) {
            for (DataTypeAttribute dataTypeAttribute : dataType.getDataTypeAttributes()) {
                this.m_attributeNames.add(dataTypeAttribute.getName());
            }
        }
    }

    @Deprecated
    public void registerComplexType(Type type, Class<? extends Database> clazz) {
    }

    @Deprecated
    public DataType createUserDataType(String string, Class<? extends Database> clazz) {
        UserDataType userDataType = new UserDataType(string);
        userDataType.setID(TemporaryObjectID.createID(userDataType));
        return userDataType;
    }

    public DataType createUserDataType(String string, DBObjectProvider dBObjectProvider) {
        UserDataType userDataType = new UserDataType(string);
        ReferenceID referenceID = new ReferenceID("DATATYPE", (String)null, string);
        referenceID.setProvider(dBObjectProvider);
        userDataType.setID(referenceID);
        return userDataType;
    }

    public DataType findDataType(String string, Class clazz) {
        DataType dataType = null;
        if (ModelUtil.hasLength((String)string) && (dataType = this.findDataType(string, clazz, true)) == null && clazz != null && JdbcDatabase.class.isAssignableFrom(clazz)) {
            return this.findAnsiType(string);
        }
        return dataType;
    }

    private DataType findDataType(String string, Class clazz, boolean bl) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        this.getDataTypesImpl(clazz, bl, arrayList, string.toUpperCase());
        return arrayList.size() > 0 ? (DataType)arrayList.get(0) : null;
    }

    @Deprecated
    public Type findComplexType(String string, String string2, Class clazz) {
        return null;
    }

    public DataType[] listDataTypes(Class clazz) {
        return this.listDataTypes(clazz, true);
    }

    DataType[] listDataTypes(Class clazz, boolean bl) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        this.getDataTypesImpl(clazz, bl, arrayList, null);
        return arrayList.toArray(new DataType[arrayList.size()]);
    }

    @Deprecated
    public Type[] listComplexTypes(String string, Class clazz) {
        return new Type[0];
    }

    @Deprecated
    public String[] listComplexTypeSchemas(Class clazz) {
        return new String[0];
    }

    public boolean isRegisteredType(DataType dataType) {
        return dataType.getID() instanceof DataTypeID;
    }

    public boolean isRegisteredAttribute(String string) {
        return this.m_attributeNames.contains(string);
    }

    public DataType registerSynonym(String string, DataType dataType, Class<? extends Database> clazz) {
        DataTypeSynonym dataTypeSynonym = new DataTypeSynonym(string, dataType);
        this.registerSynonym(dataTypeSynonym, dataType, clazz);
        return dataTypeSynonym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynonym(DataType dataType, DataType dataType2, Class<? extends Database> clazz) {
        Object object = this.m_lock;
        synchronized (object) {
            this.registerDataType(dataType, clazz);
            this.m_synonyms.put(dataType, dataType2);
        }
    }

    public boolean isSynonymType(DataType dataType) {
        return this.m_synonyms.containsKey(dataType);
    }

    public DataType getBaseType(DataType dataType) {
        return this.m_synonyms.get(dataType);
    }

    public DataType findAnsiType(String string) {
        return DatabaseFactory.getDatabaseDescriptor(JdbcDatabase.class).getDataType(string);
    }

    public DataType[] getAnsiTypes() {
        Collection<DataType> collection = DatabaseFactory.getDatabaseDescriptor(JdbcDatabase.class).listSupportedDataTypes();
        return collection.toArray(new DataType[collection.size()]);
    }

    @Deprecated
    public void mapToAnsiType(DataType dataType, String string) {
    }

    public void mapToAnsiType(DataType dataType, DataType dataType2) {
        if (dataType instanceof PredefinedDataType && dataType.getSQLType() == null) {
            if (dataType2.getSQLType() == null) {
                dataType2 = this.findAnsiType(dataType2.getName());
            }
            if (dataType2 != null) {
                ((PredefinedDataType)dataType).setSQLType(dataType2.getSQLType());
            }
        }
    }

    @Deprecated
    public DataType getMappedAnsiType(DataType dataType) {
        return null;
    }

    @Deprecated
    public DataType getMappedType(String string, Class<? extends Database> clazz) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTypeRegistry getInstance() {
        DBCore dBCore = DBCore.getInstance();
        Class<DataTypeRegistry> clazz = DataTypeRegistry.class;
        synchronized (DataTypeRegistry.class) {
            DataTypeRegistry dataTypeRegistry = dBCore.get(DataTypeRegistry.class);
            if (dataTypeRegistry == null) {
                dataTypeRegistry = new DataTypeRegistry();
                dBCore.put(dataTypeRegistry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dataTypeRegistry;
        }
    }

    public static final void registerGenericJdbcClass(String string) {
        DataTypeRegistry.getInstance().m_genericJdbcClasses.add(string);
    }

    @Deprecated
    public static final void registerGenericJdbcClass(Class<? extends JdbcDatabase> clazz) {
        DataTypeRegistry.registerGenericJdbcClass(clazz.getName());
    }

    public static final boolean isGenericJdbcClass(Class clazz) {
        return DataTypeRegistry.getInstance().m_genericJdbcClasses.contains(clazz.getName());
    }

    public static class Registerer {
        protected void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
        }

        @Deprecated
        protected void registerComplexTypes(DataTypeRegistry dataTypeRegistry) {
        }

        @Deprecated
        protected boolean includeSuperclassTypes() {
            return true;
        }

        @Deprecated
        protected boolean includeComplexTypes(String string) {
            return true;
        }
    }
}

