/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.resource.APIBundle;

public class DataTypeAttribute
extends AbstractChildDBObject {
    public static final String TYPE = "DatatypeAttribute";
    public static final String DATATYPE_NAME = "name";
    public static final String DATATYPE_SIZE = "size";
    public static final String DATATYPE_PRECISION = "precision";
    public static final String DATATYPE_SCALE = "scale";
    public static final String DATATYPE_UNSIGNED = "unsigned";
    public static final String DATATYPE_IS_REF = "ref";
    public static final String DATATYPE_REF_SCOPE = "ref_scope";
    public static final int DATATYPE_CHAR = 0;
    public static final int DATATYPE_LONG = 1;
    public static final int DATATYPE_LONG_OR_KEYWORD = 2;
    public static final int DATATYPE_LIST = 3;
    private ResourceBundle m_bundle;

    public DataTypeAttribute() {
        this.setExtensible(false);
        this.setMandatory(false);
        this.setDeclarable(false);
    }

    private DataTypeAttribute(String string, int n) {
        this();
        this.setName(string);
        this.setValueType(n);
    }

    public DataTypeAttribute(String string) {
        this(string, 0);
    }

    public DataTypeAttribute(String string, long l, long l2) {
        this(string, 1);
        this.setMinValue(l);
        this.setMaxValue(l2);
    }

    public DataTypeAttribute(String string, String string2, long l, Long l2, Long l3, boolean bl) {
        this(string, 1);
        this.setLabel(string2);
        this.setMinValue(l);
        this.setMaxValue(l2);
        this.setDefaultValue(l3);
        this.setMandatory(bl);
        this.setDeclarable(true);
    }

    public DataTypeAttribute(String string, String string2, String string3, boolean bl) {
        this(string, string2, null, string3, false, bl);
    }

    public DataTypeAttribute(String string, String string2, String[] stringArray, String string3, boolean bl, boolean bl2) {
        this(string, 0);
        this.setLabel(string2);
        this.setValues(stringArray);
        this.setDefaultValue(string3);
        this.setExtensible(bl);
        this.setMandatory(bl2);
        this.setDeclarable(true);
    }

    @Deprecated
    public DataTypeAttribute(String string, int n, String[] stringArray, String string2, boolean bl, boolean bl2) {
        this(string, null, stringArray, string2, bl, bl2);
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    void setResourceBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    public int getValueType() {
        return (Integer)this.getProperty("valueType", 0);
    }

    public void setValueType(int n) {
        this.setProperty("valueType", n);
    }

    public String getLabel() {
        return (String)this.getProperty("label");
    }

    public String getNLSLabel() {
        String string = this.getLabel();
        if (string != null) {
            ResourceBundle resourceBundle = this.m_bundle == null ? APIBundle.getBundle() : this.m_bundle;
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    public void setLabel(String string) {
        this.setProperty("label", string);
    }

    public Long getMinValue() {
        return (Long)this.getProperty("minValue");
    }

    public void setMinValue(Long l) {
        this.setProperty("minValue", l);
    }

    public Long getMaxValue() {
        return (Long)this.getProperty("maxValue");
    }

    public void setMaxValue(Long l) {
        this.setProperty("maxValue", l);
    }

    public String[] getValues() {
        return (String[])this.getProperty("values");
    }

    public void setValues(String[] stringArray) {
        this.setProperty("values", stringArray);
    }

    public Object getDefaultValue() {
        return this.getProperty("defaultValue");
    }

    public void setDefaultValue(Object object) {
        this.setProperty("defaultValue", object);
    }

    public boolean isDeclarable() {
        return (Boolean)this.getProperty("declarable", false);
    }

    public void setDeclarable(boolean bl) {
        this.setProperty("declarable", bl);
    }

    public boolean isMandatory() {
        return (Boolean)this.getProperty("mandatory", false);
    }

    public void setMandatory(boolean bl) {
        this.setProperty("mandatory", bl);
    }

    public boolean isExtensible() {
        return (Boolean)this.getProperty("extensible", false);
    }

    public void setExtensible(boolean bl) {
        this.setProperty("extensible", bl);
    }
}

