/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;

public class SchemaObjectManager
extends CascadeManager {
    private static final DBObjectID[] EMPTY_ID = new DBObjectID[0];
    private boolean m_registeredAll;
    private final Map<DBObjectID, Collection<DBObjectID>> m_deps = this.createIDMap();
    private final Map<DBObjectID, Collection<DBObjectID>> m_soDeps = this.createIDMap();

    public SchemaObjectManager(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected final boolean haveRegisteredAll() {
        return this.m_registeredAll;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
    }

    public void registerObject(SystemObject systemObject) {
        this.registerObject(systemObject, false);
    }

    public void registerObject(SystemObject systemObject, boolean bl) {
        if (this.shouldRegister(systemObject, bl)) {
            this.registerObject(systemObject, systemObject);
        }
    }

    protected boolean shouldRegister(SystemObject systemObject, boolean bl) {
        boolean bl2 = this.m_registeredAll;
        if (!bl2) {
            bl2 = systemObject instanceof View || systemObject instanceof Synonym || systemObject instanceof Table || systemObject instanceof Trigger || systemObject instanceof MaterializedViewLog;
        }
        return bl2;
    }

    protected final boolean needsInitialization(SystemObject systemObject) {
        return DBUtil.needsBuilding(systemObject);
    }

    public void unregisterObject(SystemObject systemObject) {
        if (this.m_registeredAll) {
            DBObjectID dBObjectID = systemObject.getID();
            if (dBObjectID != null) {
                // empty if block
            }
            this.unregisterImpl(systemObject);
        }
    }

    @Deprecated
    public DBObjectID[] getSchemaObjectReferers(SystemObject systemObject, boolean bl) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listTopLevelReferers(SystemObject systemObject, CascadeManager.LookupCriteria lookupCriteria) throws CancelledException {
        boolean bl = lookupCriteria.isRecurse();
        this.checkInit();
        DBObjectID dBObjectID = systemObject.getID();
        Collection<DBObjectID> collection = this.getSchemaObjectReferersImpl(dBObjectID, bl ? this.createIDSet() : null);
        if (systemObject instanceof Schema) {
            collection = this.includeSchemaObjects((Schema)systemObject, collection);
        }
        if (lookupCriteria.getTypes() != null) {
            Iterator<DBObjectID> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (lookupCriteria.isRequiredType(iterator.next().getType())) continue;
                iterator.remove();
            }
        }
        return collection == null ? Collections.emptyList() : collection;
    }

    @Deprecated
    public DBObjectID[] getReferers(DBObject dBObject) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listReferers(DBObject dBObject) throws CancelledException {
        Collection<DBObjectID> collection;
        Object object;
        this.checkInit();
        SystemObject systemObject = DBUtil.findParentOfType(dBObject, SystemObject.class);
        if (systemObject != null && (object = systemObject.getID()) != null && (collection = this.getSchemaObjectReferersImpl(systemObject.getID(), null)) != null) {
            for (DBObjectID dBObjectID : collection) {
                try {
                    DBObject dBObject2 = dBObjectID.resolveID();
                    this.ensureDerivedReferencePropertiesBuilt(dBObject2);
                }
                catch (CancelledException cancelledException) {
                    throw cancelledException;
                }
                catch (DBException dBException) {
                    this.getLogger().warning(dBException.getMessage());
                }
            }
        }
        return (object = this.listReferers(dBObject, null)) == null ? Collections.emptyList() : object;
    }

    private void ensureDerivedReferencePropertiesBuilt(DBObject dBObject) throws DBException {
        if (dBObject != null) {
            PropertyCriteria propertyCriteria = new PropertyCriteria();
            propertyCriteria.addPredicate(propertyInfo -> propertyInfo.getReferencedClass() != null);
            propertyCriteria.setInternal(null);
            propertyCriteria.setDerived(true);
            for (PropertyInfo object : this.getProvider().getPropertyManager().getPropertyInfos(dBObject.getClass(), propertyCriteria).values()) {
                DBUtil.ensureObjectBuilt(dBObject, object.getPropertyName());
            }
            for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
                this.ensureDerivedReferencePropertiesBuilt(dBObject2);
            }
        }
    }

    private Collection<DBObjectID> listReferers(DBObject dBObject, Collection<DBObjectID> collection) {
        Object object;
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null && (object = this.m_deps.get(dBObjectID)) != null) {
            if (collection == null) {
                collection = this.createIDSet();
            }
            collection.addAll((Collection<DBObjectID>)object);
        }
        for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
            collection = this.listReferers(dBObject2, collection);
        }
        return collection;
    }

    private void unregisterImpl(DBObject dBObject) {
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null) {
            Collection collection;
            Collection<DBObjectID> collection2 = this.getProvider().getObjectFactory().getReferenceIDs(dBObject);
            for (DBObjectID object : collection2) {
                if (!this.m_deps.containsKey(object) || (collection = this.m_deps.get(object)) == null) continue;
                collection.remove(dBObjectID);
                if (collection.size() >= 1) continue;
                this.m_deps.remove(object);
            }
            for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
                this.unregisterImpl(dBObject2);
            }
            if (dBObject instanceof SystemObject) {
                Iterator<Object> iterator = this.m_soDeps.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    collection = (Collection)entry.getValue();
                    if (collection == null) continue;
                    collection.remove(dBObjectID);
                    if (collection.size() >= 1) continue;
                    iterator.remove();
                }
            }
        }
    }

    private Collection<DBObjectID> getSchemaObjectReferersImpl(DBObjectID dBObjectID, Collection<DBObjectID> collection) {
        Collection<DBObjectID> collection2;
        if (dBObjectID != null && (collection2 = this.m_soDeps.get(dBObjectID)) != null && collection2.size() > 0) {
            if (collection == null) {
                collection = this.createIDSet();
                collection.addAll(collection2);
            } else {
                for (DBObjectID dBObjectID2 : collection2) {
                    if (dBObjectID2 == null || collection.contains(dBObjectID2)) continue;
                    collection.add(dBObjectID2);
                    this.getSchemaObjectReferersImpl(dBObjectID2, collection);
                }
            }
        }
        return collection;
    }

    private void registerObject(SystemObject systemObject, DBObject dBObject) {
        Collection<DBObjectID> collection = this.getProvider().getObjectFactory().getReferenceIDs(dBObject);
        for (DBObjectID object : collection) {
            if (object instanceof TemporaryObjectID) {
                this.getLogger().warning("WARNING: attempt to cache temporary ID with the dependency manager");
                continue;
            }
            this.registerDependency(systemObject, dBObject, object);
        }
        for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
            this.registerObject(systemObject, dBObject2);
        }
    }

    private void registerSchemaObjectDependency(SystemObject systemObject, DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = systemObject.getID();
        this.addMapping(dBObjectID2, dBObjectID, this.m_soDeps);
    }

    protected void registerDependency(SystemObject systemObject, DBObject dBObject, DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = dBObject.getID();
        if (!(dBObjectID instanceof DataTypeID)) {
            this.addMapping(dBObjectID2, dBObjectID, this.m_deps);
            DBObjectID dBObjectID3 = DBUtil.getUppermostParent(dBObjectID);
            if (dBObjectID3 != null && systemObject != null) {
                this.registerSchemaObjectDependency(systemObject, dBObjectID3);
            }
        }
    }

    private void addMapping(DBObjectID dBObjectID, DBObjectID dBObjectID2, Map<DBObjectID, Collection<DBObjectID>> map) {
        if (dBObjectID2 != null && dBObjectID != null && !dBObjectID2.equals(dBObjectID)) {
            this.mapKeyToCollection(dBObjectID2, dBObjectID, map);
        }
    }

    private <K, T> void mapKeyToCollection(K k, T t, Map<K, Collection<T>> map) {
        Collection<T> collection = map.get(k);
        if (collection == null) {
            collection = t instanceof DBObjectID ? this.createIDSet() : new HashSet<T>();
            map.put(k, collection);
        }
        collection.add(t);
    }

    protected void checkInit() throws CancelledException {
    }

    protected final synchronized void registerAllObjects() throws CancelledException {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            String[] stringArray = this.listObjectTypes();
            Schema[] schemaArray = this.listSchemas();
            for (int i = 0; i < schemaArray.length; ++i) {
                this.setRegisterProgress(0, 1, i, schemaArray.length, schemaArray[i].getName());
                SchemaObject[] schemaObjectArray = this.getProvider().listObjects(stringArray, schemaArray[i]);
                for (int j = 0; j < schemaObjectArray.length; ++j) {
                    this.setRegisterProgress(j, schemaObjectArray.length, i, schemaArray.length, schemaArray[i].getName());
                    this.registerObject(schemaObjectArray[j]);
                }
            }
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            DBLog.getLogger(this).severe(dBException.getMessage());
            this.m_registeredAll = false;
        }
    }

    protected String[] listObjectTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getProvider().listObjectTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        arrayList.remove("SEQUENCE");
        arrayList.remove("PACKAGE");
        arrayList.remove("FUNCTION");
        arrayList.remove("PROCEDURE");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected Schema[] listSchemas() throws DBException {
        return this.getProvider().listSchemas();
    }

    protected void setRegisterProgress(int n, int n2, int n3, int n4, String string) throws CancelledException {
        CancelledException.checkInterrupt();
    }

    @Deprecated
    public static final SystemObject[] getDependencies(SystemObject systemObject, DBObjectProvider dBObjectProvider, boolean bl) {
        return new SystemObject[0];
    }
}

