/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.internal.ClassThunk;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public final class DatabaseFactory
extends DBObjectProviderFactory.Creator {
    private final Map<String, ConnectionCreator> m_connCreators = new HashMap<String, ConnectionCreator>();
    private final Map<String, DatabaseCreatorInfo> m_dbCreators = new LinkedHashMap<String, DatabaseCreatorInfo>();
    private final List<DatabaseCreator> m_legacyCreators = new ArrayList<DatabaseCreator>();
    private final Map<String, String> m_dbCreatorsByClass = new HashMap<String, String>();
    private ClassThunk<DatabaseCreator> m_jdbcDatabaseCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabaseFactory getInstance() {
        DBCore dBCore = DBCore.getInstance();
        Class<DatabaseFactory> clazz = DatabaseFactory.class;
        synchronized (DatabaseFactory.class) {
            DatabaseFactory databaseFactory = dBCore.get(DatabaseFactory.class);
            if (databaseFactory == null) {
                databaseFactory = new DatabaseFactory();
                dBCore.put(databaseFactory);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return databaseFactory;
        }
    }

    private DatabaseFactory() {
    }

    private void checkDatabaseCreatorInit() {
        DatabaseRegistry.getInstance().checkInit();
    }

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    protected String getDescription(Object object) {
        StringBuilder stringBuilder = new StringBuilder(APIBundle.get("DATABASE_CONNECTION"));
        if (object instanceof String) {
            ConnectionCreator connectionCreator;
            String[] stringArray = DatabaseFactory.decodeIdentifier((String)object);
            stringBuilder.append(" ").append(stringArray[1]);
            if (ModelUtil.hasLength((String)stringArray[0]) && (connectionCreator = DatabaseFactory.findConnectionCreator(stringArray[0])) != null) {
                stringBuilder.append(" (").append(connectionCreator.getDisplayableStoreName()).append(")");
            }
        } else {
            stringBuilder.append(" ").append(object);
        }
        return stringBuilder.toString();
    }

    public static String[] decodeIdentifier(String string) {
        String string2;
        try {
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        String[] stringArray = string2.split("#", 2);
        if (stringArray.length == 1) {
            stringArray = new String[]{null, stringArray[0]};
        }
        return stringArray;
    }

    public static String encodeIdentifier(String string, String string2) {
        String string3;
        String string4 = string3 = string == null ? string2 : string + "#" + string2;
        if (string3 != null) {
            try {
                string4 = URLEncoder.encode(string3, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string4 = string3;
            }
        }
        return string4;
    }

    @Override
    protected String getIdentifier(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider instanceof Database) {
            return ((Database)dBObjectProvider).getQualifiedName();
        }
        return null;
    }

    @Override
    protected final DBObjectProvider createProviderImpl(Object object) throws DBException {
        Database database;
        block2: {
            String[] stringArray;
            block3: {
                database = null;
                if (!(object instanceof String)) break block2;
                stringArray = DatabaseFactory.decodeIdentifier((String)object);
                if (!ModelUtil.hasLength((String)stringArray[0])) break block3;
                ConnectionCreator connectionCreator = DatabaseFactory.findConnectionCreator(stringArray[0]);
                if (connectionCreator == null) break block2;
                database = DatabaseFactory.findOrCreateDatabase(stringArray[1], connectionCreator);
                break block2;
            }
            if (ModelUtil.hasLength((String)stringArray[1])) {
                for (ConnectionCreator connectionCreator : DatabaseFactory.getConnectionCreators()) {
                    if (connectionCreator.isActive() && (database = DatabaseFactory.findOrCreateDatabase(stringArray[1], connectionCreator)) != null) break;
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Database findOrCreateDatabase(String string, ConnectionCreator connectionCreator) throws DBException {
        Database database;
        ConnectionCreator connectionCreator2 = connectionCreator;
        synchronized (connectionCreator2) {
            Database database2 = connectionCreator.findDatabase(string);
            database = database2 == null ? DatabaseFactory.createDatabase(string, connectionCreator) : database2;
        }
        return database;
    }

    public static Database createDatabase(String string, ConnectionCreator connectionCreator) throws DBException {
        Connection connection = DatabaseFactory.createConnection(string, connectionCreator);
        if (connection != null) {
            String string2 = connectionCreator.getStoreName();
            Database database = DatabaseFactory.getInstance().createDatabaseImpl(string2, string, connection);
            if (database != null) {
                connectionCreator.cacheDatabase(string, database);
                return database;
            }
        }
        return null;
    }

    private Database createDatabaseImpl(String string, String string2, Connection connection) throws DBException {
        Object object = null;
        Object object2 = null;
        if (connection != null) {
            this.checkDatabaseCreatorInit();
            for (DatabaseCreatorInfo databaseCreatorInfo : this.m_dbCreators.values()) {
                Database database;
                if (!databaseCreatorInfo.matches(connection) || (object2 = databaseCreatorInfo.getCreator()) == null || (database = ((DatabaseCreator)object2).createDatabaseImpl(string, string2, connection)) == null) continue;
                object = database;
                break;
            }
            if (object == null && (object2 = this.getJdbcCreator()) != null) {
                object = ((DatabaseCreator)object2).createDatabaseImpl(string, string2, connection);
            }
        }
        if (object != null) {
            this.registerDatabaseImplementation(object.getClass().getName(), object2.getClass().getName());
        }
        return object;
    }

    void registerDatabaseImplementation(String string, String string2) {
        String string3 = this.m_dbCreatorsByClass.get(string);
        if (ModelUtil.areDifferent((Object)string3, (Object)string2)) {
            if (string3 != null) {
                DatabaseFactory.getLogger().fine("Replacing " + string3 + " with " + string2 + " for " + string);
            }
            this.m_dbCreatorsByClass.put(string, string2);
        }
    }

    void registerDatabaseCreator(String string, ClassLoader classLoader, ConnectionMatcher connectionMatcher) {
        this.registerDatabaseCreator(string, new ClassThunk<DatabaseCreator>(string, classLoader, DatabaseCreator.class), connectionMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDatabaseCreator(String string, ClassThunk<DatabaseCreator> classThunk, ConnectionMatcher connectionMatcher) {
        Map<String, DatabaseCreatorInfo> map = this.m_dbCreators;
        synchronized (map) {
            if (!this.m_dbCreators.containsKey(string)) {
                this.m_dbCreators.put(string, new DatabaseCreatorInfo(classThunk, connectionMatcher));
            }
        }
    }

    private DatabaseDescriptor getDescriptor(DatabaseCreator databaseCreator, Object object) {
        DatabaseDescriptor databaseDescriptor = object instanceof Class ? databaseCreator.getDatabaseDescriptorImpl((Class)object) : databaseCreator.getDatabaseDescriptorImpl((Database)object);
        return databaseDescriptor;
    }

    DatabaseCreator findDatabaseCreator(String string) {
        DatabaseCreatorInfo databaseCreatorInfo;
        this.checkDatabaseCreatorInit();
        DatabaseCreator databaseCreator = null;
        String string2 = this.m_dbCreatorsByClass.get(string);
        if (string2 != null && (databaseCreatorInfo = this.m_dbCreators.get(string2)) != null) {
            databaseCreator = databaseCreatorInfo.getCreator();
        }
        return databaseCreator;
    }

    private DatabaseDescriptor getDatabaseDescriptorImpl(Object object, Class<? extends Database> clazz) {
        Object object2;
        Object object3 = null;
        DatabaseCreator databaseCreator = this.findDatabaseCreator(clazz.getName());
        if (databaseCreator == null) {
            DatabaseCreator databaseCreator2;
            object2 = this.m_legacyCreators.iterator();
            while (object2.hasNext() && (object3 = this.getDescriptor(databaseCreator = (databaseCreator2 = (DatabaseCreator)object2.next()), object)) == null) {
            }
            if (object3 != null) {
                this.registerDatabaseImplementation(clazz.getName(), databaseCreator.getClass().getName());
            }
        } else {
            object2 = this.getDescriptor(databaseCreator, object);
            if (object2 != null) {
                object3 = object2;
            }
        }
        if (object3 == null && JdbcDatabase.class.isAssignableFrom(clazz) && (object2 = this.getJdbcCreator()) != null) {
            object3 = this.getDescriptor((DatabaseCreator)object2, object);
        }
        return object3;
    }

    void setJdbcDatabaseCreator(String string) {
        if (this.m_jdbcDatabaseCreator != null) {
            throw new IllegalStateException("The Generic JDBC DatabseCreator implementation cannot be replaced.");
        }
        this.m_jdbcDatabaseCreator = new ClassThunk<DatabaseCreator>(string, null, DatabaseCreator.class);
    }

    private DatabaseCreator getJdbcCreator() {
        return (DatabaseCreator)this.m_jdbcDatabaseCreator.get();
    }

    @Override
    protected DBObjectProvider findProvider(Object object) {
        Database database;
        block2: {
            String[] stringArray;
            block3: {
                database = null;
                if (!(object instanceof String)) break block2;
                stringArray = DatabaseFactory.decodeIdentifier((String)object);
                if (!ModelUtil.hasLength((String)stringArray[0])) break block3;
                ConnectionCreator connectionCreator = DatabaseFactory.findConnectionCreator(stringArray[0]);
                if (connectionCreator == null) break block2;
                database = connectionCreator.findDatabase(stringArray[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)stringArray[1])) {
                for (ConnectionCreator connectionCreator : DatabaseFactory.getConnectionCreators()) {
                    if (connectionCreator.isActive() && (database = connectionCreator.findDatabase(stringArray[1])) != null) break;
                }
            }
        }
        return database;
    }

    @Override
    protected DBObjectProvider uncacheProvider(Object object) {
        Database database;
        block2: {
            String[] stringArray;
            block3: {
                database = null;
                if (!(object instanceof String)) break block2;
                stringArray = DatabaseFactory.decodeIdentifier((String)object);
                if (!ModelUtil.hasLength((String)stringArray[0])) break block3;
                ConnectionCreator connectionCreator = DatabaseFactory.findConnectionCreator(stringArray[0]);
                if (connectionCreator == null) break block2;
                database = connectionCreator.uncacheDatabase(stringArray[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)stringArray[1])) {
                for (ConnectionCreator connectionCreator : DatabaseFactory.getConnectionCreators()) {
                    if (connectionCreator.isActive() && (database = connectionCreator.uncacheDatabase(stringArray[1])) != null) break;
                }
            }
        }
        return database;
    }

    public static final Database findOrCreateDatabase(String string, String string2) throws DBException {
        String string3 = DatabaseFactory.encodeIdentifier(string, string2);
        return (Database)DBObjectProviderFactory.findOrCreateProvider("db", string3);
    }

    @Deprecated
    public static final Database findOrCreateDatabase(String string, Connection connection) throws DBException {
        Database database = (Database)DBObjectProviderFactory.findOrCreateProvider("db", string);
        if (database == null) {
            database = DatabaseFactory.createStandaloneDatabase(string, connection);
        }
        return database;
    }

    public static final Database createStandaloneDatabase(String string, Connection connection) throws DBException {
        return DatabaseFactory.getInstance().createDatabaseImpl(null, string, connection);
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Class<? extends Database> clazz) {
        return DatabaseFactory.getInstance().getDatabaseDescriptorImpl(clazz, clazz);
    }

    @Deprecated
    public static void setJdbcDatabaseCreator(DatabaseCreator databaseCreator) {
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Database database) {
        return DatabaseFactory.getInstance().getDatabaseDescriptorImpl(database, database.getClass());
    }

    public static final void registerConnectionCreator(String string, ConnectionCreator connectionCreator) {
        if (connectionCreator != null) {
            DatabaseFactory.getInstance().m_connCreators.put(string, connectionCreator);
        }
    }

    public static final void unregisterConnectionCreator(String string, ConnectionCreator connectionCreator) {
        if (connectionCreator != null) {
            ConnectionCreator connectionCreator2 = DatabaseFactory.getInstance().m_connCreators.remove(string);
            if (connectionCreator2 == null) {
                DatabaseFactory.getLogger().warning("Cannot unregister ConnectionCreator for " + string + " as it was not registered using registerConnectionCreator");
            } else if (connectionCreator2 != connectionCreator) {
                DatabaseFactory.getLogger().warning("ConnectionCreator unregistration for " + string + ": store is not the same as the original registration.");
            }
        }
    }

    @Deprecated
    public static final void registerDatabaseCreator(DatabaseCreator databaseCreator) {
        DatabaseFactory.getInstance().registerDatabaseCreator(databaseCreator.getClass().getName(), new ClassThunk<DatabaseCreator>(databaseCreator), null);
        DatabaseFactory.getInstance().m_legacyCreators.add(databaseCreator);
    }

    private static List<ConnectionCreator> getConnectionCreators() {
        ArrayList<ConnectionCreator> arrayList = new ArrayList<ConnectionCreator>();
        arrayList.addAll(DatabaseFactory.getInstance().m_connCreators.values());
        List<? extends Thunk> list = DBCore.getInstance().getFactoryList(ConnectionCreatorFactory.class);
        if (list != null) {
            for (Thunk thunk : list) {
                ConnectionCreatorFactory connectionCreatorFactory = (ConnectionCreatorFactory)thunk.get();
                if (connectionCreatorFactory == null) continue;
                arrayList.addAll(connectionCreatorFactory.listCreators());
            }
        }
        return arrayList;
    }

    public static ConnectionCreator findConnectionCreator(String string) {
        List<? extends Thunk> list;
        ConnectionCreator connectionCreator = DatabaseFactory.getInstance().m_connCreators.get(string);
        if (connectionCreator == null && (list = DBCore.getInstance().getFactoryList(ConnectionCreatorFactory.class)) != null) {
            for (Thunk thunk : list) {
                try {
                    ConnectionCreatorFactory connectionCreatorFactory = (ConnectionCreatorFactory)thunk.get();
                    if (connectionCreatorFactory == null || (connectionCreator = connectionCreatorFactory.getCreator(string)) == null) continue;
                    break;
                }
                catch (Exception exception) {
                    DatabaseFactory.getLogger().log(Level.WARNING, "ConnectionCreatorFactory failure", exception);
                }
            }
        }
        if (connectionCreator == null) {
            DatabaseFactory.getLogger().warning("Unknown connection store name: " + string);
        }
        return connectionCreator;
    }

    @Deprecated
    public static final <T extends ConnectionCreator> T findConnectionCreator(Class<T> clazz) {
        return null;
    }

    @Deprecated
    public static final ConnectionCreator findConnectionCreator(Database database) {
        return null;
    }

    public static final Connection createConnection(Database database) throws DBException {
        ConnectionCreator connectionCreator;
        String string;
        String string2 = database.getConnectionName();
        if (string2 != null && (string = database.getConnectionStore()) != null && (connectionCreator = DatabaseFactory.findConnectionCreator(string)) != null) {
            return DatabaseFactory.createConnection(string2, connectionCreator);
        }
        return database.getConnection();
    }

    private static final Connection createConnection(String string, ConnectionCreator connectionCreator) throws DBException {
        long l = System.currentTimeMillis();
        Connection connection = connectionCreator.createConnectionImpl(string);
        if (connection != null) {
            DatabaseFactory.getLogger().log(Level.FINEST, "Opening connection for {0} took {1}ms", new Object[]{string, Long.toString(System.currentTimeMillis() - l)});
            return connection;
        }
        return null;
    }

    @Deprecated
    public static void registerProviderClass(Class<? extends Database> clazz, String string) {
    }

    @Deprecated
    public static Collection<Class<? extends Database>> getClasses() {
        ArrayList<Class<? extends Database>> arrayList = new ArrayList<Class<? extends Database>>();
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getInstance();
        for (String string : databaseRegistry.listDatabaseTypes()) {
            for (int n : databaseRegistry.listDatabaseVersions(string)) {
                Class<? extends Database> clazz = databaseRegistry.getDatabaseDescriptor(string, n).getDatabaseClass();
                if (clazz == null) continue;
                arrayList.add(clazz);
            }
        }
        return arrayList;
    }

    @Deprecated
    public static String getDatabaseName(Class<? extends Database> clazz) {
        DatabaseDescriptor databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(clazz);
        return databaseDescriptor == null ? null : databaseDescriptor.getDatabaseName();
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DatabaseFactory.class);
    }

    private static class DatabaseCreatorInfo {
        private final Thunk<DatabaseCreator> m_thunk;
        private final ConnectionMatcher m_matcher;

        DatabaseCreatorInfo(Thunk<DatabaseCreator> thunk, ConnectionMatcher connectionMatcher) {
            this.m_thunk = thunk;
            this.m_matcher = connectionMatcher;
        }

        boolean matches(Connection connection) {
            return this.m_matcher == null || this.m_matcher.matches(connection);
        }

        DatabaseCreator getCreator() {
            return (DatabaseCreator)this.m_thunk.get();
        }
    }

    public static abstract class ConnectionCreatorFactory {
        public abstract ConnectionCreator getCreator(String var1);

        public abstract Collection<ConnectionCreator> listCreators();
    }

    public static abstract class ConnectionCreator {
        private Map<String, Database> m_dbs;

        protected abstract Connection createConnectionImpl(String var1) throws DBException;

        protected boolean isActive() {
            return true;
        }

        protected abstract String getStoreName();

        protected String getDisplayableStoreName() {
            return this.getStoreName();
        }

        public boolean shouldClearCaches(Connection connection, Connection connection2, Database database) {
            return true;
        }

        public Collection<String> listDatabases() {
            List<String> list = this.m_dbs == null ? Collections.emptyList() : new ArrayList<String>(this.m_dbs.keySet());
            return list;
        }

        public Database findDatabase(String string) {
            Database database = null;
            if (this.m_dbs != null) {
                database = this.m_dbs.get(string);
            }
            return database;
        }

        public synchronized Database uncacheDatabase(String string) {
            Database database = null;
            if (this.m_dbs != null) {
                Database database2 = this.m_dbs.remove(string);
                if (database2 != null) {
                    DBObjectProviderFactory.notifyOfRemoval(database2.getQualifiedName(), database2);
                }
                database = database2;
            }
            return database;
        }

        protected synchronized void cacheDatabase(String string, Database database) {
            if (string != null) {
                if (this.m_dbs == null) {
                    this.m_dbs = new HashMap<String, Database>();
                }
                this.m_dbs.put(string, database);
                DBObjectProviderFactory.notifyOfCreation(database.getQualifiedName(), database);
            }
        }

        public synchronized boolean renameDatabase(String string, String string2) {
            Database database = this.uncacheDatabase(string);
            if (database != null) {
                ((AbstractDatabase)database).setConnectionName(string2);
                this.cacheDatabase(string2, database);
                return true;
            }
            return false;
        }
    }

    public static abstract class DatabaseCreator {
        protected abstract Database createDatabaseImpl(String var1, String var2, Connection var3) throws DBException;

        protected abstract DatabaseDescriptor getDatabaseDescriptorImpl(Class var1);

        protected DatabaseDescriptor getDatabaseDescriptorImpl(Database database) {
            return this.getDatabaseDescriptorImpl(database.getClass());
        }

        protected DatabaseDescriptor getDatabaseDescriptorImpl(String string, int n) {
            return null;
        }
    }
}

