/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class DBUtil
implements Comparator<DBObject> {
    private static Comparator<DBObject> s_typeComparator;
    private static Comparator<DBObject> s_nameComparator;
    private boolean m_compareByType;

    protected DBUtil() {
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBUtil.class);
    }

    @Override
    public int compare(DBObject dBObject, DBObject dBObject2) {
        int n;
        if (dBObject == dBObject2) {
            n = 0;
        } else if (dBObject == null) {
            n = -10;
        } else if (dBObject2 == null) {
            n = 10;
        } else {
            if (this.m_compareByType) {
                n = this.compareType(dBObject, dBObject2);
                if (n == 0) {
                    n = this.compareName(dBObject, dBObject2);
                }
            } else {
                n = this.compareName(dBObject, dBObject2);
                if (n == 0) {
                    n = this.compareType(dBObject, dBObject2);
                }
            }
            if (n == 0) {
                n = this.compareSchema(dBObject, dBObject2);
            }
        }
        return n;
    }

    private int compareName(DBObject dBObject, DBObject dBObject2) {
        String string;
        String string2 = dBObject.getName();
        int n = string2 == (string = dBObject2.getName()) ? 0 : (string2 == null ? -10 : (string == null ? 10 : string2.compareTo(string)));
        return n;
    }

    private int compareSchema(DBObject dBObject, DBObject dBObject2) {
        int n = 0;
        if (dBObject instanceof SchemaObject && dBObject2 instanceof SchemaObject) {
            Schema schema = ((SchemaObject)dBObject).getSchema();
            Schema schema2 = ((SchemaObject)dBObject2).getSchema();
            n = this.compare(schema, schema2);
        }
        return n;
    }

    private int compareType(DBObject dBObject, DBObject dBObject2) {
        String string;
        String string2 = dBObject.getType();
        int n = string2.compareTo(string = dBObject2.getType());
        if (n == 0 && dBObject instanceof Constraint) {
            String string3 = ((Constraint)dBObject).getConstraintType();
            String string4 = ((Constraint)dBObject2).getConstraintType();
            n = string3.compareTo(string4);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DBUtil && ((DBUtil)object).m_compareByType == this.m_compareByType;
    }

    public int hashCode() {
        return this.m_compareByType ? 0 : 1;
    }

    public static Comparator<DBObject> getTypeComparator() {
        if (s_typeComparator == null) {
            s_typeComparator = new DBUtil();
            ((DBUtil)DBUtil.s_typeComparator).m_compareByType = true;
        }
        return s_typeComparator;
    }

    public static Comparator<DBObject> getNameComparator() {
        if (s_nameComparator == null) {
            s_nameComparator = new DBUtil();
            ((DBUtil)DBUtil.s_nameComparator).m_compareByType = false;
        }
        return s_nameComparator;
    }

    public static Map<DBObjectID, DBObjectID> getTemporaryIDMap(DBObject ... dBObjectArray) {
        HashMap<DBObjectID, DBObjectID> hashMap = new HashMap<DBObjectID, DBObjectID>();
        if (dBObjectArray != null) {
            for (DBObject dBObject : dBObjectArray) {
                DBUtil.poplateTempIDMap(dBObject, hashMap);
            }
        }
        return hashMap;
    }

    private static void poplateTempIDMap(DBObject dBObject, Map<DBObjectID, DBObjectID> map) {
        DBObjectID object3;
        Object object2;
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID instanceof TemporaryObjectID && (object2 = ((TemporaryObjectID)dBObjectID).getOriginalObject()) != null && (object3 = object2.getID()) != null) {
            map.put(object3, dBObjectID);
        }
        for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
            DBUtil.poplateTempIDMap(dBObject2, map);
        }
    }

    public static void resetTemporaryCopy(DBObject dBObject, DBObject dBObject2, DBObject dBObject3, DBObjectProvider dBObjectProvider) {
        Object object;
        DBObject dBObject4 = TemporaryObjectID.getOriginalObject(dBObject);
        if (dBObject2 == null && dBObject3 != null && (object = DBUtil.getParentProperty(dBObject)) != null) {
            Object object2 = dBObject3.getProperty((String)object);
            if (object2 instanceof DBObject) {
                dBObject2 = (DBObject)object2;
            } else if (object2 instanceof DBObject[]) {
                DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
                dBObject2 = DBUtil.findChildByNameImpl((DBObject[])object2, dBObject.getName(), databaseDescriptor);
                if (dBObject2 == null && dBObject4 != null) {
                    dBObject2 = DBUtil.findChildByNameImpl((DBObject[])object2, dBObject4.getName(), databaseDescriptor);
                }
            }
        }
        if (dBObject4 == null && dBObject3 != null && dBObject2 != null) {
            dBObject2.copyTo(dBObject, true);
        } else if (dBObject4 != null && dBObject4 != dBObject2) {
            dBObject.setID(TemporaryObjectID.createID(dBObject, dBObject2));
        }
        for (DBObject dBObject5 : DBUtil.getExistingOwnedObjects(dBObject)) {
            DBUtil.resetTemporaryCopy(dBObject5, null, dBObject2, dBObjectProvider);
        }
    }

    public static <D extends DBObject> D makeTemporaryCopy(D d) {
        DBObject dBObject = null;
        if (d != null) {
            dBObject = d.copyTo(null, true);
        }
        return (D)dBObject;
    }

    public static <D extends DBObject> D makeClonedCopy(D d) {
        DBObject dBObject = null;
        if (d != null) {
            dBObject = d.copyTo(null, new IDPolicy.SameIDPolicy());
        }
        return (D)dBObject;
    }

    public static <T> T copyPropertyValue(T t, DBObject dBObject, DBObject dBObject2, IDPolicy iDPolicy) {
        Object object = null;
        if (t instanceof AbstractDBObject) {
            object = ((AbstractDBObject)t).copyTo(null, dBObject2, iDPolicy);
        } else if (t instanceof Copyable) {
            object = ((Copyable)t).copyTo(null);
        } else if (t instanceof Object[]) {
            Object[] objectArray = (Object[])Array.newInstance(t.getClass().getComponentType(), ((Object[])t).length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = DBUtil.copyPropertyValue(((Object[])t)[i], dBObject, dBObject2, iDPolicy);
            }
            object = objectArray;
        } else if (t instanceof Map) {
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : ((Map)t).entrySet()) {
                hashMap.put(entry.getKey(), DBUtil.copyPropertyValue(entry.getValue(), dBObject, dBObject2, iDPolicy));
            }
            object = hashMap;
        } else {
            object = t;
        }
        return (T)object;
    }

    public static Map<String, Object> getFrozenProperties(DBObject dBObject) {
        AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport = dBObject instanceof AbstractBuildableObject ? ((AbstractBuildableObject)dBObject).getPropertySupport() : dBObject.getProperties();
        return Collections.unmodifiableMap(buildablePropertySupport);
    }

    public static Collection<DBObject> getExistingOwnedObjects(DBObject dBObject) {
        return ((AbstractDBObject)dBObject).getPropertySupport().getOwnedObjects(new String[0]);
    }

    public static Collection<DBObjectID> getExistingReferenceIDs(DBObject dBObject) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        ((AbstractDBObject)dBObject).getPropertySupport().addAllReferenceIDs(arrayList);
        return arrayList;
    }

    public static boolean needsBuilding(DBObject dBObject) {
        if (dBObject instanceof AbstractBuildableObject) {
            return ((AbstractBuildableObject)dBObject).needsInitialization();
        }
        return false;
    }

    public static boolean needsBuilding(DBObject dBObject, String string) {
        if (dBObject instanceof AbstractBuildableObject) {
            return !((AbstractBuildableObject)dBObject).isBuilt(string);
        }
        return false;
    }

    public static DBObjectBuilder getDBObjectBuilder(DBObject dBObject, String string) {
        DBObjectBuilder dBObjectBuilder = null;
        if (dBObject instanceof AbstractBuildableObject) {
            dBObjectBuilder = ((AbstractBuildableObject)dBObject).getPropertySupport().getBuilder(string);
        }
        return dBObjectBuilder;
    }

    public static void ensureObjectBuilt(DBObject dBObject, String ... stringArray) throws DBException {
        if (dBObject instanceof AbstractBuildableObject) {
            AbstractBuildableObject abstractBuildableObject = (AbstractBuildableObject)dBObject;
            if (stringArray == null || stringArray.length == 0) {
                if (abstractBuildableObject.needsInitialization()) {
                    abstractBuildableObject.getPropertySupport().checkBuiltEx(null);
                }
            } else {
                for (String string : stringArray) {
                    abstractBuildableObject.getPropertySupport().checkBuiltEx(string);
                }
            }
        }
    }

    public static boolean needsDerivedPropertiesBuilding(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        DerivedPropertyBuilder derivedPropertyBuilder;
        if (dBObject instanceof SQLQueryOwner || dBObject instanceof SQLQuery) {
            SQLQuery sQLQuery = null;
            sQLQuery = dBObject instanceof SQLQueryOwner ? ((SQLQueryOwner)dBObject).getSQLQuery() : (SQLQuery)dBObject;
            if (sQLQuery != null) {
                return !sQLQuery.isDeclarative();
            }
        } else if (dBObjectProvider != null && (derivedPropertyBuilder = dBObjectProvider.getObjectFactory().ensureDerivedPropertyBuilder(dBObject)) != null) {
            PropertyManager propertyManager = dBObjectProvider.getPropertyManager();
            Class<?> clazz = dBObject.getClass();
            for (String string : derivedPropertyBuilder.listBuildableProperties()) {
                PropertyInfo propertyInfo = propertyManager.findPropertyInfo(clazz, string);
                if (propertyInfo == null || !propertyInfo.isDerived() || !DBUtil.needsBuilding(dBObject, propertyInfo.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void ensureDerivedPropertiesBuilt(DBObject dBObject, DBObjectProvider dBObjectProvider) throws DBException {
        DBUtil.ensureDerivedPropertiesBuilt(dBObject, dBObjectProvider, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureDerivedPropertiesBuilt(DBObject dBObject, DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) throws DBException {
        if (dBObject instanceof SystemObject) {
            DBUtil.ensureObjectBuilt((SystemObject)dBObject, new String[0]);
        }
        if (dBObject != null) {
            DerivedPropertyBuilder derivedPropertyBuilder = dBObjectProvider.getObjectFactory().ensureDerivedPropertyBuilder(dBObject);
            for (AbstractBuildableObject abstractBuildableObject : DBUtil.findChildren(dBObject, AbstractBuildableObject.class)) {
                boolean bl = false;
                try {
                    if (derivedPropertyBuilder instanceof AbstractSQLQueryBuilder && collection != null && !collection.isEmpty()) {
                        bl = true;
                        ((AbstractSQLQueryBuilder)derivedPropertyBuilder).setExtraObjects(collection);
                    }
                    abstractBuildableObject.getPropertySupport().ensureDerivedPropertiesBuilt();
                }
                finally {
                    if (bl) {
                        ((AbstractSQLQueryBuilder)derivedPropertyBuilder).setExtraObjects(null);
                    }
                }
            }
        }
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject dBObject, boolean bl, IDQuery iDQuery, String ... stringArray) {
        IDQueryCriteria iDQueryCriteria = new IDQueryCriteria(iDQuery);
        iDQueryCriteria.setTypes(stringArray);
        iDQueryCriteria.setRecurse(bl);
        return DBUtil.getReferenceIDs(dBObject, iDQueryCriteria);
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject dBObject, IDQueryCriteria iDQueryCriteria) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        DBUtil.getReferenceIDsImpl(dBObject, arrayList, null, iDQueryCriteria);
        return arrayList;
    }

    public static Collection<Tuple<DBObjectID, DBObject>> getReferenceIDsAndReferers(DBObject dBObject, boolean bl, IDQuery iDQuery, String ... stringArray) {
        ArrayList<Tuple<DBObjectID, DBObject>> arrayList = new ArrayList<Tuple<DBObjectID, DBObject>>();
        ArrayList<DBObjectID> arrayList2 = new ArrayList<DBObjectID>();
        ArrayList<DBObject> arrayList3 = new ArrayList<DBObject>();
        IDQueryCriteria iDQueryCriteria = new IDQueryCriteria(iDQuery);
        iDQueryCriteria.setTypes(stringArray);
        iDQueryCriteria.setRecurse(bl);
        DBUtil.getReferenceIDsImpl(dBObject, arrayList2, arrayList3, iDQueryCriteria);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add((Tuple<DBObjectID, DBObject>)new Tuple((Object)((DBObjectID)arrayList2.get(i)), (Object)((DBObject)arrayList3.get(i))));
        }
        return arrayList;
    }

    private static void getReferenceIDsImpl(DBObject dBObject, List<DBObjectID> list, List<DBObject> list2, IDQueryCriteria iDQueryCriteria) {
        Object object;
        Collection<DBObjectID> collection = iDQueryCriteria.m_existingOnly ? DBUtil.getExistingReferenceIDs(dBObject) : Arrays.asList(dBObject.getReferenceIDs());
        for (DBObjectID object2 : collection) {
            object = iDQueryCriteria.m_types;
            if (object != null && ((String[])object).length > 0 && Arrays.binarySearch(object, object2.getType()) < 0 || (iDQueryCriteria.m_idQuery != IDQuery.INTERNAL ? iDQueryCriteria.m_idQuery == IDQuery.EXTERNAL && DBUtil.isInternalRef(object2, dBObject) : !DBUtil.isInternalRef(object2, dBObject))) continue;
            list.add(iDQueryCriteria.m_topLevelOnly ? DBUtil.getUppermostParent(object2) : object2);
            if (list2 == null) continue;
            list2.add(dBObject);
        }
        if (iDQueryCriteria.m_recurse) {
            Collection<DBObject> collection2 = iDQueryCriteria.m_existingOnly ? DBUtil.getExistingOwnedObjects(dBObject) : Arrays.asList(dBObject.getOwnedObjects());
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                object = (DBObject)iterator.next();
                DBUtil.getReferenceIDsImpl((DBObject)object, list, list2, iDQueryCriteria);
            }
        }
    }

    public static boolean isInternalRef(DBObjectID dBObjectID, DBObject dBObject) {
        DBObject dBObject2 = DBUtil.getUppermostParent(dBObject);
        DBObjectID dBObjectID2 = DBUtil.getUppermostParent(dBObjectID);
        return dBObjectID2 != null && ModelUtil.areEqual((Object)dBObjectID2, (Object)dBObject2.getID());
    }

    public static boolean replaceReferenceIDs(DBObject dBObject, Map<? extends DBObjectID, ? extends DBObjectID> map) {
        return DBUtil.replaceIDsImpl(dBObject, map, false);
    }

    public static boolean replaceAllIDs(DBObject dBObject, Map<? extends DBObjectID, ? extends DBObjectID> map) {
        return DBUtil.replaceIDsImpl(dBObject, map, true);
    }

    private static boolean replaceIDsImpl(DBObject dBObject, Map<? extends DBObjectID, ? extends DBObjectID> map, boolean bl) {
        boolean bl2 = false;
        if (map != null && !map.isEmpty()) {
            Object object;
            DBObjectID object22;
            if (bl && (object22 = map.get(object = ((AbstractDBObject)dBObject).obtainActualID())) != null) {
                dBObject.setID(object22);
                bl2 = true;
            }
            bl2 = dBObject.replaceReferenceIDs(map) || bl2;
            for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
                bl2 = DBUtil.replaceIDsImpl(dBObject2, map, bl) || bl2;
            }
        }
        return bl2;
    }

    public static void updateObjectAndIDs(DBObject dBObject, DBObject dBObject2) {
        dBObject2.copyTo(dBObject, new IDPolicy.SameIDPolicy());
    }

    public static DBObject findOwnedObjectInHierarchy(DBObject dBObject, DBObjectID dBObjectID) {
        Object object = null;
        if (dBObject != null && dBObject.getID() != null) {
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            for (object2 = dBObjectID; object2 != null; object2 = object2.getParent()) {
                if (object2.equals(dBObject.getID(), true)) {
                    bl = true;
                    break;
                }
                arrayList.add(0, object2);
            }
            if (bl) {
                DBObjectID dBObjectID2;
                object2 = dBObject;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext() && (object2 = object2.findOwnedObject(dBObjectID2 = (DBObjectID)iterator.next())) != null) {
                }
                object = object2;
            }
        }
        return object;
    }

    public static <T extends DBObject> Collection<T> findChildren(DBObject dBObject, Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        if (clazz != null) {
            DBUtil.findChildrenImpl(arrayList, dBObject, clazz);
        }
        return arrayList;
    }

    private static <T extends DBObject> void findChildrenImpl(Collection<T> collection, DBObject dBObject, Class<T> clazz) {
        if (clazz.isAssignableFrom(dBObject.getClass())) {
            collection.add((DBObject)clazz.cast(dBObject));
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            DBUtil.findChildrenImpl(collection, dBObject2, clazz);
        }
    }

    public static <T extends DBObject> T findChildInCopy(DBObject dBObject, DBObject dBObject2, T t) {
        Object object = null;
        if (dBObject == null || dBObject2 == null || t == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (dBObject == t) {
            object = dBObject2;
        } else {
            Object object2;
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
            for (Object object3 = t; object3 != null; object3 = object3.getParent()) {
                object2 = DBUtil.getParentProperty(object3);
                arrayList.add(new Tuple(object2, object3));
                if (object3 == dBObject) break;
                if (object3 != null) continue;
                throw new IllegalArgumentException("origChild isn't in the hierarchy of orig");
            }
            object2 = dBObject2;
            DBObject dBObject3 = null;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Tuple tuple = (Tuple)arrayList.get(i);
                dBObject3 = (DBObject)tuple.getSecond();
                Object object4 = object2.getProperty((String)tuple.getFirst());
                DBObject dBObject4 = null;
                if (object4 instanceof DBObject && DBUtil.isTempCopy((DBObject)object4, dBObject3)) {
                    dBObject4 = (DBObject)object4;
                } else if (object4 instanceof Object[]) {
                    for (Object object5 : (Object[])object4) {
                        if (!(object5 instanceof DBObject) || !DBUtil.isTempCopy((DBObject)object5, dBObject3)) continue;
                        dBObject4 = (DBObject)object5;
                    }
                }
                if (dBObject4 == null) {
                    dBObject3 = null;
                    break;
                }
                object2 = dBObject4;
            }
            if (dBObject3 == t) {
                object = object2;
            }
        }
        return (T)object;
    }

    private static boolean isTempCopy(DBObject dBObject, DBObject dBObject2) {
        return dBObject2 == TemporaryObjectID.getOriginalObject(dBObject);
    }

    public static String getParentProperty(DBObject dBObject) {
        String string = null;
        DBObject dBObject2 = dBObject.getParent();
        if (dBObject2 != null) {
            Map<String, Object> map = DBUtil.getFrozenProperties(dBObject2);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                boolean bl = false;
                Object object = entry.getValue();
                if (object == dBObject) {
                    bl = true;
                } else if (object instanceof Object[]) {
                    for (Object object2 : (Object[])object) {
                        if (object2 != dBObject) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                string = entry.getKey();
                break;
            }
        }
        return string;
    }

    public static String getPropertyPath(DBObject dBObject, DBObject dBObject2) {
        String string = null;
        boolean bl = false;
        for (DBObject dBObject3 = dBObject2; dBObject3 != null; dBObject3 = dBObject3.getParent()) {
            if (dBObject3 == dBObject) {
                bl = true;
                break;
            }
            String string2 = DBUtil.getParentProperty(dBObject3);
            string = Property.createPath(string2, string);
        }
        return bl ? string : null;
    }

    public static String getUniqueName(Collection<String> collection, String string) {
        return DBUtil.getUniqueName(collection, string, true);
    }

    public static String getUniqueName(Collection<String> collection, String object, boolean bl) {
        Object object2 = null;
        if (collection == null || !collection.contains(object)) {
            object2 = object;
        } else {
            Object object3;
            int n = 1;
            int n2 = ((String)object).length() - 1;
            if (bl) {
                Tuple<String, Integer> tuple = DBUtil.splitBaseName((String)object);
                object = (String)tuple.getFirst();
                object3 = (Integer)tuple.getSecond();
                if (object3 != null) {
                    n = (Integer)object3;
                }
            } else if (Character.isDigit(((String)object).charAt(n2))) {
                object = (String)object + "_";
            }
            int n3 = n;
            while (object2 == null) {
                object3 = (String)object + n3;
                if (!collection.contains(object3)) {
                    object2 = object3;
                }
                ++n3;
            }
        }
        return object2;
    }

    public static Tuple<String, Integer> splitBaseName(String string) {
        Integer n = null;
        String string2 = string;
        if (ModelUtil.hasLength((String)string)) {
            int n2;
            for (n2 = string2.length() - 1; Character.isDigit(string2.charAt(n2)) && n2 > 0; --n2) {
            }
            try {
                n = Integer.parseInt(n2 == 0 ? string2 : string2.substring(n2 + 1));
                string2 = n2 == 0 ? "" : string2.substring(0, n2 + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Tuple((Object)string2, n);
    }

    public static String getUniqueName(Collection<String> collection, String string, boolean bl, int n) {
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n - 1);
            bl = false;
        }
        String string2 = null;
        while (string2 == null) {
            string2 = DBUtil.getUniqueName(collection, string, bl);
            if (n <= 0 || string2.length() <= n) continue;
            string2 = null;
            bl = false;
            if ((string = string.substring(0, string.length() - 1)).length() != 0) continue;
            break;
        }
        return string2;
    }

    public static String getFullyQualifiedName(DBObjectID dBObjectID) {
        return DBUtil.getFullyQualifiedName(dBObjectID, false);
    }

    public static String getFullyQualifiedName(DBObjectID dBObjectID, boolean bl) {
        Object object;
        Object object2 = null;
        if (dBObjectID instanceof BaseObjectID && ModelUtil.hasLength((String)(object = ((BaseObjectID)dBObjectID).getName()))) {
            object2 = object;
            DBObjectID dBObjectID2 = dBObjectID.getParent();
            if (dBObjectID2 == null) {
                String string;
                if (bl && ModelUtil.hasLength((String)(string = ((BaseObjectID)dBObjectID).getSchemaName()))) {
                    object2 = string + "." + (String)object2;
                }
                if (ModelUtil.hasLength((String)(string = ((BaseObjectID)dBObjectID).getDatabaseName()))) {
                    object2 = (String)object2 + "@" + string;
                }
            } else {
                object2 = DBUtil.getFullyQualifiedName(dBObjectID2, bl) + "." + (String)object2;
            }
        }
        if (object2 == null) {
            try {
                object = dBObjectID.resolveID();
                if (object != null) {
                    object2 = DBUtil.getFullyQualifiedName((DBObject)object, bl);
                }
            }
            catch (DBException dBException) {
                object2 = null;
            }
        }
        return object2;
    }

    public static String getFullyQualifiedName(DBObject dBObject) {
        return DBUtil.getFullyQualifiedName(dBObject, false);
    }

    public static String getFullyQualifiedName(DBObject dBObject, boolean bl) {
        Object object;
        DBObject dBObject2 = dBObject.getParent();
        Object object2 = null;
        object2 = dBObject2 == null ? (dBObject instanceof SchemaObject && bl ? ((object = ((SchemaObject)dBObject).getSchema()) == null ? "" : ((AbstractDBObject)object).getName() + ".") : "") : DBUtil.getFullyQualifiedName(dBObject2, bl) + ".";
        object = dBObject.getName();
        if (object != null) {
            object2 = (String)object2 + (String)object;
        }
        return object2;
    }

    public static Schema getSchema(DBObject dBObject) {
        Schema schema = null;
        if (dBObject instanceof SchemaObject) {
            schema = ((SchemaObject)dBObject).getSchema();
        } else if (dBObject != null) {
            DBObject dBObject2 = dBObject.getParent();
            if (dBObject2 instanceof Schema) {
                schema = (Schema)dBObject2;
            } else if (dBObject2 != null) {
                schema = DBUtil.getSchema(dBObject2);
            }
        }
        return schema;
    }

    public static String getSchemaName(DBObject dBObject) {
        Schema schema = DBUtil.getSchema(dBObject);
        return schema == null ? null : schema.getName();
    }

    public static <T extends DBObject> T findParentOfType(DBObject dBObject, Class<T> clazz) {
        DBObject dBObject2 = null;
        if (dBObject != null) {
            dBObject2 = clazz.isAssignableFrom(dBObject.getClass()) ? dBObject : DBUtil.findParentOfType(dBObject.getParent(), clazz);
        }
        return (T)dBObject2;
    }

    public static SchemaObject getSchemaObject(DBObject dBObject) {
        return DBUtil.getTopParent(dBObject, SchemaObject.class);
    }

    public static SystemObject getSystemObject(DBObject dBObject) {
        return DBUtil.getTopParent(dBObject, SystemObject.class);
    }

    private static <T extends DBObject> T getTopParent(DBObject dBObject, Class<T> clazz) {
        if (dBObject == null) {
            return null;
        }
        DBObject dBObject2 = dBObject.getParent();
        if (dBObject2 != null) {
            return DBUtil.getTopParent(dBObject2, clazz);
        }
        if (clazz.isAssignableFrom(dBObject.getClass())) {
            return (T)((DBObject)clazz.cast(dBObject));
        }
        return null;
    }

    public static DBObject getUppermostParent(DBObject dBObject) {
        DBObject dBObject2 = dBObject.getParent();
        if (dBObject2 != null) {
            return DBUtil.getUppermostParent(dBObject2);
        }
        return dBObject;
    }

    public static DBObjectID getUppermostParent(DBObjectID dBObjectID) {
        DBObject dBObject;
        DBObjectID dBObjectID2;
        Object object;
        if (dBObjectID instanceof TemporaryObjectID && (object = ((TemporaryObjectID)dBObjectID).getDBObject()) != null && (dBObjectID2 = (dBObject = DBUtil.getUppermostParent(object)).getID()) != null) {
            return dBObjectID2;
        }
        if (dBObjectID != null && (object = dBObjectID.getParent()) != null) {
            return DBUtil.getUppermostParent((DBObjectID)object);
        }
        return dBObjectID;
    }

    public static boolean isSameOrChildOf(DBObjectID dBObjectID, DBObjectID dBObjectID2, boolean bl) {
        DBObjectID dBObjectID3;
        boolean bl2 = dBObjectID.equals(dBObjectID2, bl);
        if (!bl2 && (dBObjectID3 = dBObjectID.getParent()) != null) {
            bl2 = DBUtil.isSameOrChildOf(dBObjectID3, dBObjectID2, bl);
        }
        return bl2;
    }

    public static Map<Schema, Collection<SystemObject>> sortIntoSchemas(SystemObject ... systemObjectArray) {
        if (systemObjectArray != null && systemObjectArray.length > 0) {
            return DBUtil.sortIntoSchemas(Arrays.asList(systemObjectArray));
        }
        return Collections.emptyMap();
    }

    public static Map<Schema, Collection<SystemObject>> sortIntoSchemas(Collection<? extends SystemObject> collection) {
        TreeMap<DBObject, ArrayList<SystemObject>> treeMap = new TreeMap<DBObject, ArrayList<SystemObject>>(DBUtil.getNameComparator());
        for (SystemObject systemObject : collection) {
            Schema schema = DBUtil.getSchema(systemObject);
            ArrayList<SystemObject> arrayList = (ArrayList<SystemObject>)treeMap.get(schema);
            if (arrayList == null) {
                arrayList = new ArrayList<SystemObject>();
                treeMap.put(schema, arrayList);
            }
            arrayList.add(systemObject);
        }
        return treeMap;
    }

    public static <T extends DBObject> T getProviderDefinition(T t, DBObjectProvider dBObjectProvider) throws DBException {
        return DBUtil.getProviderDefinition(t, dBObjectProvider, null);
    }

    public static <T extends DBObject> T getProviderDefinition(T t, DBObjectProvider dBObjectProvider, String string) throws DBException {
        DBObject dBObject;
        DBObject dBObject2;
        DBObject dBObject3 = null;
        if (t instanceof SystemObject && dBObjectProvider.supportsObjectType(t.getType())) {
            DBObjectCriteria<SystemObject> dBObjectCriteria = new DBObjectCriteria<SystemObject>((SystemObject)t);
            if (t instanceof SchemaObject && ModelUtil.hasLength((String)string)) {
                dBObjectCriteria.setSchemaName(string);
            }
            dBObject3 = dBObjectProvider.getObject(dBObjectCriteria);
        } else if (t != null && (dBObject2 = t.getParent()) != null && (dBObject = DBUtil.getProviderDefinition(dBObject2, dBObjectProvider, string)) != null) {
            dBObject3 = dBObject.findOwnedObject(t.getType(), t.getName());
        }
        return (T)dBObject3;
    }

    public static <T extends SystemObject> T[] getProviderDefinitions(T[] TArray, DBObjectProvider dBObjectProvider) throws DBException {
        SystemObject[] systemObjectArray = (SystemObject[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            systemObjectArray[i] = (SystemObject)DBUtil.getProviderDefinition(TArray[i], dBObjectProvider);
        }
        return systemObjectArray;
    }

    @Deprecated
    public static DBObject getProviderDefinition(ReferenceID referenceID, DBObjectProvider dBObjectProvider) throws DBException {
        return DBUtil.resolveInOtherProvider(referenceID, dBObjectProvider);
    }

    public static <T> T[] stripNulls(T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            arrayList.add(TArray[i]);
        }
        return arrayList.toArray((Object[])Array.newInstance(TArray.getClass().getComponentType(), arrayList.size()));
    }

    public static boolean isCompoundName(String string, String string2) {
        boolean bl = false;
        if (ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
            int n = string.indexOf(string2);
            if (n == 0) {
                String string3 = string.substring(1);
                n = string3.indexOf(string2);
                while (n > -1 && n < string3.length() - 1) {
                    if (string3.startsWith(string2, n + 1)) {
                        string3 = string3.substring(n + 2);
                        n = string3.indexOf(string2);
                        continue;
                    }
                    string3 = string3.substring(n + 1);
                    break;
                }
                bl = string3.startsWith(".");
            } else {
                n = string.indexOf(".");
                bl = n > -1;
            }
        }
        return bl;
    }

    public static boolean isDangling(DBObjectID dBObjectID) {
        boolean bl = false;
        if (dBObjectID instanceof ReferenceID) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                bl = null == dBObject;
            }
            catch (DBException dBException) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isDatabaseLink(DBObjectID dBObjectID) {
        return dBObjectID instanceof BaseObjectID && ModelUtil.hasLength((String)((BaseObjectID)dBObjectID).getDatabaseName());
    }

    public static DBObjectID getOriginalID(DBObject dBObject) {
        DBObjectID dBObjectID = null;
        DBObjectID dBObjectID2 = dBObject.getID();
        if (dBObjectID2 instanceof TemporaryObjectID) {
            dBObjectID = TemporaryObjectID.findOriginalID((TemporaryObjectID)dBObjectID2);
        }
        return dBObjectID;
    }

    public static Collection<DBObject> findUsagesIn(DBObject dBObject, DBObject dBObject2) {
        DBObjectID dBObjectID;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (dBObject != null && (dBObjectID = dBObject.getID()) != null) {
            DBUtil.findUsagesImpl(dBObjectID, dBObject2, arrayList);
        }
        return arrayList;
    }

    private static void findUsagesImpl(DBObjectID dBObjectID, DBObject dBObject, Collection<DBObject> collection) {
        DBObjectIDComparator dBObjectIDComparator = new DBObjectIDComparator(true);
        if (dBObject != null) {
            for (DBObjectID object : dBObject.getReferenceIDs()) {
                if (dBObjectIDComparator.compare(object, dBObjectID) != 0) continue;
                collection.add(dBObject);
            }
            for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
                DBUtil.findUsagesImpl(dBObjectID, dBObject2, collection);
            }
        }
    }

    public static FKConstraint[] getReferences(Constraint constraint, DBObjectProvider dBObjectProvider) throws CancelledException {
        ArrayList<FKConstraint> arrayList = new ArrayList<FKConstraint>();
        if (constraint instanceof UniqueConstraint) {
            CascadeManager cascadeManager = dBObjectProvider.getCascadeManager();
            for (DBObjectID dBObjectID : cascadeManager.listReferers(constraint)) {
                try {
                    DBObject dBObject = dBObjectID.resolveID();
                    if (!(dBObject instanceof FKConstraint)) continue;
                    arrayList.add((FKConstraint)dBObject);
                }
                catch (CancelledException cancelledException) {
                    throw cancelledException;
                }
                catch (DBException dBException) {
                    DBUtil.getLogger().log(Level.WARNING, "Couldn't resolve reference to constraint: " + dBException.getMessage());
                }
            }
        }
        return arrayList.toArray(new FKConstraint[arrayList.size()]);
    }

    public static String getDBObjectName(DBObjectID dBObjectID) {
        String string = "";
        if (dBObjectID != null) {
            if (dBObjectID instanceof BaseObjectID) {
                string = ((BaseObjectID)dBObjectID).getName();
            } else if (dBObjectID instanceof DataTypeID) {
                string = ((DataTypeID)dBObjectID).getTypeName();
            }
            if (!ModelUtil.hasLength((String)string)) {
                try {
                    DBObject dBObject = dBObjectID.resolveID();
                    if (dBObject != null) {
                        string = dBObject.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static String getSchemaName(DBObjectID dBObjectID) {
        String string = "";
        if (dBObjectID != null) {
            if (dBObjectID instanceof BaseObjectID && Metadata.getInstance().isSchemaObject(dBObjectID.getType())) {
                string = ((BaseObjectID)dBObjectID).getSchemaName();
            }
            if (!ModelUtil.hasLength((String)string)) {
                try {
                    Schema schema;
                    DBObject dBObject = dBObjectID.resolveID();
                    if (dBObject instanceof SchemaObject && (schema = ((SchemaObject)dBObject).getSchema()) != null) {
                        string = schema.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static DBObject resolveInOtherProvider(BaseObjectID baseObjectID, DBObjectProvider dBObjectProvider) throws DBException {
        BaseObjectID baseObjectID2;
        DBObject dBObject;
        DBObjectProvider dBObjectProvider2 = baseObjectID.getProvider();
        if (dBObjectProvider2 == dBObjectProvider) {
            return baseObjectID.resolveID();
        }
        if (dBObjectProvider instanceof AbstractDBObjectProvider && (dBObject = (baseObjectID2 = BaseObjectID.copyWithNewProvider(baseObjectID, (AbstractDBObjectProvider)dBObjectProvider)).resolveID()) != null) {
            return dBObject;
        }
        if (baseObjectID instanceof NameBasedID) {
            return dBObjectProvider.getObject(DBObjectCriteria.createSingleObjectCriteria(baseObjectID.getType(), baseObjectID.getSchemaName(), baseObjectID.getName()));
        }
        return null;
    }

    public static boolean areNamesAndTypesEqual(DBObject dBObject, DBObject dBObject2) {
        return DBUtil.getNameComparator().compare(dBObject, dBObject2) == 0;
    }

    public static boolean areEqualIgnoreNullValues(Map map, Map map2) {
        boolean bl = true;
        if (map != map2) {
            HashSet hashSet = new HashSet();
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
            if (map2 != null) {
                hashSet.addAll(map2.keySet());
            }
            for (Object e : hashSet) {
                Object object;
                Object object2 = DBUtil.getValue(map, e);
                if (DBUtil.areEqual(object2, object = DBUtil.getValue(map2, e))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean areEqual(Object object, Object object2) {
        boolean bl = object instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object, (Object[])object2) : ModelUtil.areEqual((Object)object, (Object)object2);
        return bl;
    }

    private static Object getValue(Map map, Object object) {
        Object var2_2 = null;
        if (map != null && (var2_2 = map.get(object)) instanceof Collection && ((Collection)var2_2).isEmpty()) {
            var2_2 = null;
        }
        return var2_2;
    }

    public static void suspendTimestampChecking(DBObjectProvider dBObjectProvider, String string) {
        if (dBObjectProvider instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)dBObjectProvider).suspendTimestampQueries(string);
        }
    }

    public static void resumeTimestampChecking(DBObjectProvider dBObjectProvider, String string) {
        if (dBObjectProvider instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)dBObjectProvider).resumeTimestampQueries(string);
        }
    }

    public static void clearCachedTimestamp(DBObjectProvider dBObjectProvider, SystemObject systemObject) {
        DBObjectID dBObjectID;
        if (dBObjectProvider instanceof AbstractDBObjectProvider && (dBObjectID = systemObject.getID()) != null) {
            ((AbstractDBObjectProvider)dBObjectProvider).putCachedTimestampKey(dBObjectID, null);
        }
    }

    public static Iterator<String> getTimestampKeyGenerator(final String string) {
        final AtomicInteger atomicInteger = new AtomicInteger();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public String next() {
                return string + atomicInteger.getAndUpdate(n -> n == Integer.MAX_VALUE ? 0 : n + 1);
            }
        };
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static SQLFragment getColumnExpressionFragment(String string, Relation relation, DBObjectProvider dBObjectProvider, boolean bl) {
        SQLFragment sQLFragment = null;
        if (ModelUtil.hasLength((String)string)) {
            try {
                sQLFragment = SQLFragmentExpressionBuilder.getExpressionOrFail(dBObjectProvider, relation, SQLFragmentExpressionBuilder.ExpressionType.ITEM, string.trim());
                if (sQLFragment != null && bl) {
                    DBUtil.markColumnUsages(sQLFragment);
                }
            }
            catch (SQLQueryException sQLQueryException) {
                sQLFragment = new SimpleSQLFragment(string);
            }
        }
        return sQLFragment;
    }

    private static void markColumnUsages(SQLFragment sQLFragment) {
        if (sQLFragment instanceof ColumnUsage) {
            ((ColumnUsage)sQLFragment).setAlwaysQuote(true);
        }
        for (DBObject dBObject : sQLFragment.getOwnedObjects()) {
            if (!(dBObject instanceof SQLFragment)) continue;
            DBUtil.markColumnUsages((SQLFragment)dBObject);
        }
    }

    public static String[] filterSchemaObjectTypes(String[] stringArray) {
        return DBUtil.filterObjectTypes(stringArray, SchemaObject.class);
    }

    public static String[] filterObjectTypes(String[] stringArray, Class<? extends DBObject> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null || !Metadata.getInstance().isTypeOf(clazz, string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void forceObjectReset(String string, String string2, String string3, DBObjectProvider dBObjectProvider) {
        SystemObject systemObject;
        if (dBObjectProvider instanceof AbstractDatabase && ModelUtil.hasLength((String)string) && dBObjectProvider.supportsObjectType(string) && ModelUtil.hasLength((String)string3) && (systemObject = ((AbstractDBObjectProvider)dBObjectProvider).findObject(string, string2 == null ? null : new Schema(string2), string3)) != null) {
            ((AbstractDBObjectProvider)dBObjectProvider).resetObject(systemObject, null, null);
        }
    }

    public static void forceObjectReset(SystemObject systemObject, DBObjectProvider dBObjectProvider) throws DBException {
        if ((systemObject = DBUtil.getProviderDefinition(systemObject, dBObjectProvider)) != null && dBObjectProvider instanceof AbstractDatabase) {
            ((AbstractDBObjectProvider)dBObjectProvider).resetObject(systemObject, null, null);
        }
    }

    public static void forceObjectUpdate(DBObjectProvider dBObjectProvider, SystemObject systemObject, Runnable runnable) {
        if (!(dBObjectProvider instanceof AbstractDBObjectProvider)) {
            throw new IllegalArgumentException("pro expected to be instance of AbstractDBObjectProvider");
        }
        if (systemObject == null) {
            throw new NullPointerException("orig cannot be null");
        }
        DBObjectChange dBObjectChange = DBUtil.invokeCompoundChange(systemObject, runnable, true);
        if (dBObjectChange != null) {
            AbstractDBObjectProvider abstractDBObjectProvider = (AbstractDBObjectProvider)dBObjectProvider;
            abstractDBObjectProvider.fireObjectUpdated(dBObjectChange);
        }
    }

    public static void forceObjectUpdate(DBObjectProvider dBObjectProvider, SystemObject systemObject, SystemObject systemObject2) {
        if (!(dBObjectProvider instanceof AbstractDBObjectProvider)) {
            throw new IllegalArgumentException("pro expected to be instance of AbstractDBObjectProvider");
        }
        if (systemObject == null) {
            throw new NullPointerException("orig cannot be null");
        }
        if (systemObject2 == null) {
            throw new NullPointerException("upd cannot be null");
        }
        if (systemObject.getClass() != systemObject2.getClass()) {
            throw new IllegalArgumentException("orig must be same class as upd");
        }
        AbstractDBObjectProvider abstractDBObjectProvider = (AbstractDBObjectProvider)dBObjectProvider;
        DifferenceApplier differenceApplier = new DifferenceApplier(abstractDBObjectProvider);
        differenceApplier.apply(systemObject, systemObject2);
        for (DBObjectChange dBObjectChange : differenceApplier.getEvents()) {
            abstractDBObjectProvider.fireObjectUpdated(dBObjectChange);
        }
    }

    public static Class findCommonSuperclass(Class<?> clazz, Class<?> clazz2) {
        Class clazz3;
        if (clazz == null) {
            clazz3 = clazz2;
        } else if (clazz2 == null || ModelUtil.areEqual(clazz, clazz2)) {
            clazz3 = clazz;
        } else if (clazz.isAssignableFrom(clazz2)) {
            clazz3 = clazz;
        } else if (clazz2.isAssignableFrom(clazz)) {
            clazz3 = clazz2;
        } else {
            TreeSet treeSet = new TreeSet(new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> clazz, Class<?> clazz2) {
                    if (clazz.equals(clazz2)) {
                        return 0;
                    }
                    if (clazz.equals(Object.class)) {
                        return 1000;
                    }
                    if (clazz2.equals(Object.class)) {
                        return -1000;
                    }
                    boolean bl = clazz.isInterface();
                    boolean bl2 = clazz2.isInterface();
                    if (bl && !bl2) {
                        return 100;
                    }
                    if (bl2 && !bl) {
                        return -100;
                    }
                    if (clazz.isAssignableFrom(clazz2)) {
                        return 10;
                    }
                    if (clazz2.isAssignableFrom(clazz)) {
                        return -10;
                    }
                    return (int)Math.signum(clazz.getName().compareTo(clazz2.getName()));
                }
            });
            for (Class<?> clazz4 = clazz; clazz4 != null; clazz4 = clazz4.getSuperclass()) {
                for (Class<?> clazz5 : clazz4.getInterfaces()) {
                    treeSet.add(clazz5);
                }
                if (!clazz4.isAssignableFrom(clazz2)) continue;
                treeSet.add(clazz4);
            }
            clazz3 = (Class)treeSet.iterator().next();
        }
        return clazz3;
    }

    public static DBObject findChildByName(DBObject dBObject, String string, String string2, DBObjectProvider dBObjectProvider) {
        return DBUtil.findChildByName(dBObject, string, string2, false, dBObjectProvider);
    }

    public static DBObject findChildByName(DBObject dBObject, String string, String string2, boolean bl, DBObjectProvider dBObjectProvider) {
        DBObject dBObject2;
        Object object = dBObject.getProperty(string);
        if (object instanceof Object[]) {
            DBObject dBObject3;
            DBObject dBObject4;
            dBObject2 = DBUtil.findChildByNameImpl((Object[])object, string2, dBObjectProvider.getDescriptor());
            if (dBObject2 == null && bl && (dBObject4 = TemporaryObjectID.getOriginalObject(dBObject)) != null && (dBObject3 = DBUtil.findChildByName(dBObject4, string, string2, true, dBObjectProvider)) != null) {
                dBObject2 = DBUtil.findChildInCopy(dBObject4, dBObject, dBObject3);
            }
        } else {
            dBObject2 = null;
        }
        return dBObject2;
    }

    private static DBObject findChildByNameImpl(Object[] objectArray, String string, DatabaseDescriptor databaseDescriptor) {
        for (Object object : objectArray) {
            DBObject dBObject;
            String string2;
            if (!(object instanceof DBObject) || !databaseDescriptor.areNamesEqual(string2 = (dBObject = (DBObject)object).getName(), string, dBObject.getType(), false)) continue;
            return dBObject;
        }
        return null;
    }

    public static SystemObject getSystemObjectFromParent(Difference difference, String string) {
        DBObject dBObject = DBUtil.getDBObjectFromParent(difference, string);
        return DBUtil.getSystemObject(dBObject);
    }

    public static String getFullPropertyPath(Difference difference) {
        Object object = null;
        if (difference != null && !DBObject.class.isAssignableFrom(difference.getDifferenceClass())) {
            object = difference.getPropertyName();
        }
        if (object != null) {
            String string;
            Difference difference2 = difference.getParent();
            String string2 = string = difference2 == null ? null : DBUtil.getFullPropertyPath(difference2);
            if (ModelUtil.hasLength((String)string)) {
                object = string + "/" + (String)object;
            }
        }
        return object;
    }

    public static DBObject getDBObjectFromParent(Difference difference, String string) {
        DBObject dBObject = null;
        while (difference != null) {
            Object object = null;
            if (ModelUtil.hasLength((String)string)) {
                object = difference.getObject(string);
            } else {
                object = difference.getOriginalObject();
                if (object == null) {
                    object = difference.getUpdatedObject();
                }
            }
            if (object instanceof DBObject) {
                dBObject = (DBObject)object;
                break;
            }
            difference = difference.getParent();
        }
        return dBObject;
    }

    public static Class<?> decodeArrayClass(Class<?> clazz) {
        if (clazz != null && clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static boolean isDeprecated(Enum enum_) {
        boolean bl = false;
        if (enum_ != null) {
            try {
                Field field = enum_.getClass().getField(enum_.name());
                bl = field.isAnnotationPresent(Deprecated.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String isViaDatabaseLink(SystemObject systemObject) {
        DBObjectID dBObjectID;
        Schema schema;
        String string = null;
        DBObjectID dBObjectID2 = systemObject.getID();
        if (dBObjectID2 instanceof BaseObjectID) {
            string = ((BaseObjectID)dBObjectID2).getDatabaseName();
        }
        if (string == null && systemObject instanceof SchemaObject && (schema = ((SchemaObject)systemObject).getSchema()) != null && (dBObjectID = schema.getID()) instanceof BaseObjectID) {
            string = ((BaseObjectID)dBObjectID).getDatabaseName();
        }
        return string;
    }

    public static List<SchemaObject> getSynonymReferenceChain(Synonym synonym) {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        DBObject dBObject = synonym;
        try {
            while (dBObject instanceof SchemaObject) {
                arrayList.add((SchemaObject)dBObject);
                if (dBObject instanceof Synonym) {
                    DBObjectID dBObjectID = dBObject.getReference();
                    if (dBObjectID != null) {
                        dBObject = dBObjectID.resolveID();
                        continue;
                    }
                    dBObject = null;
                    continue;
                }
                dBObject = null;
            }
        }
        catch (DBException dBException) {
            DBUtil.getLogger().log(Level.WARNING, "Couldn't resolve synonym {0} : {1}", new String[]{synonym.getName(), dBException.getMessage()});
        }
        return arrayList;
    }

    public static SchemaObject getSynonymReference(Synonym synonym) {
        SchemaObject schemaObject = null;
        if (synonym != null) {
            List<SchemaObject> list = DBUtil.getSynonymReferenceChain(synonym);
            schemaObject = list.get(list.size() - 1);
        }
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectChange invokeCompoundChange(DBObject dBObject, Runnable runnable, boolean bl) {
        final Holder holder = new Holder();
        DBObjectListener dBObjectListener = new DBObjectListener(){

            @Override
            public void objectUpdated(DBObjectChange dBObjectChange) {
                holder.set((Object)dBObjectChange);
            }
        };
        try {
            if (dBObject != null) {
                dBObject.addObjectListener(dBObjectListener);
            }
            if (dBObject instanceof AbstractDBObject) {
                ((AbstractDBObject)dBObject).invokeCompoundChange(runnable, bl);
            } else {
                runnable.run();
            }
        }
        finally {
            if (dBObject != null) {
                dBObject.removeObjectListener(dBObjectListener);
            }
        }
        return (DBObjectChange)holder.get();
    }

    public static Collection<String> listSupportedTypes(DBObjectProvider dBObjectProvider, Class<? extends SystemObject> ... classArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (classArray != null) {
            for (Class<? extends SystemObject> clazz : classArray) {
                for (String string : Metadata.getInstance().getAllTypes(clazz)) {
                    if (!dBObjectProvider.supportsObjectType(string)) continue;
                    hashSet.add(string);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cascadeInternalRename(SystemObject systemObject, DBObject dBObject, String string, String string2, DBObjectProvider dBObjectProvider) throws DBException {
        if (dBObjectProvider instanceof AbstractDBObjectProvider && systemObject != null && dBObject instanceof Column && ModelUtil.areDifferent((Object)string, (Object)string2)) {
            DBObjectID dBObjectID = dBObject.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                if (TemporaryObjectID.getOriginalObject(dBObject) == null) {
                    SystemObject systemObject2 = DBUtil.makeTemporaryCopy(systemObject);
                    DBObject dBObject2 = DBUtil.findChildInCopy(systemObject, systemObject2, dBObject);
                    dBObject.setName(string);
                    try {
                        DBUtil.cascadeInternalRenameImpl(systemObject2, dBObject2, string, string2, dBObjectProvider);
                        systemObject2.copyTo(systemObject);
                    }
                    finally {
                        dBObject.setName(string2);
                    }
                } else {
                    DBUtil.cascadeInternalRenameImpl(systemObject, dBObject, string, string2, dBObjectProvider);
                }
            } else {
                throw new IllegalStateException("DBUtil.cascadeInternalRename can only be used on a new object, or a temp copy");
            }
        }
    }

    private static <T extends SystemObject> void cascadeInternalRenameImpl(T t, DBObject dBObject, String string, String string2, DBObjectProvider dBObjectProvider) throws DBException {
        try {
            DBObjectValidator<T> dBObjectValidator = ((AbstractDBObjectProvider)dBObjectProvider).getValidator(t);
            ResultSet resultSet = new ResultSet(null, dBObject, (Object)dBObject, null, "MAP");
            resultSet.setSame(false);
            ResultSet resultSet2 = new ResultSet(resultSet, false, (Object)string, (Object)string2, "name");
            dBObjectValidator.cascadeUpdate(resultSet, t);
        }
        catch (MissingValidatorException missingValidatorException) {
            DBUtil.getLogger().warning(missingValidatorException.getMessage());
        }
    }

    public static <T extends Enum> T findEnumFromString(String string, Class<? extends Enum> clazz) {
        Enum enum_ = null;
        if (string != null) {
            for (Enum enum_2 : clazz.getEnumConstants()) {
                if (!string.equals(enum_2.toString())) continue;
                enum_ = enum_2;
                break;
            }
        }
        return (T)enum_;
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (clazz != null) {
            linkedHashSet.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return linkedHashSet.toArray(new Class[linkedHashSet.size()]);
    }

    public static class IDQueryCriteria {
        private final IDQuery m_idQuery;
        private boolean m_recurse;
        private boolean m_existingOnly;
        private boolean m_topLevelOnly;
        private String[] m_types;

        public IDQueryCriteria(IDQuery iDQuery) {
            this.m_idQuery = iDQuery;
        }

        public void setTypes(String ... stringArray) {
            if (stringArray != null) {
                stringArray = DBUtil.stripNulls(stringArray);
                Arrays.sort(stringArray);
            }
            this.m_types = stringArray;
        }

        public void setRecurse(boolean bl) {
            this.m_recurse = bl;
        }

        public void setExistingOnly(boolean bl) {
            this.m_existingOnly = bl;
        }

        public void setTopLevelOnly(boolean bl) {
            this.m_topLevelOnly = bl;
        }
    }

    public static enum IDQuery {
        INTERNAL,
        EXTERNAL,
        BOTH;

    }
}

