/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

public final class DBObjectProviderFactory {
    private final Map<String, Creator> m_factories = new HashMap<String, Creator>();
    private final Collection<Listener> m_listeners = new CopyOnWriteArraySet<Listener>();
    private final MultiMap<String, DBObjectProviderListener> m_proListeners = new MultiMap(ConcurrentHashMap.class, CopyOnWriteArraySet.class);

    private DBObjectProviderFactory() {
    }

    private static DBObjectProviderFactory getInstance() {
        DBCore dBCore = DBCore.getInstance();
        DBObjectProviderFactory dBObjectProviderFactory = dBCore.get(DBObjectProviderFactory.class);
        if (dBObjectProviderFactory == null) {
            dBObjectProviderFactory = new DBObjectProviderFactory();
            dBCore.put(dBObjectProviderFactory);
        }
        return dBObjectProviderFactory;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBObjectProviderFactory.class);
    }

    public static void registerListener(Listener listener) {
        Collection<Listener> collection = DBObjectProviderFactory.getInstance().m_listeners;
        if (!collection.contains(listener)) {
            collection.add(listener);
        }
    }

    public static void unregisterListener(Listener listener) {
        Collection<Listener> collection = DBObjectProviderFactory.getInstance().m_listeners;
        if (listener != null) {
            collection.remove(listener);
        }
    }

    public static void registerProviderListener(String string, DBObjectProviderListener dBObjectProviderListener) {
        if (string != null && dBObjectProviderListener != null) {
            MultiMap<String, DBObjectProviderListener> multiMap = DBObjectProviderFactory.getInstance().m_proListeners;
            multiMap.add((Object)string, (Object)dBObjectProviderListener);
        }
    }

    public static void unregisterProviderListener(String string, DBObjectProviderListener dBObjectProviderListener) {
        if (string != null && dBObjectProviderListener != null) {
            MultiMap<String, DBObjectProviderListener> multiMap = DBObjectProviderFactory.getInstance().m_proListeners;
            multiMap.removeValue((Object)string, (Object)dBObjectProviderListener);
        }
    }

    public static void registerFactory(Creator creator) {
        Map<String, Creator> map = DBObjectProviderFactory.getInstance().m_factories;
        String string = creator.getProviderType();
        if (ModelUtil.hasLength((String)string)) {
            if (map.containsKey(string)) {
                DBObjectProviderFactory.getLogger().warning("Ignoring attempt to replace Creator for: " + string);
            } else {
                map.put(string, creator);
            }
        }
    }

    public static void unregisterFactory(Creator creator) {
        Map<String, Creator> map = DBObjectProviderFactory.getInstance().m_factories;
        String string = creator.getProviderType();
        if (ModelUtil.hasLength((String)string) && map.get(string) == creator) {
            map.remove(string);
        }
    }

    @Deprecated
    public static <T extends Creator> T findFactory(Class<T> clazz) {
        return null;
    }

    @Deprecated
    public static DBObjectProvider findProvider(Object object) {
        DBObjectProvider dBObjectProvider;
        block1: {
            String string;
            dBObjectProvider = null;
            if (object == null) break block1;
            Iterator<String> iterator = DBObjectProviderFactory.getProviderTypes().iterator();
            while (iterator.hasNext() && (dBObjectProvider = DBObjectProviderFactory.findProvider(string = iterator.next(), object)) == null) {
            }
        }
        return dBObjectProvider;
    }

    public static DBObjectProvider findProvider(DBObjectProviderID dBObjectProviderID) {
        DBObjectProvider dBObjectProvider = null;
        if (dBObjectProviderID != null) {
            dBObjectProvider = DBObjectProviderFactory.findProvider(dBObjectProviderID.getType(), dBObjectProviderID.getIdentifier());
        }
        return dBObjectProvider;
    }

    public static DBObjectProvider findProvider(String string, Object object) {
        Creator creator;
        DBObjectProvider dBObjectProvider = null;
        if (object != null && string != null && (creator = DBObjectProviderFactory.getCreator(string)) != null) {
            dBObjectProvider = creator.findProvider(object);
        }
        return dBObjectProvider;
    }

    @Deprecated
    public static DBObjectProvider findOrCreateProvider(Object object) throws DBException {
        DBObjectProvider dBObjectProvider;
        block1: {
            String string;
            dBObjectProvider = null;
            if (object == null) break block1;
            Iterator<String> iterator = DBObjectProviderFactory.getProviderTypes().iterator();
            while (iterator.hasNext() && (dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider(string = iterator.next(), object)) == null) {
            }
        }
        return dBObjectProvider;
    }

    public static DBObjectProvider findOrCreateProvider(DBObjectProviderID dBObjectProviderID) throws DBException {
        DBObjectProvider dBObjectProvider = null;
        if (dBObjectProviderID != null) {
            dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider(dBObjectProviderID.getType(), dBObjectProviderID.getIdentifier());
        }
        return dBObjectProvider;
    }

    public static DBObjectProvider findOrCreateProvider(String string, Object object) throws DBException {
        DBObjectProvider dBObjectProvider = null;
        if (object != null && string != null) {
            Creator creator = DBObjectProviderFactory.getCreator(string);
            if (creator == null) {
                throw new DBException(null, "Unknown provider type: " + string);
            }
            dBObjectProvider = DBObjectProviderFactory.findOrCreateProviderFromFactory(creator, object);
        }
        return dBObjectProvider;
    }

    private static final Collection<String> getProviderTypes() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("db");
        linkedHashSet.addAll(DBObjectProviderFactory.getInstance().m_factories.keySet());
        Map<String, Thunk> map = DBCore.getInstance().getFactoryMap(Creator.class);
        if (map != null) {
            linkedHashSet.addAll(map.keySet());
        }
        return linkedHashSet;
    }

    public static final Creator getCreator(String string) {
        Creator creator = null;
        if (string != null && (creator = DBObjectProviderFactory.getInstance().m_factories.get(string)) == null && (creator = DBCore.getInstance().getRegisteredFactory(Creator.class, string)) == null && string.equals("db")) {
            creator = DatabaseFactory.getInstance();
        }
        return creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DBObjectProvider findOrCreateProviderFromFactory(Creator creator, Object object) throws DBException {
        DBObjectProvider dBObjectProvider = creator.findProvider(object);
        if (dBObjectProvider == null) {
            Creator creator2 = creator;
            synchronized (creator2) {
                dBObjectProvider = creator.findProvider(object);
                if (dBObjectProvider == null) {
                    dBObjectProvider = DBObjectProviderFactory.createProviderFromFactory(creator, object);
                }
            }
        }
        return dBObjectProvider;
    }

    private static final DBObjectProvider createProviderFromFactory(Creator creator, Object object) throws DBException {
        DBObjectProvider dBObjectProvider = null;
        try {
            dBObjectProvider = creator.createProviderImpl(object);
            if (dBObjectProvider != null) {
                DBObjectProviderFactory.notifyOfCreation(creator.getIdentifier(dBObjectProvider), dBObjectProvider);
            }
        }
        catch (Exception exception) {
            if (exception instanceof DBException) {
                throw (DBException)exception;
            }
            DBObjectProviderFactory.getLogger().log(DBLog.getExceptionLogLevel(), exception.getMessage(), exception);
            throw new DBException(exception);
        }
        return dBObjectProvider;
    }

    @Deprecated
    public static final DBObjectProvider uncacheProvider(Object object) {
        return null;
    }

    public static final DBObjectProvider uncacheProvider(String string, Object object) {
        Creator creator;
        DBObjectProvider dBObjectProvider = null;
        if (object != null && string != null && (dBObjectProvider = (creator = DBObjectProviderFactory.getCreator(string)).uncacheProvider(object)) != null) {
            DBObjectProviderFactory.notifyOfRemoval(creator.getIdentifier(dBObjectProvider), dBObjectProvider);
        }
        return dBObjectProvider;
    }

    public static String getDescription(String string, Object object) {
        Creator creator = DBObjectProviderFactory.getCreator(string);
        String string2 = creator == null ? String.valueOf(object) : creator.getDescription(object);
        return string2;
    }

    public static final Class<? extends DBObjectProvider> loadProviderClass(String string) throws ClassNotFoundException {
        Class<Database> clazz = null;
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getInstance();
        if (databaseRegistry.isRegisteredDatabase(string)) {
            clazz = databaseRegistry.loadDatabaseClass(string);
        } else {
            ClassLoader classLoader = DBCore.getImplClassLoader();
            clazz = classLoader.loadClass(string);
        }
        return clazz;
    }

    private static Collection<Listener> listeners(String string) {
        Thunk thunk;
        ArrayList<Listener> arrayList = new ArrayList<Listener>(DBObjectProviderFactory.getInstance().m_listeners);
        Map<String, Thunk> map = DBCore.getInstance().getFactoryMap(Listener.class);
        if (map != null && (thunk = map.get(string)) != null) {
            arrayList.add((Listener)thunk.get());
        }
        return arrayList;
    }

    static void notifyOfCreation(Object object, DBObjectProvider dBObjectProvider) {
        DBObjectProviderFactory.getLogger().log(Level.FINE, "Provider created using key {0}: {1}", new Object[]{object, dBObjectProvider.getClass().getName()});
        for (Listener object2 : DBObjectProviderFactory.listeners(dBObjectProvider.getProviderType())) {
            try {
                object2.providerCreated(object, dBObjectProvider);
            }
            catch (Exception dBObjectProviderListener) {
                DBObjectProviderFactory.getLogger().log(DBLog.getExceptionLogLevel(), object2.getClass().getName(), dBObjectProviderListener);
            }
        }
        Collection collection = DBObjectProviderFactory.getInstance().m_proListeners.get((Object)dBObjectProvider.getProviderType());
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DBObjectProviderListener dBObjectProviderListener = (DBObjectProviderListener)iterator.next();
                dBObjectProvider.addProviderListener(dBObjectProviderListener);
            }
        }
        if (dBObjectProvider instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)dBObjectProvider).fireProviderOpened();
        }
    }

    static void notifyOfRemoval(Object object, DBObjectProvider dBObjectProvider) {
        DBObjectProviderFactory.getLogger().log(Level.FINE, "Provider uncached using key {0}", object);
        for (Listener object2 : DBObjectProviderFactory.listeners(dBObjectProvider.getProviderType())) {
            try {
                object2.providerRemoved(object, dBObjectProvider);
            }
            catch (Exception dBObjectProviderListener) {
                DBObjectProviderFactory.getLogger().log(DBLog.getExceptionLogLevel(), object2.getClass().getName(), dBObjectProviderListener);
            }
        }
        Collection collection = DBObjectProviderFactory.getInstance().m_proListeners.get((Object)dBObjectProvider.getProviderType());
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DBObjectProviderListener dBObjectProviderListener = (DBObjectProviderListener)iterator.next();
                dBObjectProvider.removeProviderListener(dBObjectProviderListener);
            }
        }
    }

    private static void notifyOfDelete(Object object, DBObjectProvider dBObjectProvider) {
        DBObjectProviderFactory.getLogger().log(Level.FINE, "Provider deleted using key {0}: {1}", new Object[]{object, dBObjectProvider.getClass().getName()});
        for (Listener listener : DBObjectProviderFactory.listeners(dBObjectProvider.getProviderType())) {
            try {
                listener.providerDeleted(object, dBObjectProvider);
            }
            catch (Exception exception) {
                DBObjectProviderFactory.getLogger().log(DBLog.getExceptionLogLevel(), listener.getClass().getName(), exception);
            }
        }
    }

    public static abstract class Creator {
        public abstract String getProviderType();

        protected abstract DBObjectProvider createProviderImpl(Object var1) throws DBException;

        protected String getDescription(Object object) {
            return this.getProviderType() + " " + String.valueOf(object);
        }

        protected abstract Object getIdentifier(DBObjectProvider var1);

        protected DBObjectProvider uncacheProvider(Object object) {
            return null;
        }

        protected DBObjectProvider findProvider(Object object) {
            return null;
        }

        protected final void fireProviderDeleted(Object object, DBObjectProvider dBObjectProvider) {
            DBObjectProviderFactory.notifyOfDelete(object, dBObjectProvider);
        }
    }

    public static interface Listener {
        public void providerCreated(Object var1, DBObjectProvider var2);

        public void providerRemoved(Object var1, DBObjectProvider var2);

        public void providerDeleted(Object var1, DBObjectProvider var2);
    }
}

