/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObjectIterator;

public class DBObjectIterator
implements Iterator<DBObject> {
    private boolean m_started;
    private String[] m_types;
    private final Iterator<? extends DBObject> m_parentIter;
    private DBObject m_currentParent;
    private Iterator<DBObject> m_childObjIter;
    private DBObject m_currObj;

    public DBObjectIterator(DBObject dBObject) {
        this.m_parentIter = Collections.singleton(dBObject).iterator();
    }

    public DBObjectIterator(Iterator<? extends DBObject> iterator) {
        this.m_parentIter = iterator;
    }

    public void setTypes(String ... stringArray) {
        if (this.m_started) {
            throw new IllegalStateException("Cannot modify iterator parameters after it has been started");
        }
        this.m_types = stringArray;
    }

    private void start() {
        if (!this.m_started) {
            this.m_started = true;
            this.nextParent();
        }
    }

    private void nextParent() {
        this.m_currentParent = null;
        this.m_childObjIter = null;
        this.m_currObj = null;
        if (this.m_parentIter.hasNext()) {
            this.m_currentParent = this.m_parentIter.next();
            if (this.m_currentParent != null) {
                DBObject[] dBObjectArray = this.m_currentParent.getOwnedObjects(this.m_types);
                if (dBObjectArray.length == 0) {
                    this.nextParent();
                } else {
                    this.m_childObjIter = Arrays.asList(dBObjectArray).iterator();
                    this.nextDBO();
                }
            }
        }
    }

    private void nextDBO() {
        this.m_currObj = this.m_childObjIter != null && this.m_childObjIter.hasNext() ? this.m_childObjIter.next() : null;
        if (this.m_currObj == null) {
            this.nextParent();
        }
    }

    @Override
    public boolean hasNext() {
        this.start();
        return this.m_currObj != null;
    }

    @Override
    public DBObject next() {
        this.start();
        DBObject dBObject = this.m_currObj;
        this.nextDBO();
        return dBObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by DBObjectIterator");
    }

    public static final Iterator<? extends DBObject> createIterator(DBObjectProvider[] dBObjectProviderArray, String[] stringArray, String[] ... stringArray2) {
        SchemaObjectIterator schemaObjectIterator = new SchemaObjectIterator(dBObjectProviderArray);
        schemaObjectIterator.setTypes(stringArray);
        return DBObjectIterator.createIterator(schemaObjectIterator, stringArray2);
    }

    public static final Iterator<? extends DBObject> createIterator(DBObject dBObject, String[] ... stringArray) {
        return DBObjectIterator.createIterator(Collections.singleton(dBObject).iterator(), stringArray);
    }

    private static final Iterator<? extends DBObject> createIterator(Iterator<? extends DBObject> dBObjectIterator, String[] ... stringArray) {
        DBObjectIterator dBObjectIterator2 = dBObjectIterator;
        if (stringArray != null) {
            for (String[] stringArray2 : stringArray) {
                dBObjectIterator2 = new DBObjectIterator(dBObjectIterator2);
                dBObjectIterator2.setTypes(stringArray2);
            }
        }
        return dBObjectIterator2;
    }
}

