/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class DBObjectCriteria<T extends SystemObject>
implements DBObjectFilter<T> {
    public static final char LIKE_WILDCARD_CHAR = '%';
    public static final String LIKE_WILDCARD = String.valueOf('%');
    public static final char LIKE_SINGLE_CHAR_WILDCARD_CHAR = '_';
    public static final String LIKE_SINGLE_CHAR_WILDCARD = String.valueOf('_');
    private Collection<DBObjectFilter<T>> m_filters;
    private final Class<? extends T> m_clz;
    private DatabaseDescriptor m_databaseDescriptor;
    private String m_nameLike;
    private String m_name;
    private String m_schemaName;
    private String m_dbName;
    private final Collection<String> m_types = new HashSet<String>();
    private boolean m_userOnly;
    private boolean m_skipTimestamps;
    private boolean m_fullLoad;

    private DBObjectCriteria(Class<? extends T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Criteria class cannot be null");
        }
        this.m_clz = clazz;
    }

    public DBObjectCriteria(T t) throws NullPointerException {
        this(t.getClass(), t.getType());
        DBObjectID dBObjectID;
        this.setName(t.getName());
        if (t instanceof SchemaObject) {
            this.setSchema(((SchemaObject)t).getSchema());
        }
        if ((dBObjectID = t.getID()) instanceof BaseObjectID) {
            this.setDatabaseName(((BaseObjectID)dBObjectID).getDatabaseName());
        }
    }

    public DBObjectCriteria(Class<? extends T> clazz, String ... stringArray) {
        this(clazz);
        if (ModelUtil.hasNonNullElement((Object[])stringArray)) {
            Collection<String> collection = Metadata.getInstance().getAllTypes(this.m_clz);
            for (String string : stringArray) {
                if (string == null) continue;
                if (collection.contains(string)) {
                    this.m_types.add(string);
                    continue;
                }
                throw new IllegalArgumentException(string + " is not a valid type for class " + this.m_clz.getSimpleName());
            }
        } else if (!this.m_clz.equals(SystemObject.class)) {
            String string = Metadata.getType(this.m_clz);
            if (string == null) {
                this.m_types.addAll(Metadata.getInstance().getAllTypes(this.m_clz));
            } else {
                this.m_types.add(string);
            }
        }
    }

    final Class<? extends T> getObjectClass() {
        return this.m_clz;
    }

    public final String getNameLike() {
        String string = ModelUtil.hasLength((String)this.m_nameLike) ? this.m_nameLike : (ModelUtil.hasLength((String)this.m_name) ? this.m_name : LIKE_WILDCARD);
        return string;
    }

    public final void setNameLike(String string) {
        this.m_nameLike = string;
        this.m_name = null;
    }

    public final String getName() {
        Object object = this.m_name == null ? (this.m_nameLike == null || this.m_nameLike.contains(LIKE_WILDCARD) ? null : this.m_nameLike) : this.m_name;
        return object;
    }

    public final void setName(String string) {
        this.m_name = string;
        this.m_nameLike = null;
    }

    public final void setDatabaseDescriptor(DatabaseDescriptor databaseDescriptor) {
        this.m_databaseDescriptor = databaseDescriptor;
    }

    public final boolean isNameWild() {
        return this.m_name == null && (this.m_nameLike == null || DBObjectCriteria.containsWildcard(this.m_nameLike));
    }

    public final boolean isAllowedName(String string) {
        boolean bl = false;
        if (ModelUtil.hasLength((String)this.m_name)) {
            bl = this.areNamesEqual(this.m_name, string);
        } else if (ModelUtil.hasLength((String)this.m_nameLike)) {
            if (ModelUtil.hasLength((String)string)) {
                if (DBObjectCriteria.containsWildcard(this.m_nameLike)) {
                    int n;
                    int n2;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n3 = 32;
                    for (n2 = 0; n2 < this.m_nameLike.length(); ++n2) {
                        boolean bl2;
                        n = this.m_nameLike.charAt(n2);
                        boolean bl3 = bl2 = n3 == 92;
                        if (n == 37 && !bl2) {
                            stringBuilder.append(".*");
                        } else if (n == 95 && !bl2) {
                            stringBuilder.append(".");
                        } else {
                            stringBuilder.append(Pattern.quote(String.valueOf((char)n)));
                        }
                        n3 = n;
                    }
                    try {
                        n2 = 0;
                        if (this.m_databaseDescriptor != null && (n = this.m_databaseDescriptor.getCasePolicy()) == 0) {
                            n2 = 66;
                        }
                        Pattern pattern = Pattern.compile(stringBuilder.toString(), n2);
                        Matcher matcher = pattern.matcher(string);
                        bl = matcher.matches();
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        bl = false;
                    }
                } else {
                    bl = this.areNamesEqual(this.m_nameLike, string);
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean areNamesEqual(String string, String string2) {
        boolean bl = this.m_databaseDescriptor == null ? string.equals(string2) : this.m_databaseDescriptor.areNamesEqual(string, string2, null, false);
        return bl;
    }

    public final Collection<String> getTypes() {
        return Collections.unmodifiableCollection(this.m_types);
    }

    public final String[] getTypeArray() {
        return this.m_types.toArray(new String[this.m_types.size()]);
    }

    public final boolean isAllowedType(String string) {
        return this.getTypes().isEmpty() || this.getTypes().contains(string);
    }

    @Deprecated
    public final void setTypes(Collection<String> collection) {
    }

    @Deprecated
    public final void setTypes(String ... stringArray) {
    }

    public final String getSchemaName() {
        return this.m_schemaName;
    }

    public final void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public final void setSchema(Schema schema) {
        this.m_schemaName = schema != null ? schema.getName() : null;
    }

    public final boolean isAllowedSchema(Schema schema) {
        return this.isAllowedSchemaName(schema == null ? null : schema.getName());
    }

    public final boolean isAllowedSchemaName(String string) {
        boolean bl = ModelUtil.hasLength((String)this.m_schemaName) ? this.areNamesEqual(string, this.m_schemaName) : true;
        return bl;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String string) {
        this.m_dbName = string;
    }

    public final boolean isUserOnly() {
        return this.m_userOnly;
    }

    public final void setUserOnly(boolean bl) {
        this.m_userOnly = bl;
    }

    public boolean accept(String string, Schema schema, String string2) {
        return this.isAllowedType(string) && this.isAllowedSchema(schema) && this.isAllowedName(string2);
    }

    @Override
    public boolean accept(T t) {
        boolean bl = false;
        if (t != null) {
            boolean bl2 = bl = this.isAllowedName(t.getName()) && this.isAllowedType(t.getType());
            if (bl && t instanceof SchemaObject) {
                bl = this.isAllowedSchema(((SchemaObject)t).getSchema());
            }
        }
        if (bl && this.m_filters != null) {
            for (DBObjectFilter<T> dBObjectFilter : this.m_filters) {
                bl = bl && dBObjectFilter.accept(t);
            }
        }
        return bl;
    }

    public final void addFilter(DBObjectFilter<T> dBObjectFilter) {
        if (dBObjectFilter != null) {
            if (this.m_filters == null) {
                this.m_filters = new ArrayList<DBObjectFilter<T>>();
            }
            this.m_filters.add(dBObjectFilter);
        }
    }

    public final boolean hasExtraCriteria() {
        return this.m_filters != null;
    }

    void setSkipTimestampCheck(boolean bl) {
        this.m_skipTimestamps = bl;
    }

    boolean getSkipTimestampCheck() {
        return this.m_skipTimestamps;
    }

    public void setFullyLoadObjects(boolean bl) {
        this.m_fullLoad = bl;
    }

    public boolean isFullyLoadObjects() {
        return this.m_fullLoad;
    }

    public int hashCode() {
        return this.m_clz.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DBObjectCriteria && this.equalsImpl((DBObjectCriteria)object);
    }

    private boolean equalsImpl(DBObjectCriteria dBObjectCriteria) {
        return ModelUtil.areEqual((Object)this.m_dbName, (Object)dBObjectCriteria.m_dbName) && ModelUtil.areEqual((Object)this.m_name, (Object)dBObjectCriteria.m_name) && ModelUtil.areEqual((Object)this.m_nameLike, (Object)dBObjectCriteria.m_nameLike) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)dBObjectCriteria.m_schemaName) && ModelUtil.areEqual((Object)this.m_skipTimestamps, (Object)dBObjectCriteria.m_skipTimestamps) && ModelUtil.areEqual((Object)this.m_fullLoad, (Object)dBObjectCriteria.m_fullLoad) && ModelUtil.areEqual((Object)this.m_userOnly, (Object)dBObjectCriteria.m_userOnly) && this.contentsSame(this.m_types, dBObjectCriteria.m_types) && this.contentsSame(this.m_filters, dBObjectCriteria.m_filters);
    }

    private boolean contentsSame(Collection collection, Collection collection2) {
        boolean bl = true;
        if (collection != collection2) {
            if (collection == null || collection.isEmpty()) {
                bl = collection2 == null || collection2.isEmpty();
            } else if (collection2 == null || collection2.isEmpty()) {
                bl = false;
            } else {
                ArrayList arrayList = new ArrayList(collection2);
                for (Object e : collection) {
                    if (arrayList.remove(e)) continue;
                    bl = false;
                    break;
                }
                bl = bl && arrayList.isEmpty();
            }
        }
        return bl;
    }

    public DBObjectCriteria<T> clone() {
        DBObjectCriteria<Class<? extends T>> dBObjectCriteria = new DBObjectCriteria<Class<? extends T>>(this.m_clz);
        dBObjectCriteria.m_dbName = this.m_dbName;
        dBObjectCriteria.m_name = this.m_name;
        dBObjectCriteria.m_nameLike = this.m_nameLike;
        dBObjectCriteria.m_schemaName = this.m_schemaName;
        dBObjectCriteria.m_skipTimestamps = this.m_skipTimestamps;
        dBObjectCriteria.m_fullLoad = this.m_fullLoad;
        dBObjectCriteria.m_types.addAll(this.m_types);
        dBObjectCriteria.m_userOnly = this.m_userOnly;
        if (this.m_filters != null) {
            dBObjectCriteria.m_filters = new ArrayList<DBObjectFilter<T>>(this.m_filters);
        }
        return dBObjectCriteria;
    }

    public static DBObjectCriteria<SystemObject> createTypeCriteria(String ... stringArray) {
        String string;
        Class clazz = null;
        if (stringArray != null && stringArray.length == 1 && (string = stringArray[0]) != null) {
            clazz = Metadata.getInstance().getObjectClass(string);
        }
        if (clazz == null) {
            clazz = SystemObject.class;
        }
        return new DBObjectCriteria<SystemObject>(clazz, stringArray);
    }

    public static DBObjectCriteria<SystemObject> createTypeCriteria(Collection<String> collection) {
        String[] stringArray = collection == null || collection.isEmpty() ? null : collection.toArray(new String[collection.size()]);
        return DBObjectCriteria.createTypeCriteria(stringArray);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String string, Schema schema, String string2) {
        return DBObjectCriteria.createCriteria(string, null, schema == null ? null : schema.getName(), string2);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String string, String string2, String string3) {
        return DBObjectCriteria.createCriteria(string, null, string2, string3);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String string, String string2, String string3, String string4) {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createTypeCriteria(string);
        dBObjectCriteria.setNameLike(string4);
        dBObjectCriteria.setSchemaName(string3);
        dBObjectCriteria.setDatabaseName(string2);
        return dBObjectCriteria;
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String[] stringArray, Schema schema, String string) {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createTypeCriteria(stringArray);
        dBObjectCriteria.setNameLike(string);
        dBObjectCriteria.setSchema(schema);
        return dBObjectCriteria;
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String string, Schema schema, String string2) {
        return DBObjectCriteria.createSingleObjectCriteria(string, null, schema == null ? null : schema.getName(), string2);
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String string, String string2, String string3) {
        return DBObjectCriteria.createSingleObjectCriteria(string, null, string2, string3);
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String string, String string2, String string3, String string4) {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createTypeCriteria(string);
        dBObjectCriteria.setName(string4);
        dBObjectCriteria.setSchemaName(string3);
        dBObjectCriteria.setDatabaseName(string2);
        return dBObjectCriteria;
    }

    public static boolean containsWildcard(String string) {
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (c != '%' && c != '_') continue;
            bl = true;
            break;
        }
        return bl;
    }
}

