/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.AbstractResourceCache;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class BuiltInObjectCache
extends AbstractResourceCache {
    private Map<String, MultiMap<String, ObjectEntry>> m_objCache = new HashMap<String, MultiMap<String, ObjectEntry>>();
    private List<BuiltInFunction> m_builtInFunctions;
    private final Object m_bifLock = new Object();

    public BuiltInObjectCache(DatabaseDescriptor databaseDescriptor, String string) {
        super(databaseDescriptor, string);
    }

    public boolean isEmpty() {
        boolean bl = this.m_objCache.isEmpty();
        if (bl) {
            URL uRL = this.getResourceClassLoader().getResource(this.getBIFResource());
            bl = uRL == null;
        }
        return bl;
    }

    private String getBIFResource() {
        return this.getResourcePath("bif.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<BuiltInFunction> listBuiltInFunctions() {
        Object object = this.m_bifLock;
        synchronized (object) {
            if (this.m_builtInFunctions == null) {
                this.m_builtInFunctions = new ArrayList<BuiltInFunction>();
                InputStream inputStream = null;
                try {
                    inputStream = this.getResourceClassLoader().getResourceAsStream(this.getBIFResource());
                    if (inputStream != null) {
                        DBObjectHandler dBObjectHandler = this.getHandler(null);
                        for (DBObject dBObject : dBObjectHandler.read(inputStream, null, null)) {
                            if (!(dBObject instanceof BuiltInFunction)) continue;
                            BuiltInFunction builtInFunction = (BuiltInFunction)dBObject;
                            builtInFunction.setDescription(this.getDatabaseDescriptor().getBuiltInFunctionDescription(builtInFunction));
                            builtInFunction.setReturnTypeID(this.getPreferredTypeID(builtInFunction.getReturnTypeID()));
                            for (BuiltInFunctionArgument builtInFunctionArgument : builtInFunction.getArguments()) {
                                builtInFunctionArgument.setDataTypeID(this.getPreferredTypeID(builtInFunctionArgument.getDataTypeID()));
                            }
                            this.m_builtInFunctions.add(builtInFunction);
                        }
                    }
                }
                catch (Exception exception) {
                    this.getLogger().warning(exception.getMessage());
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.m_builtInFunctions;
    }

    private DBObjectID getPreferredTypeID(DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = dBObjectID;
        if (dBObjectID instanceof DataTypeID) {
            DatabaseDescriptor databaseDescriptor = this.getDatabaseDescriptor();
            DataType dataType = databaseDescriptor.getDataType(((DataTypeID)dBObjectID).getTypeName());
            if ((dataType = DataTypeHelper.unwrapDataType(dataType, PredefinedDataType.class)) instanceof PredefinedDataType) {
                PredefinedDataType predefinedDataType = (PredefinedDataType)dataType;
                PredefinedDataType.ValueType valueType = predefinedDataType.getValueType();
                for (DataType dataType2 : databaseDescriptor.listPreferredDataTypes()) {
                    if (!(dataType2 instanceof PredefinedDataType)) continue;
                    PredefinedDataType predefinedDataType2 = (PredefinedDataType)dataType2;
                    PredefinedDataType.ValueType valueType2 = predefinedDataType2.getValueType();
                    if (valueType == valueType2) {
                        dBObjectID2 = dataType2.getID();
                        break;
                    }
                    if (!PredefinedDataType.ValueType.isNumericType(valueType) || !PredefinedDataType.ValueType.isNumericType(valueType2)) continue;
                    dBObjectID2 = dataType2.getID();
                    break;
                }
            }
        }
        return dBObjectID2;
    }

    public final <T extends SystemObject> Collection<T> listBuiltInObjects(DBObjectCriteria<T> dBObjectCriteria) {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray = dBObjectCriteria.getTypeArray()) {
            Class<? extends DBObject> clazz = Metadata.getInstance().getObjectClass(string);
            if (SchemaObject.class.isAssignableFrom(clazz)) {
                String string2 = dBObjectCriteria.getSchemaName();
                if (!ModelUtil.hasLength((String)string2)) continue;
                this.addObjects(string2, string, dBObjectCriteria, arrayList);
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clazz)) continue;
            this.addObjects(null, string, dBObjectCriteria, arrayList);
        }
        return arrayList;
    }

    private <T extends SystemObject> void addObjects(String string, String string2, DBObjectCriteria dBObjectCriteria, Collection<T> collection) {
        Collection collection2;
        MultiMap<String, ObjectEntry> multiMap = this.getSchemaCache(string, false);
        if (multiMap != null && (collection2 = multiMap.get((Object)string2)) != null) {
            dBObjectCriteria.setDatabaseDescriptor(this.getDatabaseDescriptor());
            for (ObjectEntry objectEntry : collection2) {
                SystemObject systemObject;
                if (!dBObjectCriteria.isAllowedName(objectEntry.m_name) || (systemObject = objectEntry.getObject()) == null) continue;
                if (systemObject instanceof SchemaObject && ((SchemaObject)systemObject).getSchema() == null) {
                    ((SchemaObject)systemObject).setSchema((Schema)this.findBuiltInObject("SCHEMA", null, string));
                }
                collection.add(systemObject);
                if (dBObjectCriteria.isNameWild()) continue;
                break;
            }
        }
    }

    private SystemObject findBuiltInObject(String string, String string2, String string3) {
        SystemObject systemObject = null;
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(string, string2, string3);
        Collection<SystemObject> collection = this.listBuiltInObjects(dBObjectCriteria);
        if (collection != null && collection.size() == 1) {
            systemObject = collection.iterator().next();
        }
        return systemObject;
    }

    private MultiMap<String, ObjectEntry> getSchemaCache(String string, boolean bl) {
        MultiMap multiMap = this.m_objCache.get(string);
        if (multiMap == null && bl) {
            multiMap = new MultiMap();
            this.m_objCache.put(string, (MultiMap<String, ObjectEntry>)multiMap);
            if (string != null) {
                ObjectEntry objectEntry = new ObjectEntry("SCHEMA", null, string, null);
                this.getSchemaCache(null, true).add((Object)"SCHEMA", (Object)objectEntry);
            }
        }
        return multiMap;
    }

    public void registerBuiltInObject(String string, String string2, String string3) {
        if (string == null || string3 == null) {
            throw new IllegalArgumentException("type and name must be specified.");
        }
        if (!Metadata.getInstance().isTypeOf(SystemObject.class, string)) {
            throw new IllegalArgumentException(string + "is not a SystemObject type.");
        }
        if (Metadata.getInstance().isSchemaObject(string) && !ModelUtil.hasLength((String)string2)) {
            throw new IllegalArgumentException("Schema is mandatory for " + string);
        }
        String string4 = this.getResourcePath(string2, string3 + "." + string.toLowerCase());
        this.registerBuiltInObject(string2, new ObjectEntry(string, string2, string3, string4));
    }

    public void registerBuiltInObject(SystemObject systemObject) {
        ObjectEntry objectEntry = new ObjectEntry(systemObject);
        Schema schema = DBUtil.getSchema(systemObject);
        this.registerBuiltInObject(schema == null ? null : schema.getName(), objectEntry);
    }

    private void registerBuiltInObject(String string, ObjectEntry objectEntry) {
        MultiMap<String, ObjectEntry> multiMap = this.getSchemaCache(string, true);
        multiMap.add((Object)objectEntry.m_type, (Object)objectEntry);
    }

    private class ObjectEntry {
        private final String m_schemaName;
        private final String m_type;
        private final String m_name;
        private final String m_resourcePath;
        private SystemObject m_obj;

        ObjectEntry(SystemObject systemObject) {
            this(systemObject.getType(), DBUtil.getSchemaName(systemObject), systemObject.getName(), null);
            this.m_obj = systemObject;
        }

        ObjectEntry(String string, String string2, String string3, String string4) {
            this.m_schemaName = string2;
            this.m_type = string;
            this.m_name = string3;
            this.m_resourcePath = string4;
        }

        public SystemObject getObject() {
            Object object;
            if (this.m_obj == null) {
                object = Metadata.getInstance().getObjectClass(this.m_type);
                try {
                    this.m_obj = (SystemObject)((Class)object).newInstance();
                    this.m_obj.setName(this.m_name);
                }
                catch (Exception exception) {
                    String string = this.m_type + " is not a valid SystemObject type";
                    BuiltInObjectCache.this.getLogger().log(Level.FINE, string, exception);
                    BuiltInObjectCache.this.getLogger().warning(string);
                }
            }
            if (this.m_resourcePath != null) {
                BuiltInObjectCache.this.markForLazyInit((AbstractBuildableObject)((Object)this.m_obj), this.m_resourcePath);
            }
            if (this.m_obj.getID() == null) {
                object = this.m_obj instanceof Type ? new DataTypeID(this.m_name, this.m_schemaName, BuiltInObjectCache.this.getDatabaseDescriptor()) : new ReferenceID(this.m_type, this.m_schemaName, this.m_name);
                this.m_obj.setID((DBObjectID)object);
            }
            return this.m_obj;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ObjectEntry && this.m_type.equals(((ObjectEntry)object).m_type) && this.m_name.equals(((ObjectEntry)object).m_name);
        }
    }
}

