/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import oracle.security.spnego.ASNEnumerated;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.BitString;
import oracle.security.spnego.ContextFlags;
import oracle.security.spnego.DerDecoder;
import oracle.security.spnego.DerEncoder;
import oracle.security.spnego.GSSContextToken;
import oracle.security.spnego.GeneralString;
import oracle.security.spnego.MICContainer;
import oracle.security.spnego.MechType;
import oracle.security.spnego.MechTypeList;
import oracle.security.spnego.NegTokenInit;
import oracle.security.spnego.NegTokenTarg;
import oracle.security.spnego.NegotiationToken;
import oracle.security.spnego.ObjectIdentifier;
import oracle.security.spnego.OctetString;
import oracle.security.spnego.SPNEGOException;
import oracle.security.spnego.SPNEGOProperties;

public class SPNEGO {
    public static final int KERBEROSV5_MECHANISM = 1;
    public static final int NTLMSSP_MECHANISM = 2;
    public static final int ACCEPT_COMPLETED = 0;
    public static final int ACCEPT_INCOMPLETE = 1;
    public static final int REJECT = 2;
    public static final int DELEGATION = 0;
    public static final int MUTUALAUTH = 1;
    public static final int REPLAY = 2;
    public static final int SEQUENCE = 3;
    public static final int ANONYMOUS = 4;
    public static final int CONFIDENTIAL = 5;
    public static final int INTEGRITY = 6;
    protected static final int TRANSPORT_HTTP = 1;
    protected static final int TRANSPORT_SMB = 2;
    static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    static final String KERBEROSV5_OID = "1.2.840.113554.1.2.2";
    static final String KERBEROSV5_LEGACY_OID = "1.2.840.48018.1.2.2";
    static final String NTLMSSP_OID = "1.3.6.1.4.1.311.2.2.10";
    private int _transport;
    protected BigInteger _resNegResult;
    protected String _resSupportedMech;
    protected byte[] _resMechToken;
    protected byte[] _resMic;
    protected byte[] _reqFlags;
    protected byte[] _reqMechToken;
    protected byte[] _reqMic;
    protected ArrayList _reqSupportedMechs;

    protected void start() {
        this._reqMic = null;
        this._reqSupportedMechs = null;
        this._reqFlags = null;
        this._reqMechToken = null;
    }

    protected void setTransport(int transport) {
        this._transport = transport;
        SPNEGOProperties.getInstance().setTransport(transport);
    }

    public String[] getReqSupportedMechs() {
        String[] mechs = null;
        if (this._reqSupportedMechs != null) {
            mechs = new String[this._reqSupportedMechs.size()];
            for (int i = 0; i < mechs.length; ++i) {
                mechs[i] = (String)this._reqSupportedMechs.get(i);
            }
        }
        return mechs;
    }

    public boolean isReqFlagSet(int flag) {
        if (this._reqFlags != null) {
            return this._reqFlags[flag] != 0;
        }
        return false;
    }

    public byte[] getReqMIC() {
        return this._reqMic;
    }

    public byte[] getReqMechToken() {
        return this._reqMechToken;
    }

    public int getResNegResult() {
        return this._resNegResult.intValue();
    }

    public byte[] getResMIC() {
        return this._resMic;
    }

    public byte[] getResMechToken() {
        return this._resMechToken;
    }

    public String getResSupportedMech() {
        return this._resSupportedMech;
    }

    protected int decodeReq(byte[] gssreq) throws SPNEGOException {
        if (gssreq == null) {
            throw new SPNEGOException("Input parameter is null");
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(gssreq);
            DerDecoder derDecoder = new DerDecoder();
            ((ASNReader)derDecoder).open(is);
            NegTokenInit negTokenInit = null;
            switch (this._transport) {
                case 1: {
                    GSSContextToken gsstoken = new GSSContextToken();
                    gsstoken.decode(derDecoder);
                    NegotiationToken negToken = gsstoken.getInContextToken();
                    negTokenInit = negToken.getNegTokenInit();
                    break;
                }
                case 2: {
                    negTokenInit = new NegTokenInit();
                    negTokenInit.decode(derDecoder);
                }
            }
            if (negTokenInit != null) {
                MechTypeList mechList = negTokenInit.getMechTypeList();
                this._reqSupportedMechs = mechList.getMechTypes();
                boolean foundkrb5 = false;
                boolean foundntlm = false;
                for (String s : this._reqSupportedMechs) {
                    if (s.equals(KERBEROSV5_OID) || s.equals(KERBEROSV5_LEGACY_OID)) {
                        foundkrb5 = true;
                    }
                    if (!s.equals(NTLMSSP_OID)) continue;
                    foundntlm = true;
                }
                if (!foundkrb5 && !foundntlm) {
                    throw new SPNEGOException("Unsupported SPNEGO Mechanisms");
                }
                ContextFlags cflags = negTokenInit.getReqFlags();
                if (cflags != null) {
                    this._reqFlags = cflags.byteArrayValue();
                }
                switch (this._transport) {
                    case 1: {
                        OctetString hmic = negTokenInit.getHTTPMechListMIC();
                        if (hmic == null) break;
                        this._reqMic = hmic.byteArrayValue();
                        break;
                    }
                    case 2: {
                        String s;
                        GeneralString gs;
                        MICContainer smic = negTokenInit.getSMBMechListMIC();
                        if (smic == null || (gs = smic.getElementMIC()) == null || (s = gs.stringValue()) == null) break;
                        this._reqMic = s.getBytes();
                    }
                }
                OctetString mechToken = negTokenInit.getMechToken();
                if (mechToken != null) {
                    this._reqMechToken = mechToken.byteArrayValue();
                }
                int reqMechTokenType = -1;
                if (foundkrb5) {
                    reqMechTokenType = 1;
                } else if (foundntlm) {
                    reqMechTokenType = 2;
                }
                return reqMechTokenType;
            }
            throw new SPNEGOException("NegotiationTokenInit not found in the request");
        }
        catch (IOException e) {
            if (e instanceof ASNException && ((ASNException)e).getCurrentIndex() == 4) {
                return 2;
            }
            throw new SPNEGOException(e);
        }
    }

    protected byte[] encodeReq(String[] mechs, byte[] flags, byte[] token, Object mic) throws SPNEGOException {
        try {
            NegotiationToken reqToken = new NegotiationToken();
            NegTokenInit initToken = new NegTokenInit();
            ArrayList<MechType> a = new ArrayList<MechType>(mechs.length);
            for (int i = 0; i < mechs.length; ++i) {
                MechType m = new MechType(ObjectIdentifier.getInstance(mechs[i]));
                a.add(m);
            }
            MechTypeList mechList = new MechTypeList();
            mechList.setMechTypes(a);
            initToken.setMechTypeList(mechList);
            ContextFlags cflags = new ContextFlags(BitString.getInstance(flags));
            initToken.setReqFlags(cflags);
            OctetString mechToken = OctetString.getInstance(token);
            initToken.setMechToken(mechToken);
            switch (this._transport) {
                case 2: {
                    String smic = (String)mic;
                    GeneralString micString = GeneralString.getInstance(smic);
                    MICContainer micToken = new MICContainer();
                    micToken.setElementMIC(micString);
                    DerEncoder enc = new DerEncoder();
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    ((ASNWriter)enc).open(bo);
                    micToken.encode(enc);
                    byte[] hmic = bo.toByteArray();
                    initToken.setSMBMechListMIC(OctetString.getInstance(hmic));
                    reqToken.setNegTokenInitSMB(initToken);
                    break;
                }
                case 1: {
                    byte[] amic = (byte[])mic;
                    initToken.setHTTPMechListMIC(OctetString.getInstance(amic));
                    reqToken.setNegTokenInitHTTP(initToken);
                }
            }
            DerEncoder derEncoder = new DerEncoder();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((ASNWriter)derEncoder).open(out);
            reqToken.encode(derEncoder);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new SPNEGOException(e);
        }
    }

    protected int decodeRes(byte[] gssres) throws SPNEGOException {
        if (gssres == null) {
            throw new SPNEGOException("Input parameter is null");
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(gssres);
            DerDecoder derDecoder = new DerDecoder();
            GSSContextToken gsstoken = new GSSContextToken();
            ((ASNReader)derDecoder).open(is);
            gsstoken.decode(derDecoder);
            NegotiationToken negToken = gsstoken.getInContextToken();
            if (negToken.isNegTokenTarg()) {
                int mechTokenType = -1;
                NegTokenTarg negTokenTarg = negToken.getNegTokenTarg();
                ASNEnumerated negResult = negTokenTarg.getNegResult();
                this._resNegResult = negResult.intValue();
                MechType mech = negTokenTarg.getSupportedMech();
                this._resSupportedMech = mech.stringValue();
                mechTokenType = this._resSupportedMech.equals(KERBEROSV5_OID) || this._resSupportedMech.equals(KERBEROSV5_LEGACY_OID) ? 1 : 2;
                OctetString token = negTokenTarg.getResponseToken();
                this._resMechToken = token.byteArrayValue();
                OctetString hmic = negTokenTarg.getMechListMIC();
                this._resMic = hmic.byteArrayValue();
                return mechTokenType;
            }
            throw new SPNEGOException("NegotiationTokenTarg not found in the response");
        }
        catch (IOException e) {
            throw new SPNEGOException(e);
        }
    }

    protected byte[] encodeRes(int status, String smech, byte[] token, byte[] mic) throws SPNEGOException {
        try {
            ASNEnumerated negResult = ASNEnumerated.getInstance(status);
            ObjectIdentifier oid = ObjectIdentifier.getInstance(smech);
            MechType mech = new MechType(oid);
            OctetString respToken = OctetString.getInstance(token);
            OctetString mechMIC = OctetString.getInstance(mic);
            NegTokenTarg negTokenTarg = new NegTokenTarg();
            negTokenTarg.setNegResult(negResult);
            negTokenTarg.setSupportedMech(mech);
            negTokenTarg.setResponseToken(respToken);
            negTokenTarg.setMechListMIC(mechMIC);
            NegotiationToken resToken = new NegotiationToken();
            resToken.setNegTokenTarg(negTokenTarg);
            DerEncoder derEncoder = new DerEncoder();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((ASNWriter)derEncoder).open(out);
            switch (this._transport) {
                case 1: {
                    GSSContextToken gsstoken = new GSSContextToken();
                    MechType spnego = new MechType(ObjectIdentifier.getInstance(SPNEGO_OID));
                    gsstoken.setThisMech(spnego);
                    gsstoken.setInContextToken(resToken);
                    gsstoken.encode(derEncoder);
                    break;
                }
                case 2: {
                    resToken.encode(derEncoder);
                }
            }
            return out.toByteArray();
        }
        catch (IOException x) {
            throw new SPNEGOException(x);
        }
    }
}

