/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class ObjectIdentifier
extends Type
implements IType {
    public ObjectIdentifier() {
        super("", new Tag(6));
    }

    public ObjectIdentifier(String name) {
        super(name, new Tag(6));
    }

    public ObjectIdentifier(String name, Tag tag) {
        super(name, tag);
    }

    public ObjectIdentifier(String name, Object value) {
        this(name, new Tag(6), value);
    }

    public ObjectIdentifier(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            if (value instanceof String) {
                this.value(value);
            } else {
                throw new ClassCastException();
            }
        }
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static ObjectIdentifier getInstance(String value) {
        return new ObjectIdentifier("", value);
    }

    public static ObjectIdentifier getInstance(ObjectIdentifier value) {
        return new ObjectIdentifier("", value);
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            String result = is.decodeObjectIdentifier(this);
            if (result == null) {
                throw new ASNException(1, "Decoding OBJECT IDENTIFIER");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        String cn = this.getClass().getName();
        Object val = this.value();
        if (val != null) {
            os.encodeObjectIdentifier(this, (String)val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeObjectIdentifier(this, (String)val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding OBJECT IDENTIFIER");
            }
        }
    }

    @Override
    public void value(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof ObjectIdentifier) {
            this.value = ((ObjectIdentifier)value).stringValue();
        } else {
            throw new ClassCastException();
        }
    }

    public String stringValue() {
        return (String)this.value;
    }

    @Override
    protected boolean sameValue(Object obj) {
        String val = this.stringValue();
        return val == null ? false : val.equals(obj);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append(this.stringValue());
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

