/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import oracle.security.spnego.MechType;
import oracle.security.spnego.NegotiationToken;
import oracle.security.spnego.Sequence;
import oracle.security.spnego.Tag;

public class GSSContextToken
extends Sequence {
    public GSSContextToken() {
        super("", new Tag(64, 0, false));
    }

    public GSSContextToken(String name) {
        super(name, new Tag(64, 0, false));
    }

    public GSSContextToken(String name, Tag tag) {
        super(name, tag);
    }

    public GSSContextToken(Sequence value) {
        this("", value);
    }

    public GSSContextToken(String name, Sequence value) {
        this(name, new Tag(64, 0, false), value);
    }

    public GSSContextToken(String name, Tag tag, Sequence value) {
        super(name, tag, value == null ? null : value.value());
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        MechType thisMech = new MechType("thisMech");
        this.components.add(thisMech);
        NegotiationToken inContextToken = new NegotiationToken("inContextToken");
        inContextToken.optional(true);
        this.components.add(inContextToken);
    }

    public MechType getThisMech() {
        return (MechType)this.components.get(0);
    }

    public void setThisMech(MechType obj) {
        MechType it = this.getThisMech();
        it.value(obj.value());
        this.components.set(0, it);
    }

    public NegotiationToken getInContextToken() {
        return (NegotiationToken)this.components.get(1);
    }

    public void setInContextToken(NegotiationToken obj) {
        NegotiationToken it = this.getInContextToken();
        it.value(obj.value());
        this.components.set(1, it);
    }
}

