/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.Any;
import oracle.security.spnego.IType;
import oracle.security.spnego.Set;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public abstract class Choice
extends Set {
    public Choice(Tag tag) {
        super("", tag);
    }

    public Choice(String name, Tag tag) {
        super(name, tag);
    }

    public Choice(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            if (value instanceof ArrayList) {
                this.value(value);
            } else {
                throw new ClassCastException();
            }
        }
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        this.reset();
        is.mark(Integer.MAX_VALUE);
        boolean found = false;
        try {
            IType e = is.decodeAny("choice");
            ListIterator it = this.iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                found = t.tag().equals(e.tag());
                if (!found) continue;
                t.value(e.value());
                break;
            }
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
        if (!found && !this.isOptional()) {
            throw new ASNException(1, "Decoding CHOICE");
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        boolean found = false;
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            found = !t.isBlank();
            if (!found) continue;
            t.encode(os);
            break;
        }
        if (!found && !this.isOptional()) {
            throw new ASNException(0, "Encoding CHOICE");
        }
    }

    @Override
    public void value(Object value) {
        this.reset();
        if (value instanceof Any) {
            Any src = (Any)value;
            ListIterator dst = this.iterator();
            while (dst.hasNext()) {
                IType td = (IType)dst.next();
                if (!td.tag().equals(src.tag())) continue;
                td.value(src.value());
                break;
            }
        } else {
            if (value instanceof IType) {
                value = ((IType)value).value();
            }
            Iterator src = value instanceof ArrayList ? ((ArrayList)value).iterator() : ((ArrayList)((Any)value).value()).iterator();
            ListIterator dst = this.iterator();
            while (src.hasNext() && dst.hasNext()) {
                IType ts = (IType)src.next();
                IType td = (IType)dst.next();
                td.value(ts.value());
            }
        }
    }

    @Override
    public String toString() {
        String cn = this.getClass().getName();
        String ls = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(ls);
        sb.append("-- Begin ").append(cn).append(" (CHOICE)").append(ls);
        int i = 1;
        boolean found = false;
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            boolean bl = found = !t.isBlank();
            if (found) {
                sb.append("--   alternative #").append(i).append(" (").append(t.getClass().getName()).append("): ").append(String.valueOf(t)).append(ls);
                break;
            }
            ++i;
        }
        if (!found) {
            sb.append("--   N/A").append(ls);
        }
        sb.append("-- End ").append(cn).append(" (CHOICE)");
        return sb.toString();
    }
}

