/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public abstract class ASNString
extends Type
implements IType {
    public ASNString(String name, Tag tag) {
        super(name, tag);
    }

    @Override
    public abstract void decode(ASNReader var1) throws IOException;

    @Override
    public abstract void encode(ASNWriter var1) throws IOException;

    @Override
    public void value(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof ASNString) {
            this.value = ((ASNString)value).stringValue();
        } else {
            throw new ClassCastException();
        }
    }

    public String stringValue() {
        return (String)this.value;
    }

    @Override
    protected boolean sameValue(Object obj) {
        String val = this.stringValue();
        return val == null ? false : val.equals(obj);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append("\"").append(this.stringValue()).append("\"");
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }

    void decodeInternal(ASNReader is, int tagValue) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            String result = is.decodeString(tagValue, this);
            if (result == null) {
                throw new ASNException(1, "Decoding STRING");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    void encodeInternal(ASNWriter os, int tagValue) throws IOException {
        Object val = this.value();
        if (val != null) {
            os.encodeString(tagValue, this, (String)val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeString(tagValue, this, (String)val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding STRING");
            }
        }
    }
}

