/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.util.Logger;

public class InputStreamLoggingWrapper
extends FilterInputStream {
    private String streamClass;
    private static Class<?> CLAZZ = InputStreamLoggingWrapper.class;
    private int dupInfoCount;
    private String lastInfo;
    private int dupFineCount;
    private String lastFine;

    private void logInfoNoDup(String msg) {
        if (msg.equals(this.lastInfo)) {
            ++this.dupInfoCount;
        } else {
            if (this.dupInfoCount > 0) {
                Logger.info(CLAZZ, (String)String.format("[%s] . . . x%d", this.streamClass, this.dupInfoCount));
                this.dupInfoCount = 0;
            }
            this.lastInfo = msg;
            Logger.info(CLAZZ, (String)msg);
        }
    }

    private void logFineNoDup(String msg) {
        if (msg.equals(this.lastFine)) {
            ++this.dupFineCount;
        } else {
            if (this.dupFineCount > 0) {
                Logger.fine(CLAZZ, (String)String.format("[%s] . . . x%d", this.streamClass, this.dupFineCount));
                this.dupFineCount = 0;
            }
            this.lastFine = msg;
            Logger.fine(CLAZZ, (String)msg);
        }
    }

    public InputStreamLoggingWrapper(InputStream in) {
        super(in);
        this.streamClass = this.getWrappedStreamClass(in);
        Logger.info(CLAZZ, (String)String.format("streamClass=%s", this.streamClass));
    }

    private String getWrappedStreamClass(InputStream in) {
        return in.getClass().getSimpleName() + "@" + Integer.toHexString(in.hashCode());
    }

    @Override
    public int read() throws IOException {
        this.logFineNoDup(String.format("[%s] read()", this.streamClass));
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int retVal = super.read(b);
        this.logFineNoDup(String.format("[%s] read(b[]) = %d", this.streamClass, retVal));
        return retVal;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retVal = super.read(b, off, len);
        this.logFineNoDup(String.format("[%s] read(b[], %d, %d) = %d", this.streamClass, off, len, retVal));
        return retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        long retVal = super.skip(n);
        Logger.info(CLAZZ, (String)String.format("[%s] skip(%d)=%d", this.streamClass, n, retVal));
        return retVal;
    }

    @Override
    public int available() throws IOException {
        int retVal = super.available();
        Logger.info(CLAZZ, (String)String.format("[%s] available()=%d", this.streamClass, retVal));
        return retVal;
    }

    @Override
    public void close() throws IOException {
        Logger.info(CLAZZ, (String)String.format("[%s] close()", this.streamClass));
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        Logger.info(CLAZZ, (String)String.format("[%s] mark(%d)", this.streamClass, readlimit));
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        Logger.info(CLAZZ, (String)String.format("[%s] reset()", this.streamClass));
        super.reset();
    }

    @Override
    public boolean markSupported() {
        boolean retVal = super.markSupported();
        Logger.info(CLAZZ, (String)String.format("[%s] markSupported()=%b", this.streamClass, retVal));
        return retVal;
    }
}

