/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagValue;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RestProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.util.AutoBastionUtil;
import oracle.dbtools.util.BastionHost;
import oracle.dbtools.util.BastionSSHTunnel;
import oracle.dbtools.util.BastionSession;
import oracle.dbtools.util.OpenSSH_PKCS8KeyPairGenerator;
import oracle.jdbc.datasource.impl.OracleDataSource;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;

public class OCIConnector
extends AbstractConnector {
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";

    public OCIConnector(ConnectorArgs args) {
        super(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection connect() {
        String ocid;
        String profile;
        Connection conn = null;
        ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
        if (sqlcl != null && sqlcl.getConn() != null) {
            this.OCIConnClear(this.ctx);
        }
        if ((profile = (String)this.ctx.getProperty("oci.profile.name")) == null) {
            this.ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
            return null;
        }
        String region = (String)this.ctx.getProperty(OCI_REGION_NAME);
        if (region == null) {
            region = this.set_region_home(profile, this.ctx);
        }
        if (!this.isDatabaseToolsConnectionOCID(ocid = this.connectionSpec.toLowerCase(), this.ctx)) {
            return null;
        }
        if (!this.validateOCID(ocid, this.ctx)) {
            return null;
        }
        if (!this.isOCIDRegionMatch(ocid, this.ctx)) {
            return null;
        }
        if (this.properties.getValueOf((Property)RestProperty.REST) != FlagValue.PRESENT) {
            if (!this.isDatabaseToolsConnectionOCID(ocid, this.ctx)) {
                return null;
            }
            if (!this.isOCIDRegionMatch(ocid, this.ctx)) {
                return null;
            }
            try {
                WalletValue walletValue;
                OCIProfiles p = new OCIProfiles();
                OCIRESTClient client = p.getOciClient(profile);
                String oci_url = OCIConnector.generateOCIurl(region, ocid);
                URI root = URI.create(oci_url);
                OCIRequest req = new OCIRequest.Builder().host(root.getHost()).method("get").target("/20201005/databaseToolsConnections/" + ocid).build();
                String baseInfo = client.getString(req);
                JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
                Map map = j.mapFrom((Object)baseInfo);
                if (this.isUnauthorizedError(map, this.ctx)) {
                    return null;
                }
                String isPE = (String)map.get("privateEndpointId");
                String username = (String)map.get("userName");
                String connString = (String)map.get("connectionString");
                String secretOCID = (String)((Map)map.get("userPassword")).get("secretId");
                String secret_host = "secrets.vaults." + region + ".oci.oraclecloud.com";
                req = new OCIRequest.Builder().host(secret_host).method("get").target("/20190301/secretbundles/" + secretOCID + "?stage=CURRENT").build();
                Properties props = new Properties();
                String secretJson = client.getString(req);
                Map secretMap = j.mapFrom((Object)secretJson);
                String passwdEncoded = (String)((Map)secretMap.get("secretBundleContent")).get("content");
                String password = new String(Base64.getDecoder().decode(passwdEncoded.getBytes()));
                props.put("user", username);
                props.put("password", password);
                String autonomousDatabaseID = (String)((Map)map.get("relatedResource")).get("identifier");
                String walletSecret = "{\"generateType\": \"SINGLE\", \"password\": \"al123@#@#skjfalskjfaslkdfja\"}";
                String wallet_host = "database." + region + ".oraclecloud.com";
                req = new OCIRequest.Builder().host(wallet_host).contentType("application/json").body(walletSecret).method("post").target("/20160918/autonomousDatabases/" + autonomousDatabaseID + "/actions/generateWallet/").build();
                this.ctx.getOutputStream().flush();
                CloseableHttpResponse response = client.getResponse(req);
                HttpEntity ent = response.getEntity();
                req = new OCIRequest.Builder().host(wallet_host).method("get").target("/20160918/autonomousDatabases/" + autonomousDatabaseID).build();
                String walletInfo = client.getString(req);
                JSON jWallet = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
                Map walletMap = jWallet.mapFrom((Object)walletInfo);
                String dburl = (String)((Map)((ArrayList)((Map)walletMap.get("connectionStrings")).get("profiles")).get(0)).get("displayName");
                if (response.getCode() != 200) {
                    String url = "jdbc:oracle:thin:@" + connString;
                    Class.forName("oracle.jdbc.OracleDriver");
                    Connection oracleConnection = DriverManager.getConnection(url, props);
                    this.setConnection(this.ctx, props, oracleConnection);
                    return oracleConnection;
                }
                try (InputStream inputStream = ent.getContent();){
                    ArrayList errors = new ArrayList();
                    walletValue = WalletValue.create((ScriptRunnerContext)this.ctx, (String)dburl, (InputStream)inputStream, errors::add);
                    if (!errors.isEmpty()) {
                        Iterator iterator = errors.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.ctx.getOutputStream().flush();
                                iterator = null;
                                return iterator;
                            }
                            String error = (String)iterator.next();
                            this.ctx.write(error);
                        }
                    }
                }
                this.ctx.getOutputStream().flush();
                if (isPE != null) {
                    try {
                        this.ctx.write(CommandMessages.getString("OCI_CREATING_BASTION"));
                        this.ctx.getOutputStream().flush();
                        BastionHost bastionHost = new BastionHost(ocid, client, region);
                        String bastionId = bastionHost.getBastionId();
                        Thread.sleep(60000L);
                        OpenSSH_PKCS8KeyPairGenerator opensshKeys = new OpenSSH_PKCS8KeyPairGenerator();
                        String publicKey = opensshKeys.getPublicKey();
                        String privateKeyPath = opensshKeys.getPrivateKeyPath();
                        BastionSession bastionSession = new BastionSession(ocid, client, region, bastionId, publicKey);
                        String bastionSessionId = bastionSession.getBastionSessionId();
                        this.ctx.write(CommandMessages.getString("OCI_CREATING_SESSION"));
                        this.ctx.getOutputStream().flush();
                        Thread.sleep(25000L);
                        this.ctx.write(CommandMessages.getString("OCI_CREATING_SSH_TUNNEL"));
                        this.ctx.getOutputStream().flush();
                        AutoBastionUtil autoBastionUtil = new AutoBastionUtil(ocid, client, region);
                        int databasePort = Integer.parseInt(autoBastionUtil.getDatabasePort());
                        String databaseIP = autoBastionUtil.getDbEndpointIP();
                        BastionSSHTunnel bastionSSHTunnel = new BastionSSHTunnel(privateKeyPath);
                        String bastionHostId = "host.bastion." + region + ".oci.oraclecloud.com";
                        Tunnel sshTunnel = bastionSSHTunnel.openTunnel(this.ctx, databasePort, databaseIP, bastionHostId, bastionSessionId, 22);
                        String databaseConnString = autoBastionUtil.getDatabaseConnString();
                        dburl = autoBastionUtil.modifyDBurl();
                    }
                    catch (SQLException e) {
                        this.ctx.write(e.getMessage() + "\n");
                        this.ctx.getOutputStream().flush();
                        return null;
                    }
                }
                String url = "jdbc:oracle:thin:@" + dburl;
                OracleDataSource dataSource = new OracleDataSource();
                walletValue.configureDataSource((oracle.jdbc.datasource.OracleDataSource)dataSource, url, props, this.properties);
                conn = dataSource.getConnection();
                this.setConnection(this.ctx, props, conn);
                return conn;
            }
            catch (IOException | ClassNotFoundException | InterruptedException | GeneralSecurityException | SQLException | ParseException e) {
                this.ctx.write(e.getMessage());
                return null;
            }
        }
        String config_filepath = this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) != null ? (String)this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) : "~/.oci/config";
        Properties props = new Properties();
        props.put("oci_config_filepath", config_filepath);
        props.put("oci_profile", profile);
        props.put("region", region);
        try {
            Connection restConnection = DriverManager.getConnection(ocid, props);
            this.setConnection(this.ctx, props, restConnection);
            return restConnection;
        }
        catch (SQLException e) {
            this.ctx.write(e.getMessage());
        }
        return null;
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }

    private String set_region_home(String profile, ScriptRunnerContext ctx) {
        OCIProfiles profiles = new OCIProfiles();
        String region = null;
        try {
            Properties pProps = profiles.getProperties();
            region = pProps.getProperty(profile + "/region");
            ctx.putProperty(OCI_REGION_NAME, (Object)region);
            ctx.write("Region set to: " + region + "\n");
        }
        catch (IOException e) {
            ctx.write(e.getLocalizedMessage() + "\n");
        }
        return region;
    }

    private boolean validateOCID(String ocid, ScriptRunnerContext ctx) {
        String[] parts = ocid.replace("\n", "").split("\\.");
        return parts[0].contains("ocid");
    }

    private boolean isDatabaseToolsConnectionOCID(String ocid, ScriptRunnerContext ctx) {
        if (ocid.contains(":") && ocid.substring(0, 4).equalsIgnoreCase("ocid")) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_OCID"));
            return false;
        }
        String[] parts = ocid.replace("\n", "").split("\\.");
        if (!parts[1].equalsIgnoreCase("databasetoolsconnection")) {
            try {
                throw new SQLException(CommandMessages.getString("OCI_INCORRECT_OCID") + CommandMessages.format("OCI_INCORRECT_PROVIDED_OCID", parts[1]));
            }
            catch (SQLException e) {
                ctx.write(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean isOCIDRegionMatch(String ocid, ScriptRunnerContext ctx) {
        String[] parts = ocid.replace("\n", "").split("\\.");
        String ocid_region = parts[3];
        String set_region = (String)ctx.getProperty(OCI_REGION_NAME);
        if (ocid_region.equals("phx") && set_region.equals("us-phoenix-1")) {
            return true;
        }
        if (!ctx.getProperty(OCI_REGION_NAME).equals(ocid_region)) {
            ctx.write(CommandMessages.getString("OCI_REGION_ERROR"));
            ctx.write(CommandMessages.format("OCI_REGION_CURRENT", ocid_region));
            ctx.write(CommandMessages.format("OCI_REGION_SET", ctx.getProperty(OCI_REGION_NAME)));
            return false;
        }
        return true;
    }

    private static String generateOCIurl(String region, String ocid) {
        if (!((String)ocid).endsWith("/")) {
            ocid = (String)ocid + "/";
        }
        Object url = "https://";
        if (region.contains("r1")) {
            url = (String)url + "test-04.";
        }
        if (!region.contains("r1")) {
            url = (String)url + "dbtools.";
        }
        url = region.contains(".") ? (String)url + region + "/20201005/ords/" + (String)ocid : (String)url + region + ".oci.oraclecloud.com/20201005/ords/" + (String)ocid;
        return url;
    }

    private boolean isUnauthorizedError(Map<String, Object> map, ScriptRunnerContext ctx) {
        if (map.containsKey("code")) {
            if (((String)map.get("code")).equalsIgnoreCase("NotAuthorizedOrNotFound")) {
                ctx.write((String)map.get("message") + "\n");
                ctx.write(CommandMessages.getString("OCI_INVALID_OCID"));
            }
            return true;
        }
        return false;
    }

    private void setConnection(ScriptRunnerContext ctx, Properties props, Connection conn) throws SQLException {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        if (sqlcl != null) {
            if (conn != null) {
                sqlcl.setConn(conn);
                sqlcl.getScriptRunnerContext().setCurrentConnection(conn);
                sqlcl.getScriptRunnerContext().setBaseConnection(conn);
                sqlcl.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", (Object)Boolean.FALSE);
                ctx.putProperty("cli.conn.props", (Object)props);
            } else {
                ctx.write(CommandMessages.getString("OCI_CONN_FAILED"));
            }
        }
    }
}

