/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.generated.server;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectIds;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ORAData;

public class OdmrProject {
    protected Connection __onn = null;
    protected DataSource __dataSource = null;

    public void setDataSource(DataSource dataSource) throws SQLException {
        this.release();
        this.__dataSource = dataSource;
    }

    public void setDataSourceLocation(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.InitialContext");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("lookup", String.class);
            DataSource dataSource = (DataSource)method.invoke(obj, "java:comp/env/" + string);
            this.setDataSource(dataSource);
        }
        catch (Exception exception) {
            throw new SQLException("Error initializing DataSource at " + string + ": " + exception.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.__onn != null) {
            return this.__onn;
        }
        if (this.__dataSource != null) {
            this.__onn = this.__dataSource.getConnection();
        }
        return this.__onn;
    }

    public void release() throws SQLException {
        this.__onn = null;
        this.__dataSource = null;
    }

    public void closeConnection() {
        if (this.__dataSource != null) {
            try {
                if (this.__onn != null) {
                    this.__onn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.__onn = null;
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public OdmrProject() throws SQLException {
    }

    public OdmrProject(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public OdmrProject(DataSource dataSource) throws SQLException {
        this.__dataSource = dataSource;
    }

    public BigDecimal projectCreate(String string, String string2) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_PROJECT\".PROJECT_CREATE(:2 ,:3 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string2);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_PROJECT\".PROJECT_CREATE(:2 ,:3 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string2);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal;
    }

    public void setComment(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".SET_COMMENT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".SET_COMMENT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void projectRename(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_RENAME(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_RENAME(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void projectDelete(OdmrObjectIds odmrObjectIds) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_DELETE(:1 ); END;");
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(1, (ORAData)odmrObjectIds);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_DELETE(:1 ); END;");
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(1, (ORAData)odmrObjectIds);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void projectDelete(BigDecimal bigDecimal) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_DELETE(:1 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_PROJECT\".PROJECT_DELETE(:1 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }
}

