/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;

public class Table {
    private String schema;
    private String name;
    private String type;
    private String synonymName;
    private String synonymSchema;
    private Map<String, AttributeType> columns;

    public Table() {
        this(null, null);
    }

    public Table(String string, String string2) {
        this(string, string2, null, null);
    }

    public Table(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Table(String string, String string2, Map<String, AttributeType> map) {
        this(string, string2, null, map);
    }

    public Table(String string, String string2, String string3, Map<String, AttributeType> map) {
        this.schema = string;
        this.name = string2;
        this.type = string3;
        this.columns = map;
    }

    public Table(TableType tableType) {
        this.schema = tableType.getSchema();
        this.name = tableType.getName();
        if (null != tableType.isSynonym() && tableType.isSynonym().booleanValue()) {
            this.type = CoreCommonLrb.get("SYNONYM_UP");
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isSynonym() {
        boolean bl = CoreCommonLrb.get("SYNONYM_UP").equals(this.type);
        return bl;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setSynonymName(String string) {
        this.synonymName = string;
    }

    public String getSynonymName() {
        if (this.isSynonym()) {
            return this.synonymName;
        }
        return this.getName();
    }

    public void setSynonymSchema(String string) {
        this.synonymSchema = string;
    }

    public String getSynonymSchema() {
        if (this.isSynonym()) {
            return this.synonymSchema;
        }
        return this.getSchema();
    }

    public String getFullName() {
        return this.getSchema() + "." + this.getName();
    }

    public List<AttributeType> getColumnList() {
        Collection<AttributeType> collection = this.columns.values();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(collection.size());
        arrayList.addAll(collection);
        return arrayList;
    }

    public Map<String, AttributeType> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, AttributeType> map) {
        this.columns = map;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Table) {
            Table table = (Table)object;
            bl = ObjectUtils.areEqual(this.getSchema(), table.getSchema()) && ObjectUtils.areEqual(this.getName(), table.getName()) && ObjectUtils.areEqual(this.getType(), table.getType()) && ObjectUtils.areEqual(this.getSynonymSchema(), table.getSynonymSchema()) && ObjectUtils.areEqual(this.getSynonymName(), table.getSynonymName());
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.schema);
        n += ObjectUtils.hashCode(this.name);
        n += ObjectUtils.hashCode(this.type);
        n += ObjectUtils.hashCode(this.synonymSchema);
        return n += ObjectUtils.hashCode(this.synonymName);
    }

    public String toString() {
        if (this.getSchema() == null || this.getName() == null) {
            return "";
        }
        return this.getFullName();
    }
}

