/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build.partition;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;

public class PartitionVO {
    public static final String PARTITION_ID = "PARTITION";
    private String partitionID;
    private String partitionName;
    private List<PartitionColumn> columns;

    public PartitionVO(String string, String string2) {
        this(string, string2, null);
    }

    public PartitionVO(String string, String string2, List<PartitionColumn> list) {
        assert (string2 != null) : "Name can't be null";
        this.partitionID = string;
        this.partitionName = string2;
        this.columns = list == null ? new LinkedList<PartitionColumn>() : list;
    }

    public String getPartitionID() {
        return this.partitionID;
    }

    public void setPartitionID(String string) {
        this.partitionID = string;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String string) {
        this.partitionName = string;
    }

    public List<PartitionColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void setColumns(List<PartitionColumn> list) {
        this.columns = list;
    }

    public static PartitionVO createEmpty() {
        return new PartitionVO("", "");
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PartitionVO) {
            PartitionVO partitionVO = (PartitionVO)object;
            boolean bl2 = this.partitionName.equals(partitionVO.getPartitionName());
            boolean bl3 = true;
            if (this.partitionID != null) {
                bl3 = this.partitionID.equals(partitionVO.getPartitionID());
            }
            bl = bl2 & bl3;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + Objects.hashCode(this.partitionID);
        n = 67 * n + Objects.hashCode(this.partitionName);
        return n;
    }
}

