/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ASSOAGGREGATES;
import oracle.dmt.dataminer.workflow.xmlschema.RuleItemsType;

public class ServerConstants {
    public static final int APPLY_TOPN_MAX_VALUE = Integer.MAX_VALUE;
    public static final int QUERY_TIMEOUT = 5;

    public static class EventLog {
        public static final String ERROR = "ERR";
        public static final String WARNING = "WARN";
        public static final String INFO = "INFO";
    }

    public static class JSONFilterOperators {
        public static final String JSON_FILTER_OP_IN = "In";
        public static final String JSON_FILTER_OP_NOT_IN = "NotIn";
        public static final String JSON_FILTER_OP_EQUAL = "Equal";
        public static final String JSON_FILTER_OP_NOT_EQUAL = "NotEqual";
        public static final String JSON_FILTER_OP_GREATER = "Greater";
        public static final String JSON_FILTER_OP_GREATER_EQUAL = "GreaterOrEqual";
        public static final String JSON_FILTER_OP_LESS = "Less";
        public static final String JSON_FILTER_OP_LESS_EQUAL = "LessOrEqual";
        public static final String JSON_FILTER_OP_CONTAIN = "Contain";
        public static final String JSON_FILTER_OP_START_WITH = "StartWith";

        public static String toSchema(String string) {
            if (string.equals(SETTINGS.JSON_FILTER_OP_IN.value())) {
                return JSON_FILTER_OP_IN;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_NOT_IN.value())) {
                return JSON_FILTER_OP_NOT_IN;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_EQUAL.value())) {
                return JSON_FILTER_OP_EQUAL;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_NOT_EQUAL.value())) {
                return JSON_FILTER_OP_NOT_EQUAL;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_GREATER.value())) {
                return JSON_FILTER_OP_GREATER;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_GREATER_EQUAL.value())) {
                return JSON_FILTER_OP_GREATER_EQUAL;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_LESS.value())) {
                return JSON_FILTER_OP_LESS;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_LESS_EQUAL.value())) {
                return JSON_FILTER_OP_LESS_EQUAL;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_CONTAIN.value())) {
                return JSON_FILTER_OP_CONTAIN;
            }
            if (string.equals(SETTINGS.JSON_FILTER_OP_START_WITH.value())) {
                return JSON_FILTER_OP_START_WITH;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(JSON_FILTER_OP_IN)) {
                return SETTINGS.JSON_FILTER_OP_IN.value();
            }
            if (string.equals(JSON_FILTER_OP_NOT_IN)) {
                return SETTINGS.JSON_FILTER_OP_NOT_IN.value();
            }
            if (string.equals(JSON_FILTER_OP_EQUAL)) {
                return SETTINGS.JSON_FILTER_OP_EQUAL.value();
            }
            if (string.equals(JSON_FILTER_OP_NOT_EQUAL)) {
                return SETTINGS.JSON_FILTER_OP_NOT_EQUAL.value();
            }
            if (string.equals(JSON_FILTER_OP_GREATER)) {
                return SETTINGS.JSON_FILTER_OP_GREATER.value();
            }
            if (string.equals(JSON_FILTER_OP_GREATER_EQUAL)) {
                return SETTINGS.JSON_FILTER_OP_GREATER_EQUAL.value();
            }
            if (string.equals(JSON_FILTER_OP_LESS)) {
                return SETTINGS.JSON_FILTER_OP_LESS.value();
            }
            if (string.equals(JSON_FILTER_OP_LESS_EQUAL)) {
                return SETTINGS.JSON_FILTER_OP_LESS_EQUAL.value();
            }
            if (string.equals(JSON_FILTER_OP_CONTAIN)) {
                return SETTINGS.JSON_FILTER_OP_CONTAIN.value();
            }
            if (string.equals(JSON_FILTER_OP_START_WITH)) {
                return SETTINGS.JSON_FILTER_OP_START_WITH.value();
            }
            return null;
        }

        public static boolean isOperatorIn(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_IN);
        }

        public static boolean isOperatorNotIn(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_NOT_IN);
        }

        public static boolean isOperatorEqual(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_EQUAL);
        }

        public static boolean isOperatorNotEqual(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_NOT_EQUAL);
        }

        public static boolean isOperatorGreater(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_GREATER);
        }

        public static boolean isOperatorGreaterEqual(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_GREATER_EQUAL);
        }

        public static boolean isOperatorLess(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_LESS);
        }

        public static boolean isOperatorLessEqual(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_LESS_EQUAL);
        }

        public static boolean isOperatorContain(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_CONTAIN);
        }

        public static boolean isOperatorStartWith(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(JSON_FILTER_OP_START_WITH);
        }

        public static enum SETTINGS {
            JSON_FILTER_OP_IN("In"),
            JSON_FILTER_OP_NOT_IN("Not In"),
            JSON_FILTER_OP_EQUAL("="),
            JSON_FILTER_OP_NOT_EQUAL("!="),
            JSON_FILTER_OP_GREATER(">"),
            JSON_FILTER_OP_GREATER_EQUAL(">="),
            JSON_FILTER_OP_LESS("<"),
            JSON_FILTER_OP_LESS_EQUAL("<="),
            JSON_FILTER_OP_CONTAIN("Contains"),
            JSON_FILTER_OP_START_WITH("Starts with");

            private final String value;

            private SETTINGS(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class JSONFilterApplySetting {
        public static final String APPLY_TYPE_ALL = "All";
        public static final String APPLY_TYPE_UNNEST = "Unnest";
        public static final String APPLY_TYPE_AGGREG = "Aggregation";

        public static String toSchema(String string) {
            if (string.equals(SETTINGS.APPLY_TYPE_ALL.value())) {
                return APPLY_TYPE_ALL;
            }
            if (string.equals(SETTINGS.APPLY_TYPE_UNNEST.value())) {
                return APPLY_TYPE_UNNEST;
            }
            if (string.equals(SETTINGS.APPLY_TYPE_AGGREG.value())) {
                return APPLY_TYPE_AGGREG;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(APPLY_TYPE_ALL)) {
                return SETTINGS.APPLY_TYPE_ALL.value();
            }
            if (string.equals(APPLY_TYPE_UNNEST)) {
                return SETTINGS.APPLY_TYPE_UNNEST.value();
            }
            if (string.equals(APPLY_TYPE_AGGREG)) {
                return SETTINGS.APPLY_TYPE_AGGREG.value();
            }
            return null;
        }

        public static boolean isApplyAll(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(APPLY_TYPE_ALL);
        }

        public static boolean isApplyAggreg(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(APPLY_TYPE_AGGREG);
        }

        public static boolean isApplyUnnest(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(APPLY_TYPE_UNNEST);
        }

        public static enum SETTINGS {
            APPLY_TYPE_ALL(CoreServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_ALL")),
            APPLY_TYPE_UNNEST(CoreServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_UNNEST")),
            APPLY_TYPE_AGGREG(CoreServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_AGGREG"));

            private final String value;

            private SETTINGS(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class JSONFilterMatchSetting {
        public static final String MATCH_TYPE_ALL = "All";
        public static final String MATCH_TYPE_ANY = "Any";

        public static String toSchema(String string) {
            if (string.equals(SETTINGS.MATCH_TYPE_ALL.value())) {
                return MATCH_TYPE_ALL;
            }
            if (string.equals(SETTINGS.MATCH_TYPE_ANY.value())) {
                return MATCH_TYPE_ANY;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(MATCH_TYPE_ALL)) {
                return SETTINGS.MATCH_TYPE_ALL.value();
            }
            if (string.equals(MATCH_TYPE_ANY)) {
                return SETTINGS.MATCH_TYPE_ANY.value();
            }
            return null;
        }

        public static boolean isMatchAll(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(MATCH_TYPE_ALL);
        }

        public static boolean isMatchAny(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(MATCH_TYPE_ANY);
        }

        public static enum SETTINGS {
            MATCH_TYPE_ALL(CoreServerConstantsLrb.get("JSON_FILTER_MATCH_TYPE_ALL")),
            MATCH_TYPE_ANY(CoreServerConstantsLrb.get("JSON_FILTER_MATCH_TYPE_ANY"));

            private final String value;

            private SETTINGS(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static final class SamplingType {
        public static final String SAMPLING_TYPE_RANDOM = "Random";
        public static final String SAMPLING_TYPE_STRATIFIED = "Stratified";
        public static final String SAMPLING_TYPE_SYS_DETERMINED = "System";

        public static String toSchema(String string) {
            if (SAMPLING_TYPE.SAMPLING_TYPE_RANDOM.value().equals(string)) {
                return SAMPLING_TYPE_RANDOM;
            }
            if (SAMPLING_TYPE.SAMPLING_TYPE_STRATIFIED.value().equals(string)) {
                return SAMPLING_TYPE_STRATIFIED;
            }
            if (SAMPLING_TYPE.SAMPLING_TYPE_SYS_DETERMINED.value().equals(string)) {
                return SAMPLING_TYPE_SYS_DETERMINED;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (SAMPLING_TYPE_RANDOM.equals(string)) {
                return SAMPLING_TYPE.SAMPLING_TYPE_RANDOM.value();
            }
            if (SAMPLING_TYPE_STRATIFIED.equals(string)) {
                return SAMPLING_TYPE.SAMPLING_TYPE_STRATIFIED.value();
            }
            if (SAMPLING_TYPE_SYS_DETERMINED.equals(string)) {
                return SAMPLING_TYPE.SAMPLING_TYPE_SYS_DETERMINED.value();
            }
            return null;
        }

        public static boolean isRandom(String string) {
            return SAMPLING_TYPE_RANDOM.equals(string);
        }

        public static boolean isStratified(String string) {
            return SAMPLING_TYPE_STRATIFIED.equals(string);
        }

        public static boolean isSysDetermined(String string) {
            return SAMPLING_TYPE_SYS_DETERMINED.equals(string);
        }

        private static enum SAMPLING_TYPE {
            SAMPLING_TYPE_RANDOM(CoreServerConstantsLrb.get("SAMPLING_TYPE_RANDOM")),
            SAMPLING_TYPE_STRATIFIED(CoreServerConstantsLrb.get("SAMPLING_TYPE_STRATIFIED")),
            SAMPLING_TYPE_SYS_DETERMINED(CoreServerConstantsLrb.get("SAMPLING_TYPE_SYS_DETERMINED"));

            private final String value;

            private SAMPLING_TYPE(String string2) {
                this.value = string2;
            }

            private String value() {
                return this.value;
            }
        }
    }

    public static class SplitDataFormat {
        public static final String SPLIT_DATA_FORMAT_TABLE = "Table";
        public static final String SPLIT_DATA_FORMAT_VIEW = "View";

        public static String toSchema(String string) {
            if (string.equals(SPLIT_DATA_FORMAT.SPLIT_DATA_FORMAT_TABLE.value())) {
                return SPLIT_DATA_FORMAT_TABLE;
            }
            if (string.equals(SPLIT_DATA_FORMAT.SPLIT_DATA_FORMAT_VIEW.value())) {
                return SPLIT_DATA_FORMAT_VIEW;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(SPLIT_DATA_FORMAT_TABLE)) {
                return SPLIT_DATA_FORMAT.SPLIT_DATA_FORMAT_TABLE.value();
            }
            if (string.equals(SPLIT_DATA_FORMAT_VIEW)) {
                return SPLIT_DATA_FORMAT.SPLIT_DATA_FORMAT_VIEW.value();
            }
            return null;
        }

        public static boolean isTable(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(SPLIT_DATA_FORMAT_TABLE);
        }

        public static boolean isView(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(SPLIT_DATA_FORMAT_VIEW);
        }

        public static enum SPLIT_DATA_FORMAT {
            SPLIT_DATA_FORMAT_TABLE(CoreServerConstantsLrb.get("SPLIT_DATA_FORMAT_TABLE")),
            SPLIT_DATA_FORMAT_VIEW(CoreServerConstantsLrb.get("SPLIT_DATA_FORMAT_VIEW"));

            private final String value;

            private SPLIT_DATA_FORMAT(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class TextTransformType {
        public static final String TEXT_TRANSFORM_TOKEN = "Token";
        public static final String TEXT_TRANSFORM_THEME = "Theme";
        public static final String TEXT_TRANSFORM_SYNONYM = "Synonym";

        public static String toSchema(String string) {
            if (string.equals(TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_TOKEN.value())) {
                return TEXT_TRANSFORM_TOKEN;
            }
            if (string.equals(TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_THEME.value())) {
                return TEXT_TRANSFORM_THEME;
            }
            if (string.equals(TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_SYNONYM.value())) {
                return TEXT_TRANSFORM_SYNONYM;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(TEXT_TRANSFORM_TOKEN)) {
                return TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_TOKEN.value();
            }
            if (string.equals(TEXT_TRANSFORM_THEME)) {
                return TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_THEME.value();
            }
            if (string.equals(TEXT_TRANSFORM_SYNONYM)) {
                return TEXT_TRANSFORM_TYPE.TEXT_TRANSFORM_SYNONYM.value();
            }
            return null;
        }

        public static boolean isToken(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(TEXT_TRANSFORM_TOKEN);
        }

        public static boolean isTheme(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(TEXT_TRANSFORM_THEME);
        }

        public static interface DEFAULTS {
            public static final int MIN_NUMBER_ALL_DOCS = 1;
        }

        public static enum TEXT_TRANSFORM_TYPE {
            TEXT_TRANSFORM_TOKEN(CoreServerConstantsLrb.get("TEXT_TRANSFORM_TOKEN")),
            TEXT_TRANSFORM_THEME(CoreServerConstantsLrb.get("TEXT_TRANSFORM_THEME")),
            TEXT_TRANSFORM_SYNONYM(CoreServerConstantsLrb.get("TEXT_TRANSFORM_SYNONYM"));

            private final String value;

            private TEXT_TRANSFORM_TYPE(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class StopTokenType {
        public static final String STOPLIST_TYPE_WORD = "Word";
        public static final String STOPLIST_TYPE_THEME = "Theme";
        public static final String STOPLIST_TYPE_UNKNOWN = "Unknown";

        public static String toSchema(String string) {
            if (string != null) {
                if (STOPLIST_TYPE.STOPLIST_TYPE_WORD.value().equals(string)) {
                    return STOPLIST_TYPE_WORD;
                }
                if (STOPLIST_TYPE.STOPLIST_TYPE_THEME.value().equals(string)) {
                    return STOPLIST_TYPE_THEME;
                }
                if (STOPLIST_TYPE.STOPLIST_TYPE_UNKNOWN.value().equals(string)) {
                    return STOPLIST_TYPE_UNKNOWN;
                }
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string != null) {
                if (STOPLIST_TYPE_WORD.equals(string)) {
                    return STOPLIST_TYPE.STOPLIST_TYPE_WORD.value();
                }
                if (STOPLIST_TYPE_THEME.equals(string)) {
                    return STOPLIST_TYPE.STOPLIST_TYPE_THEME.value();
                }
                if (STOPLIST_TYPE_UNKNOWN.equals(string)) {
                    return STOPLIST_TYPE.STOPLIST_TYPE_UNKNOWN.value();
                }
            }
            return null;
        }

        public static boolean isWord(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_TYPE_WORD);
        }

        public static boolean isTheme(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_TYPE_THEME);
        }

        public static boolean isUnknown(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_TYPE_UNKNOWN);
        }

        public static enum STOPLIST_TYPE {
            STOPLIST_TYPE_WORD(CoreServerConstantsLrb.get("STOPLIST_TYPE_WORD")),
            STOPLIST_TYPE_THEME(CoreServerConstantsLrb.get("STOPLIST_TYPE_THEME")),
            STOPLIST_TYPE_UNKNOWN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_UNKNOWN"));

            private final String value;

            private STOPLIST_TYPE(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class StoplistLanguage {
        public static final String STOPLIST_DEFAULT = "Default";
        public static final String STOPLIST_NONE = "None";
        public static final String STOPLIST_DEFAULT_ARABIC = "ARABIC";
        public static final String STOPLIST_DEFAULT_BULGARIAN = "BULGARIAN";
        public static final String STOPLIST_DEFAULT_CATALAN = "CATALAN";
        public static final String STOPLIST_DEFAULT_SIMPLIFIED_CHINESE = "SIMPLIFIED CHINESE";
        public static final String STOPLIST_DEFAULT_TRADITIONAL_CHINESE = "TRADITIONAL CHINESE";
        public static final String STOPLIST_DEFAULT_CROATIAN = "CROATIAN";
        public static final String STOPLIST_DEFAULT_CZECH = "CZECH";
        public static final String STOPLIST_DEFAULT_DANISH = "DANISH";
        public static final String STOPLIST_DEFAULT_DUTCH = "DUTCH";
        public static final String STOPLIST_DEFAULT_ENGLISH = "ENGLISH";
        public static final String STOPLIST_DEFAULT_ESTONIAN = "ESTONIAN";
        public static final String STOPLIST_DEFAULT_FINNISH = "FINNISH";
        public static final String STOPLIST_DEFAULT_FRENCH = "FRENCH";
        public static final String STOPLIST_DEFAULT_GERMAN = "GERMAN";
        public static final String STOPLIST_DEFAULT_GREEK = "GREEK";
        public static final String STOPLIST_DEFAULT_HEBREW = "HEBREW";
        public static final String STOPLIST_DEFAULT_HUNGARIAN = "HUNGARIAN";
        public static final String STOPLIST_DEFAULT_ITALIAN = "ITALIAN";
        public static final String STOPLIST_DEFAULT_JAPANESE = "JAPANESE";
        public static final String STOPLIST_DEFAULT_KOREAN = "KOREAN";
        public static final String STOPLIST_DEFAULT_MALAY = "MALAY";
        public static final String STOPLIST_DEFAULT_NORWEGIAN = "NORWEGIAN";
        public static final String STOPLIST_DEFAULT_POLISH = "POLISH";
        public static final String STOPLIST_DEFAULT_PORTUGUESE = "PORTUGUESE";
        public static final String STOPLIST_DEFAULT_ROMANIAN = "ROMANIAN";
        public static final String STOPLIST_DEFAULT_RUSSIAN = "RUSSIAN";
        public static final String STOPLIST_DEFAULT_SLOVAK = "SLOVAK";
        public static final String STOPLIST_DEFAULT_SPANISH = "SPANISH";
        public static final String STOPLIST_DEFAULT_SWEDISH = "SWEDISH";
        public static final String STOPLIST_DEFAULT_THAI = "THAI";
        public static final String STOPLIST_DEFAULT_TURKISH = "TURKISH";
        public static final String STOPLIST_DEFAULT_SINGLE = "Basic";
        public static final String STOPLIST_DEFAULT_MULTIPLE = "Multi";
        public static final String STOPLIST_DEFAULT_ALL = "All";
        public static final String STOPLIST_DEFAULT_UNKNOWN = "Unknown";

        public static boolean isAutoLexerCompatible(String string) {
            for (AUTO_LEXER_LANG aUTO_LEXER_LANG : AUTO_LEXER_LANG.values()) {
                if (!string.equals(aUTO_LEXER_LANG.value)) continue;
                return true;
            }
            return false;
        }

        public static String toSchema(String string) {
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_DEFAULT.value())) {
                return STOPLIST_DEFAULT;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_NONE.value())) {
                return STOPLIST_NONE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ARABIC.value())) {
                return STOPLIST_DEFAULT_ARABIC;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_BULGARIAN.value())) {
                return STOPLIST_DEFAULT_BULGARIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_CATALAN.value())) {
                return STOPLIST_DEFAULT_CATALAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_CROATIAN.value())) {
                return STOPLIST_DEFAULT_CROATIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_CZECH.value())) {
                return STOPLIST_DEFAULT_CZECH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_GREEK.value())) {
                return STOPLIST_DEFAULT_GREEK;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_HEBREW.value())) {
                return STOPLIST_DEFAULT_HEBREW;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_HUNGARIAN.value())) {
                return STOPLIST_DEFAULT_HUNGARIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_JAPANESE.value())) {
                return STOPLIST_DEFAULT_JAPANESE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_KOREAN.value())) {
                return STOPLIST_DEFAULT_KOREAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ESTONIAN.value())) {
                return STOPLIST_DEFAULT_ESTONIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_MALAY.value())) {
                return STOPLIST_DEFAULT_MALAY;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_POLISH.value())) {
                return STOPLIST_DEFAULT_POLISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_RUSSIAN.value())) {
                return STOPLIST_DEFAULT_RUSSIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_NORWEGIAN.value())) {
                return STOPLIST_DEFAULT_NORWEGIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_SLOVAK.value())) {
                return STOPLIST_DEFAULT_SLOVAK;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ROMANIAN.value())) {
                return STOPLIST_DEFAULT_ROMANIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_THAI.value())) {
                return STOPLIST_DEFAULT_THAI;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_TURKISH.value())) {
                return STOPLIST_DEFAULT_TURKISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ENGLISH.value())) {
                return STOPLIST_DEFAULT_ENGLISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_TRADITIONAL_CHINESE.value())) {
                return STOPLIST_DEFAULT_TRADITIONAL_CHINESE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_SIMPLIFIED_CHINESE.value())) {
                return STOPLIST_DEFAULT_SIMPLIFIED_CHINESE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_DANISH.value())) {
                return STOPLIST_DEFAULT_DANISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_DUTCH.value())) {
                return STOPLIST_DEFAULT_DUTCH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_FINNISH.value())) {
                return STOPLIST_DEFAULT_FINNISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_FRENCH.value())) {
                return STOPLIST_DEFAULT_FRENCH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_GERMAN.value())) {
                return STOPLIST_DEFAULT_GERMAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ITALIAN.value())) {
                return STOPLIST_DEFAULT_ITALIAN;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_PORTUGUESE.value())) {
                return STOPLIST_DEFAULT_PORTUGUESE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_SPANISH.value())) {
                return STOPLIST_DEFAULT_SPANISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_SWEDISH.value())) {
                return STOPLIST_DEFAULT_SWEDISH;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_SINGLE.value())) {
                return STOPLIST_DEFAULT_SINGLE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_MULTIPLE.value())) {
                return STOPLIST_DEFAULT_MULTIPLE;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_ALL.value())) {
                return STOPLIST_DEFAULT_ALL;
            }
            if (string.equals(STOPLIST_LANG.STOPLIST_LANG_UNKNOWN.value())) {
                return STOPLIST_DEFAULT_UNKNOWN;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(STOPLIST_DEFAULT)) {
                return STOPLIST_LANG.STOPLIST_LANG_DEFAULT.value();
            }
            if (string.equals(STOPLIST_NONE)) {
                return STOPLIST_LANG.STOPLIST_LANG_NONE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ARABIC)) {
                return STOPLIST_LANG.STOPLIST_LANG_ARABIC.value();
            }
            if (string.equals(STOPLIST_DEFAULT_BULGARIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_BULGARIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_CATALAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_CATALAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_CROATIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_CROATIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_CZECH)) {
                return STOPLIST_LANG.STOPLIST_LANG_CZECH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_GREEK)) {
                return STOPLIST_LANG.STOPLIST_LANG_GREEK.value();
            }
            if (string.equals(STOPLIST_DEFAULT_HEBREW)) {
                return STOPLIST_LANG.STOPLIST_LANG_HEBREW.value();
            }
            if (string.equals(STOPLIST_DEFAULT_HUNGARIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_HUNGARIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_JAPANESE)) {
                return STOPLIST_LANG.STOPLIST_LANG_JAPANESE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_KOREAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_KOREAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ESTONIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_ESTONIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_MALAY)) {
                return STOPLIST_LANG.STOPLIST_LANG_MALAY.value();
            }
            if (string.equals(STOPLIST_DEFAULT_POLISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_POLISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_RUSSIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_RUSSIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_NORWEGIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_NORWEGIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_SLOVAK)) {
                return STOPLIST_LANG.STOPLIST_LANG_SLOVAK.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ROMANIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_ROMANIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_THAI)) {
                return STOPLIST_LANG.STOPLIST_LANG_THAI.value();
            }
            if (string.equals(STOPLIST_DEFAULT_TURKISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_TURKISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ENGLISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_ENGLISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_TRADITIONAL_CHINESE)) {
                return STOPLIST_LANG.STOPLIST_LANG_TRADITIONAL_CHINESE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_SIMPLIFIED_CHINESE)) {
                return STOPLIST_LANG.STOPLIST_LANG_SIMPLIFIED_CHINESE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_DANISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_DANISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_DUTCH)) {
                return STOPLIST_LANG.STOPLIST_LANG_DUTCH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_FINNISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_FINNISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_FRENCH)) {
                return STOPLIST_LANG.STOPLIST_LANG_FRENCH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_GERMAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_GERMAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ITALIAN)) {
                return STOPLIST_LANG.STOPLIST_LANG_ITALIAN.value();
            }
            if (string.equals(STOPLIST_DEFAULT_PORTUGUESE)) {
                return STOPLIST_LANG.STOPLIST_LANG_PORTUGUESE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_SPANISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_SPANISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_SWEDISH)) {
                return STOPLIST_LANG.STOPLIST_LANG_SWEDISH.value();
            }
            if (string.equals(STOPLIST_DEFAULT_SINGLE)) {
                return STOPLIST_LANG.STOPLIST_LANG_SINGLE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_MULTIPLE)) {
                return STOPLIST_LANG.STOPLIST_LANG_MULTIPLE.value();
            }
            if (string.equals(STOPLIST_DEFAULT_ALL)) {
                return STOPLIST_LANG.STOPLIST_LANG_ALL.value();
            }
            if (string.equals(STOPLIST_DEFAULT_UNKNOWN)) {
                return STOPLIST_LANG.STOPLIST_LANG_UNKNOWN.value();
            }
            return null;
        }

        public static boolean isDefault(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_DEFAULT.equals(string);
        }

        public static boolean isNone(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_NONE.equals(string);
        }

        public static boolean isSingle(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_DEFAULT_SINGLE.equals(string);
        }

        public static boolean isMultiple(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_DEFAULT_MULTIPLE.equals(string);
        }

        public static boolean isALL(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_DEFAULT_ALL.equals(string);
        }

        public static boolean isUnknown(String string) {
            if (string == null) {
                return false;
            }
            return STOPLIST_DEFAULT_UNKNOWN.equals(string);
        }

        public static boolean isTraditionalChinese(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_DEFAULT_TRADITIONAL_CHINESE);
        }

        public static boolean isSimplifiedChinese(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_DEFAULT_SIMPLIFIED_CHINESE);
        }

        public static boolean isJapanese(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_DEFAULT_JAPANESE);
        }

        public static boolean isKorean(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STOPLIST_DEFAULT_KOREAN);
        }

        public static enum STOPLIST_LANG {
            STOPLIST_LANG_ARABIC(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ARABIC")),
            STOPLIST_LANG_BULGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_BULGARIAN")),
            STOPLIST_LANG_CATALAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CATALAN")),
            STOPLIST_LANG_SIMPLIFIED_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SIMPLIFIED_CHINESE")),
            STOPLIST_LANG_TRADITIONAL_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TRADITIONAL_CHINESE")),
            STOPLIST_LANG_CROATIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CROATIAN")),
            STOPLIST_LANG_CZECH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CZECH")),
            STOPLIST_LANG_DANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DANISH")),
            STOPLIST_LANG_DUTCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DUTCH")),
            STOPLIST_LANG_ENGLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ENGLISH")),
            STOPLIST_LANG_ESTONIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ESTONIAN")),
            STOPLIST_LANG_FINNISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FINNISH")),
            STOPLIST_LANG_FRENCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FRENCH")),
            STOPLIST_LANG_GERMAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GERMAN")),
            STOPLIST_LANG_GREEK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GREEK")),
            STOPLIST_LANG_HEBREW(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HEBREW")),
            STOPLIST_LANG_HUNGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HUNGARIAN")),
            STOPLIST_LANG_ITALIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ITALIAN")),
            STOPLIST_LANG_JAPANESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_JAPANESE")),
            STOPLIST_LANG_KOREAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_KOREAN")),
            STOPLIST_LANG_MALAY(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_MALAY")),
            STOPLIST_LANG_NORWEGIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_NORWEGIAN")),
            STOPLIST_LANG_POLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_POLISH")),
            STOPLIST_LANG_PORTUGUESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_PORTUGUESE")),
            STOPLIST_LANG_ROMANIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ROMANIAN")),
            STOPLIST_LANG_RUSSIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_RUSSIAN")),
            STOPLIST_LANG_SLOVAK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SLOVAK")),
            STOPLIST_LANG_SPANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SPANISH")),
            STOPLIST_LANG_SWEDISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SWEDISH")),
            STOPLIST_LANG_THAI(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_THAI")),
            STOPLIST_LANG_TURKISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TURKISH")),
            STOPLIST_LANG_DEFAULT(CoreServerConstantsLrb.get("STOPLIST_DEFAULT")),
            STOPLIST_LANG_NONE(CoreServerConstantsLrb.get("STOPLIST_NONE")),
            STOPLIST_LANG_SINGLE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SINGLE")),
            STOPLIST_LANG_MULTIPLE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_MULTIPLE")),
            STOPLIST_LANG_ALL(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ALL")),
            STOPLIST_LANG_UNKNOWN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_UNKNOWN"));

            private final String value;

            private STOPLIST_LANG(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum BASIC_LEXER_LANG_SINGLE_BYTE {
            STOPLIST_LANG_ARABIC(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ARABIC")),
            STOPLIST_LANG_BULGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_BULGARIAN")),
            STOPLIST_LANG_CATALAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CATALAN")),
            STOPLIST_LANG_CROATIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CROATIAN")),
            STOPLIST_LANG_CZECH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CZECH")),
            STOPLIST_LANG_DANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DANISH")),
            STOPLIST_LANG_DUTCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DUTCH")),
            STOPLIST_LANG_ENGLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ENGLISH")),
            STOPLIST_LANG_ESTONIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ESTONIAN")),
            STOPLIST_LANG_FINNISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FINNISH")),
            STOPLIST_LANG_FRENCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FRENCH")),
            STOPLIST_LANG_GERMAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GERMAN")),
            STOPLIST_LANG_GREEK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GREEK")),
            STOPLIST_LANG_HEBREW(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HEBREW")),
            STOPLIST_LANG_HUNGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HUNGARIAN")),
            STOPLIST_LANG_ITALIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ITALIAN")),
            STOPLIST_LANG_MALAY(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_MALAY")),
            STOPLIST_LANG_NORWEGIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_NORWEGIAN")),
            STOPLIST_LANG_POLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_POLISH")),
            STOPLIST_LANG_PORTUGUESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_PORTUGUESE")),
            STOPLIST_LANG_ROMANIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ROMANIAN")),
            STOPLIST_LANG_RUSSIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_RUSSIAN")),
            STOPLIST_LANG_SLOVAK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SLOVAK")),
            STOPLIST_LANG_SPANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SPANISH")),
            STOPLIST_LANG_SWEDISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SWEDISH")),
            STOPLIST_LANG_THAI(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_THAI")),
            STOPLIST_LANG_TURKISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TURKISH"));

            private final String value;

            private BASIC_LEXER_LANG_SINGLE_BYTE(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum BASIC_LEXER_LANG {
            STOPLIST_LANG_ARABIC(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ARABIC")),
            STOPLIST_LANG_BULGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_BULGARIAN")),
            STOPLIST_LANG_CATALAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CATALAN")),
            STOPLIST_LANG_SIMPLIFIED_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SIMPLIFIED_CHINESE")),
            STOPLIST_LANG_TRADITIONAL_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TRADITIONAL_CHINESE")),
            STOPLIST_LANG_CROATIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CROATIAN")),
            STOPLIST_LANG_CZECH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CZECH")),
            STOPLIST_LANG_DANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DANISH")),
            STOPLIST_LANG_DUTCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DUTCH")),
            STOPLIST_LANG_ENGLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ENGLISH")),
            STOPLIST_LANG_ESTONIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ESTONIAN")),
            STOPLIST_LANG_FINNISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FINNISH")),
            STOPLIST_LANG_FRENCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FRENCH")),
            STOPLIST_LANG_GERMAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GERMAN")),
            STOPLIST_LANG_GREEK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GREEK")),
            STOPLIST_LANG_HEBREW(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HEBREW")),
            STOPLIST_LANG_HUNGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HUNGARIAN")),
            STOPLIST_LANG_ITALIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ITALIAN")),
            STOPLIST_LANG_JAPANESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_JAPANESE")),
            STOPLIST_LANG_KOREAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_KOREAN")),
            STOPLIST_LANG_MALAY(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_MALAY")),
            STOPLIST_LANG_NORWEGIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_NORWEGIAN")),
            STOPLIST_LANG_POLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_POLISH")),
            STOPLIST_LANG_PORTUGUESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_PORTUGUESE")),
            STOPLIST_LANG_ROMANIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ROMANIAN")),
            STOPLIST_LANG_RUSSIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_RUSSIAN")),
            STOPLIST_LANG_SLOVAK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SLOVAK")),
            STOPLIST_LANG_SPANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SPANISH")),
            STOPLIST_LANG_SWEDISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SWEDISH")),
            STOPLIST_LANG_THAI(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_THAI")),
            STOPLIST_LANG_TURKISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TURKISH"));

            private final String value;

            private BASIC_LEXER_LANG(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum AUTO_LEXER_LANG {
            STOPLIST_LANG_CATALAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CATALAN")),
            STOPLIST_LANG_SIMPLIFIED_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SIMPLIFIED_CHINESE")),
            STOPLIST_LANG_TRADITIONAL_CHINESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TRADITIONAL_CHINESE")),
            STOPLIST_LANG_CZECH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_CZECH")),
            STOPLIST_LANG_DUTCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_DUTCH")),
            STOPLIST_LANG_ENGLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ENGLISH")),
            STOPLIST_LANG_FRENCH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_FRENCH")),
            STOPLIST_LANG_GERMAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GERMAN")),
            STOPLIST_LANG_GREEK(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_GREEK")),
            STOPLIST_LANG_HUNGARIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_HUNGARIAN")),
            STOPLIST_LANG_ITALIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ITALIAN")),
            STOPLIST_LANG_JAPANESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_JAPANESE")),
            STOPLIST_LANG_KOREAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_KOREAN")),
            STOPLIST_LANG_POLISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_POLISH")),
            STOPLIST_LANG_PORTUGUESE(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_PORTUGUESE")),
            STOPLIST_LANG_ROMANIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_ROMANIAN")),
            STOPLIST_LANG_RUSSIAN(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_RUSSIAN")),
            STOPLIST_LANG_SPANISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SPANISH")),
            STOPLIST_LANG_SWEDISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_SWEDISH")),
            STOPLIST_LANG_TURKISH(CoreServerConstantsLrb.get("STOPLIST_DEFAULT_TURKISH"));

            private final String value;

            private AUTO_LEXER_LANG(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class StratifiedTypeOption {
        public static final String STRATIFIED_TYPE_ORIGINAL = "Original";
        public static final String STRATIFIED_TYPE_BALANCED = "Balanced";
        public static final String STRATIFIED_TYPE_CUSTOM = "Custom";

        public static String toSchema(String string) {
            if (string.equals(STRATIFIED_TYPE.STRATIFIED_TYPE_ORIGINAL.value())) {
                return STRATIFIED_TYPE_ORIGINAL;
            }
            if (string.equals(STRATIFIED_TYPE.STRATIFIED_TYPE_BALANCED.value())) {
                return STRATIFIED_TYPE_BALANCED;
            }
            if (string.equals(STRATIFIED_TYPE.STRATIFIED_TYPE_CUSTOM.value())) {
                return STRATIFIED_TYPE_CUSTOM;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(STRATIFIED_TYPE_ORIGINAL)) {
                return STRATIFIED_TYPE.STRATIFIED_TYPE_ORIGINAL.value();
            }
            if (string.equals(STRATIFIED_TYPE_BALANCED)) {
                return STRATIFIED_TYPE.STRATIFIED_TYPE_BALANCED.value();
            }
            if (string.equals(STRATIFIED_TYPE_CUSTOM)) {
                return STRATIFIED_TYPE.STRATIFIED_TYPE_CUSTOM.value();
            }
            return null;
        }

        public static boolean isBalanced(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STRATIFIED_TYPE_BALANCED);
        }

        public static boolean isOriginal(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STRATIFIED_TYPE_ORIGINAL);
        }

        public static boolean isCustom(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(STRATIFIED_TYPE_CUSTOM);
        }

        public static enum STRATIFIED_TYPE {
            STRATIFIED_TYPE_ORIGINAL(CoreServerConstantsLrb.get("SAMPLE_DISTRIBUTION_ORIGINAL")),
            STRATIFIED_TYPE_BALANCED(CoreServerConstantsLrb.get("SAMPLE_DISTRIBUTION_BALANCED")),
            STRATIFIED_TYPE_CUSTOM(CoreServerConstantsLrb.get("SAMPLE_DISTRIBUTION_CUSTOM"));

            private final String value;

            private STRATIFIED_TYPE(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class BuildSettingPriorsOption {
        public static final String BUILD_SETTING_NB_USE_PRIOR = "BUILD_SETTING_NB_USE_PRIOR";
        public static final String BUILD_SETTING_NB_USE_PRIOR_TRUE = "Y";
        public static final String BUILD_SETTING_NB_USE_PRIOR_FALSE = "N";

        public static boolean isPriorsTrue(String string) {
            return string.equals(BUILD_SETTING_NB_USE_PRIOR_TRUE);
        }
    }

    public static class BuildSettingCostBenefitOption {
        public static final String BUILD_SETTING_COST_BENEFITS_OPTION = "BUILD_SETTING_COST_BENEFITS_OPTION";
        public static final String BUILD_SETTING_COST_MATRIX_OPTION = "BUILD_SETTING_COST_MATRIX_OPTION";
        public static final String BUILD_SETTING_CSTBNF_OP_NONE = "BUILD_SETTING_CSTBNF_OP_NONE";
        public static final String BUILD_SETTING_CSTBNF_OP_TRUE = "BUILD_SETTING_CSTBNF_OP_TRUE";
        public static final String BUILD_SETTING_CSTBNF_OP_TUNED = "BUILD_SETTING_CSTBNF_OP_TUNED";

        public static boolean isCostMatrixTrue(String string) {
            return string.equals(BUILD_SETTING_CSTBNF_OP_TRUE);
        }

        public static boolean isCostBenefitTrue(String string) {
            return string.equals(BUILD_SETTING_COST_BENEFITS_OPTION);
        }
    }

    public static class BuildSettingPerformanceOption {
        public static final String BUILD_SETTING_PERFORM_OPTION = "BUILD_SETTING_PERFORM_OPTION";
        public static final String BUILD_SETTING_PERFORM_OP_AVG = "BUILD_SETTING_PERFORM_OP_AVG";
        public static final String BUILD_SETTING_PERFORM_OP_OVRL = "BUILD_SETTING_PERFORM_OP_OVRL";
        public static final String BUILD_SETTING_PERFORM_OP_CUST = "BUILD_SETTING_PERFORM_OP_CUST";

        public static boolean isBalanced(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(BUILD_SETTING_PERFORM_OP_AVG);
        }

        public static boolean isNatural(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(BUILD_SETTING_PERFORM_OP_OVRL);
        }

        public static boolean isCustom(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(BUILD_SETTING_PERFORM_OP_CUST);
        }
    }

    public static class ModelSettingTuneOption {
        public static final String MODEL_SETTING_TUNE_OPTION = "MODEL_SETTING_TUNE_OPTION";
        public static final String MODEL_SETTING_TUNE_OP_NONE = "MODEL_SETTING_TUNE_OP_NONE";
        public static final String MODEL_SETTING_TUNE_OP_DEFAULT = "MODEL_SETTING_TUNE_OP_DEFAULT";
        public static final String MODEL_SETTING_TUNE_OP_CUSTOM = "MODEL_SETTING_TUNE_OP_CUSTOM";

        public static boolean isNone(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(MODEL_SETTING_TUNE_OP_NONE);
        }

        public static boolean isDefault(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(MODEL_SETTING_TUNE_OP_DEFAULT);
        }

        public static boolean isCustom(String string) {
            if (string == null) {
                return false;
            }
            return string.equals(MODEL_SETTING_TUNE_OP_CUSTOM);
        }
    }

    public static class ModelSettings {
        public static final int MAX_NAME_LENGTH = 25;
        public static final int MAX_COMMENT_LENGTH = 4000;
        public static final String TOKEN_IDF_FREQUENCY = "IDF";
        public static final int MAX_NUMBER_ALL_DOCS_DEFAULT = 3000;
        public static final int MAX_NUMBER_PER_DOC_DEFAULT = 1;
    }

    public static class WorkflowSettings {
        public static final String WORKFLOW_STATUS_INACTIVE = "INACTIVE";
        public static final String WORKFLOW_STATUS_FAILED = "FAILED";
        public static final String WORKFLOW_STATUS_QUEUED = "QUEUED";
        public static final String WORKFLOW_STATUS_STOPPING = "STOPPING";
        public static final String WORKFLOW_STATUS_STOPPED = "STOPPED";
        public static final String WORKFLOW_STATUS_RUNNING = "RUNNING";
        public static final String WORKFLOW_STATUS_SUCCEEDED = "SUCCEEDED";
        public static final String WORKFLOW_STATUS_SCHEDULED = "SCHEDULED";
        public static final String NODE_STATUS_SUCCESS = "SUCCEEDED";
        public static final String NODE_STATUS_FAILURE = "FAILED";
        public static final String NODE_STATUS_RUNNING = "RUNNING";
        public static final String NODE_STATUS_STOPPED = "STOPPED";
        public static final String START_NODE_ID = "WF_START";
        public static final String END_NODE_ID = "WF_END";
    }

    public static class GlobalSettings {
        public static final String GLOBAL_SETTING_VALUE_YES = "YES";
        public static final String GLOBAL_SETTING_VALUE_NO = "NO";
        public static final String GLOBAL_SETTING_VALUE_ON = "ON";
        public static final String GLOBAL_SETTING_VALUE_OFF = "OFF";
        public static final String ODMS_MISSING_VALUE_TREATMENT = "ODMS_MISSING_VALUE_TREATMENT";
        public static final String ODMS_MISSING_VALUE_MEAN_MODE = "ODMS_MISSING_VALUE_MEAN_MODE";
        public static final String ODMS_MISSING_VALUE_DELETE_ROW = "ODMS_MISSING_VALUE_DELETE_ROW";
        public static final String ODMS_MISSING_VALUE_AUTO = "ODMS_MISSING_VALUE_AUTO";
        public static final String ODMS_ROW_WEIGHT_COLUMN_NAME = "ODMS_ROW_WEIGHT_COLUMN_NAME";
        public static final String PREP_AUTO = "PREP_AUTO";
        public static final String PREP_AUTO_OFF = "PREP_AUTO_OFF";
        public static final String PREP_AUTO_ON = "PREP_AUTO_ON";
        public static final String ALGO_NAME = "ALGO_NAME";
        public static final String ODMS_PARTITION_COLUMNS = "ODMS_PARTITION_COLUMNS";
        public static final String ODMS_MAX_PARTITIONS = "ODMS_MAX_PARTITIONS";
        public static final String CLAS_WEIGHTS_BALANCED = "CLAS_WEIGHTS_BALANCED";
        public static final String ODMS_SAMPLING = "ODMS_SAMPLING";
        public static final String ODMS_SAMPLING_DISABLE = "ODMS_SAMPLING_DISABLE";
        public static final String ODMS_SAMPLING_ENABLE = "ODMS_SAMPLING_ENABLE";
        public static final String ODMS_SAMPLE_SIZE = "ODMS_SAMPLE_SIZE";
        public static final String ODMS_TEXT_MIN_DOCUMENTS = "ODMS_TEXT_MIN_DOCUMENTS";
        public static final String ODMS_ITEM_ID_COLUMN_NAME = "ODMS_ITEM_ID_COLUMN_NAME";
        public static final String ODMS_TEXT_MAX_FEATURES = "ODMS_TEXT_MAX_FEATURES";
        public static final String PREP_SCALE_2DNUM = "PREP_SCALE_2DNUM";
        public static final String PREP_SCALE_STDDEV = "PREP_SCALE_STDDEV";
        public static final String PREP_SCALE_RANGE = "PREP_SCALE_RANGE";
        public static final String PREP_SCALE_NNUM = "PREP_SCALE_NNUM";
        public static final String PREP_SCALE_MAXABS = "PREP_SCALE_MAXABS";
        public static final String PREP_SHIFT_2DNUM = "PREP_SHIFT_2DNUM";
        public static final String PREP_SHIFT_MEAN = "PREP_SHIFT_MEAN";
        public static final String PREP_SHIFT_MIN = "PREP_SHIFT_MIN";
        public static final String NUM_ROWS = "NUM_ROWS";
        public static final String ITERATIONS = "ITERATIONS";
        public static final String NUM_ITERATIONS = "NUM_ITERATIONS";
        public static final String MODEL_CONVERGED = "MODEL_CONVERGED";
        public static final String CONVERGED = "CONVERGED";
        public static final String BATCH_ROWS = "BATCH_ROWS";
        public static final String SOLVER = "SOLVER";
        public static final String RANDOM_SEED = "RANDOM_SEED";
        public static final String NUM_COMPONENTS = "NUM_COMPONENTS";
        public static final String ODMS_PARTITION_BUILD_TYPE = "ODMS_PARTITION_BUILD_TYPE";
        public static final String ODMS_PARTITION_BUILD_INTRA = "ODMS_PARTITION_BUILD_INTRA";
        public static final String ODMS_PARTITION_BUILD_INTER = "ODMS_PARTITION_BUILD_INTER";
        public static final String ODMS_PARTITION_BUILD_HYBRID = "ODMS_PARTITION_BUILD_HYBRID";
        public static final String DATA_MINER_ADDITIONAL_OUTPUT_WARNING_ID = "DATA_MINER_ADDITIONAL_OUTPUT_WARNING_ID";

        public static String toAlgorithm(String string) {
            if (string.equals(ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_MEAN_MODE.value())) {
                return ODMS_MISSING_VALUE_MEAN_MODE;
            }
            if (string.equals(ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_DELETE_ROW.value())) {
                return ODMS_MISSING_VALUE_DELETE_ROW;
            }
            if (string.equals(ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_AUTO.value())) {
                return ODMS_MISSING_VALUE_AUTO;
            }
            if (string.equals(ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_INTRA.value())) {
                return ODMS_PARTITION_BUILD_INTRA;
            }
            if (string.equals(ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_INTER.value())) {
                return ODMS_PARTITION_BUILD_INTER;
            }
            if (string.equals(ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_HYBRID.value())) {
                return ODMS_PARTITION_BUILD_HYBRID;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(ODMS_MISSING_VALUE_MEAN_MODE)) {
                return ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_MEAN_MODE.value();
            }
            if (string.equals(ODMS_MISSING_VALUE_DELETE_ROW)) {
                return ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_DELETE_ROW.value();
            }
            if (string.equals(ODMS_MISSING_VALUE_AUTO)) {
                return ODMS_MISSING_VALUE_TREATMENT_OPTION.ODMS_MISSING_VALUE_AUTO.value();
            }
            if (string.equals(ODMS_PARTITION_BUILD_INTRA)) {
                return ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_INTRA.value();
            }
            if (string.equals(ODMS_PARTITION_BUILD_INTER)) {
                return ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_INTER.value();
            }
            if (string.equals(ODMS_PARTITION_BUILD_HYBRID)) {
                return ODMS_PARTITION_BUILD_TYPE_OPTION.ODMS_PARTITION_BUILD_HYBRID.value();
            }
            return null;
        }

        public static enum ODMS_MISSING_VALUE_TREATMENT_OPTION {
            ODMS_MISSING_VALUE_MEAN_MODE(CoreServerConstantsLrb.get("ODMS_MISSING_VALUE_MEAN_MODE")),
            ODMS_MISSING_VALUE_DELETE_ROW(CoreServerConstantsLrb.get("ODMS_MISSING_VALUE_DELETE_ROW")),
            ODMS_MISSING_VALUE_AUTO(CoreServerConstantsLrb.get("ODMS_MISSING_VALUE_AUTO"));

            private final String value;

            private ODMS_MISSING_VALUE_TREATMENT_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum ODMS_PARTITION_BUILD_TYPE_OPTION {
            ODMS_PARTITION_BUILD_INTRA(CoreServerConstantsLrb.get("ODMS_PARTITION_BUILD_INTRA")),
            ODMS_PARTITION_BUILD_INTER(CoreServerConstantsLrb.get("ODMS_PARTITION_BUILD_INTER")),
            ODMS_PARTITION_BUILD_HYBRID(CoreServerConstantsLrb.get("ODMS_PARTITION_BUILD_HYBRID"));

            private final String value;

            private ODMS_PARTITION_BUILD_TYPE_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class OrderPartitions {
        public static final String YES = "Yes";
        public static final String NO = "No";
    }

    public static class ColumnOutputOrder {
        public static final String OUTPUT_COLUMNS = "OutputColumns";
        public static final String SUPPLEMENTAL_COLUMNS = "SupplementalColumns";
    }

    public static class ApplyPredictionDetailsSort {
        public static final String ABS = "ABS";
        public static final String ASC = "ASC";
        public static final String DESC = "DESC";

        public static boolean isABS(String string) {
            if (string == null) {
                return false;
            }
            return ABS.equalsIgnoreCase(string);
        }

        public static boolean isAsc(String string) {
            if (string == null) {
                return false;
            }
            return ASC.equalsIgnoreCase(string);
        }

        public static boolean isDesc(String string) {
            if (string == null) {
                return false;
            }
            return DESC.equalsIgnoreCase(string);
        }

        public static String toAlgorithm(String string) {
            if (string != null) {
                if (string.equals(PREDICTION_DETAILS_SORT_OPTION.ABS.value())) {
                    return ABS;
                }
                if (string.equals(PREDICTION_DETAILS_SORT_OPTION.ASC.value())) {
                    return ASC;
                }
                if (string.equals(PREDICTION_DETAILS_SORT_OPTION.DESC.value())) {
                    return DESC;
                }
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string != null) {
                if (string.equals(ABS)) {
                    return PREDICTION_DETAILS_SORT_OPTION.ABS.value();
                }
                if (string.equals(ASC)) {
                    return PREDICTION_DETAILS_SORT_OPTION.ASC.value();
                }
                if (string.equals(DESC)) {
                    return PREDICTION_DETAILS_SORT_OPTION.DESC.value();
                }
            }
            return null;
        }

        public static interface DEFAULTS {
            public static final String SORT_ORDER = "ABS";
        }

        public static enum PREDICTION_DETAILS_SORT_OPTION {
            ABS(CoreServerConstantsLrb.get("PREDICTION_DETAILS_SORT_ABS")),
            ASC(CoreServerConstantsLrb.get("PREDICTION_DETAILS_SORT_ASC")),
            DESC(CoreServerConstantsLrb.get("PREDICTION_DETAILS_SORT_DESC"));

            private final String value;

            private PREDICTION_DETAILS_SORT_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class ApplyPredictionFunctions {
        public static final String PREDICTION = "PREDICTION";
        public static final String PREDICTION_BOUNDS = "PREDICTION_BOUNDS";
        public static final String PREDICTION_BOUNDS_LOWER = "PREDICTION_BOUNDS_LOWER";
        public static final String PREDICTION_BOUNDS_UPPER = "PREDICTION_BOUNDS_UPPER";
        public static final String PREDICTION_COST = "PREDICTION_COST";
        public static final String PREDICTION_DETAILS = "PREDICTION_DETAILS";
        public static final String PREDICTION_PROBABILITY = "PREDICTION_PROBABILITY";
        public static final String PREDICTION_SET = "PREDICTION_SET";
        public static final String CLUSTER_ID = "CLUSTER_ID";
        public static final String CLUSTER_PROBABILITY = "CLUSTER_PROBABILITY";
        public static final String CLUSTER_SET = "CLUSTER_SET";
        public static final String CLUSTER_DETAILS = "CLUSTER_DETAILS";
        public static final String CLUSTER_DISTANCE = "CLUSTER_DISTANCE";
        public static final String FEATURE_ID = "FEATURE_ID";
        public static final String FEATURE_VALUE = "FEATURE_VALUE";
        public static final String FEATURE_SET = "FEATURE_SET";
        public static final String FEATURE_DETAILS = "FEATURE_DETAILS";
        public static final String PARTITION_NAME = "PARTITION_NAME";

        public static boolean isPrediction(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION.equalsIgnoreCase(string);
        }

        public static boolean isPredictionBounds(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_BOUNDS.equalsIgnoreCase(string);
        }

        public static boolean isPredictionBoundsLower(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_BOUNDS_LOWER.equalsIgnoreCase(string);
        }

        public static boolean isPredictionBoundsUpper(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_BOUNDS_UPPER.equalsIgnoreCase(string);
        }

        public static boolean isPredictionCost(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_COST.equalsIgnoreCase(string);
        }

        public static boolean isPredictionDetails(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_DETAILS.equalsIgnoreCase(string);
        }

        public static boolean isPredictionProbability(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_PROBABILITY.equalsIgnoreCase(string);
        }

        public static boolean isPredictionSet(String string) {
            if (string == null) {
                return false;
            }
            return PREDICTION_SET.equalsIgnoreCase(string);
        }

        public static boolean isClusterId(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTER_ID.equalsIgnoreCase(string);
        }

        public static boolean isClusterProbability(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTER_PROBABILITY.equalsIgnoreCase(string);
        }

        public static boolean isClusterSet(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTER_SET.equalsIgnoreCase(string);
        }

        public static boolean isClusterDetails(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTER_DETAILS.equalsIgnoreCase(string);
        }

        public static boolean isClusterDistance(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTER_DISTANCE.equalsIgnoreCase(string);
        }

        public static boolean isFeatureId(String string) {
            if (string == null) {
                return false;
            }
            return FEATURE_ID.equalsIgnoreCase(string);
        }

        public static boolean isFeatureValue(String string) {
            if (string == null) {
                return false;
            }
            return FEATURE_VALUE.equalsIgnoreCase(string);
        }

        public static boolean isFeatureSet(String string) {
            if (string == null) {
                return false;
            }
            return FEATURE_SET.equalsIgnoreCase(string);
        }

        public static boolean isFeatureDetails(String string) {
            if (string == null) {
                return false;
            }
            return FEATURE_DETAILS.equalsIgnoreCase(string);
        }

        public static String getUIFunctionName(String string) {
            return ApplyPredictionFunctions.toHuman(string);
        }

        public static String toAlgorithm(String string) {
            if (string != null) {
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION.value())) {
                    return PREDICTION;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS.value())) {
                    return PREDICTION_BOUNDS;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS_UPPER.value())) {
                    return PREDICTION_BOUNDS_UPPER;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS_LOWER.value())) {
                    return PREDICTION_BOUNDS_LOWER;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_COST.value())) {
                    return PREDICTION_COST;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_DETAILS.value())) {
                    return PREDICTION_DETAILS;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_PROBABILITY.value())) {
                    return PREDICTION_PROBABILITY;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PREDICTION_SET.value())) {
                    return PREDICTION_SET;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.CLUSTER_ID.value())) {
                    return CLUSTER_ID;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.CLUSTER_PROBABILITY.value())) {
                    return CLUSTER_PROBABILITY;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.CLUSTER_SET.value())) {
                    return CLUSTER_SET;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.CLUSTER_DETAILS.value())) {
                    return CLUSTER_DETAILS;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.CLUSTER_DISTANCE.value())) {
                    return CLUSTER_DISTANCE;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.FEATURE_ID.value())) {
                    return FEATURE_ID;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.FEATURE_VALUE.value())) {
                    return FEATURE_VALUE;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.FEATURE_SET.value())) {
                    return FEATURE_SET;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.FEATURE_DETAILS.value())) {
                    return FEATURE_DETAILS;
                }
                if (string.equals(PREDICTION_FUNCTION_OPTION.PARTITION_NAME.value())) {
                    return PARTITION_NAME;
                }
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string != null) {
                if (string.equals(PREDICTION)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION.value();
                }
                if (string.equals(PREDICTION_BOUNDS)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS.value();
                }
                if (string.equals(PREDICTION_BOUNDS_UPPER)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS_UPPER.value();
                }
                if (string.equals(PREDICTION_BOUNDS_LOWER)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_BOUNDS_LOWER.value();
                }
                if (string.equals(PREDICTION_COST)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_COST.value();
                }
                if (string.equals(PREDICTION_DETAILS)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_DETAILS.value();
                }
                if (string.equals(PREDICTION_PROBABILITY)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_PROBABILITY.value();
                }
                if (string.equals(PREDICTION_SET)) {
                    return PREDICTION_FUNCTION_OPTION.PREDICTION_SET.value();
                }
                if (string.equals(CLUSTER_ID)) {
                    return PREDICTION_FUNCTION_OPTION.CLUSTER_ID.value();
                }
                if (string.equals(CLUSTER_PROBABILITY)) {
                    return PREDICTION_FUNCTION_OPTION.CLUSTER_PROBABILITY.value();
                }
                if (string.equals(CLUSTER_SET)) {
                    return PREDICTION_FUNCTION_OPTION.CLUSTER_SET.value();
                }
                if (string.equals(CLUSTER_DETAILS)) {
                    return PREDICTION_FUNCTION_OPTION.CLUSTER_DETAILS.value();
                }
                if (string.equals(CLUSTER_DISTANCE)) {
                    return PREDICTION_FUNCTION_OPTION.CLUSTER_DISTANCE.value();
                }
                if (string.equals(FEATURE_ID)) {
                    return PREDICTION_FUNCTION_OPTION.FEATURE_ID.value();
                }
                if (string.equals(FEATURE_VALUE)) {
                    return PREDICTION_FUNCTION_OPTION.FEATURE_VALUE.value();
                }
                if (string.equals(FEATURE_SET)) {
                    return PREDICTION_FUNCTION_OPTION.FEATURE_SET.value();
                }
                if (string.equals(FEATURE_DETAILS)) {
                    return PREDICTION_FUNCTION_OPTION.FEATURE_DETAILS.value();
                }
                if (string.equals(PARTITION_NAME)) {
                    return PREDICTION_FUNCTION_OPTION.PARTITION_NAME.value();
                }
            }
            return null;
        }

        public static interface DEFAULTS {
            public static final int MAX_LEN_ATTRS = 5;
        }

        public static enum PREDICTION_FUNCTION_OPTION {
            PREDICTION(CoreServerConstantsLrb.get("MODEL_PREDICTION")),
            PREDICTION_BOUNDS(CoreServerConstantsLrb.get("MODEL_PREDICTION_BOUNDS")),
            PREDICTION_BOUNDS_UPPER(CoreServerConstantsLrb.get("MODEL_PREDICTION_BOUNDS_UPPER")),
            PREDICTION_BOUNDS_LOWER(CoreServerConstantsLrb.get("MODEL_PREDICTION_BOUNDS_LOWER")),
            PREDICTION_COST(CoreServerConstantsLrb.get("MODEL_PREDICTION_COST")),
            PREDICTION_DETAILS(CoreServerConstantsLrb.get("MODEL_PREDICTION_DETAILS")),
            PREDICTION_PROBABILITY(CoreServerConstantsLrb.get("MODEL_PREDICTION_PROBABILITY")),
            PREDICTION_SET(CoreServerConstantsLrb.get("MODEL_PREDICTION_SET")),
            CLUSTER_ID(CoreServerConstantsLrb.get("MODEL_PREDICTION_CLUSTER_ID")),
            CLUSTER_PROBABILITY(CoreServerConstantsLrb.get("MODEL_PREDICTION_CLUSTER_PROBABILITY")),
            CLUSTER_SET(CoreServerConstantsLrb.get("MODEL_PREDICTION_CLUSTER_SET")),
            CLUSTER_DETAILS(CoreServerConstantsLrb.get("MODEL_PREDICTION_CLUSTER_DETAILS")),
            CLUSTER_DISTANCE(CoreServerConstantsLrb.get("MODEL_PREDICTION_CLUSTER_DISTANCE")),
            FEATURE_ID(CoreServerConstantsLrb.get("MODEL_PREDICTION_FEATURE_ID")),
            FEATURE_VALUE(CoreServerConstantsLrb.get("MODEL_PREDICTION_FEATURE_VALUE")),
            FEATURE_SET(CoreServerConstantsLrb.get("MODEL_PREDICTION_FEATURE_SET")),
            FEATURE_DETAILS(CoreServerConstantsLrb.get("MODEL_PREDICTION_FEATURE_DETAILS")),
            PARTITION_NAME(CoreServerConstantsLrb.get("PARTITION_NAME"));

            private final String value;

            private PREDICTION_FUNCTION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class RSettings {
        public static final String RALG_BUILD_FUNCTION = "RALG_BUILD_FUNCTION";
        public static final String RALG_BUILD_PARAMETER = "RALG_BUILD_PARAMETER";
        public static final String RALG_SCORE_FUNCTION = "RALG_SCORE_FUNCTION";
        public static final String RALG_WEIGHT_FUNCTION = "RALG_WEIGHT_FUNCTION";
        public static final String RALG_DETAILS_FUNCTION = "RALG_DETAILS_FUNCTION";
        public static final String RALG_DETAILS_FORMAT = "RALG_DETAILS_FORMAT";
    }

    public static class ExtensibleSettings {
        public static final String ALGO_EXTENSIBLE_LANG = "ALGO_EXTENSIBLE_LANG";
    }

    public static class ESASettings {
        public static final String ESAS_VALUE_THRESHOLD = "ESAS_VALUE_THRESHOLD";
        public static final String ESAS_TOPN_FEATURES = "ESAS_TOPN_FEATURES";
        public static final String ESAS_MIN_ITEMS = "ESAS_MIN_ITEMS";
        public static final String ODMS_TEXT_MIN_DOCUMENTS = "ESAS_MIN_ITEMS";
        public static final String ODMS_TEXT_MAX_FEATURES = "ESAS_MIN_ITEMS";
        public static final String REMOVED_ROWS_BY_FILTERS = "REMOVED_ROWS_BY_FILTERS";

        public static interface DEFAULTS {
            public static final double ESAS_VALUE_THRESHOLD = 1.0E-8;
            public static final BigInteger ESAS_TOPN_FEATURES = BigInteger.valueOf(1000L);
            public static final BigInteger ESAS_MIN_ITEMS = BigInteger.valueOf(100L);
        }
    }

    public static class DTSettings {
        public static final String TREE_IMPURITY_METRIC = "TREE_IMPURITY_METRIC";
        public static final String TREE_IMPURITY_ENTROPY_STR = "TREE_IMPURITY_ENTROPY";
        public static final String TREE_IMPURITY_GINI_STR = "TREE_IMPURITY_GINI";
        public static final String TREE_TERM_MAX_DEPTH = "TREE_TERM_MAX_DEPTH";
        public static final String TREE_TERM_MINPCT_NODE = "TREE_TERM_MINPCT_NODE";
        public static final String TREE_TERM_MINPCT_SPLIT = "TREE_TERM_MINPCT_SPLIT";
        public static final String TREE_TERM_MINREC_NODE = "TREE_TERM_MINREC_NODE";
        public static final String TREE_TERM_MINREC_SPLIT = "TREE_TERM_MINREC_SPLIT";
        public static final String CLAS_MAX_SUP_BINS = "CLAS_MAX_SUP_BINS";

        public static String toAlgorithm(String string) {
            if (string.equals(TREE_IMPURITY.TREE_IMPURITY_GINI.value())) {
                return TREE_IMPURITY_GINI_STR;
            }
            return TREE_IMPURITY_ENTROPY_STR;
        }

        public static String toHuman(String string) {
            if (string.equals(TREE_IMPURITY_GINI_STR)) {
                return TREE_IMPURITY.TREE_IMPURITY_GINI.value();
            }
            return TREE_IMPURITY.TREE_IMPURITY_ENTROPY.value();
        }

        public static interface DEFAULTS {
            public static final int TREE_TERM_MAX_DEPTH_DEFAULT = 7;
            public static final double TREE_TERM_MINPCT_NODE = 0.05;
            public static final double TREE_TERM_MINPCT_SPLIT = 0.1;
            public static final int TREE_TERM_MINREC_NODE = 10;
            public static final int TREE_TERM_MINREC_SPLIT = 20;
            public static final int CLAS_MAX_SUP_BINS = 32;
        }

        public static enum TREE_IMPURITY {
            TREE_IMPURITY_GINI(CoreServerConstantsLrb.get("DECISION_TREE_HOMONGENITY_GINI")),
            TREE_IMPURITY_ENTROPY(CoreServerConstantsLrb.get("DECISION_TREE_HOMONGENITY_ENTROPY"));

            private final String value;

            private TREE_IMPURITY(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class SVDSettings {
        public static final String SVDS_SCORING_MODE = "SVDS_SCORING_MODE";
        public static final String SVDS_SCORING_SVD = "SVDS_SCORING_SVD";
        public static final String SVDS_SCORING_PCA = "SVDS_SCORING_PCA";
        public static final String SVDS_SOLVER = "SVDS_SOLVER";
        public static final String SVDS_SOLVER_TSSVD = "SVDS_SOLVER_TSSVD";
        public static final String SVDS_SOLVER_TSEIGEN = "SVDS_SOLVER_TSEIGEN";
        public static final String SVDS_SOLVER_SSVD = "SVDS_SOLVER_SSVD";
        public static final String SVDS_SOLVER_STEIGEN = "SVDS_SOLVER_STEIGEN";
        public static final String SVDS_TOLERANCE = "SVDS_TOLERANCE";
        public static final String SVDS_RANDOM_SEED = "SVDS_RANDOM_SEED";
        public static final String SVDS_OVER_SAMPLING = "SVDS_OVER_SAMPLING";
        public static final String SVDS_POWER_ITERATIONS = "SVDS_POWER_ITERATIONS";
        public static final String SUGGESTED_CUTOFF = "SUGGESTED_CUTOFF";

        public static interface DEFAULTS {
            public static final String SVDS_SOLVER = "SVDS_SOLVER_SSVD";
            public static final Double SVDS_TOLERANCE = null;
            public static final Integer SVDS_OVER_SAMPLING = 5;
            public static final Integer SVDS_POWER_ITERATIONS = 2;
            public static final BigInteger SVDS_RANDOM_SEED = new BigInteger("0");
        }
    }

    public static class SVMSettings {
        public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
        public static final String SVMS_AL_DISABLE = "SVMS_AL_DISABLE";
        public static final String SVMS_AL_ENABLE = "SVMS_AL_ENABLE";
        public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
        public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
        public static final Double SVMS_CONV_TOLERANCE_DEFAULT = 0.001;
        public static final String SVMS_EPSILON = "SVMS_EPSILON";
        public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
        public static final Long SVMS_KERNEL_CACHE_SIZE_DEFAULT = 50000000L;
        public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
        public static final String SVMS_SYSTEM_DETERMINED = "SVMS_SYSTEM_DETERMINED";
        public static final String SVMS_GAUSSIAN = "SVMS_GAUSSIAN";
        public static final String SVMS_LINEAR = "SVMS_LINEAR";
        public static final String SVMS_OUTLIER_RATE = "SVMS_OUTLIER_RATE";
        public static final Double SVMS_OUTLIER_RATE_DEFAULT = 0.1;
        public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
        public static final String SVMS_SOLVER = "SVMS_SOLVER";
        public static final String SVMS_SOLVER_SGD = "SVMS_SOLVER_SGD";
        public static final String SVMS_SOLVER_IPM = "SVMS_SOLVER_IPM";
        public static final String SVMS_NUM_ITERATIONS = "SVMS_NUM_ITERATIONS";
        public static final String SVMS_REGULARIZER = "SVMS_REGULARIZER";
        public static final String SVMS_BATCH_ROWS = "SVMS_BATCH_ROWS";
        public static final String SVMS_NUM_PIVOTS = "SVMS_NUM_PIVOTS";
        public static final Double SVMS_NUM_PIVOTS_DEFAULT = 200.0;
        public static final Double SVMS_NUM_PIVOTS_MAX = 10000.0;
        public static final String SVMS_REGULARIZER_L1 = "SVMS_REGULARIZER_L1";
        public static final String SVMS_REGULARIZER_L2 = "SVMS_REGULARIZER_L2";

        public static Object getDefaultValue(String string) {
            if (string.equals(SVMS_KERNEL_CACHE_SIZE)) {
                return SVMS_KERNEL_CACHE_SIZE_DEFAULT;
            }
            if (string.equals(SVMS_CONV_TOLERANCE)) {
                return SVMS_CONV_TOLERANCE_DEFAULT;
            }
            if (string.equals(SVMS_ACTIVE_LEARNING)) {
                return SVMS_AL_ENABLE;
            }
            if (string.equals(SVMS_OUTLIER_RATE)) {
                return SVMS_OUTLIER_RATE_DEFAULT;
            }
            if (string.equals(SVMS_NUM_PIVOTS)) {
                return SVMS_NUM_PIVOTS_DEFAULT;
            }
            return BigDecimal.ZERO;
        }
    }

    public static class NMFSettings {
        public static final String FEAT_NUM_FEATURES = "FEAT_NUM_FEATURES";
        public static final String NMFS_CONV_TOLERANCE = "NMFS_CONV_TOLERANCE";
        public static final String NMFS_NUM_ITERATIONS = "NMFS_NUM_ITERATIONS";
        public static final String NMFS_RANDOM_SEED = "NMFS_RANDOM_SEED";
        public static final String NMFS_NONNEGATIVE_SCORING = "NMFS_NONNEGATIVE_SCORING";
        public static final String NMFS_NONNEG_SCORING_ENABLE = "NMFS_NONNEG_SCORING_ENABLE";
        public static final String NMFS_NONNEG_SCORING_DISABLE = "NMFS_NONNEG_SCORING_DISABLE";
        public static final String SVDS_U_MATRIX_OUTPUT = "SVDS_U_MATRIX_OUTPUT";
        public static final String SVDS_U_MATRIX_ENABLE = "SVDS_U_MATRIX_ENABLE";
        public static final String SVDS_U_MATRIX_DISABLE = "SVDS_U_MATRIX_DISABLE";
        public static final String ODMS_APPROXIMATE_COMPUTATION = "ODMS_APPROXIMATE_COMPUTATION";
        public static final String ODMS_APPR_COMP_ENABLE = "ODMS_APPR_COMP_ENABLE";
        public static final String ODMS_APPR_COMP_DISABLE = "ODMS_APPR_COMP_DISABLE";
        public static final String SVDS_SCORING_MODE = "SVDS_SCORING_MODE";
        public static final String SVDS_SCORING_SVD = "SVDS_SCORING_SVD";
        public static final String SVDS_SCORING_PCA = "SVDS_SCORING_PCA";
        public static final String CONV_ERROR = "CONV_ERROR";
        public static final String SAMPLE_SIZE = "SAMPLE_SIZE";

        public static String toAlgorithm(String string) {
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value())) {
                return ODMS_APPR_COMP_ENABLE;
            }
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value())) {
                return ODMS_APPR_COMP_DISABLE;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(ODMS_APPR_COMP_ENABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value();
            }
            if (string.equals(ODMS_APPR_COMP_DISABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value();
            }
            return null;
        }

        public static interface DEFAULTS {
            public static final double NMFS_CONV_TOLERANCE = 0.05;
            public static final int NMFS_NUM_ITERATIONS = 50;
            public static final int NMFS_RANDOM_SEED = -1;
            public static final String SVDS_U_MATRIX_OUTPUT = "SVDS_U_MATRIX_DISABLE";
            public static final String ODMS_APPROXIMATE_COMPUTATION = "ODMS_APPR_COMP_ENABLE";
            public static final String NMFS_NONNEGATIVE_SCORING = "NMFS_NONNEG_SCORING_ENABLE";
        }

        public static enum ODMS_APPROXIMATE_COMPUTATION_OPTION {
            ODMS_APPR_COMP_ENABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_ENABLE")),
            ODMS_APPR_COMP_DISABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_DISABLE"));

            private final String value;

            private ODMS_APPROXIMATE_COMPUTATION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class NBSettings {
        public static final String NABS_PAIRWISE_THRESHOLD = "NABS_PAIRWISE_THRESHOLD";
        public static final String NABS_SINGLETON_THRESHOLD = "NABS_SINGLETON_THRESHOLD";
    }

    public static class GLMSettings {
        public static final String GLMS_CONF_LEVEL = "GLMS_CONF_LEVEL";
        public static final String GLMS_DIAGNOSTICS_TABLE_NAME = "GLMS_DIAGNOSTICS_TABLE_NAME";
        public static final String GLMS_REFERENCE_CLASS_NAME = "GLMS_REFERENCE_CLASS_NAME";
        public static final String GLMS_RIDGE_REGRESSION = "GLMS_RIDGE_REGRESSION";
        public static final String GLMS_RIDGE_REG_ENABLE = "GLMS_RIDGE_REG_ENABLE";
        public static final String GLMS_RIDGE_REG_DISABLE = "GLMS_RIDGE_REG_DISABLE";
        public static final String GLMS_RIDGE_VALUE = "GLMS_RIDGE_VALUE";
        public static final String GLMS_VIF_FOR_RIDGE = "GLMS_VIF_FOR_RIDGE";
        public static final String GLMS_VIF_RIDGE_ENABLE = "GLMS_VIF_RIDGE_ENABLE";
        public static final String GLMS_VIF_RIDGE_DISABLE = "GLMS_VIF_RIDGE_DISABLE";
        public static final String GLMS_MISSING_VALUE_TREATMENT = "ODMS_MISSING_VALUE_TREATMENT";
        public static final String GLMS_MISSING_VALUE_MEAN_MODE = "ODMS_MISSING_VALUE_MEAN_MODE";
        public static final String GLMS_MISSING_VALUE_DELETE_ROW = "ODMS_MISSING_VALUE_DELETE_ROW";
        public static final String GLMS_ROW_WEIGHT_COLUMN_NAME = "ODMS_ROW_WEIGHT_COLUMN_NAME";
        public static final String GLMS_FTR_SEL_CRIT = "GLMS_FTR_SEL_CRIT";
        public static final String GLMS_FTR_SEL_AIC = "GLMS_FTR_SEL_AIC";
        public static final String GLMS_FTR_SEL_SBIC = "GLMS_FTR_SEL_SBIC";
        public static final String GLMS_FTR_SEL_RIC = "GLMS_FTR_SEL_RIC";
        public static final String GLMS_SEL_ALPHA_INV = "GLMS_FTR_SEL_ALPHA_INV";
        public static final String GLMS_MAX_FEATURES = "GLMS_MAX_FEATURES";
        public static final String GLMS_SELECT_BLOCK = "GLMS_SELECT_BLOCK";
        public static final String GLMS_SELECT_BLOCK_DISABLE = "GLMS_SELECT_BLOCK_DISABLE";
        public static final String GLMS_SELECT_BLOCK_ENABLE = "GLMS_SELECT_BLOCK_ENABLE";
        public static final String GLMS_PRUNE_MODEL = "GLMS_PRUNE_MODEL";
        public static final String GLMS_PRUNE_MODEL_ENABLE = "GLMS_PRUNE_MODEL_ENABLE";
        public static final String GLMS_PRUNE_MODEL_DISABLE = "GLMS_PRUNE_MODEL_DISABLE";
        public static final String GLMS_FTR_ACCEPTANCE = "GLMS_FTR_ACCEPTANCE";
        public static final String GLMS_FTR_ACCEPTANCE_STRICT = "GLMS_FTR_ACCEPTANCE_STRICT";
        public static final String GLMS_FTR_ACCEPTANCE_RELAXED = "GLMS_FTR_ACCEPTANCE_RELAXED";
        public static final String GLMS_FTR_GENERATION = "GLMS_FTR_GENERATION";
        public static final String GLMS_FTR_GENERATION_ENABLE = "GLMS_FTR_GENERATION_ENABLE";
        public static final String GLMS_FTR_GENERATION_DISABLE = "GLMS_FTR_GENERATION_DISABLE";
        public static final String ODMS_APPROXIMATE_COMPUTATION = "ODMS_APPROXIMATE_COMPUTATION";
        public static final String ODMS_APPR_COMP_ENABLE = "ODMS_APPR_COMP_ENABLE";
        public static final String ODMS_APPR_COMP_DISABLE = "ODMS_APPR_COMP_DISABLE";
        public static final String GLMS_FTR_SELECTION = "GLMS_FTR_SELECTION";
        public static final String GLMS_FTR_SELECTION_ENABLE = "GLMS_FTR_SELECTION_ENABLE";
        public static final String GLMS_FTR_SELECTION_DISABLE = "GLMS_FTR_SELECTION_DISABLE";
        public static final String GLMS_FTR_GEN_METHOD = "GLMS_FTR_GEN_METHOD";
        public static final String GLMS_FTR_GEN_QUADRATIC = "GLMS_FTR_GEN_QUADRATIC";
        public static final String GLMS_FTR_GEN_CUBIC = "GLMS_FTR_GEN_CUBIC";
        public static final String GLMS_FTR_IDENTIFICATION = "GLMS_FTR_IDENTIFICATION";
        public static final String GLMS_FTR_IDENTIFICATION_QUICK = "GLMS_FTR_IDENTIFICATION_QUICK";
        public static final String GLMS_FTR_IDENTIFICATION_COMPLETE = "GLMS_FTR_IDENTIFICATION_COMPLETE";
        public static final String GLMS_CONV_TOLERANCE = "GLMS_CONV_TOLERANCE";
        public static final String GLMS_NUM_ITERATIONS = "GLMS_NUM_ITERATIONS";
        public static final String GLMS_BATCH_ROWS = "GLMS_BATCH_ROWS";
        public static final String GLMS_RANK_DEFICIENCY = "RANK_DEFICIENCY";
        public static final String GLMS_ROW_DIAGNOSTICS = "GLMS_ROW_DIAGNOSTICS";
        public static final String GLMS_SPARSE_SOLVER = "GLMS_SPARSE_SOLVER";
        public static final String GLMS_SOLVER = "GLMS_SOLVER";
        public static final String GLMS_ROW_DIAG_DISABLE = "GLMS_ROW_DIAG_DISABLE";
        public static final String GLMS_ROW_DIAG_ENABLE = "GLMS_ROW_DIAG_ENABLE";
        public static final String GLMS_SPARSE_SOLVER_ENABLE = "GLMS_SPARSE_SOLVER_ENABLE";
        public static final String GLMS_SPARSE_SOLVER_DISABLE = "GLMS_SPARSE_SOLVER_DISABLE";
        public static final String GLMS_SOLVER_SGD = "GLMS_SOLVER_SGD";
        public static final String GLMS_SOLVER_CHOL = "GLMS_SOLVER_CHOL";
        public static final String GLMS_SOLVER_QR = "GLMS_SOLVER_QR";
        public static final String GLM_GLOBAL_MODEL_DF = "MODEL_DF";
        public static final String GLM_GLOBAL_MODEL_SUM_SQUARES = "MODEL_SUM_SQUARES";
        public static final String GLM_GLOBAL_MODEL_MEAN_SQUARE = "MODEL_MEAN_SQUARE";
        public static final String GLM_GLOBAL_F_VALUE = "F_VALUE";
        public static final String GLM_GLOBAL_MODEL_F_P_VALUE = "MODEL_F_P_VALUE";
        public static final String GLM_GLOBAL_ERROR_DF = "ERROR_DF";
        public static final String GLM_GLOBAL_ERROR_SUM_SQUARES = "ERROR_SUM_SQUARES";
        public static final String GLM_GLOBAL_ERROR_MEAN_SQUARE = "ERROR_MEAN_SQUARE";
        public static final String GLM_GLOBAL_CORRECTED_TOTAL_DF = "CORRECTED_TOTAL_DF";
        public static final String GLM_GLOBAL_CORRECTED_TOT_SS = "CORRECTED_TOT_SS";
        public static final String GLM_GLOBAL_ROOT_MEAN_SQ = "ROOT_MEAN_SQ";
        public static final String GLM_GLOBAL_DEPENDENT_MEAN = "DEPENDENT_MEAN";
        public static final String GLM_GLOBAL_COEFF_VAR = "COEFF_VAR";
        public static final String GLM_GLOBAL_R_SQ = "R_SQ";
        public static final String GLM_GLOBAL_ADJUSTED_R_SQUARE = "ADJUSTED_R_SQUARE";
        public static final String GLM_GLOBAL_AIC = "AIC";
        public static final String GLM_GLOBAL_SBIC = "SBIC";
        public static final String GLM_GLOBAL_GMSEP = "GMSEP";
        public static final String GLM_GLOBAL_HOCKING_SP = "HOCKING_SP";
        public static final String GLM_GLOBAL_J_P = "J_P";
        public static final String GLM_GLOBAL_NUM_PARAMS = "NUM_PARAMS";
        public static final String GLM_GLOBAL_VALID_COVARIANCE_MATRIX = "VALID_COVARIANCE_MATRIX";
        public static final String GLM_GLOBAL_TERMINATION = "TERMINATION";
        public static final String GLM_GLOBAL_TERMINATION_NORMAL = "TERMINATION_NORMAL";
        public static final String GLM_GLOBAL_TERMINATION_EARY = "TERMINATION_EARY";
        public static final String GLM_GLOBAL_TERMINATION_SKIP_CATEGORICALS = "TERMINATION_SKIP_CATEGORICALS";
        public static final String GLM_GLOBAL_AIC_INTERCEPT = "AIC_INTERCEPT";
        public static final String GLM_GLOBAL_AIC_MODEL = "AIC_MODEL";
        public static final String GLM_GLOBAL_SC_INTERCEPT = "SC_INTERCEPT";
        public static final String GLM_GLOBAL_SC_MODEL = "SC_MODEL";
        public static final String GLM_GLOBAL_NEG2_LL_INTERCEPT = "NEG2_LL_INTERCEPT";
        public static final String GLM_GLOBAL_NEG2_LL_MODEL = "NEG2_LL_MODEL";
        public static final String GLM_GLOBAL_LR_DF = "LR_DF";
        public static final String GLM_GLOBAL_LR_CHI_SQ = "LR_CHI_SQ";
        public static final String GLM_GLOBAL_LR_CHI_SQ_P_VALUE = "LR_CHI_SQ_P_VALUE";
        public static final String GLM_GLOBAL_PSEUDO_R_SQ_CS = "PSEUDO_R_SQ_CS";
        public static final String GLM_GLOBAL_PSEUDO_R_SQ_N = "PSEUDO_R_SQ_N";
        public static final String GLM_GLOBAL_PCT_CORRECT = "PCT_CORRECT";
        public static final String GLM_GLOBAL_PCT_INCORRECT = "PCT_INCORRECT";
        public static final String GLM_GLOBAL_PCT_TIED = "PCT_TIED";

        public static String toAlgorithm(String string) {
            if (string.equals(GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_AIC.value())) {
                return GLMS_FTR_SEL_AIC;
            }
            if (string.equals(GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_SBIC.value())) {
                return GLMS_FTR_SEL_SBIC;
            }
            if (string.equals(GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_RIC.value())) {
                return GLMS_FTR_SEL_RIC;
            }
            if (string.equals(GLMS_FTR_SEL_CRIT_OPTION.GLMS_SEL_ALPHA_INV.value())) {
                return GLMS_SEL_ALPHA_INV;
            }
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value())) {
                return ODMS_APPR_COMP_ENABLE;
            }
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value())) {
                return ODMS_APPR_COMP_DISABLE;
            }
            if (string.equals(GLMS_FTR_ACCEPTANCE_OPTION.GLMS_FTR_ACCEPTANCE_STRICT.value())) {
                return GLMS_FTR_ACCEPTANCE_STRICT;
            }
            if (string.equals(GLMS_FTR_ACCEPTANCE_OPTION.GLMS_FTR_ACCEPTANCE_RELAXED.value())) {
                return GLMS_FTR_ACCEPTANCE_RELAXED;
            }
            if (string.equals(GLMS_FTR_GEN_METHOD_OPTION.GLMS_FTR_GEN_QUADRATIC.value())) {
                return GLMS_FTR_GEN_QUADRATIC;
            }
            if (string.equals(GLMS_FTR_GEN_METHOD_OPTION.GLMS_FTR_GEN_CUBIC.value())) {
                return GLMS_FTR_GEN_CUBIC;
            }
            if (string.equals(GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_ENABLE.value())) {
                return GLMS_PRUNE_MODEL_ENABLE;
            }
            if (string.equals(GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_DISABLE.value())) {
                return GLMS_PRUNE_MODEL_DISABLE;
            }
            if (string.equals(GLMS_FTR_GENERATION_OPTION.GLMS_FTR_GENERATION_ENABLE.value())) {
                return GLMS_FTR_GENERATION_ENABLE;
            }
            if (string.equals(GLMS_FTR_GENERATION_OPTION.GLMS_FTR_GENERATION_DISABLE.value())) {
                return GLMS_FTR_GENERATION_DISABLE;
            }
            if (string.equals(GLMS_FTR_SELECTION_OPTION.GLMS_FTR_SELECTION_ENABLE.value())) {
                return GLMS_FTR_SELECTION_ENABLE;
            }
            if (string.equals(GLMS_FTR_SELECTION_OPTION.GLMS_FTR_SELECTION_DISABLE.value())) {
                return GLMS_FTR_SELECTION_DISABLE;
            }
            if (string.equals(GLMS_RIDGE_REGRESSION_OPTION.GLMS_RIDGE_REG_ENABLE.value())) {
                return GLMS_RIDGE_REG_ENABLE;
            }
            if (string.equals(GLMS_RIDGE_REGRESSION_OPTION.GLMS_RIDGE_REG_DISABLE.value())) {
                return GLMS_RIDGE_REG_DISABLE;
            }
            if (string.equals(GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_QUICK.value())) {
                return GLMS_FTR_IDENTIFICATION_QUICK;
            }
            if (string.equals(GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_COMPLETE.value())) {
                return GLMS_FTR_IDENTIFICATION_COMPLETE;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(GLMS_FTR_SEL_AIC)) {
                return GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_AIC.value();
            }
            if (string.equals(GLMS_FTR_SEL_SBIC)) {
                return GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_SBIC.value();
            }
            if (string.equals(GLMS_FTR_SEL_RIC)) {
                return GLMS_FTR_SEL_CRIT_OPTION.GLMS_FTR_SEL_RIC.value();
            }
            if (string.equals(GLMS_SEL_ALPHA_INV)) {
                return GLMS_FTR_SEL_CRIT_OPTION.GLMS_SEL_ALPHA_INV.value();
            }
            if (string.equals(ODMS_APPR_COMP_ENABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value();
            }
            if (string.equals(ODMS_APPR_COMP_DISABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value();
            }
            if (string.equals(GLMS_FTR_ACCEPTANCE_STRICT)) {
                return GLMS_FTR_ACCEPTANCE_OPTION.GLMS_FTR_ACCEPTANCE_STRICT.value();
            }
            if (string.equals(GLMS_FTR_ACCEPTANCE_RELAXED)) {
                return GLMS_FTR_ACCEPTANCE_OPTION.GLMS_FTR_ACCEPTANCE_RELAXED.value();
            }
            if (string.equals(GLMS_FTR_GEN_QUADRATIC)) {
                return GLMS_FTR_GEN_METHOD_OPTION.GLMS_FTR_GEN_QUADRATIC.value();
            }
            if (string.equals(GLMS_FTR_GEN_CUBIC)) {
                return GLMS_FTR_GEN_METHOD_OPTION.GLMS_FTR_GEN_CUBIC.value();
            }
            if (string.equals(GLMS_PRUNE_MODEL_ENABLE)) {
                return GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_ENABLE.value();
            }
            if (string.equals(GLMS_PRUNE_MODEL_DISABLE)) {
                return GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_DISABLE.value();
            }
            if (string.equals(GLMS_FTR_GENERATION_ENABLE)) {
                return GLMS_FTR_GENERATION_OPTION.GLMS_FTR_GENERATION_ENABLE.value();
            }
            if (string.equals(GLMS_FTR_GENERATION_DISABLE)) {
                return GLMS_FTR_GENERATION_OPTION.GLMS_FTR_GENERATION_DISABLE.value();
            }
            if (string.equals(GLMS_FTR_SELECTION_ENABLE)) {
                return GLMS_FTR_SELECTION_OPTION.GLMS_FTR_SELECTION_ENABLE.value();
            }
            if (string.equals(GLMS_FTR_SELECTION_DISABLE)) {
                return GLMS_FTR_SELECTION_OPTION.GLMS_FTR_SELECTION_DISABLE.value();
            }
            if (string.equals(GLMS_RIDGE_REG_ENABLE)) {
                return GLMS_RIDGE_REGRESSION_OPTION.GLMS_RIDGE_REG_ENABLE.value();
            }
            if (string.equals(GLMS_RIDGE_REG_DISABLE)) {
                return GLMS_RIDGE_REGRESSION_OPTION.GLMS_RIDGE_REG_DISABLE.value();
            }
            if (string.equals(GLMS_FTR_IDENTIFICATION_QUICK)) {
                return GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_QUICK.value();
            }
            if (string.equals(GLMS_FTR_IDENTIFICATION_COMPLETE)) {
                return GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_COMPLETE.value();
            }
            if (string.equals(GLMS_VIF_RIDGE_ENABLE)) {
                return GLMS_VIF_FOR_RIDGE_OPTION.GLMS_VIF_RIDGE_ENABLE.value();
            }
            if (string.equals(GLMS_VIF_RIDGE_DISABLE)) {
                return GLMS_VIF_FOR_RIDGE_OPTION.GLMS_VIF_RIDGE_DISABLE.value();
            }
            return null;
        }

        public static enum GLMS_FTR_IDENTIFICATION_OPTION {
            GLMS_FTR_IDENTIFICATION_QUICK(CoreServerConstantsLrb.get("GLMS_FTR_IDENTIFICATION_QUICK")),
            GLMS_FTR_IDENTIFICATION_COMPLETE(CoreServerConstantsLrb.get("GLMS_FTR_IDENTIFICATION_COMPLETE"));

            private final String value;

            private GLMS_FTR_IDENTIFICATION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_VIF_FOR_RIDGE_OPTION {
            GLMS_VIF_RIDGE_ENABLE(CoreServerConstantsLrb.get("GLMS_RIDGE_REG_ENABLE")),
            GLMS_VIF_RIDGE_DISABLE(CoreServerConstantsLrb.get("GLMS_RIDGE_REG_DISABLE"));

            private final String value;

            private GLMS_VIF_FOR_RIDGE_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_RIDGE_REGRESSION_OPTION {
            GLMS_RIDGE_REG_ENABLE(CoreServerConstantsLrb.get("GLMS_RIDGE_REG_ENABLE")),
            GLMS_RIDGE_REG_DISABLE(CoreServerConstantsLrb.get("GLMS_RIDGE_REG_DISABLE"));

            private final String value;

            private GLMS_RIDGE_REGRESSION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_FTR_GEN_METHOD_OPTION {
            GLMS_FTR_GEN_QUADRATIC(CoreServerConstantsLrb.get("GLMS_FTR_GEN_QUADRATIC")),
            GLMS_FTR_GEN_CUBIC(CoreServerConstantsLrb.get("GLMS_FTR_GEN_CUBIC"));

            private final String value;

            private GLMS_FTR_GEN_METHOD_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_FTR_GENERATION_OPTION {
            GLMS_FTR_GENERATION_ENABLE(CoreServerConstantsLrb.get("GLMS_FTR_GENERATION_ENABLE")),
            GLMS_FTR_GENERATION_DISABLE(CoreServerConstantsLrb.get("GLMS_FTR_GENERATION_DISABLE"));

            private final String value;

            private GLMS_FTR_GENERATION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_FTR_SELECTION_OPTION {
            GLMS_FTR_SELECTION_ENABLE(CoreServerConstantsLrb.get("GLMS_FTR_SELECTION_ENABLE")),
            GLMS_FTR_SELECTION_DISABLE(CoreServerConstantsLrb.get("GLMS_FTR_SELECTION_DISABLE"));

            private final String value;

            private GLMS_FTR_SELECTION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_FTR_ACCEPTANCE_OPTION {
            GLMS_FTR_ACCEPTANCE_STRICT(CoreServerConstantsLrb.get("GLMS_FTR_ACCEPTANCE_STRICT")),
            GLMS_FTR_ACCEPTANCE_RELAXED(CoreServerConstantsLrb.get("GLMS_FTR_ACCEPTANCE_RELAXED"));

            private final String value;

            private GLMS_FTR_ACCEPTANCE_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum ODMS_APPROXIMATE_COMPUTATION_OPTION {
            ODMS_APPR_COMP_ENABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_ENABLE")),
            ODMS_APPR_COMP_DISABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_DISABLE"));

            private final String value;

            private ODMS_APPROXIMATE_COMPUTATION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_FTR_SEL_CRIT_OPTION {
            GLMS_FTR_SEL_AIC(CoreServerConstantsLrb.get("GLMS_FTR_SEL_AIC")),
            GLMS_FTR_SEL_SBIC(CoreServerConstantsLrb.get("GLMS_FTR_SEL_SBIC")),
            GLMS_FTR_SEL_RIC(CoreServerConstantsLrb.get("GLMS_FTR_SEL_RIC")),
            GLMS_SEL_ALPHA_INV(CoreServerConstantsLrb.get("GLMS_SEL_ALPHA_INV"));

            private final String value;

            private GLMS_FTR_SEL_CRIT_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum GLMS_PRUNE_MODEL_OPTION {
            GLMS_PRUNE_MODEL_ENABLE(CoreServerConstantsLrb.get("GLMS_PRUNE_MODEL_ENABLE")),
            GLMS_PRUNE_MODEL_DISABLE(CoreServerConstantsLrb.get("GLMS_PRUNE_MODEL_DISABLE"));

            private final String value;

            private GLMS_PRUNE_MODEL_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static interface DEFAULTS {
            public static final double CONF_LEVVEL = 0.95;
            public static final String GLMS_SELECT_BLOCK = "GLMS_SELECT_BLOCK_DISABLE";
            public static final String GLMS_PRUNE_MODEL = "GLMS_PRUNE_MODEL_ENABLE";
            public static final String GLMS_SPARSE_SOLVER = "GLMS_SPARSE_SOLVER_DISABLE";
        }
    }

    public static class ClusteringSetings {
        public static final String CLUS_NUM_CLUSTERS = "CLUS_NUM_CLUSTERS";
        public static final String KMNS_BLOCK_GROWTH = "KMNS_BLOCK_GROWTH";
        public static final String KMNS_CONV_TOLERANCE = "KMNS_CONV_TOLERANCE";
        public static final String KMNS_DISTANCE = "KMNS_DISTANCE";
        public static final String KMNS_COSINE_STR = "KMNS_COSINE";
        public static final String KMNS_EUCLIDEAN_STR = "KMNS_EUCLIDEAN";
        public static final String KMNS_FAST_COSINE_STR = "KMNS_FAST_COSINE";
        public static final String KMNS_ITERATIONS = "KMNS_ITERATIONS";
        public static final String KMNS_MIN_PCT_ATTR_SUPPORT = "KMNS_MIN_PCT_ATTR_SUPPORT";
        public static final String KMNS_NUM_BINS = "KMNS_NUM_BINS";
        public static final String KMNS_SPLIT_CRITERION = "KMNS_SPLIT_CRITERION";
        public static final String KMNS_SIZE_STR = "KMNS_SIZE";
        public static final String KMNS_VARIANCE_STR = "KMNS_VARIANCE";
        public static final String KMNS_LEVEL_DETAILS_NONE = "KMNS_DETAILS_NONE";
        public static final String KMNS_LEVEL_DETAILS_HIERARCHY = "KMNS_DETAILS_HIERARCHY";
        public static final String KMNS_LEVEL_DETAILS_ALL = "KMNS_DETAILS_ALL";
        public static final String KMNS_DETAILS = "KMNS_DETAILS";
        public static final String KMNS_DETAILS_NONE = "KMNS_DETAILS_NONE";
        public static final String KMNS_DETAILS_HIERARCHY = "KMNS_DETAILS_HIERARCHY";
        public static final String KMNS_DETAILS_ALL = "KMNS_DETAILS_ALL";
        public static final String KMNS_RANDOM_SEED = "KMNS_RANDOM_SEED";
        public static final String OCLT_MAX_BUFFER = "OCLT_MAX_BUFFER";
        public static final String OCLT_SENSITIVITY = "OCLT_SENSITIVITY";
        public static final String ODMS_APPROXIMATE_COMPUTATION = "ODMS_APPROXIMATE_COMPUTATION";
        public static final String ODMS_APPR_COMP_ENABLE = "ODMS_APPR_COMP_ENABLE";
        public static final String ODMS_APPR_COMP_DISABLE = "ODMS_APPR_COMP_DISABLE";
        public static final String EMCS_NUM_COMPONENTS = "EMCS_NUM_COMPONENTS";
        public static final String NUM_COMPONENTS = "NUM_COMPONENTS";
        public static final String EMCS_CLUSTER_COMPONENTS = "EMCS_CLUSTER_COMPONENTS";
        public static final String EMCS_CLUSTER_COMP_ENABLE = "EMCS_CLUSTER_COMP_ENABLE";
        public static final String EMCS_CLUSTER_COMP_DISABLE = "EMCS_CLUSTER_COMP_DISABLE";
        public static final String EMCS_CLUSTER_THRESH = "EMCS_CLUSTER_THRESH";
        public static final String EMCS_MAX_NUM_ATTR_2D = "EMCS_MAX_NUM_ATTR_2D";
        public static final String EMCS_NUM_PROJECTIONS = "EMCS_NUM_PROJECTIONS";
        public static final String EMCS_NUM_QUANTILE_BINS = "EMCS_NUM_QUANTILE_BINS";
        public static final String EMCS_NUM_TOPN_BINS = "EMCS_NUM_TOPN_BINS";
        public static final String EMCS_NUM_EQUIWIDTH_BINS = "EMCS_NUM_EQUIWIDTH_BINS";
        public static final String EMCS_MIN_PCT_ATTR_SUPPORT = "EMCS_MIN_PCT_ATTR_SUPPORT";
        public static final String EMCS_CLUSTER_STATISTICS = "EMCS_CLUSTER_STATISTICS";
        public static final String EMCS_CLUS_STATS_ENABLE = "EMCS_CLUS_STATS_ENABLE";
        public static final String EMCS_CLUS_STATS_DISABLE = "EMCS_CLUS_STATS_DISABLE";
        public static final String EMCS_LEVEL_DETAILS_ALL = "EMCS_LEVEL_DETAILS_ALL";
        public static final String EMCS_LEVEL_DETAILS_HIERARCHY = "EMCS_LEVEL_DETAILS_HIERARCHY";
        public static final String EMCS_NUM_DISTRIBUTION = "EMCS_NUM_DISTRIBUTION";
        public static final String EMCS_NUM_DISTR_BERNOULLI = "EMCS_NUM_DISTR_BERNOULLI";
        public static final String EMCS_NUM_DISTR_GAUSSIAN = "EMCS_NUM_DISTR_GAUSSIAN";
        public static final String EMCS_NUM_DISTR_SYSTEM = "EMCS_NUM_DISTR_SYSTEM";
        public static final String EMCS_NUM_ITERATIONS = "EMCS_NUM_ITERATIONS";
        public static final String EMCS_LOGLIKE_IMPROVEMENT = "EMCS_LOGLIKE_IMPROVEMENT";
        public static final String LOGLIKELIHOOD = "LOGLIKELIHOOD";
        public static final String EMCS_LINKAGE_FUNCTION = "EMCS_LINKAGE_FUNCTION";
        public static final String EMCS_LINKAGE_SINGLE = "EMCS_LINKAGE_SINGLE";
        public static final String EMCS_LINKAGE_AVERAGE = "EMCS_LINKAGE_AVERAGE";
        public static final String EMCS_LINKAGE_COMPLETE = "EMCS_LINKAGE_COMPLETE";
        public static final String EMCS_CONVERGENCE_CRITERION = "EMCS_CONVERGENCE_CRITERION";
        public static final String EMCS_CONV_CRIT_HELDASIDE = "EMCS_CONV_CRIT_HELDASIDE";
        public static final String EMCS_CONV_CRIT_BIC = "EMCS_CONV_CRIT_BIC";
        public static final String EMCS_ATTRIBUTE_FILTER = "EMCS_ATTRIBUTE_FILTER";
        public static final String EMCS_ATTR_FILTER_ENABLE = "EMCS_ATTR_FILTER_ENABLE";
        public static final String EMCS_ATTR_FILTER_DISABLE = "EMCS_ATTR_FILTER_DISABLE";
        public static final String EMCS_RANDOM_SEED = "EMCS_RANDOM_SEED";
        public static final String EMCS_MODEL_SEARCH = "EMCS_MODEL_SEARCH";
        public static final String EMCS_MODEL_SEARCH_DISABLE = "EMCS_MODEL_SEARCH_DISABLE";
        public static final String EMCS_MODEL_SEARCH_ENABLE = "EMCS_MODEL_SEARCH_ENABLE";
        public static final String EMCS_REMOVE_COMPONENTS = "EMCS_REMOVE_COMPONENTS";
        public static final String EMCS_REMOVE_COMPS_DISABLE = "EMCS_REMOVE_COMPS_DISABLE";
        public static final String EMCS_REMOVE_COMPS_ENABLE = "EMCS_REMOVE_COMPS_ENABLE";
        public static final String REMOVED_COMPONENTS = "REMOVED_COMPONENTS";
        public static final String NUM_CLUSTERS = "NUM_CLUSTERS";

        public static String toAlgorithm(String string) {
            if (string.equals(KMNS_DISTANCE_OPTION.KMNS_COSINE.value())) {
                return KMNS_COSINE_STR;
            }
            if (string.equals(KMNS_DISTANCE_OPTION.KMNS_FAST_COSINE.value())) {
                return KMNS_FAST_COSINE_STR;
            }
            if (string.equals(KMNS_DISTANCE_OPTION.KMNS_EUCLIDEAN.value())) {
                return KMNS_EUCLIDEAN_STR;
            }
            if (string.equals(KMNS_SPLIT_CRITERION_OPTION.KMNS_SIZE.value())) {
                return KMNS_SIZE_STR;
            }
            if (string.equals(KMNS_SPLIT_CRITERION_OPTION.KMNS_VARIANCE.value())) {
                return KMNS_VARIANCE_STR;
            }
            if (string.equals(KMNS_DETAILS_OPTION.KMNS_ALL.value())) {
                return "KMNS_DETAILS_ALL";
            }
            if (string.equals(KMNS_DETAILS_OPTION.KMNS_NONE.value())) {
                return "KMNS_DETAILS_NONE";
            }
            if (string.equals(KMNS_DETAILS_OPTION.KMNS_HIERARCHY.value())) {
                return "KMNS_DETAILS_HIERARCHY";
            }
            if (string.equals(EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_BERNOULLI.value())) {
                return EMCS_NUM_DISTR_BERNOULLI;
            }
            if (string.equals(EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_GAUSSIAN.value())) {
                return EMCS_NUM_DISTR_GAUSSIAN;
            }
            if (string.equals(EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_SYSTEM.value())) {
                return EMCS_NUM_DISTR_SYSTEM;
            }
            if (string.equals(EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_SINGLE.value())) {
                return EMCS_LINKAGE_SINGLE;
            }
            if (string.equals(EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_AVERAGE.value())) {
                return EMCS_LINKAGE_AVERAGE;
            }
            if (string.equals(EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_COMPLETE.value())) {
                return EMCS_LINKAGE_COMPLETE;
            }
            if (string.equals(EMCS_CONVERGENCE_CRITERION_OPTION.EMCS_CONV_CRIT_HELDASIDE.value())) {
                return EMCS_CONV_CRIT_HELDASIDE;
            }
            if (string.equals(EMCS_CONVERGENCE_CRITERION_OPTION.EMCS_CONV_CRIT_BIC.value())) {
                return EMCS_CONV_CRIT_BIC;
            }
            if (string.equals(EMCS_ATTRIBUTE_FILTER_OPTION.EMCS_ATTR_FILTER_ENABLE.value())) {
                return EMCS_ATTR_FILTER_ENABLE;
            }
            if (string.equals(EMCS_ATTRIBUTE_FILTER_OPTION.EMCS_ATTR_FILTER_DISABLE.value())) {
                return EMCS_ATTR_FILTER_DISABLE;
            }
            if (string.equals(EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_ENABLE.value())) {
                return EMCS_MODEL_SEARCH_ENABLE;
            }
            if (string.equals(EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_DISABLE.value())) {
                return EMCS_MODEL_SEARCH_DISABLE;
            }
            if (string.equals(EMCS_CLUSTER_STATISTICS_OPTION.EMCS_CLUS_STATS_ENABLE.value()) || string.equals(EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value())) {
                return EMCS_CLUS_STATS_ENABLE;
            }
            if (string.equals(EMCS_CLUSTER_STATISTICS_OPTION.EMCS_CLUS_STATS_DISABLE.value()) || string.equals(EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_HIERARCHY.value())) {
                return EMCS_CLUS_STATS_DISABLE;
            }
            if (string.equals(EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_ENABLE.value())) {
                return EMCS_REMOVE_COMPS_ENABLE;
            }
            if (string.equals(EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_DISABLE.value())) {
                return EMCS_REMOVE_COMPS_DISABLE;
            }
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value())) {
                return ODMS_APPR_COMP_ENABLE;
            }
            if (string.equals(ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value())) {
                return ODMS_APPR_COMP_DISABLE;
            }
            return null;
        }

        public static String toHuman(String string) {
            if (string.equals(KMNS_COSINE_STR)) {
                return KMNS_DISTANCE_OPTION.KMNS_COSINE.value();
            }
            if (string.equals(KMNS_FAST_COSINE_STR)) {
                return KMNS_DISTANCE_OPTION.KMNS_FAST_COSINE.value();
            }
            if (string.equals(KMNS_EUCLIDEAN_STR)) {
                return KMNS_DISTANCE_OPTION.KMNS_EUCLIDEAN.value();
            }
            if (string.equals(KMNS_SIZE_STR)) {
                return KMNS_SPLIT_CRITERION_OPTION.KMNS_SIZE.value();
            }
            if (string.equals(KMNS_VARIANCE_STR)) {
                return KMNS_SPLIT_CRITERION_OPTION.KMNS_VARIANCE.value();
            }
            if (string.equals("KMNS_DETAILS_ALL")) {
                return KMNS_DETAILS_OPTION.KMNS_ALL.value();
            }
            if (string.equals("KMNS_DETAILS_NONE")) {
                return KMNS_DETAILS_OPTION.KMNS_NONE.value();
            }
            if (string.equals("KMNS_DETAILS_HIERARCHY")) {
                return KMNS_DETAILS_OPTION.KMNS_HIERARCHY.value();
            }
            if (string.equals(EMCS_NUM_DISTR_BERNOULLI)) {
                return EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_BERNOULLI.value();
            }
            if (string.equals(EMCS_NUM_DISTR_GAUSSIAN)) {
                return EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_GAUSSIAN.value();
            }
            if (string.equals(EMCS_NUM_DISTR_SYSTEM)) {
                return EMCS_NUM_DISTRIBUTION_OPTION.EMCS_NUM_DISTR_SYSTEM.value();
            }
            if (string.equals(EMCS_LINKAGE_SINGLE)) {
                return EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_SINGLE.value();
            }
            if (string.equals(EMCS_LINKAGE_AVERAGE)) {
                return EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_AVERAGE.value();
            }
            if (string.equals(EMCS_LINKAGE_COMPLETE)) {
                return EMCS_LINKAGE_FUNCTION_OPTION.EMCS_LINKAGE_COMPLETE.value();
            }
            if (string.equals(EMCS_CONV_CRIT_HELDASIDE)) {
                return EMCS_CONVERGENCE_CRITERION_OPTION.EMCS_CONV_CRIT_HELDASIDE.value();
            }
            if (string.equals(EMCS_CONV_CRIT_BIC)) {
                return EMCS_CONVERGENCE_CRITERION_OPTION.EMCS_CONV_CRIT_BIC.value();
            }
            if (string.equals(EMCS_ATTR_FILTER_ENABLE)) {
                return EMCS_ATTRIBUTE_FILTER_OPTION.EMCS_ATTR_FILTER_ENABLE.value();
            }
            if (string.equals(EMCS_ATTR_FILTER_DISABLE)) {
                return EMCS_ATTRIBUTE_FILTER_OPTION.EMCS_ATTR_FILTER_DISABLE.value();
            }
            if (string.equals(EMCS_MODEL_SEARCH_ENABLE)) {
                return EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_ENABLE.value();
            }
            if (string.equals(EMCS_MODEL_SEARCH_DISABLE)) {
                return EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_DISABLE.value();
            }
            if (string.equals(EMCS_CLUS_STATS_ENABLE)) {
                return EMCS_CLUSTER_STATISTICS_OPTION.EMCS_CLUS_STATS_ENABLE.value();
            }
            if (string.equals(EMCS_CLUS_STATS_DISABLE)) {
                return EMCS_CLUSTER_STATISTICS_OPTION.EMCS_CLUS_STATS_DISABLE.value();
            }
            if (string.equals(EMCS_LEVEL_DETAILS_ALL)) {
                return EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value();
            }
            if (string.equals(EMCS_LEVEL_DETAILS_HIERARCHY)) {
                return EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_HIERARCHY.value();
            }
            if (string.equals(EMCS_REMOVE_COMPS_ENABLE)) {
                return EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_ENABLE.value();
            }
            if (string.equals(EMCS_REMOVE_COMPS_DISABLE)) {
                return EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_DISABLE.value();
            }
            if (string.equals(ODMS_APPR_COMP_ENABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value();
            }
            if (string.equals(ODMS_APPR_COMP_DISABLE)) {
                return ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value();
            }
            return null;
        }

        public static interface DEFAULTS {
            public static final int CLUS_NUM_CLUSTERS = 10;
            public static final int KMNS_BLOCK_GROWTH = 2;
            public static final double KMNS_CONV_TOLERANCE = 0.01;
            public static final int KMNS_ITERATIONS = 20;
            public static final double KMNS_MIN_PCT_ATTR_SUPPORT = 0.1;
            public static final int KMNS_NUM_BINS = 10;
            public static final String KMNSDISTANCE = "KMNS_EUCLIDEAN";
            public static final String KMNSSPLITCRITERION = "KMNS_VARIANCE";
            public static final BigInteger KMNS_RANDOM_SEED = BigInteger.valueOf(0L);
            public static final String KMNS_DETAILS = "KMNS_DETAILS_ALL";
            public static final int OCLT_MAX_BUFFER = 50000;
            public static final double OCLT_SENSITIVITY = 0.5;
            public static final int EMCS_NUM_COMPONENTS = 20;
            public static final String EMCS_CLUSTER_COMPONENTS = "EMCS_CLUSTER_COMP_ENABLE";
            public static final double EMCS_CLUSTER_THRESH = 2.0;
            public static final int EMCS_MAX_NUM_ATTR_2D = 50;
            public static final int EMCS_NUM_PROJECTIONS = 50;
            public static final int EMCS_NUM_EQUIWIDTH_BINS = 11;
            public static final double EMCS_MIN_PCT_ATTR_SUPPORT = 0.1;
            public static final String EMCS_CLUSTER_STATISTICS = "EMCS_CLUS_STATS_ENABLE";
            public static final String EMCS_NUM_DISTRIBUTION = "EMCS_NUM_DISTR_SYSTEM";
            public static final int EMCS_NUM_ITERATIONS = 100;
            public static final double EMCS_LOGLIKE_IMPROVEMENT = 0.001;
            public static final String EMCS_LINKAGE_FUNCTION = "EMCS_LINKAGE_SINGLE";
        }

        public static enum KMNS_DETAILS_OPTION {
            KMNS_NONE(CoreServerConstantsLrb.get("CLUS_LEVEL_DETAILS_NONE")),
            KMNS_HIERARCHY(CoreServerConstantsLrb.get("CLUS_LEVEL_DETAILS_HIERARCHY")),
            KMNS_ALL(CoreServerConstantsLrb.get("CLUS_LEVEL_DETAILS_ALL"));

            private final String value;

            private KMNS_DETAILS_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum KMNS_SPLIT_CRITERION_OPTION {
            KMNS_SIZE(CoreServerConstantsLrb.get("KMEANS_SIZE")),
            KMNS_VARIANCE(CoreServerConstantsLrb.get("KMEANS_VARIANCE"));

            private final String value;

            private KMNS_SPLIT_CRITERION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum KMNS_DISTANCE_OPTION {
            KMNS_COSINE(CoreServerConstantsLrb.get("KMEANS_COSINE")),
            KMNS_EUCLIDEAN(CoreServerConstantsLrb.get("KMEANS_EUCLIDEAN")),
            KMNS_FAST_COSINE(CoreServerConstantsLrb.get("KMEANS_FAST_COSINE"));

            private final String value;

            private KMNS_DISTANCE_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_REMOVE_COMPONENTS_OPTION {
            EMCS_REMOVE_COMPS_DISABLE(CoreCommonLrb.get("DISABLE")),
            EMCS_REMOVE_COMPS_ENABLE(CoreCommonLrb.get("ENABLE"));

            private final String value;

            private EMCS_REMOVE_COMPONENTS_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_LEVEL_DETAILS_OPTION {
            EMCS_LEVEL_DETAILS_HIERARCHY(CoreServerConstantsLrb.get("CLUS_LEVEL_DETAILS_HIERARCHY")),
            EMCS_LEVEL_DETAILS_ALL(CoreServerConstantsLrb.get("CLUS_LEVEL_DETAILS_ALL"));

            private final String value;

            private EMCS_LEVEL_DETAILS_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_CLUSTER_STATISTICS_OPTION {
            EMCS_CLUS_STATS_DISABLE(CoreCommonLrb.get("DISABLE")),
            EMCS_CLUS_STATS_ENABLE(CoreCommonLrb.get("ENABLE"));

            private final String value;

            private EMCS_CLUSTER_STATISTICS_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_MODEL_SEARCH_OPTION {
            EMCS_MODEL_SEARCH_DISABLE(CoreCommonLrb.get("DISABLE")),
            EMCS_MODEL_SEARCH_ENABLE(CoreCommonLrb.get("ENABLE"));

            private final String value;

            private EMCS_MODEL_SEARCH_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_ATTRIBUTE_FILTER_OPTION {
            EMCS_ATTR_FILTER_ENABLE(CoreServerConstantsLrb.get("EMCS_ATTR_FILTER_ENABLE")),
            EMCS_ATTR_FILTER_DISABLE(CoreServerConstantsLrb.get("EMCS_ATTR_FILTER_DISABLE"));

            private final String value;

            private EMCS_ATTRIBUTE_FILTER_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum ODMS_APPROXIMATE_COMPUTATION_OPTION {
            ODMS_APPR_COMP_ENABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_ENABLE")),
            ODMS_APPR_COMP_DISABLE(CoreServerConstantsLrb.get("ODMS_APPR_COMP_DISABLE"));

            private final String value;

            private ODMS_APPROXIMATE_COMPUTATION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_CONVERGENCE_CRITERION_OPTION {
            EMCS_CONV_CRIT_HELDASIDE(CoreServerConstantsLrb.get("EMCS_CONV_CRIT_HELDASIDE")),
            EMCS_CONV_CRIT_BIC(CoreServerConstantsLrb.get("EMCS_CONV_CRIT_BIC"));

            private final String value;

            private EMCS_CONVERGENCE_CRITERION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_LINKAGE_FUNCTION_OPTION {
            EMCS_LINKAGE_SINGLE(CoreServerConstantsLrb.get("EMCS_LINKAGE_SINGLE")),
            EMCS_LINKAGE_AVERAGE(CoreServerConstantsLrb.get("EMCS_LINKAGE_AVERAGE")),
            EMCS_LINKAGE_COMPLETE(CoreServerConstantsLrb.get("EMCS_LINKAGE_COMPLETE"));

            private final String value;

            private EMCS_LINKAGE_FUNCTION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }

        public static enum EMCS_NUM_DISTRIBUTION_OPTION {
            EMCS_NUM_DISTR_BERNOULLI(CoreServerConstantsLrb.get("EMCS_NUM_DISTR_BERNOULLI")),
            EMCS_NUM_DISTR_GAUSSIAN(CoreServerConstantsLrb.get("EMCS_NUM_DISTR_GAUSSIAN")),
            EMCS_NUM_DISTR_SYSTEM(CoreServerConstantsLrb.get("EMCS_NUM_DISTR_SYSTEM"));

            private final String value;

            private EMCS_NUM_DISTRIBUTION_OPTION(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }
        }
    }

    public static class AssocSettings {
        public static final String ASSO_AGGREGATES = "ASSO_AGGREGATES";
        public static final String ASSO_MAX_RULE_LENGTH = "ASSO_MAX_RULE_LENGTH";
        public static final String ASSO_MIN_CONFIDENCE = "ASSO_MIN_CONFIDENCE";
        public static final String ASSO_MIN_SUPPORT = "ASSO_MIN_SUPPORT";
        public static final String ASSO_MIN_REVERSE_CONF = "ASSO_MIN_REVERSE_CONF";
        public static final String ASSO_MIN_SUPPORT_COUNT = "ASSO_MIN_SUPPORT_COUNT";
        public static final String ODMS_ITEM_ID_COLUMN_NAME = "ODMS_ITEM_ID_COLUMN_NAME";
        public static final String ODMS_ITEM_VALUE_COLUMN_NAME = "ODMS_ITEM_VALUE_COLUMN_NAME";
        public static final String ASSO_ANT_IN_RULES = "ASSO_ANT_IN_RULES";
        public static final String ASSO_CONS_IN_RULES = "ASSO_CONS_IN_RULES";
        public static final String ASSO_ANT_EX_RULES = "ASSO_ANT_EX_RULES";
        public static final String ASSO_CONS_EX_RULES = "ASSO_CONS_EX_RULES";
        public static final String ASSO_GENERATE_PREPROCESSED_TABLE = "ASSO_GENERATE_PREPROCESSED_TABLE";
        public static final String ASSO_PREPROCESSED_TABLE_NAME = "ASSO_PREPROCESSED_TABLE_NAME";
        public static final String ASSO_DEFAULT_NO_GENERATED_TABLE = "NONE";
        public static final String ASSO_FILTERS_ACTIVE = "ASSO_FILTERS_ACTIVE";
        public static final String ASSO_MIN_REV_CONFIDENCE = "ASSO_MIN_REV_CONFIDENCE";
        public static final String ASSO_MIN_SUPPORT_INT = "ASSO_MIN_SUPPORT_INT";
        public static final String ASSO_IN_RULES = "ASSO_IN_RULES";
        public static final String ASSO_EX_RULES = "ASSO_EX_RULES";
        public static final String ITEMSET_COUNT = "ITEMSET_COUNT";
        public static final String MAX_SUPPORT = "MAX_SUPPORT";
        public static final String RULE_COUNT = "RULE_COUNT";
        public static final String TRANSACTION_COUNT = "TRANSACTION_COUNT";

        public static interface UPPER_BOUND {
            public static final int ASSO_MAX_RULE_LENGTH = 20;
            public static final double ASSO_MAX_CONFIDENCE = 1.0;
            public static final double ASSO_MAX_SUPPORT = 1.0;
            public static final double ASSO_MAX_REVERSE_CONFIDENCE = 1.0;
            public static final int ASSO_MAX_SUPPORT_COUNT = Integer.MAX_VALUE;
        }

        public static interface LOWER_BOUND {
            public static final int ASSO_MAX_RULE_LENGTH = 2;
            public static final double ASSO_MIN_CONFIDENCE = 0.0;
            public static final double ASSO_MIN_SUPPORT = 0.0;
            public static final double ASSO_MIN_REVERSE_CONFIDENCE = 0.0;
            public static final int ASSO_MIN_SUPPORT_COUNT = 1;
        }

        public static interface DEFAULTS {
            public static final int ASSO_DEF_RULE_LENGTH = 4;
            public static final double ASSO_DEF_CONFIDENCE = 0.1;
            public static final double ASSO_DEF_SUPPORT = 0.01;
            public static final double ASSO_DEF_REVERSE_CONFIDENCE = 0.0;
            public static final BigInteger ASSO_DEF_SUPPORT_COUNT = BigInteger.valueOf(1L);
            public static final ASSOAGGREGATES ASSO_AGGREGATES = new ASSOAGGREGATES();
            public static final String ODMS_ITEM_ID_COLUMN_NAME = "";
            public static final String ODMS_ITEM_VALUE_COLUMN_NAME = "";
            public static final RuleItemsType ASSO_ANT_IN_RULES = new RuleItemsType();
            public static final RuleItemsType ASSO_ANT_EX_RULES = new RuleItemsType();
            public static final RuleItemsType ASSO_CONS_IN_RULES = new RuleItemsType();
            public static final RuleItemsType ASSO_CONS_EX_RULES = new RuleItemsType();
            public static final boolean ASSO_GENERATE_PREPROCESSED_TABLE = false;
            public static final boolean ASSO_FILTERS_ACTIVE = false;
        }
    }

    public static class Algorithm {
        public static final String ALGO_NAIVE_BAYES = "ALGO_NAIVE_BAYES";
        public static final String ALGO_ADAPTIVE_BAYES_NETWORK = "ALGO_ADAPTIVE_BAYES_NETWORK";
        public static final String ALGO_SUPPORT_VECTOR_MACHINE = "ALGO_SUPPORT_VECTOR_MACHINES";
        public static final String ALGO_NONNEGATIVE_MATRIX_FACTOR = "ALGO_NONNEGATIVE_MATRIX_FACTOR";
        public static final String ALGO_SINGULAR_VALUE_DECOMP = "ALGO_SINGULAR_VALUE_DECOMP";
        public static final String ALGO_PRINCIPAL_COMPONENT_ANALYSIS = "ALGO_PRINCIPAL_COMPONENT_ANALYSIS";
        public static final String ALGO_APRIORI_ASSOCIATION_RULES = "ALGO_APRIORI_ASSOCIATION_RULES";
        public static final String ALGO_KMEANS = "ALGO_KMEANS";
        public static final String ALGO_O_CLUSTER = "ALGO_O_CLUSTER";
        public static final String ALGO_EXPECTATION_MAXIMIZATION = "ALGO_EXPECTATION_MAXIMIZATION";
        public static final String ALGO_AI_MDL = "ALGO_AI_MDL";
        public static final String ALGO_DECISION_TREE = "ALGO_DECISION_TREE";
        public static final String ALGO_GENERALIZED_LINEAR_MODEL = "ALGO_GENERALIZED_LINEAR_MODEL";
        public static final String ALGO_NAIVE_BAYES_IN_MODEL = "NAIVE_BAYES";
        public static final String ALGO_ADAPTIVE_BAYES_NETWORK_IN_MODEL = "ADAPTIVE_BAYES_NETWORK";
        public static final String ALGO_SUPPORT_VECTOR_MACHINE_IN_MODEL = "SUPPORT_VECTOR_MACHINES";
        public static final String ALGO_NONNEGATIVE_MATRIX_FACTOR_IN_MODEL = "NONNEGATIVE_MATRIX_FACTOR";
        public static final String ALGO_SINGULAR_VALUE_DECOMP_IN_MODEL = "SINGULAR_VALUE_DECOMP";
        public static final String ALGO_PRINCIPAL_COMPONENT_ANALYSIS_IN_MODEL = "PRINCIPAL_COMPONENT_ANALYSIS";
        public static final String ALGO_EXPLICIT_SEMANTIC_ANALYS = "ALGO_EXPLICIT_SEMANTIC_ANALYS";
        public static final String ALGO_APRIORI_ASSOCIATION_RULES_IN_MODEL = "APRIORI_ASSOCIATION_RULES";
        public static final String ALGO_KMEANS_IN_MODEL = "KMEANS";
        public static final String ALGO_O_CLUSTER_IN_MODEL = "O_CLUSTER";
        public static final String ALGO_EXPECTATION_MAXIMIZATION_IN_MODEL = "EXPECTATION_MAXIMIZATION";
        public static final String ALGO_AI_MDL_IN_MODEL = "MINIMUM_DESCRIPTION_LENGTH";
        public static final String ALGO_DECISION_TREE_IN_MODEL = "DECISION_TREE";
        public static final String ALGO_GENERALIZED_LINEAR_MODEL_IN_MODEL = "GENERALIZED_LINEAR_MODEL";
        public static final String ALGO_R_USER_DEFINED = "ALGO_R_USER_DEFINED";
        private static HashMap<String, String> s_algorithmNames = new HashMap();

        public static boolean isSVM(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_SUPPORT_VECTOR_MACHINE.equalsIgnoreCase(string);
        }

        public static boolean isDT(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_DECISION_TREE.equalsIgnoreCase(string);
        }

        public static boolean isGLM(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_GENERALIZED_LINEAR_MODEL.equalsIgnoreCase(string);
        }

        public static boolean isNB(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_NAIVE_BAYES.equalsIgnoreCase(string);
        }

        public static boolean isKM(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_KMEANS.equalsIgnoreCase(string);
        }

        public static boolean isOC(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_O_CLUSTER.equalsIgnoreCase(string);
        }

        public static boolean isEM(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_EXPECTATION_MAXIMIZATION.equalsIgnoreCase(string);
        }

        public static boolean isNMF(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_NONNEGATIVE_MATRIX_FACTOR.equalsIgnoreCase(string);
        }

        public static boolean isSVD(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_SINGULAR_VALUE_DECOMP.equalsIgnoreCase(string);
        }

        public static boolean isPCA(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_PRINCIPAL_COMPONENT_ANALYSIS.equalsIgnoreCase(string);
        }

        public static boolean isESA(String string) {
            if (string == null) {
                return false;
            }
            return ALGO_EXPLICIT_SEMANTIC_ANALYS.equalsIgnoreCase(string);
        }

        public static HashMap<String, String> getAlgorithmMap() {
            return s_algorithmNames;
        }

        public static String getUIAlgorithmName(String string) {
            return s_algorithmNames.get(string);
        }

        static {
            s_algorithmNames.put(ALGO_NAIVE_BAYES, CoreServerConstantsLrb.get(ALGO_NAIVE_BAYES));
            s_algorithmNames.put(ALGO_ADAPTIVE_BAYES_NETWORK, CoreServerConstantsLrb.get(ALGO_ADAPTIVE_BAYES_NETWORK));
            s_algorithmNames.put(ALGO_SUPPORT_VECTOR_MACHINE, CoreServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
            s_algorithmNames.put(ALGO_NONNEGATIVE_MATRIX_FACTOR, CoreServerConstantsLrb.get(ALGO_NONNEGATIVE_MATRIX_FACTOR));
            s_algorithmNames.put(ALGO_SINGULAR_VALUE_DECOMP, CoreServerConstantsLrb.get(ALGO_SINGULAR_VALUE_DECOMP));
            s_algorithmNames.put(ALGO_PRINCIPAL_COMPONENT_ANALYSIS, CoreServerConstantsLrb.get(ALGO_PRINCIPAL_COMPONENT_ANALYSIS));
            s_algorithmNames.put(ALGO_APRIORI_ASSOCIATION_RULES, CoreServerConstantsLrb.get(ALGO_APRIORI_ASSOCIATION_RULES));
            s_algorithmNames.put(ALGO_KMEANS, CoreServerConstantsLrb.get(ALGO_KMEANS));
            s_algorithmNames.put(ALGO_O_CLUSTER, CoreServerConstantsLrb.get(ALGO_O_CLUSTER));
            s_algorithmNames.put(ALGO_EXPECTATION_MAXIMIZATION, CoreServerConstantsLrb.get(ALGO_EXPECTATION_MAXIMIZATION));
            s_algorithmNames.put(ALGO_AI_MDL, CoreServerConstantsLrb.get(ALGO_AI_MDL));
            s_algorithmNames.put(ALGO_DECISION_TREE, CoreServerConstantsLrb.get(ALGO_DECISION_TREE));
            s_algorithmNames.put(ALGO_GENERALIZED_LINEAR_MODEL, CoreServerConstantsLrb.get(ALGO_GENERALIZED_LINEAR_MODEL));
            s_algorithmNames.put(ALGO_NAIVE_BAYES_IN_MODEL, CoreServerConstantsLrb.get(ALGO_NAIVE_BAYES));
            s_algorithmNames.put(ALGO_ADAPTIVE_BAYES_NETWORK_IN_MODEL, CoreServerConstantsLrb.get(ALGO_ADAPTIVE_BAYES_NETWORK));
            s_algorithmNames.put(ALGO_SUPPORT_VECTOR_MACHINE_IN_MODEL, CoreServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
            s_algorithmNames.put(ALGO_NONNEGATIVE_MATRIX_FACTOR_IN_MODEL, CoreServerConstantsLrb.get(ALGO_NONNEGATIVE_MATRIX_FACTOR));
            s_algorithmNames.put(ALGO_SINGULAR_VALUE_DECOMP_IN_MODEL, CoreServerConstantsLrb.get(ALGO_SINGULAR_VALUE_DECOMP));
            s_algorithmNames.put(ALGO_PRINCIPAL_COMPONENT_ANALYSIS_IN_MODEL, CoreServerConstantsLrb.get(ALGO_PRINCIPAL_COMPONENT_ANALYSIS));
            s_algorithmNames.put(ALGO_APRIORI_ASSOCIATION_RULES_IN_MODEL, CoreServerConstantsLrb.get(ALGO_APRIORI_ASSOCIATION_RULES));
            s_algorithmNames.put(ALGO_KMEANS_IN_MODEL, CoreServerConstantsLrb.get(ALGO_KMEANS));
            s_algorithmNames.put(ALGO_O_CLUSTER_IN_MODEL, CoreServerConstantsLrb.get(ALGO_O_CLUSTER));
            s_algorithmNames.put(ALGO_EXPECTATION_MAXIMIZATION_IN_MODEL, CoreServerConstantsLrb.get(ALGO_EXPECTATION_MAXIMIZATION));
            s_algorithmNames.put(ALGO_AI_MDL_IN_MODEL, CoreServerConstantsLrb.get(ALGO_AI_MDL));
            s_algorithmNames.put(ALGO_DECISION_TREE_IN_MODEL, CoreServerConstantsLrb.get(ALGO_DECISION_TREE));
            s_algorithmNames.put(ALGO_GENERALIZED_LINEAR_MODEL_IN_MODEL, CoreServerConstantsLrb.get(ALGO_GENERALIZED_LINEAR_MODEL));
            s_algorithmNames.put(ALGO_EXPLICIT_SEMANTIC_ANALYS, CoreServerConstantsLrb.get(ALGO_EXPLICIT_SEMANTIC_ANALYS));
            s_algorithmNames.put(ALGO_R_USER_DEFINED, CoreServerConstantsLrb.get(ALGO_R_USER_DEFINED));
        }
    }

    public static class MiningFunction {
        public static final String CLASSIFICATION = "CLASSIFICATION";
        public static final String REGRESSION = "REGRESSION";
        public static final String CLUSTERING = "CLUSTERING";
        public static final String ASSOCIATION = "ASSOCIATION";
        public static final String ASSOCIATION_IN_MODEL = "ASSOCIATION_RULES";
        public static final String FEATURE_EXTRACTION = "FEATURE_EXTRACTION";
        public static final String ATTRIBUTE_IMPORTANCE = "ATTRIBUTE_IMPORTANCE";
        public static final String ANOMALY_DETECTION = "ANOMALY_DETECTION";
        private static HashMap<String, String> s_functionNames = new HashMap();

        public static boolean isClassification(String string) {
            if (string == null) {
                return false;
            }
            return CLASSIFICATION.equalsIgnoreCase(string);
        }

        public static boolean isAnomaly(String string) {
            if (string == null) {
                return false;
            }
            return ANOMALY_DETECTION.equalsIgnoreCase(string);
        }

        public static boolean isRegression(String string) {
            if (string == null) {
                return false;
            }
            return REGRESSION.equalsIgnoreCase(string);
        }

        public static boolean isClustering(String string) {
            if (string == null) {
                return false;
            }
            return CLUSTERING.equalsIgnoreCase(string);
        }

        public static boolean isAssociation(String string) {
            if (string == null) {
                return false;
            }
            return ASSOCIATION.equalsIgnoreCase(string);
        }

        public static boolean isFeature(String string) {
            if (string == null) {
                return false;
            }
            return FEATURE_EXTRACTION.equalsIgnoreCase(string);
        }

        public static String getUIFunctionName(String string) {
            return s_functionNames.get(string);
        }

        static {
            s_functionNames.put(CLASSIFICATION, CoreServerConstantsLrb.get(CLASSIFICATION));
            s_functionNames.put(REGRESSION, CoreServerConstantsLrb.get(REGRESSION));
            s_functionNames.put(CLUSTERING, CoreServerConstantsLrb.get(CLUSTERING));
            s_functionNames.put(ASSOCIATION, CoreServerConstantsLrb.get(ASSOCIATION));
            s_functionNames.put(ASSOCIATION_IN_MODEL, CoreServerConstantsLrb.get(ASSOCIATION));
            s_functionNames.put(FEATURE_EXTRACTION, CoreServerConstantsLrb.get(FEATURE_EXTRACTION));
            s_functionNames.put(ATTRIBUTE_IMPORTANCE, CoreServerConstantsLrb.get(ATTRIBUTE_IMPORTANCE));
            s_functionNames.put(ANOMALY_DETECTION, CoreServerConstantsLrb.get(ANOMALY_DETECTION));
        }
    }

    public static class UsageType {
        public static final String NOT_USED = "N";
        public static final String INPUT = "I";
        public static final String TARGET = "T";
        public static final String SUPPLEMENTAL = "S";
    }

    public static class MiningType {
        public static final String CATEGORICAL = "Categorical";
        private static final String CATEGORICAL_ALL_CAPS = "Categorical".toUpperCase();
        private static final String CATEGORICAL_HUMAN = CoreServerConstantsLrb.get("MINING_TYPE_CATEGORICAL");
        public static final String NUMERICAL = "Numerical";
        private static final String NUMERICAL_ALL_CAPS = "Numerical".toUpperCase();
        private static final String NUMERICAL_HUMAN = CoreServerConstantsLrb.get("MINING_TYPE_NUMERICAL");
        public static final String TEXT = "Text";
        private static final String TEXT_ALL_CAPS = "Text".toUpperCase();
        private static final String TEXT_HUMAN = CoreServerConstantsLrb.get("MINING_TYPE_TEXT");
        public static final String MIXED = "Mixed";
        private static final String MIXED_ALL_CAPS = "Mixed".toUpperCase();
        private static final String MIXED_HUMAN = CoreServerConstantsLrb.get("MINING_TYPE_MIXED");
        public static final String PARTITION = "Partition";
        private static final String PARTITION_ALL_CAPS = "Partition".toUpperCase();
        private static final String PARTITION_HUMAN = CoreServerConstantsLrb.get("MINING_TYPE_PARTITION");
        public static final String TEXT_CUSTOM = "TextCustom";

        public static String toHuman(String string) {
            String string2 = "unknown";
            if (string.equals(CATEGORICAL) || string.equals(CATEGORICAL_ALL_CAPS)) {
                string2 = CATEGORICAL_HUMAN;
            } else if (string.equals(NUMERICAL) || string.equals(NUMERICAL_ALL_CAPS)) {
                string2 = NUMERICAL_HUMAN;
            } else if (string.equals(TEXT) || string.equals(TEXT_ALL_CAPS)) {
                string2 = TEXT_HUMAN;
            } else if (string.equals(MIXED) || string.equals(MIXED_ALL_CAPS)) {
                string2 = MIXED_HUMAN;
            } else if (string.equals(PARTITION) || string.equals(PARTITION_ALL_CAPS)) {
                string2 = PARTITION_HUMAN;
            }
            return string2;
        }

        public static String toSchema(String string) {
            String string2 = "unknown";
            if (string.equals(CATEGORICAL_HUMAN)) {
                string2 = CATEGORICAL;
            } else if (string.equals(NUMERICAL_HUMAN)) {
                string2 = NUMERICAL;
            } else if (string.equals(TEXT_HUMAN)) {
                string2 = TEXT;
            } else if (string.equals(MIXED_HUMAN)) {
                string2 = MIXED;
            } else if (string.equals(PARTITION_HUMAN)) {
                string2 = PARTITION;
            }
            return string2;
        }
    }
}

