/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.clus;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.clus.AttributeBinIdentifier;
import oracle.dmt.dataminer.core.model.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.core.model.generated.server.DmHistograms;

public class HistogramRowData {
    private String attributeName;
    private String attributeSubname;
    private Integer binId;
    private Double lowerBound;
    private Double upperBound;
    private String label;
    private Double count;

    public HistogramRowData() {
        this.attributeName = "";
        this.attributeSubname = "";
        this.binId = 0;
        this.lowerBound = 0.0;
        this.upperBound = 0.0;
        this.label = "";
        this.count = 0.0;
    }

    public HistogramRowData(String string, String string2, Integer n, Double d, Double d2, String string3, Double d3) {
        this.attributeName = string;
        this.attributeSubname = string2;
        this.binId = n;
        this.lowerBound = d;
        this.upperBound = d2;
        this.label = string3;
        this.count = d3;
    }

    public HistogramRowData(DmHistogramBin dmHistogramBin) throws SQLException {
        this.attributeName = dmHistogramBin.getAttributeName();
        this.attributeSubname = dmHistogramBin.getAttributeSubname() != null ? dmHistogramBin.getAttributeSubname() : null;
        this.binId = dmHistogramBin.getBinId() != null ? Integer.valueOf(dmHistogramBin.getBinId().intValue()) : null;
        this.lowerBound = dmHistogramBin.getLowerBound() != null ? Double.valueOf(dmHistogramBin.getLowerBound().doubleValue()) : null;
        this.upperBound = dmHistogramBin.getUpperBound() != null ? Double.valueOf(dmHistogramBin.getUpperBound().doubleValue()) : null;
        this.label = dmHistogramBin.getLabel() != null ? dmHistogramBin.getLabel() : null;
        this.count = dmHistogramBin.getCount() != null ? Double.valueOf(dmHistogramBin.getCount().doubleValue()) : null;
    }

    public String getFullAttributeName() {
        Object object = this.attributeSubname != null ? this.attributeName + "." + this.attributeSubname : this.attributeName;
        return object;
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeSubname(String string) {
        this.attributeSubname = string;
    }

    public String getAttributeSubname() {
        return this.attributeSubname;
    }

    public void setBinId(Integer n) {
        this.binId = n;
    }

    public Integer getBinId() {
        return this.binId;
    }

    public void setLowerBound(Double d) {
        this.lowerBound = d;
    }

    public Double getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(Double d) {
        this.upperBound = d;
    }

    public Double getUpperBound() {
        return this.upperBound;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setCount(Double d) {
        this.count = d;
    }

    public Double getCount() {
        return this.count;
    }

    public static List<HistogramRowData> createHistogramsFromDmHistograms(DmHistograms dmHistograms) throws SQLException {
        ArrayList<HistogramRowData> arrayList = new ArrayList<HistogramRowData>();
        for (int i = 0; i < dmHistograms.length(); ++i) {
            DmHistogramBin dmHistogramBin = dmHistograms.getElement(i);
            HistogramRowData histogramRowData = new HistogramRowData(dmHistogramBin);
            arrayList.add(histogramRowData);
        }
        return arrayList;
    }

    public static Map<AttributeBinIdentifier, HistogramRowData> createMappedAttributeHistogram(List<HistogramRowData> list) {
        HashMap<AttributeBinIdentifier, HistogramRowData> hashMap = new HashMap<AttributeBinIdentifier, HistogramRowData>();
        AttributeBinIdentifier attributeBinIdentifier = null;
        for (HistogramRowData histogramRowData : list) {
            attributeBinIdentifier = new AttributeBinIdentifier(histogramRowData.getFullAttributeName(), histogramRowData.getBinId());
            hashMap.put(attributeBinIdentifier, histogramRowData);
        }
        return hashMap;
    }

    public static List<HistogramRowData> createAttributeHistogram(List<HistogramRowData> list, String string) {
        ArrayList<HistogramRowData> arrayList = new ArrayList<HistogramRowData>();
        for (HistogramRowData histogramRowData : list) {
            if (!histogramRowData.getFullAttributeName().equals(string)) continue;
            arrayList.add(histogramRowData);
        }
        return arrayList;
    }

    public static List<HistogramRowData> createAttributeHistogramFromMap(HashMap<AttributeBinIdentifier, HistogramRowData> hashMap, String string) {
        ArrayList<HistogramRowData> arrayList = new ArrayList<HistogramRowData>();
        boolean bl = true;
        int n = 1;
        HistogramRowData histogramRowData = null;
        AttributeBinIdentifier attributeBinIdentifier = new AttributeBinIdentifier(string, 1);
        while (bl) {
            attributeBinIdentifier.setBinId(n);
            histogramRowData = hashMap.get(attributeBinIdentifier);
            if (histogramRowData == null) {
                bl = false;
                continue;
            }
            arrayList.add(histogramRowData);
        }
        return arrayList;
    }
}

